/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import java.io.IOException;

@JSRequire(value={"WebImage"})
public class WebImage
extends WebControl
implements DatasourceUsage {
    private static final int TAG_WEB_IMAGE_NODEID = 40;
    private static final int TAG_WEB_IMAGE_INDEX = 41;
    private static final int TAG_WEB_IMAGE_SIZE = 42;
    private static final int TAG_WEB_IMAGE_DATASOURCE = 43;
    private static final int TAG_WEB_IMAGE_FIELD = 44;
    private static final int TAG_WEB_IMAGE_PROPORTIONAL = 47;
    private double node;
    private int index;
    private int size;
    private int dsid;
    private int[] field;
    private boolean proportional;

    public WebImage(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.node = reader.getNodeID();
                break;
            }
            case 41: {
                this.index = reader.getInt();
                break;
            }
            case 42: {
                this.size = reader.getInt();
                break;
            }
            case 43: {
                this.dsid = reader.getInt();
                break;
            }
            case 44: {
                this.field = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 47: {
                this.proportional = reader.getBoolean();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        json.object().underscore("WebImage.WclControl", this).prop("prop").val(this.proportional);
        boolean enabled = this.isEnabled();
        if (!enabled) {
            json.prop("enabled").val(enabled);
        }
        json.prop("tag").val(this.getTag());
        this.addScriptProp(json, resolver);
        if (this.index > 0) {
            json.prop("src_icon").val(this.index);
        }
        if (this.node != 0.0) {
            json.prop("src_node").val((long)this.node);
        }
        if (this.hasdb(this.dsid, this.field)) {
            json.prop("src_blob").js("DM.mkFieldPath(").val(this.field).js(",").val(this.dsid).js(",components.datamodel._datasources)");
        }
        json.end();
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) {
        out.append((Object)this, this.dsid, this.field);
    }
}

