/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.Strings;
import inform.agent.db.sql.QueryTokenizer;
import java.util.HashSet;
import java.util.Map;

public class WebScript {
    static final String[] LIBS = new String[]{"Dates", "Strings", "DataTypes", "Colors", "FormatManager"};
    static final String[] REQUIRE = new String[]{"static.wcl.libs.Dates", "static.wcl.libs.Strings", "static.wcl.libs.DataTypes", "static.wcl.libs.Colors", "static.wcl.libs.FormatManager"};

    public static void required(String script, Map<String, String> requiresJs) {
        if (Strings.isVoid(script)) {
            return;
        }
        Contains contains = new Contains();
        for (int i = 0; i < LIBS.length; ++i) {
            String lib = LIBS[i];
            if (!contains.containsLib(lib, script)) continue;
            requiresJs.put(REQUIRE[i], lib);
        }
    }

    private static class Contains {
        boolean exists;
        QueryTokenizer parser;
        QueryTokenizer.Token tokenType;
        String lib;

        private Contains() {
        }

        private QueryTokenizer.Token processLib() {
            switch (this.tokenType) {
                case Word: {
                    this.exists = this.lib.equals(this.parser.value);
                    if (this.exists || Strings.isVoid(this.parser.value)) break;
                    this.exists = this.parser.value.startsWith(this.lib);
                    if (!this.exists) break;
                    this.exists = this.parser.value.length() > this.lib.length() && this.parser.value.charAt(this.lib.length()) == '.';
                    break;
                }
            }
            return this.tokenType;
        }

        boolean containsLib(String lib, String script) {
            this.lib = lib;
            this.exists = false;
            this.parser = new QueryTokenizer(script);
            this.tokenType = null;
            while (this.tokenType != QueryTokenizer.Token.Eof) {
                this.tokenType = this.parser.nextToken();
                this.tokenType = this.processLib();
                if (!this.exists) continue;
                break;
            }
            return this.exists;
        }
    }

    public static interface ScriptModule {
        public ScriptType getScriptType();

        public String getScriptModuleText();

        public String getScriptModuleName();
    }

    public static interface EventHolder {
        public HashSet<String> getScriptEvents(HashSet<String> var1);
    }

    public static enum ScriptType {
        ST_NONE,
        ST_SERVER_SIDE,
        ST_BROWSER_SIDE;

    }
}

