/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.Collections;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebGridCommon;
import inform.agent.web.forms.expr.JsEvaluator;
import inform.agent.web.forms.expr.JsExpression;
import inform.common.Base64BinString;
import java.io.IOException;
import java.util.Iterator;

@JSRequire(value={"WebTree", "css!WebTree", "WebGridCommon"})
@WebControlContainer.ContainsChildren(type=508, cls=WebGridCommon.Footer.class)
public class WebTree
extends WebControlContainer {
    private static final int WF_TREE_NODE = 505;
    private static final int WF_TREE_HEADER = 506;
    private Header header;

    public WebTree(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        writer.tag("div").attr("class", "grid tree").attr("id", this.id);
        this.appendAttributes(writer, resolver);
        this.appendStyles(writer, resolver);
        if (this.width > 0.0) {
            writer.style("width", this.width, "mm");
        }
        if (this.height > 0.0) {
            writer.style("height", this.height, "mm");
        }
        writer.tag("table").attr("id", this.id).attr("class", "grid");
        WebGridCommon.generateHeader(writer, resolver, Collections.castingIterator(this.header.controls.iterator(), WebGridCommon.ColumnCaption.class), false);
        writer.end();
        WebGridCommon.Footer footer = null;
        for (WebControl i : this.controls) {
            if (i instanceof Node) {
                i.generate(writer, resolver);
                continue;
            }
            if (!(i instanceof WebGridCommon.Footer)) continue;
            footer = (WebGridCommon.Footer)i;
        }
        if (footer != null) {
            writer.tag("div").attr("class", "gfoot").tag("div").attr("class", "cutter").tag("div").attr("class", "rester").tag("table").attr("id", this.id).attr("class", "grid");
            WebGridCommon.generateFooter(writer, resolver, footer, false, true);
            writer.end().end().end().end();
        }
        writer.end();
    }

    @Override
    protected WebControl createTypedControl(int type, int id, int options) {
        switch (type) {
            case 505: {
                return new Node(id, options, this.parent);
            }
            case 506: {
                this.header = new Header(id, options, this.parent);
                return this.header;
            }
        }
        return super.createTypedControl(type, id, options);
    }

    private static class Node
    extends WebControlContainer
    implements DatasourceUsage {
        static final int WF_TREE_CELL = 507;
        static final int TAG_WF_TREE_NODE_DATASOURCE = 40;
        static final int TAG_WF_TREE_NODE_COLOR_EXPRESSION = 41;
        static final int TAG_WF_TREE_NODE_TEXT_COLOR_EXPRESSION = 42;
        static final int TAG_WF_TREE_NODE_TEXT_STYLE_EXPRESSION = 43;
        static final int TAG_WF_TREE_NODE_RECURSION = 44;
        static final int TAG_WF_TREE_NODE_RECURSION_CURRENT_RECORD_FIELD = 1;
        static final int TAG_WF_TREE_NODE_RECURSION_PARENT_RECORD_FIELD = 2;
        static final int TAG_WF_TREE_NODE_RECURSION_PARENT_SEARCH_PARAM = 3;
        int dsid;
        int reCurrent = -1;
        int reParent;
        int reParentParam;
        JsEvaluator exColor;
        JsEvaluator exTextColor;
        JsEvaluator exTextStyle;

        Node(int id, int options, WebControlContainer parent) {
            super(id, parent, true);
        }

        @Override
        protected void loadTag(TaggedReader reader) throws IOException {
            switch (reader.getCurrentTag()) {
                case 40: {
                    this.dsid = reader.getInt();
                    break;
                }
                case 41: {
                    this.exColor = JsExpression.loadAndCompile(reader.getStreamReader());
                    break;
                }
                case 42: {
                    this.exTextColor = JsExpression.loadAndCompile(reader.getStreamReader());
                    break;
                }
                case 43: {
                    this.exTextStyle = JsExpression.loadAndCompile(reader.getStreamReader());
                    break;
                }
                case 44: {
                    TaggedReader r = reader.getSubStreamReader();
                    while (r.next()) {
                        switch (r.getCurrentTag()) {
                            case 1: {
                                this.reCurrent = r.getInt();
                                break;
                            }
                            case 2: {
                                this.reParent = r.getInt();
                                break;
                            }
                            case 3: {
                                this.reParentParam = r.getInt();
                            }
                        }
                    }
                    break;
                }
                default: {
                    super.loadTag(reader);
                }
            }
        }

        @Override
        public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
            writer.tag("div").attr("class", "nd");
            writer.attr("id", this.id);
            if (this.dsid != 0) {
                writer.attr("data-datasource", this.dsid);
            }
            if (this.reParent != 0) {
                writer.attr("data-recursion", this.reCurrent + ":" + this.reParent + ":" + this.reParentParam);
            }
            if (this.exColor != null) {
                writer.attr("data-color-expression", this.expr2str(this.exColor, resolver));
            }
            if (this.exTextColor != null) {
                writer.attr("data-textcolor-expression", this.expr2str(this.exTextColor, resolver));
            }
            if (this.exTextStyle != null) {
                writer.attr("data-textstyle-expression", this.expr2str(this.exTextStyle, resolver));
            }
            for (WebControl i : this.controls) {
                if (!(i instanceof Cell)) continue;
                i.generate(writer, resolver);
            }
            for (WebControl i : this.controls) {
                if (!(i instanceof Node)) continue;
                i.generate(writer, resolver);
            }
            writer.end();
        }

        @Override
        protected WebControl createTypedControl(int type, int id, int options) {
            switch (type) {
                case 505: {
                    return new Node(id, options, this.parent);
                }
                case 507: {
                    return new Cell(id, options, this.parent);
                }
            }
            return super.createTypedControl(type, id, options);
        }

        @Override
        public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
            out.append((Object)this, this.dsid, new int[0]);
            if (this.reParent != 0) {
                out.append((Object)this, this.dsid, this.reCurrent);
                out.append((Object)this, this.dsid, this.reParent);
            }
            if (this.exColor != null) {
                this.exColor.appendUsedDirectoriesTo(this, out);
            }
            if (this.exTextColor != null) {
                this.exTextColor.appendUsedDirectoriesTo(this, out);
            }
            if (this.exTextStyle != null) {
                this.exTextStyle.appendUsedDirectoriesTo(this, out);
            }
        }

        static class Cell
        extends WebControl
        implements DatasourceUsage {
            static final int TAG_WF_TREE_CELL_DATASOURCE = 41;
            static final int TAG_WF_TREE_CELL_FIELD = 42;
            static final int TAG_WF_TREE_CELL_DATA_TYPE = 43;
            static final int TAG_WF_TREE_CELL_EXPRESSION = 44;
            static final int TAG_WF_TREE_CELL_COLOR_EXPRESSION = 45;
            static final int TAG_WF_TREE_CELL_TEXT_COLOR_EXPRESSION = 46;
            static final int TAG_WF_TREE_CELL_TEXT_STYLE_EXPRESSION = 47;
            static final int TAG_WF_TREE_CELL_FORMAT = 48;
            static final int TAG_WF_TREE_CELL_FORMAT_OPTION = 49;
            static final int TAG_WF_TREE_CELL_TEXT = 52;
            String text;
            int dsid;
            int[] fpath;
            JsEvaluator expression;
            JsEvaluator exColor;
            JsEvaluator exTextColor;
            JsEvaluator exTextStyle;
            int dataType;
            int formatId;
            byte[] formatOption;

            Cell(int id, int options, WebControlContainer parent) {
                super(id, parent, true);
            }

            @Override
            protected void loadTag(TaggedReader reader) throws IOException {
                switch (reader.getCurrentTag()) {
                    case 41: {
                        this.dsid = reader.getInt();
                        break;
                    }
                    case 42: {
                        this.fpath = LittleEndian.toIntArray(reader.getRaw());
                        break;
                    }
                    case 43: {
                        this.dataType = reader.getInt();
                        break;
                    }
                    case 44: {
                        this.expression = JsExpression.loadAndCompile(reader.getStreamReader());
                        break;
                    }
                    case 45: {
                        this.exColor = JsExpression.loadAndCompile(reader.getStreamReader());
                        break;
                    }
                    case 46: {
                        this.exTextColor = JsExpression.loadAndCompile(reader.getStreamReader());
                        break;
                    }
                    case 47: {
                        this.exTextStyle = JsExpression.loadAndCompile(reader.getStreamReader());
                        break;
                    }
                    case 48: {
                        this.formatId = reader.getInt();
                        break;
                    }
                    case 49: {
                        this.formatOption = reader.getRaw();
                        break;
                    }
                    case 52: {
                        this.text = reader.getString();
                        break;
                    }
                    default: {
                        super.loadTag(reader);
                    }
                }
            }

            @Override
            public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
                writer.tag("span");
                writer.attr("id", this.id);
                if (this.expression != null) {
                    writer.attr("data-expression", this.expr2str(this.expression, resolver));
                } else if (this.dsid != 0 && this.fpath != null) {
                    this.appendDataBindingsAsExpressionTo(writer, this.dsid, this.fpath);
                } else if (this.text != null) {
                    writer.attr("data-expression", "val(" + JSON.toString(this.text) + ")");
                }
                DataType dt = this.dataType != 0 ? DataType.getDataTypeById(this.dataType) : (this.hasdb(this.dsid, this.fpath) ? resolver.resolveDataType(this.dsid, this.fpath) : null);
                int fmtid = this.formatId;
                if (fmtid == 0 && this.hasdb(this.dsid, this.fpath)) {
                    fmtid = resolver.resolveFormatId(this.dsid, this.fpath);
                }
                if (fmtid != 0) {
                    writer.attr("data-format", fmtid);
                    if (this.formatOption != null) {
                        writer.attr("data-format-option", Base64BinString.Encode(this.formatOption));
                    }
                }
                if (this.dataType != 0) {
                    writer.attr("data-datatype", this.dataType);
                } else if (dt != null) {
                    writer.attr("data-datatype", dt.getTypeId());
                }
                if (this.exColor != null) {
                    writer.attr("data-color-expression", this.expr2str(this.exColor, resolver));
                }
                if (this.exTextColor != null) {
                    writer.attr("data-textcolor-expression", this.expr2str(this.exTextColor, resolver));
                }
                if (this.exTextStyle != null) {
                    writer.attr("data-textstyle-expression", this.expr2str(this.exTextStyle, resolver));
                }
                writer.end();
            }

            @Override
            public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
                out.append((Object)this, this.dsid, this.fpath);
                if (this.expression != null) {
                    this.expression.appendUsedDirectoriesTo(this, out);
                }
                if (this.exColor != null) {
                    this.exColor.appendUsedDirectoriesTo(this, out);
                }
                if (this.exTextColor != null) {
                    this.exTextColor.appendUsedDirectoriesTo(this, out);
                }
                if (this.exTextStyle != null) {
                    this.exTextStyle.appendUsedDirectoriesTo(this, out);
                }
            }
        }
    }

    private static class Header
    extends WebControlContainer {
        static final int WF_TREE_COLUMN = 504;

        Header(int id, int options, WebControlContainer parent) {
            super(id, parent, true);
        }

        @Override
        protected WebControl createTypedControl(int type, int id, int options) {
            switch (type) {
                case 504: {
                    return new Column(id, options, this.parent);
                }
            }
            return super.createTypedControl(type, id, options);
        }

        static class Column
        extends Header
        implements WebGridCommon.ColumnCaption {
            static final int TAG_WF_TREE_COLUMN_TEXT = 40;
            String text;

            Column(int id, int options, WebControlContainer parent) {
                super(id, options, parent);
            }

            @Override
            protected void loadTag(TaggedReader reader) throws IOException {
                switch (reader.getCurrentTag()) {
                    case 40: {
                        this.text = reader.getString();
                        break;
                    }
                    default: {
                        super.loadTag(reader);
                    }
                }
            }

            @Override
            public int id() {
                return this.id;
            }

            @Override
            public String captionText() {
                return this.text;
            }

            @Override
            public void appendCaptionStyles(HtmlWriter writer, Resolver resolver) throws IOException {
                if (this.alignHorz != WebControl.HorzAlign.DEFAULT) {
                    writer.style("text-align", this.alignHorz.name().toLowerCase());
                }
                this.appendStyles(writer, resolver);
            }

            @Override
            public Iterator<WebGridCommon.ColumnCaption> childrenIterator() {
                return Collections.castingIterator(this.controls.iterator(), WebGridCommon.ColumnCaption.class);
            }
        }
    }
}

