/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.ScriptableValue;
import inform.agent.scripts.util.Binding;
import inform.agent.web.JSON;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.components.WebComponentContainer;
import java.io.IOException;

public abstract class WebComponent
implements IntegerHash.Entry {
    protected static final Constants DEFAULT_CONSTANTS = new Constants(0.0);
    private static final int TAG_SS_COMPONENT_NAME = 20;
    private static final int TAG_SS_COMPONENT_TITLE = 21;
    public final int id;
    public final WebComponentContainer parent;
    protected final boolean isSubComponent;
    protected String name;
    protected String title;

    public WebComponent(int id, WebComponentContainer parent, boolean isSubComponent) {
        this.id = id;
        this.parent = parent;
        this.isSubComponent = isSubComponent;
    }

    public double getOwnerId() {
        if (this.parent != null) {
            return this.parent.getOwnerId();
        }
        return 0.0;
    }

    @Override
    public int key() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public boolean isSubComponent() {
        return this.isSubComponent;
    }

    public String title() {
        return this.title;
    }

    public void load(TaggedReader reader) throws IOException {
        while (reader.next()) {
            this.loadTag(reader);
        }
    }

    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 20: {
                this.name = reader.getAnsi();
                break;
            }
            case 21: {
                this.title = reader.getString();
            }
        }
    }

    public void generate(Appendable out, String pad, WebForm.Task task) throws IOException {
    }

    public static void generateParametersTo(double ownerId, StringBuilder to, ParametersList parameters, String pad) {
        boolean nc = false;
        for (Parameter p : parameters.values()) {
            double ref;
            if (nc) {
                to.append(',');
            }
            to.append(pad);
            nc = true;
            to.append(p.getId()).append(":{type:").append(p.getDataType().getTypeId());
            if (!Strings.isVoid(p.getName())) {
                to.append(",name:").append(JSON.toString(p.getName()));
            }
            if (!Strings.isVoid(p.getCaption())) {
                to.append(",caption:").append(JSON.toString(p.getCaption()));
            }
            if (p.getFormatId() != 0) {
                to.append(",format:").append(JSON.toString(p.getFormatId()));
            }
            if (p.getDataType() == DataType.METATREE_NODE) {
                to.append(",filter:").append(JSON.toString(p.metadataFilter()));
            }
            if ((ref = p.refTableId()) != 0.0) {
                to.append(",directory:{table:").append((long)ref).append(",field:").append(p.fieldAssoc());
                int sf = p.selectedField();
                if (sf != 0) {
                    to.append(",display:").append(sf);
                }
                to.append(",ownerId:").append(NumberConverter.doubleToString(ownerId));
                to.append('}');
            }
            if (p.oneValue()) {
                to.append(",oneValue:true");
            }
            if (p.notNull()) {
                to.append(",notNull:true");
            }
            if (p.hidden()) {
                to.append(",hidden:true");
            }
            if (p.returnValue()) {
                to.append(",retval:true");
            }
            to.append('}');
        }
    }

    public static void generateParametersBindingsTo(StringBuilder to, ParametersList parameters, String datasourcesVar, String pad, boolean force, IntegerSet deps) {
        boolean nc = false;
        for (Parameter p : parameters.values()) {
            ScriptableValue b;
            if (!force && !p.binded()) continue;
            if (nc) {
                to.append(',');
            }
            to.append(pad);
            nc = true;
            to.append(p.getId()).append(':');
            if (p.souCtrlID() != 0) {
                to.append("new DM.CBind(").append(p.souCtrlID()).append(')');
                continue;
            }
            Object v = p.getInternalValue();
            if (v instanceof Binding) {
                b = (Binding)v;
                if (deps != null) {
                    deps.add(((Binding)b).getDatasourceId());
                }
                to.append("new DM.CBind(").append(((Binding)b).getDatasourceId()).append(',').append(((Binding)b).getFieldId()).append(')');
                continue;
            }
            if (v instanceof Parameter) {
                b = (Parameter)v;
                to.append(datasourcesVar).append("[-1]._fbyid[").append(((Parameter)b).getId()).append(']');
                continue;
            }
            if (v instanceof ScriptableValue) {
                ScriptableValue sv = (ScriptableValue)v;
                if (sv.getIsIgnored()) {
                    to.append("DM.ALLVAL");
                    continue;
                }
                to.append(JSON.toString(sv.getRawValue()));
                continue;
            }
            if (p.getIsIgnored()) {
                to.append("DM.ALLVAL");
                continue;
            }
            to.append(JSON.toString(v));
        }
    }
}

