/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.components;

import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.ParametersList;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.WebForm;
import inform.agent.web.forms.WebScript;
import inform.agent.web.forms.components.WebComponent;
import inform.agent.web.forms.components.WebComponentContainer;
import java.io.IOException;

@JSRequire(value={"WebScriptLauncher"})
public class WebScriptLauncher
extends WebComponent
implements DatasourceUsage,
WebScript.ScriptModule {
    private static final int TAG_SS_TASK_MODE = 4;
    private static final int TAG_SS_CLOSE_MODE = 5;
    private static final int TAG_SS_SCRIPT_NODE = 40;
    private static final int TAG_SS_SCRIPT_PARAMS = 42;
    private static final int SSSCRIPT_OPTION_JS = 1;
    private WebForm.NodeData<ND, IOException> node;
    private byte[] pbindings;
    private WebScript.ScriptType scriptType;

    public WebScriptLauncher(int id, int options, WebComponentContainer parent) {
        super(id, parent, false);
        this.scriptType = (options & 1) == 1 ? WebScript.ScriptType.ST_BROWSER_SIDE : WebScript.ScriptType.ST_SERVER_SIDE;
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.node = new WebForm.NodeData<ND, IOException>(reader.getNodeID()){

                    @Override
                    protected ND read(Node node) throws IOException {
                        ND result = new ND();
                        TaggedReader reader = new TaggedReader(((BasicNode)node).getContent());
                        while (reader.next()) {
                            block0 : switch (reader.getCurrentTag()) {
                                case 4: {
                                    result.silent = reader.getInt() > 1;
                                    break;
                                }
                                case 5: {
                                    result.syncok = reader.getInt() == 2;
                                    break;
                                }
                                case 152: {
                                    TaggedReader r = reader.getSubStreamReader();
                                    while (r.next()) {
                                        if (r.getCurrentTag() != 153) continue;
                                        result.parameters = r.getSubStreamData();
                                        break block0;
                                    }
                                    break;
                                }
                            }
                        }
                        return result;
                    }
                };
                break;
            }
            case 42: {
                this.pbindings = reader.getSubStreamData();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(Appendable out, String pad, WebForm.Task task) throws IOException {
        if (this.scriptType != WebScript.ScriptType.ST_SERVER_SIDE) {
            return;
        }
        out.append(pad).append("components[").append(Integer.toString(this.id)).append("] = new WebScriptLauncher({id:").append(Integer.toString(this.id));
        out.append(",ownerId:").append(NumberConverter.doubleToString(this.getOwnerId()));
        if (this.node != null) {
            ND nd = this.node.fetch();
            out.append(",node:").append(Long.toString((long)this.node.id)).append(",silent:").append(Boolean.toString(nd.silent)).append(",syncok:").append(Boolean.toString(nd.syncok));
            StringBuilder params = new StringBuilder();
            StringBuilder pbinds = new StringBuilder();
            if (nd.parameters != null) {
                ParametersList plist = new ParametersList();
                plist.load(task.getConstants(), new TaggedReader(nd.parameters), task.getHost());
                if (this.pbindings != null) {
                    plist.loadParametersBindings(task.getParameters(), task.getConstants(), new TaggedReader(this.pbindings));
                }
                WebScriptLauncher.generateParametersTo(this.getOwnerId(), params, plist, "\n\t\t" + pad);
                WebScriptLauncher.generateParametersBindingsTo(pbinds, plist, "datamodel._datasources", "\n\t\t" + pad, true, null);
            }
            if (params.length() > 0) {
                out.append('\n').append(pad).append("\t,parameters:{").append(params).append('\n').append(pad).append("\t}");
            }
            if (pbinds.length() > 0) {
                out.append('\n').append(pad).append("\t,p_bindings:{").append(pbinds).append('\n').append(pad).append("\t}");
            }
        }
        out.append('\n').append(pad).append("});\n");
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        if (this.pbindings != null) {
            out.appendPBindings(this, new TaggedReader(this.pbindings));
        }
    }

    @Override
    public WebScript.ScriptType getScriptType() {
        return this.scriptType;
    }

    @Override
    public String getScriptModuleText() {
        if (this.scriptType != WebScript.ScriptType.ST_BROWSER_SIDE) {
            return null;
        }
        if (this.node.id == 0.0) {
            return "";
        }
        Node node = MtdEngine.getNode(this.node.id);
        if (node == null) {
            return null;
        }
        if (node.getType() != 14) {
            return null;
        }
        byte[] content = MtdEngine.getNodeContent(this.node.id);
        if (content == null || content.length == 0) {
            return "";
        }
        return new String(content, TaggedWriter.ANSI);
    }

    @Override
    public String getScriptModuleName() {
        return this.name;
    }

    private static class ND {
        byte[] parameters;
        boolean silent;
        boolean syncok;

        private ND() {
        }
    }
}

