/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms.expr;

import inform.agent.expr.AbstractEvaluator;
import inform.agent.expr.ConstantTerm;
import inform.agent.expr.DatasourcePropertyTerm;
import inform.agent.expr.FieldTerm;
import inform.agent.expr.FunctionArgs;
import inform.agent.expr.FunctionTerm;
import inform.agent.expr.OperationTerm;
import inform.agent.expr.ParameterTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constant;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.Resolver;
import inform.agent.web.utils.HtmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class JsEvaluator
extends AbstractEvaluator {
    private final Collection<JsEvaluator> arguments = new ArrayList<JsEvaluator>();

    public JsEvaluator(Term term, JsEvaluator ... args) {
        super(term);
        for (JsEvaluator a : args) {
            this.arguments.add(a);
        }
    }

    @Override
    public void addArgument(AbstractEvaluator evaluator) {
        this.arguments.add((JsEvaluator)evaluator);
    }

    @Override
    public boolean isStringType() throws Exception {
        return false;
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    private String opById(int opId) {
        switch (opId) {
            case 0: {
                return "add";
            }
            case 1: {
                return "sub";
            }
            case 2: {
                return "mul";
            }
            case 3: {
                return "div";
            }
            case 4: {
                return "mod";
            }
            case 5: {
                return "ls";
            }
            case 6: {
                return "le";
            }
            case 7: {
                return "gt";
            }
            case 8: {
                return "ge";
            }
            case 9: {
                return "eq";
            }
            case 13: {
                return "ne";
            }
            case 10: {
                return "and";
            }
            case 11: {
                return "or";
            }
            case 12: {
                return "not";
            }
        }
        throw new UnsupportedOperationException("OpID:" + opId);
    }

    private String funcById(int funcId) {
        switch (funcId) {
            case 0: {
                return "round";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "min";
            }
            case 3: {
                return "trim";
            }
            case 4: {
                return "abs";
            }
            case 1101: {
                return "nvl";
            }
            case 4001: {
                return "caze";
            }
            case 4002: {
                return "when";
            }
        }
        throw new UnsupportedOperationException("FuncID:" + funcId);
    }

    public void generate(StringBuilder out, Resolver resolver) throws IOException {
        if (this.term instanceof FunctionTerm) {
            byte[] argsContent = ((FunctionTerm)this.term).getStaticArgsContent();
            if (argsContent != null && argsContent.length > 0) {
                for (JsEvaluator a : this.arguments) {
                    if (a == null || a.isIgnored()) continue;
                    FunctionArgs fArgs = new FunctionArgs(argsContent);
                    out.append("fStyle(");
                    a.generate(out, resolver);
                    String c = "null";
                    if (fArgs.color != 0x1FFFFFFF) {
                        c = JSON.toString(HtmlUtils.vColor(fArgs.color));
                    }
                    out.append(',').append(fArgs.style).append(',').append(c).append(')');
                    break;
                }
                return;
            }
            out.append(this.funcById(((FunctionTerm)this.term).getFunctionId()));
        } else if (this.term instanceof OperationTerm) {
            out.append(this.opById(((OperationTerm)this.term).getOperationId()));
        } else {
            if (this.term instanceof ValueTerm) {
                out.append("val(").append(JSON.toString(((ValueTerm)this.term).getValue())).append(')');
                return;
            }
            if (this.term instanceof FieldTerm) {
                FieldTerm ft = (FieldTerm)this.term;
                out.append("fld(").append(ft.getDatasourceId()).append(',').append(Arrays.toString(ft.getFieldIdPath())).append(')');
                return;
            }
            if (this.term instanceof ParameterTerm) {
                ParameterTerm pt = (ParameterTerm)this.term;
                out.append("fld(").append(-1).append(",[").append(pt.getParamId()).append("])");
                return;
            }
            if (this.term instanceof ConstantTerm) {
                ConstantTerm ct = (ConstantTerm)this.term;
                Constant c = resolver.constants().get(ct.getConstId());
                out.append("val(").append(JSON.toString(c.getValue())).append(')');
                return;
            }
            if (this.term instanceof DatasourcePropertyTerm) {
                DatasourcePropertyTerm dp = (DatasourcePropertyTerm)this.term;
                out.append("ds");
                switch (dp.prop()) {
                    case 4501: {
                        out.append('e');
                        break;
                    }
                    case 4502: {
                        out.append('i');
                        break;
                    }
                    case 4503: {
                        out.append('c');
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("prop: " + dp.prop());
                    }
                }
                out.append('(').append(dp.dsid()).append(')');
                return;
            }
            throw new UnsupportedOperationException(this.term.getClass().getName());
        }
        out.append('(');
        boolean nc = false;
        for (JsEvaluator a : this.arguments) {
            if (nc) {
                out.append(',');
            }
            nc = true;
            a.generate(out, resolver);
        }
        out.append(')');
    }

    public void appendUsedDirectoriesTo(Object owner, DatasourceUsage.Scanner out) throws IOException {
        switch (this.term.getToken()) {
            case param: {
                ParameterTerm pt = (ParameterTerm)this.term;
                out.append(owner, -1, pt.getParamId());
                break;
            }
            case field: {
                FieldTerm ft = (FieldTerm)this.term;
                out.append(owner, ft.getDatasourceId(), ft.getFieldIdPath());
            }
        }
        for (JsEvaluator a : this.arguments) {
            a.appendUsedDirectoriesTo(owner, out);
        }
    }
}

