/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import com.google.zxing.BarcodeFormat;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.barcode.BarcodeRequest;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.reports.controls.Control;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.Container;
import inform.agent.web.reports.document.DocImage;
import inform.agent.web.reports.document.Document;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public class ReportBarCode
extends WebControl
implements Control {
    private static final int TAG_WEB_BARCODE_DATASOURCE = 40;
    private static final int TAG_WEB_BARCODE_FIELD = 41;
    private static final int TAG_WEB_BARCODE_TYPE = 42;
    private static final int TAG_WEB_BARCODE_SYMB_VISIBLE = 43;
    private static final int TAG_WEB_BARCODE_ORIENTATION = 44;
    private static final int TAG_WEB_BARCODE_RESOLUTION = 45;
    private static final double MM_PER_INCH = 25.4;
    private int datasourceId = 0;
    private int[] fieldIdPath = null;
    private Dataset datasource = null;
    private DatasetField field = null;
    private int resolution = 300;
    private boolean symbVisible = true;
    private int barCodeType = 1;
    private int orientation = 0;

    @Override
    public void beforeGenerate() {
        this.hasBindedData = this.field != null;
    }

    @Override
    public void setupDatamodel(Datamodel datamodel) {
        if (this.field != null) {
            datamodel.add(this.datasource);
        }
    }

    @Override
    public boolean isSubControl() {
        return true;
    }

    @Override
    public void generate(Document document, Container container) throws Exception {
        if (container != null && this.getVisible() && this.isGenerated()) {
            DocImage docImage = container.addImage();
            docImage.setVisible(this.isVisible());
            docImage.setWidth(this.getWidth());
            docImage.setHeight(this.getHeight());
            byte[] imageContent = null;
            if (this.field != null) {
                if (!this.datasource.isSelected()) {
                    this.datasource.executeSelect();
                }
                if (!this.datasource.isCurrentRowAvailable() && !this.datasource.next()) {
                    return;
                }
                if (!this.field.getIsNull()) {
                    BarcodeFormat format;
                    String str = this.field.getAsString();
                    int _width = (int)Math.round((double)this.resolution * this.width / 25.4);
                    int _height = (int)Math.round((double)this.resolution * this.height / 25.4);
                    switch (this.barCodeType) {
                        case 0: {
                            format = BarcodeFormat.EAN_8;
                            break;
                        }
                        case 1: {
                            format = BarcodeFormat.EAN_13;
                            break;
                        }
                        case 2: {
                            format = BarcodeFormat.CODE_39;
                            break;
                        }
                        case 3: {
                            format = BarcodeFormat.PDF_417;
                            break;
                        }
                        case 4: {
                            format = BarcodeFormat.QR_CODE;
                            break;
                        }
                        default: {
                            format = BarcodeFormat.EAN_13;
                        }
                    }
                    imageContent = BarcodeRequest.drawBarCode(null, format.ordinal(), str, _width, _height, "PNG", this.orientation, false);
                }
            }
            docImage.setImageContent(imageContent);
        }
    }

    public ReportBarCode(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
    }

    public ReportBarCode(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        assert (scope instanceof WebControlContainer);
        return this.createClone(task, (WebControlContainer)scope);
    }

    public WebControl createClone(Task task, WebControlContainer container) {
        ReportBarCode bc = new ReportBarCode(task, null, task.generateId(), ReportBarCode.cloneName(container, this.getName()));
        bc.assignProps(this);
        bc.datasourceId = this.datasourceId;
        bc.fieldIdPath = this.fieldIdPath;
        bc.resolution = this.resolution;
        bc.symbVisible = this.symbVisible;
        bc.barCodeType = this.barCodeType;
        bc.orientation = this.orientation;
        return bc;
    }

    @Override
    protected void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 40: {
                this.datasourceId = in.getInt();
                break;
            }
            case 41: {
                this.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                break;
            }
            case 2: {
                this.width = in.getDouble();
                break;
            }
            case 3: {
                this.height = in.getDouble();
                break;
            }
            case 45: {
                this.resolution = in.getInt();
                break;
            }
            case 43: {
                this.symbVisible = in.getBoolean();
                break;
            }
            case 42: {
                this.barCodeType = in.getInt();
                break;
            }
            case 44: {
                this.orientation = in.getInt();
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
        this.datasource = null;
        this.field = null;
        if (this.datasourceId != 0 && this.fieldIdPath != null) {
            this.datasource = this.task.getComponents().findDataset(this.datasourceId);
            if (this.datasource != null) {
                this.field = this.datasource.findFieldPath(this.fieldIdPath);
            }
        }
    }

    @Override
    public void print(Writer out) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public String getClassName() {
        return "BarCode";
    }

    private static class BarCodeOrientation {
        private static final int boLeftRight = 0;
        private static final int boRightLeft = 1;
        private static final int boTopBottom = 2;
        private static final int boBottomTop = 3;

        private BarCodeOrientation() {
        }
    }

    private static class BarCodeType {
        private static final int EAN8 = 0;
        private static final int EAN13 = 1;
        private static final int C39 = 2;
        private static final int PDF417 = 3;
        private static final int QRCODE = 4;

        private BarCodeType() {
        }
    }
}

