/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.agent.scripts.Task;
import inform.agent.web.reports.controls.ReportColumn;
import inform.agent.web.reports.controls.ReportTable;
import java.util.ArrayList;
import java.util.Collection;
import org.mozilla.javascript.Scriptable;

public class ReportColumns {
    private final ArrayList<ReportColumn> columns = new ArrayList();
    final ReportTable table;

    public ReportColumns(ReportTable table) {
        this.table = table;
    }

    public String getClassName() {
        return "ReportColumns";
    }

    public ReportColumn getByName(String name) {
        if (this.columns != null) {
            for (ReportColumn column : this.columns) {
                if (!name.equals(column.getName())) continue;
                return column;
            }
        }
        return null;
    }

    public ReportColumn get(int index) {
        return this.columns.get(index);
    }

    void assignColumns(Task task, ReportColumns reportColumns) {
        this.columns.clear();
        for (ReportColumn column : reportColumns.columns) {
            ReportColumn c = column.createClone(task, this.table);
            this.add(c);
        }
    }

    boolean validIndex(int index) {
        return 0 <= index && index < this.columns.size();
    }

    public Object get(String name, Scriptable start) {
        ReportColumn obj = this.getByName(name);
        return obj;
    }

    public Object get(int index, Scriptable start) {
        if (this.validIndex(index)) {
            return this.get(index);
        }
        return Scriptable.NOT_FOUND;
    }

    public int getLength() {
        return this.columns.size();
    }

    public int size() {
        return this.columns.size();
    }

    public Collection<ReportColumn> values() {
        return this.columns;
    }

    public void add(ReportColumn column) {
        for (ReportColumn c : this.columns) {
            if (c != column) continue;
            return;
        }
        column.controlIndex = this.columns.size();
        this.columns.add(column);
    }

    public void insert(int columnIndex, ReportColumn column) {
        for (ReportColumn c : this.columns) {
            if (c != column) continue;
            return;
        }
        this.columns.add(columnIndex, column);
        columnIndex = 0;
        for (ReportColumn c : this.columns) {
            c.controlIndex = columnIndex++;
        }
    }
}

