/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.Task;
import inform.agent.web.reports.controls.Control;
import inform.agent.web.reports.controls.WebControl;
import inform.agent.web.reports.controls.WebControlContainer;
import inform.agent.web.reports.document.Container;
import inform.agent.web.reports.document.DocText;
import inform.agent.web.reports.document.Document;
import inform.agent.web.utils.Font;
import java.io.IOException;
import java.io.Writer;
import org.mozilla.javascript.Scriptable;

public class ReportLabel
extends WebControl
implements Control {
    private static final int TAG_WEB_LABEL_TEXT = 40;
    private static final int TAG_WR_TEXT_DOCUMENT_WRITER_FIELD_KIND = 80;
    private String text;
    private int documentWriterFieldKind = 0;

    @Override
    public boolean isSubControl() {
        return true;
    }

    @Override
    public void generate(Document document, Container container) throws Exception {
        if (container != null && this.getVisible()) {
            DocText documentText = container.addText();
            documentText.setVisible(this.isVisible());
            int color = this.getColor();
            Font font = this.getFont();
            if (document.getUseBlackAndWhite()) {
                color = 0x1FFFFFFF;
                font.setColor(0);
            }
            documentText.setFont(font);
            documentText.setColor(color);
            documentText.setWidth(this.getWidth());
            documentText.setDocumentWriterFieldKind(this.documentWriterFieldKind);
            documentText.setText(this.text);
        }
    }

    public ReportLabel(Task task, Scriptable scope, ComponentHeader header) {
        super(task, scope, header);
    }

    public ReportLabel(Task task, Scriptable scope, int id, String name) {
        super(task, scope, id, name);
    }

    @Override
    public WebControl createClone(Task task, Scriptable scope) {
        assert (scope instanceof WebControlContainer);
        return this.createClone(task, (WebControlContainer)scope);
    }

    public WebControl createClone(Task task, WebControlContainer container) {
        ReportLabel label = new ReportLabel(task, null, task.generateId(), ReportLabel.cloneName(container, this.getName()));
        label.assignProps(this);
        label.text = this.text;
        label.documentWriterFieldKind = this.documentWriterFieldKind;
        return label;
    }

    @Override
    protected void readTag(int tag, TaggedReader in) throws IOException, TaggedReaderException, InformException {
        switch (tag) {
            case 40: {
                this.text = in.getAnsi();
                break;
            }
            case 80: {
                this.documentWriterFieldKind = in.getInt();
                break;
            }
            default: {
                super.readTag(tag, in);
            }
        }
    }

    @Override
    public void afterLoad() throws InformException {
    }

    @Override
    public void print(Writer out) throws IOException {
        out.append(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    @Override
    public String getClassName() {
        return "Label";
    }
}

