/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.controls;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;
import org.mozilla.javascript.Scriptable;

public class SheetProtection {
    public static final int TAG_WEB_PROTECTION_OPTIONS = 1;
    public static final int TAG_WEB_PROTECTION_PASSWORD = 2;
    private boolean enabled = false;
    private int options = 0;
    private String password = "";

    public SheetProtection(Scriptable parentScope) {
    }

    public void assign(SheetProtection p) {
        this.enabled = p.enabled;
        this.options = p.options;
        this.password = p.password;
    }

    public void load(TaggedReader in) throws IOException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.enabled = true;
                    this.options = in.getShort();
                    break;
                }
                case 2: {
                    this.enabled = true;
                    this.password = in.getAnsi();
                }
            }
        }
    }

    public void store(TaggedWriter out) throws IOException {
        out.putInt16(1, (short)this.options);
        out.putAnsi(2, this.password);
    }

    public void storeAs(int tag, TaggedWriter out) throws IOException {
        if (!this.enabled) {
            return;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(data);
        this.store(writer);
        out.putEmpty(tag);
        writer.flush();
        out.putRaw(202, data.internalBuffer(), data.size());
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

