/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.document;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.web.reports.document.DocFont;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.document.IDocumentElement;
import inform.agent.web.reports.style.DocTextStyle;
import inform.agent.web.reports.style.TextStyle;
import inform.agent.web.utils.Font;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public abstract class DocElement
implements IDocumentElement {
    protected final Document document;
    protected TextStyle style = null;
    protected DocTextStyle docStyle = null;
    protected IDocumentElement parent = null;
    protected double width = 0.0;
    protected double height = 0.0;
    protected boolean useParentFont = true;

    protected DocElement(Document document) {
        this.document = document;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public IDocumentElement getParent() {
        return this.parent;
    }

    protected void createStyle() {
        if (this.style == null) {
            this.style = this.docStyle != null ? new TextStyle(this.docStyle.getFont(), this.docStyle.getColor()) : this.document.createDefaultTextStyle();
        }
    }

    public void prepareStore() {
        this.actualizeStyle();
    }

    public void finalizeDocument() {
    }

    public void store(TaggedWriter out) throws InformException, IOException {
        if (this.style != null || this.docStyle == null) {
            this.actualizeStyle();
        }
        if (this.docStyle != null) {
            DocFont font = this.docStyle.getFont();
            out.putInt32(8, font.id());
            if (font.isParent()) {
                out.putEmpty(10);
            }
        }
        out.putInt32(9, this.getColor());
    }

    public void beforeLoad() throws InformException, IOException {
        IDocumentElement parent = this.getParent();
        if (parent != null) {
            Font font = this.getFont();
            font.setParent(parent.getFont());
        }
    }

    public void load(TaggedReader in) throws InformException, IOException {
        this.beforeLoad();
        while (in.next()) {
            this.readTag(in.getCurrentTag(), in);
        }
        this.afterLoad();
    }

    @Override
    public Font getEffectiveFont() {
        Font font = this.getFont();
        IDocumentElement parent = this.getParent();
        if (this.useParentFont && parent != null) {
            font = parent.getEffectiveFont();
        }
        return font;
    }

    public void afterLoad() throws InformException, IOException {
        if (this.useParentFont) {
            Font font = this.getEffectiveFont();
            this.docStyle = this.document.textStyles().add(this.document, font, this.getEffectiveColor());
            this.style = null;
        }
        this.actualizeStyle();
    }

    public void readTag(int tag, TaggedReader in) throws IOException, InformException {
        switch (tag) {
            case 9: {
                this.setColor(in.getInt());
                break;
            }
            case 8: {
                TaggedReader reader = in.getSubStreamReader();
                Font font = this.getFont();
                font.load(reader);
                this.useParentFont = false;
                this.setFont(font);
                break;
            }
        }
    }

    public boolean getUseParentFont() {
        return this.useParentFont;
    }

    public DocTextStyle textStyle() {
        if (this.style != null || this.docStyle == null) {
            this.actualizeStyle();
        }
        return this.docStyle;
    }

    @Override
    public Font getFont() {
        if (this.style != null) {
            return this.style.getFont();
        }
        if (this.docStyle != null) {
            return this.docStyle.getFont();
        }
        this.createStyle();
        return this.style.getFont();
    }

    public void setFont(Font font) {
        this.createStyle();
        this.style.setFont(font);
    }

    public int getColor() {
        if (this.style != null) {
            return this.style.getColor();
        }
        if (this.docStyle != null) {
            return this.docStyle.getColor();
        }
        this.createStyle();
        return this.style.getColor();
    }

    @Override
    public int getEffectiveColor() {
        return this.getColor();
    }

    public void setColor(int color) {
        this.createStyle();
        this.style.setColor(color);
    }

    protected void actualizeStyle() {
        this.actualizeStyle(this.document);
    }

    protected void actualizeStyle(Document document) {
        if (this.style == null && this.docStyle != null) {
            return;
        }
        Font font = this.getFont();
        this.docStyle = document.textStyles().add(document, font, this.getEffectiveColor());
        this.style = null;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    protected void applyStyle(String name, Object value) {
        if (name.equalsIgnoreCase("font")) {
            if (!(value instanceof Font)) {
                return;
            }
            Font f = (Font)value;
            this.setFont(f);
        } else if (name.equalsIgnoreCase("fontName")) {
            String fn = ValueCaster.toString(value);
            this.createStyle();
            Font f = this.getFont();
            f.setName(fn);
        } else if (name.equalsIgnoreCase("fontStyle")) {
            int fs = ValueCaster.toInt(value);
            this.createStyle();
            Font f = this.getFont();
            f.setStyle(fs);
        } else if (name.equalsIgnoreCase("fontSize")) {
            int fs = ValueCaster.toInt(value);
            if (fs <= 0) {
                return;
            }
            this.createStyle();
            Font f = this.getFont();
            f.setSize(fs);
        } else if (name.equalsIgnoreCase("fontColor")) {
            int color = ValueCaster.toInt(value);
            if (color <= 0) {
                return;
            }
            this.createStyle();
            Font f = this.getFont();
            f.setColor(color);
        } else if (name.equalsIgnoreCase("color")) {
            int color = ValueCaster.toInt(value);
            this.setColor(color);
        }
    }

    public static Object applyStyle(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        return null;
    }
}

