/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports.style;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.style.TextStyle;
import inform.agent.web.utils.Borders;
import inform.agent.web.utils.Font;
import inform.agent.web.utils.HorizontalAlign;
import inform.agent.web.utils.TableMargins;
import inform.agent.web.utils.TextOrientation;
import inform.agent.web.utils.VerticalAlign;
import java.io.IOException;

public class CellStyle
extends TextStyle {
    private final TableMargins _margins = new TableMargins();
    private final Borders _borders = new Borders(null);
    private long _hashKey = 0L;
    private int _colspan = 0;
    private int _rowspan = 0;
    private boolean _word_wrap = false;
    private int _col_index = -1;
    private boolean _htmlFormatted = false;
    private double _left = 0.0;
    private double _width = 0.0;
    private boolean _suppresszero = false;
    private boolean _suppressblank = false;
    private boolean _grouped = false;
    private boolean _useParentFont = true;
    private TextOrientation _orientation = TextOrientation.LEFT_RIGHT;
    private DataType _dataType = DataType.NONE;
    private boolean _isFormatSeparateThausand = false;
    private boolean _isKeepTailZero = false;
    private int _formatScale = -1;
    private int _formatId = 0;
    private HorizontalAlign _hAlign = HorizontalAlign.DEFAULT;
    private VerticalAlign _vAlign = VerticalAlign.DEFAULT;

    public CellStyle() {
    }

    public CellStyle(Font font) {
        super(font, 0x1FFFFFFF);
    }

    public CellStyle(Font font, int color, TableMargins margins) {
        super(font, color);
        this._margins.assign(margins);
    }

    public static void load(Document document, TaggedReader in) throws IOException, TaggedReaderException {
        CellStyle cs = null;
        document.useHashedCellStyle = true;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 55: {
                    cs = new CellStyle();
                    cs._hashKey = in.getUnsignedInt();
                    break;
                }
                case 46: {
                    assert (cs != null);
                    cs._col_index = in.getInt();
                    break;
                }
                case 53: {
                    cs._left = in.getDouble();
                    break;
                }
                case 2: {
                    cs._borders.load(in.getSubStreamReader());
                    break;
                }
                case 3: {
                    cs._hAlign = HorizontalAlign.create(in.getInt());
                    break;
                }
                case 4: {
                    cs._vAlign = VerticalAlign.create(in.getInt());
                    break;
                }
                case 41: {
                    cs._colspan = in.getInt();
                    break;
                }
                case 42: {
                    cs._rowspan = in.getInt();
                    break;
                }
                case 5: {
                    cs._width = in.getDouble();
                    break;
                }
                case 40: {
                    TaggedReader reader = in.getSubStreamReader();
                    cs._margins.load(reader);
                    cs._margins.update();
                    break;
                }
                case 43: {
                    int suppress = in.getInt();
                    cs._suppresszero = (suppress & 1) != 0;
                    cs._suppressblank = (suppress & 2) != 0;
                    break;
                }
                case 44: {
                    cs._word_wrap = true;
                    break;
                }
                case 48: {
                    cs._dataType = DataType.getDataTypeById(in.getInt());
                    break;
                }
                case 49: {
                    cs._isFormatSeparateThausand = true;
                    break;
                }
                case 50: {
                    cs._formatScale = in.getInt();
                    break;
                }
                case 51: {
                    cs._isKeepTailZero = true;
                    break;
                }
                case 52: {
                    cs._formatId = in.getInt();
                    break;
                }
                case 45: {
                    cs._orientation = TextOrientation.create(in.getInt());
                    break;
                }
                case 9: {
                    cs.setColor(in.getInt());
                    break;
                }
                case 8: {
                    TaggedReader reader = in.getSubStreamReader();
                    Font font = cs.getFont();
                    font.load(reader);
                    cs._useParentFont = false;
                    cs.setFont(font);
                    break;
                }
                case 56: {
                    if (cs == null) break;
                    document.fattyCellStyles.add(cs);
                }
            }
        }
    }

    public TableMargins getMargins() {
        return this._margins;
    }

    public Borders getBorders() {
        return this._borders;
    }

    public long getHashKey() {
        return this._hashKey;
    }

    public int getCol_index() {
        return this._col_index;
    }

    public void setCol_index(int col_index) {
        this._col_index = col_index;
    }

    public int getFormatId() {
        return this._formatId;
    }

    public void setFormatId(int formatId) {
        this._formatId = formatId;
    }

    public int getFormatScale() {
        return this._formatScale;
    }

    public void setFormatScale(int formatScale) {
        this._formatScale = formatScale;
    }

    public boolean getIsKeepTailZero() {
        return this._isKeepTailZero;
    }

    public void setIsKeepTailZero(boolean isKeepTailZero) {
        this._isKeepTailZero = isKeepTailZero;
    }

    public boolean getIsFormatSeparateThausand() {
        return this._isFormatSeparateThausand;
    }

    public void setIsFormatSeparateThausand(boolean isFormatSeparateThausand) {
        this._isFormatSeparateThausand = isFormatSeparateThausand;
    }

    public int getVerticalAlign() {
        return this._vAlign.value();
    }

    public void setVerticalAlign(int vAlign) {
        this._vAlign = VerticalAlign.create(vAlign);
    }

    public int getHorizontalAlign() {
        return this._hAlign.value();
    }

    public void setHorizontalAlign(int hAlign) {
        this._hAlign = HorizontalAlign.create(hAlign);
    }

    public int getDataType() {
        return this._dataType.getTypeId();
    }

    public void setDataType(int dataType) {
        this._dataType = DataType.getDataTypeById(dataType);
    }

    public int getOrientation() {
        return this._orientation.value();
    }

    public void setOrientation(int orientation) {
        this._orientation = TextOrientation.create(orientation);
    }

    public double getWidth() {
        return this._width;
    }

    public void setWidth(double width) {
        this._width = width;
    }

    public double getLeft() {
        return this._left;
    }

    public void setLeft(double left) {
        this._left = left;
    }

    public boolean getUseParentFont() {
        return this._useParentFont;
    }

    public void setUseParentFont(boolean useParentFont) {
        this._useParentFont = useParentFont;
    }

    public boolean getGrouped() {
        return this._grouped;
    }

    public void setGrouped(boolean grouped) {
        this._grouped = grouped;
    }

    public boolean getSuppressblank() {
        return this._suppressblank;
    }

    public void setSuppressblank(boolean suppressblank) {
        this._suppressblank = suppressblank;
    }

    public boolean getSuppresszero() {
        return this._suppresszero;
    }

    public void setSuppresszero(boolean suppresszero) {
        this._suppresszero = suppresszero;
    }

    public boolean getHtmlFormatted() {
        return this._htmlFormatted;
    }

    public void setHtmlFormatted(boolean htmlFormatted) {
        this._htmlFormatted = htmlFormatted;
    }

    public boolean getWord_wrap() {
        return this._word_wrap;
    }

    public void setWord_wrap(boolean word_wrap) {
        this._word_wrap = word_wrap;
    }

    public int getRowspan() {
        return this._rowspan;
    }

    public void set(int rowspan) {
        this._rowspan = rowspan;
    }

    public int getColspan() {
        return this._colspan;
    }

    public void setColspan(int colspan) {
        this._colspan = colspan;
    }
}

