/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.rq;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.SearchParameters;
import inform.agent.db.SortDirection;
import inform.agent.db.SortingField;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.MultitypeArrayGetter;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.ResultSetPostProcess;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.db.utils.PackedRowContent;
import inform.agent.expr.FunctionTerm;
import inform.agent.expr.ParameterTerm;
import inform.agent.expr.SymbolTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.files.FileCache;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.net.Security;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ServerTableExecutor;
import inform.agent.scripts.sql.ExtraField;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryDescriptor;
import inform.agent.scripts.sql.QueryGeneratedSql;
import inform.agent.scripts.sql.QuerySortFieldList;
import inform.agent.scripts.sql.ReturnedFields;
import inform.agent.scripts.sql.expr.Condition;
import inform.agent.scripts.sql.expr.QueryFieldTerm;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import inform.agent.web.forms.components.WebDatasource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;
import org.mozilla.javascript.Context;

public class FetchRecords
extends AsmoServlet.WithSession {
    private static final int CACHE_ROWS_PER_CHUNK = 4096;
    private static final int MAX_ROWS_PER_FETCH = 131072;
    private static final FileCache CACHE;

    public FetchRecords() {
        super(AsmoServlet.Type.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, Session session) throws Throwable {
        response.setCharacterEncoding("WINDOWS-1251");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/json");
        String requestNode = request.getParameter("node");
        String requestFields = request.getParameter("fields");
        String requestParams = request.getParameter("params");
        String requestWhere = request.getParameter("where");
        String requestSort = request.getParameter("sort");
        String requestLimit = request.getParameter("limit");
        String requestSLimit = request.getParameter("slimit");
        String requestSalt = request.getParameter("salt");
        String requestUID = request.getParameter("uid");
        String requestOwner = request.getParameter("owner");
        String key = requestNode + "%" + requestFields + "%" + requestParams + "%" + requestWhere + "%" + requestSort + "%4096";
        ExecuteParams executeParams = new ExecuteParams();
        executeParams.debug = request.getQueryString();
        executeParams.key = FetchRecords.enquoteKey(key);
        if (requestSLimit != null) {
            executeParams.fetchSLimit = Integer.parseInt(requestSLimit) - 256;
        }
        if (requestLimit != null) {
            String[] sp = requestLimit.split(",");
            if (sp.length > 1) {
                executeParams.fetchRange0 = Integer.parseInt(sp[0]);
                executeParams.fetchRange1 = Integer.parseInt(sp[1]);
                if (executeParams.fetchRange1 + 1 <= executeParams.fetchRange0) {
                    throw new InformException("bad request params");
                }
                if (requestSalt != null) {
                    void var23_29;
                    long salt = Long.parseLong(requestSalt);
                    int b0 = executeParams.fetchRange0 / 4096;
                    int b1 = executeParams.fetchRange1 / 4096;
                    long maxAge = System.currentTimeMillis() - 600000L;
                    byte[][] byArrayArray = new byte[b1 - b0 + 1][];
                    for (int i = b0; i <= b1; ++i) {
                        int ci = i - b0;
                        byte[] chunk = CACHE.get(FetchRecords.chunkKey(executeParams.key, salt, i), maxAge);
                        if (chunk == null) {
                            if (ci > 0 && this.checkEos(byArrayArray[ci - 1])) {
                                byte[][] byArray = (byte[][])Arrays.copyOf(byArrayArray, ci);
                                break;
                            }
                            Object var23_28 = null;
                            Core.logger.info("fetchRecords: cache miss");
                            break;
                        }
                        byArrayArray[ci] = chunk;
                    }
                    if (var23_29 != null) {
                        this.sendData(response, (byte[][])var23_29, executeParams);
                        return;
                    } else {
                        PrintWriter w = response.getWriter();
                        w.append("{\"lost\":true}");
                    }
                    return;
                }
            } else {
                executeParams.fetchLimit = Integer.parseInt(sp[0]);
            }
        }
        double nodeId = 0.0;
        try {
            nodeId = Double.parseDouble(requestNode);
        }
        catch (NumberFormatException e) {
            throw new InformException("bad request params");
        }
        if (requestFields != null) {
            String[] sp = requestFields.split(",");
            executeParams.resultFields = new int[sp.length];
            for (int i = 0; i < executeParams.resultFields.length; ++i) {
                executeParams.resultFields[i] = Integer.parseInt(sp[i]);
            }
        }
        BasicNode node = MtdEngine.getValidTranslatedNode(nodeId);
        Acl acl = Security.acl(node);
        Session.User user = session.user();
        if ((user.accessMask(acl) & 0x4000000) == 0) {
            throw new InformException("access denied");
        }
        executeParams.host = new WebServerSideHost(nodeId, user, (AbstractConnection)((Request)request).getConnection());
        try {
            if (requestParams != null) {
                executeParams.inputParams = (Object[])JSON.parse(requestParams);
            }
            if (requestWhere != null) {
                executeParams.inputWhere = (Object[])JSON.parse(requestWhere);
            }
            if (requestSort != null) {
                Object[] s;
                for (Object e : s = (Object[])JSON.parse(requestSort)) {
                    Object[] se = (Object[])e;
                    int jd = ((Number)se[0]).intValue();
                    Object[] ids = (Object[])se[1];
                    if (ids == null || ids.length == 0) continue;
                    int[] path = new int[ids.length];
                    int index = 0;
                    for (Object id : ids) {
                        path[index++] = ValueCaster.toInt(id);
                    }
                    ServerTableExecutor.SortInfo sf = new ServerTableExecutor.SortInfo(path, SortDirection.values()[jd]);
                    if (executeParams.sortInfoFields == null) {
                        executeParams.sortInfoFields = new ArrayList();
                    }
                    executeParams.sortInfoFields.add(sf);
                }
            }
            SSContext.WebRequest ssContext = new SSContext.WebRequest(session.newRequestNo(), 1, session);
            ssContext.ownerId = ValueCaster.toDouble(requestOwner);
            ssContext.nodeId = nodeId;
            ssContext.uid = ValueCaster.toInt(requestUID);
            String sep = "";
            ssContext.script = "";
            if (!Strings.isVoid(requestFields)) {
                ssContext.script = ssContext.script + sep + "fields: " + requestFields;
                sep = "\n";
            }
            if (!Strings.isVoid(requestParams)) {
                ssContext.script = ssContext.script + sep + "params: " + requestParams;
                sep = "\n";
            }
            if (!Strings.isVoid(requestWhere)) {
                ssContext.script = ssContext.script + sep + "where: " + requestWhere;
                sep = "\n";
            }
            if (!Strings.isVoid(requestSort)) {
                ssContext.script = ssContext.script + sep + "sort: " + requestSort;
                sep = "\n";
            }
            if (!Strings.isVoid(requestLimit)) {
                ssContext.script = ssContext.script + sep + "limit: " + requestLimit;
                sep = "\n";
            }
            if (!Strings.isVoid(requestSLimit)) {
                ssContext.script = ssContext.script + sep + "slimit:" + requestSLimit;
                sep = "\n";
            }
            switch (node.getType()) {
                case 12: {
                    this.executeParameterizedTable(ssContext, (TableNode)node, executeParams, response);
                    return;
                }
                case 49: {
                    this.executeQuery(ssContext, node, executeParams, response);
                    return;
                }
                case 19: {
                    this.executeSearch(ssContext, node, executeParams, response);
                    return;
                }
                case 48: {
                    this.executeSSTable(ssContext, node, executeParams, response);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported node type (" + node.getType() + ")");
                }
            }
        }
        finally {
            executeParams.host.close();
        }
    }

    private boolean checkEos(byte[] chunk) throws IOException {
        TaggedReader reader = new TaggedReader(chunk);
        while (reader.next()) {
            if (reader.getCurrentTag() != 4) continue;
            return true;
        }
        return false;
    }

    private void sendData(HttpServletResponse response, byte[][] chunks, ExecuteParams executeParams) throws IOException {
        int recordIndex = executeParams.fetchRange0 / 4096 * 4096;
        CountedWriter w = new CountedWriter(response.getWriter());
        StringBuilder rowBuilder = new StringBuilder();
        w.append("{\"rows\":[");
        for (byte[] chunk : chunks) {
            TaggedReader reader = new TaggedReader(chunk);
            DataType[] fields = null;
            boolean run = true;
            block12: while (run && reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 2: {
                        int[] meta = LittleEndian.toIntArray(reader.getRaw());
                        fields = new DataType[meta.length / 2];
                        for (int i = 0; i < fields.length; ++i) {
                            fields[i] = DataType.getDataTypeById(meta[i * 2 + 1]);
                        }
                        continue block12;
                    }
                    case 4: {
                        if (!reader.getBoolean()) {
                            if (recordIndex > executeParams.fetchRange0) {
                                w.append(',');
                            }
                            w.append("null");
                        }
                        run = false;
                        break;
                    }
                    case 3: {
                        if (recordIndex >= executeParams.fetchRange0) {
                            byte[] data;
                            if (recordIndex > executeParams.fetchRange1) {
                                run = false;
                                break;
                            }
                            if (reader.getCurrentTagSize() == 0) {
                                w.append(",null");
                                run = false;
                                break;
                            }
                            if (null == fields) {
                                throw new InformException("Incorrect sequence of chunks");
                            }
                            rowBuilder.setLength(0);
                            if (recordIndex > executeParams.fetchRange0) {
                                rowBuilder.append(',');
                            }
                            byte[] header = data = reader.getRaw();
                            rowBuilder.append('[');
                            LittleEndianDataInputStream input = new LittleEndianDataInputStream(new ByteArrayInputStream(data));
                            input.skipBytes(PackedRowContent.getHeaderSize(fields.length));
                            block14: for (int i = 0; i < fields.length; ++i) {
                                byte mask;
                                if (i > 0) {
                                    rowBuilder.append(',');
                                }
                                if ((header[i / 8] & (mask = (byte)(1 << (byte)(i % 8)))) == 0) {
                                    rowBuilder.append("null");
                                    continue;
                                }
                                switch (fields[i]) {
                                    case BOOLEAN: {
                                        rowBuilder.append(JSON.toString(input.readInt() != 0));
                                        continue block14;
                                    }
                                    case INTEGER: {
                                        rowBuilder.append(JSON.toString(input.readInt()));
                                        continue block14;
                                    }
                                    case PRIMARY_KEY: 
                                    case FLOAT: 
                                    case DATE_TIME: 
                                    case INTERVAL: 
                                    case DIRECTORY: 
                                    case METATREE_NODE: {
                                        rowBuilder.append(JSON.toString(input.readDouble()));
                                        continue block14;
                                    }
                                    case STRING: 
                                    case BIG_NUMBER: 
                                    case UNICODE: {
                                        rowBuilder.append(JSON.toString(input.readAnsi()));
                                        continue block14;
                                    }
                                    default: {
                                        rowBuilder.append("null");
                                    }
                                }
                            }
                            rowBuilder.append(']');
                            if (w.count + rowBuilder.length() > executeParams.fetchSLimit) {
                                run = false;
                                break;
                            }
                            w.append(rowBuilder);
                        }
                        ++recordIndex;
                    }
                }
            }
        }
        w.append("]}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void sendData(SSContext ssContext, HttpServletResponse response, GeneratedSql sql, TableDescriptor tableDescriptor, Collection<ExtraField> extraFields, ExecuteParams executeParams, boolean needRealId) throws SQLException, IOException {
        int[] resultFields = executeParams.resultFields;
        Context context = null;
        try {
            ConnectionManager connectionManager = new ConnectionManager(null, "rq:FetchRecords");
            try {
                ResultSetPostProcess postProcess;
                if (sql.hasPostProcess()) {
                    context = Core.asmoJsContextFactory.enterContext();
                    postProcess = sql.createPostProcess(ssContext, context, executeParams.host, connectionManager, 0);
                } else {
                    postProcess = null;
                }
                double databaseId = tableDescriptor.getDbId();
                String sqlText = sql.getSqlText();
                long start = System.currentTimeMillis();
                DatabaseConnection database = connectionManager.getConnection(databaseId, "servlet:FetchRecords");
                database.markAsReadonly();
                try (PreparedStatement statement = database.prepareStatement(((Object)((Object)this)).getClass().getSimpleName(), sqlText);){
                    statement.setQueryTimeout();
                    statement.setSqlInfo(sql);
                    statement.setTableDesc(tableDescriptor);
                    sql.setParametersTo(statement);
                    try (ResultSet resultSet = statement.executeQuery(ssContext);){
                        void var31_36;
                        String columnName;
                        int i;
                        MultitypeArrayGetter mag;
                        long duration = System.currentTimeMillis() - start;
                        if (duration > 30000L) {
                            Core.logger.info("! long time({}) sql request {}", (Object)duration, (Object)((Object)((Object)this)).toString());
                        }
                        if (postProcess != null) {
                            postProcess.setResultSet(resultSet, true);
                            mag = postProcess;
                        } else {
                            mag = resultSet;
                        }
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        int recordIdFieldIndex = 0;
                        FieldDescriptor recordIdField = tableDescriptor.getRecordIdField();
                        boolean hasPrimaryKey = false;
                        List<FieldDescriptor> tableFields = tableDescriptor.getFields();
                        if (recordIdField != null) {
                            for (i = 1; i <= metadata.getColumnCount(); ++i) {
                                columnName = metadata.getColumnLabel(i);
                                if (!recordIdField.getRawName().equalsIgnoreCase(columnName)) continue;
                                hasPrimaryKey = true;
                                recordIdFieldIndex = i;
                                break;
                            }
                        }
                        if (!hasPrimaryKey && needRealId) {
                            block19: for (i = 1; i <= metadata.getColumnCount(); ++i) {
                                columnName = metadata.getColumnLabel(i);
                                if (!"ID".equalsIgnoreCase(columnName)) continue;
                                for (FieldDescriptor fieldDescriptor : tableFields) {
                                    if (!columnName.equalsIgnoreCase(fieldDescriptor.getRawName())) continue;
                                    recordIdField = fieldDescriptor;
                                    break block19;
                                }
                                break;
                            }
                        }
                        boolean geometryGlient = false;
                        ArrayList<FieldDescriptor> recordFields = new ArrayList<FieldDescriptor>();
                        if (resultFields != null && resultFields.length != 0) {
                            for (int fieldId : resultFields) {
                                if (fieldId == -1) {
                                    if (recordIdField == null) {
                                        recordIdField = tableDescriptor.getValidRecordIdField();
                                    }
                                    recordFields.add(recordIdField);
                                    continue;
                                }
                                FieldDescriptor field = null;
                                if (extraFields != null) {
                                    for (ExtraField f : extraFields) {
                                        if (f.id != fieldId) continue;
                                        field = new FieldDescriptor(f, -1);
                                        break;
                                    }
                                }
                                if (field == null && ((field = tableDescriptor.getExistingFieldDescriptor(fieldId)) == null || field.isAbstract())) continue;
                                recordFields.add(field);
                            }
                        } else {
                            if (recordIdField != null) {
                                recordFields.add(recordIdField);
                            }
                            Object object = tableFields.iterator();
                            while (object.hasNext()) {
                                FieldDescriptor fieldDescriptor = (FieldDescriptor)object.next();
                                if (fieldDescriptor.isAbstract() || !geometryGlient && fieldDescriptor.getType() == DataType.GEOMETRY) continue;
                                recordFields.add(fieldDescriptor);
                            }
                            int index = 0;
                            resultFields = new int[recordFields.size()];
                            for (FieldDescriptor field : recordFields) {
                                resultFields[index++] = field.getId();
                            }
                        }
                        int[] columnsMap = new int[recordFields.size()];
                        boolean bl = false;
                        while (var31_36 < columnsMap.length) {
                            FieldDescriptor field = (FieldDescriptor)recordFields.get((int)var31_36);
                            columnsMap[var31_36] = -1;
                            if (field != null) {
                                for (int i2 = 0; i2 < mag.getColumnCount(); ++i2) {
                                    String columnName2 = mag.getColumnLabel(i2 + 1);
                                    if (!columnName2.equalsIgnoreCase(field.getRawName())) continue;
                                    columnsMap[var31_36] = i2 + 1;
                                    break;
                                }
                            }
                            ++var31_36;
                        }
                        CacheWriter cacheWriter = new CacheWriter(executeParams.debug, executeParams.key, tableDescriptor, recordFields, recordIdFieldIndex, executeParams.host);
                        int recordCount = 0;
                        CountedWriter w = new CountedWriter(response.getWriter());
                        StringBuilder rowBuilder = new StringBuilder();
                        w.append("{\"rows\":[");
                        int fieldCount = recordFields.size();
                        boolean nc = false;
                        boolean hasIgnoredRows = false;
                        boolean responseFull = false;
                        while (resultSet.next()) {
                            if (postProcess != null && postProcess.next()) continue;
                            if (recordCount == 131072) {
                                ++recordCount;
                                break;
                            }
                            cacheWriter.writeRow(resultSet, columnsMap);
                            if (!responseFull && recordCount >= executeParams.fetchRange0 && recordCount <= executeParams.fetchRange1) {
                                rowBuilder.setLength(0);
                                if (nc) {
                                    rowBuilder.append(',');
                                }
                                nc = true;
                                rowBuilder.append('[');
                                block28: for (int i3 = 0; i3 < fieldCount; ++i3) {
                                    FieldDescriptor field = recordFields.get(i3);
                                    int columnIndex = columnsMap[i3];
                                    if (i3 > 0) {
                                        rowBuilder.append(',');
                                    }
                                    if (columnIndex < 0) {
                                        rowBuilder.append("null");
                                        continue;
                                    }
                                    switch (field.getType()) {
                                        case BOOLEAN: {
                                            boolean bool = mag.getBoolean(columnIndex);
                                            if (mag.wasNull()) {
                                                rowBuilder.append("null");
                                                continue block28;
                                            }
                                            rowBuilder.append(JSON.toString(bool));
                                            continue block28;
                                        }
                                        case INTEGER: 
                                        case PRIMARY_KEY: 
                                        case FLOAT: 
                                        case INTERVAL: 
                                        case DIRECTORY: 
                                        case METATREE_NODE: {
                                            double number = mag.getDouble(columnIndex);
                                            if (mag.wasNull()) {
                                                rowBuilder.append("null");
                                                continue block28;
                                            }
                                            rowBuilder.append(JSON.toString(number));
                                            continue block28;
                                        }
                                        case DATE_TIME: {
                                            double number = mag.getDateTime(columnIndex);
                                            if (mag.wasNull()) {
                                                rowBuilder.append("null");
                                                continue block28;
                                            }
                                            rowBuilder.append(JSON.toString(number));
                                            continue block28;
                                        }
                                        case STRING: 
                                        case BIG_NUMBER: 
                                        case UNICODE: {
                                            String string = mag.getString(columnIndex);
                                            if (mag.wasNull()) {
                                                rowBuilder.append("null");
                                                continue block28;
                                            }
                                            rowBuilder.append(JSON.toString(string));
                                            continue block28;
                                        }
                                        default: {
                                            rowBuilder.append("null");
                                        }
                                    }
                                }
                                rowBuilder.append(']');
                                if (w.count + rowBuilder.length() > executeParams.fetchSLimit) {
                                    hasIgnoredRows = true;
                                    responseFull = true;
                                } else {
                                    w.append(rowBuilder);
                                }
                            } else {
                                hasIgnoredRows = true;
                            }
                            ++recordCount;
                        }
                        w.append(']');
                        if (hasIgnoredRows || cacheWriter.flushed) {
                            cacheWriter.finish(recordCount >= 131072);
                        }
                        if (hasIgnoredRows) {
                            w.append(",\"salt\":").append(Long.toString(cacheWriter.salt));
                        }
                        w.append(",\"rcnt\":").append(Integer.toString(recordCount));
                        w.append('}');
                        w.flush();
                        connectionManager.commit();
                    }
                }
            }
            finally {
                connectionManager.release();
            }
        }
        finally {
            if (context != null) {
                context.exit();
            }
        }
    }

    private DataType valueType(Object e) {
        if (e instanceof String) {
            return DataType.STRING;
        }
        if (e instanceof Number) {
            return DataType.FLOAT;
        }
        if (e instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (e == null) {
            return DataType.NONE;
        }
        throw new UnsupportedOperationException();
    }

    private Term buildExpressionOperand(Object e, Condition condition, Collection<Term> terms, Query query, Term last) throws IOException {
        FieldDescriptor fd;
        int[] idPath;
        if (e instanceof Object[]) {
            SymbolTerm term = new SymbolTerm(condition);
            terms.add(term);
            term.setSymbolId(0);
            this.buildExpression((Object[])e, condition, terms, query, last);
            term = new SymbolTerm(condition);
            terms.add(term);
            term.setSymbolId(1);
            return term;
        }
        if (e instanceof Map) {
            Map m = (Map)e;
            Object v = m.get("f");
            if (v != null) {
                int fieldId = ValueCaster.toInt(v);
                QueryFieldTerm term = new QueryFieldTerm(terms.size() + 1, query.getRootNode().getEntryId(), fieldId, query, condition);
                terms.add(term);
                return term;
            }
            v = m.get("v");
            if (v != null) {
                Object[] vv = (Object[])v;
                ParametersList plist = query.getInputParameters();
                Parameter p = plist.createParameter(this.valueType(vv[0]));
                p.setRawValue(vv.length > 1 ? vv : vv[0]);
                ParameterTerm term = new ParameterTerm(terms.size() + 1, p.getId(), condition);
                terms.add(term);
                return term;
            }
            throw new UnsupportedOperationException();
        }
        ValueTerm term = new ValueTerm(condition);
        DataType dt = last instanceof QueryFieldTerm ? ((idPath = ((QueryFieldTerm)last).getFieldIdPath()).length == 1 && idPath[0] == -1 ? DataType.PRIMARY_KEY : ((fd = WebDatasource.resolveFieldDescriptor(query.getResultMetadata().getDescriptor(), idPath)) != null ? fd.getType() : DataType.STRING)) : this.valueType(e);
        term.setValue(dt, e);
        terms.add(term);
        return term;
    }

    private void buildExpression(Object[] ee, Condition condition, Collection<Term> terms, Query query, Term last) throws IOException {
        if (ee.length == 2) {
            FunctionTerm func = new FunctionTerm(condition);
            String f = ValueCaster.toString(ee[0]).toLowerCase();
            if (!"trim".equalsIgnoreCase(f)) {
                throw new UnsupportedOperationException();
            }
            func.setFunctionId(3);
            terms.add(func);
            SymbolTerm symb = new SymbolTerm(condition);
            terms.add(symb);
            symb.setSymbolId(0);
            this.buildExpressionOperand(ee[1], condition, terms, query, last);
            symb = new SymbolTerm(condition);
            terms.add(symb);
            symb.setSymbolId(1);
        } else {
            last = this.buildExpressionOperand(ee[0], condition, terms, query, last);
            for (int i = 2; i < ee.length; ++i) {
                Term term = last = this.buildExpressionOperand(ee[i], condition, terms, query, last);
                condition.createOperator(term, String.valueOf(ee[i - 1]));
            }
        }
    }

    private void executeParameterizedTable(SSContext ssContext, TableNode tableNode, ExecuteParams executeParams, HttpServletResponse response) throws Exception {
        Query query = new Query((ServerSideHost)executeParams.host, 0);
        Condition condition = query.createParameterizedTableCondition(tableNode.getId());
        if (executeParams.resultFields != null && executeParams.resultFields.length != 0) {
            ReturnedFields returnedFields = new ReturnedFields();
            for (int fieldId : executeParams.resultFields) {
                returnedFields.add(fieldId);
            }
            query.getRootNode().setReturnedFields(returnedFields);
        }
        if (executeParams.inputParams != null) {
            throw new UnsupportedOperationException("only where-condition supported");
        }
        if (executeParams.inputWhere != null) {
            this.buildExpression(executeParams.inputWhere, condition, condition.terms(), query, null);
        }
        query.setFetchLimit(executeParams.fetchLimit);
        TableDescriptor tableDescriptor = tableNode.getDescriptor();
        Collection<SortingField> sorting = ServerTableExecutor.sortingInfoToSortingFields(tableDescriptor, 0, executeParams.sortInfoFields);
        if (sorting != null) {
            query.setSortFields(new QuerySortFieldList(sorting));
        }
        String sqlText = query.generateSqlText(null, null);
        QueryGeneratedSql generatedSql = new QueryGeneratedSql(query, sqlText, query.getSqlParameters());
        this.sendData(ssContext, response, generatedSql, tableDescriptor, null, executeParams, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void executeSSTable(SSContext ssContext, BasicNode ssTableNode, ExecuteParams executeParams, HttpServletResponse response) throws Exception {
        ParametersList tableParams = null;
        if (executeParams.inputParams != null || executeParams.inputWhere != null || executeParams.sortInfoFields != null) {
            tableParams = new ParametersList();
            TaggedReader in = new TaggedReader(ssTableNode.getContent());
            while (in.next()) {
                if (in.getCurrentTag() != 152) continue;
                TaggedReader stream = in.getSubStreamReader();
                while (stream.next()) {
                    if (stream.getCurrentTag() != 153) continue;
                    Constants constants = new Constants(executeParams.host.getUserID());
                    tableParams.load(constants, stream.getSubStreamReader(), Core.serverTimeZoneHost);
                    break;
                }
                break;
            }
            if (executeParams.inputParams != null) {
                for (Object e : executeParams.inputParams) {
                    Object[] ee = (Object[])e;
                    int paramId = ((Number)ee[0]).intValue();
                    Parameter p = tableParams.get(paramId);
                    if (p == null) continue;
                    Object value = ee[1];
                    if (value == null) {
                        p.clear();
                        continue;
                    }
                    if (value instanceof Map) {
                        p.setIgnore();
                        continue;
                    }
                    p.setRawValue(value);
                }
            }
        }
        if (tableParams != null) {
            tableParams = tableParams.cloneModifiedParams();
        }
        ConnectionManager connectionManager = new ConnectionManager(null, "rq:FetchRecords.executeSSTable");
        try {
            void var17_27;
            ServerTableExecutor executor = new ServerTableExecutor(ssContext, ssTableNode.getId(), executeParams.host, connectionManager, null, 0);
            executor.setInputParams(tableParams);
            executor.setSorting(executeParams.sortInfoFields);
            Rowset rowset = executor.execute();
            TableDescriptor tableDescriptor = rowset.getTableDescriptor();
            int[] resultFields = executeParams.resultFields;
            FieldDescriptor recordIdField = tableDescriptor.getRecordIdField();
            boolean hasPrimaryKey = false;
            List<FieldDescriptor> tableFields = tableDescriptor.getFields();
            if (recordIdField != null) {
                hasPrimaryKey = true;
            }
            boolean geometryGlient = false;
            ArrayList<FieldDescriptor> recordFields = new ArrayList<FieldDescriptor>();
            if (resultFields != null && resultFields.length != 0) {
                for (int fieldId : resultFields) {
                    if (fieldId == -1) {
                        if (recordIdField == null) {
                            recordIdField = tableDescriptor.getValidRecordIdField();
                        }
                        recordFields.add(recordIdField);
                        continue;
                    }
                    FieldDescriptor field = tableDescriptor.getExistingFieldDescriptor(fieldId);
                    if (field == null || field.isAbstract()) continue;
                    recordFields.add(field);
                }
            } else {
                if (recordIdField != null) {
                    recordFields.add(recordIdField);
                }
                for (FieldDescriptor fieldDescriptor : tableFields) {
                    if (fieldDescriptor.isAbstract() || !geometryGlient && fieldDescriptor.getType() == DataType.GEOMETRY) continue;
                    recordFields.add(fieldDescriptor);
                }
                int index = 0;
                resultFields = new int[recordFields.size()];
                for (FieldDescriptor field : recordFields) {
                    resultFields[index++] = field.getId();
                }
            }
            CacheWriter cache = new CacheWriter(null == executeParams.debug ? "" : executeParams.debug, executeParams.key, tableDescriptor, recordFields, 0, executeParams.host);
            boolean bl = false;
            CountedWriter w = new CountedWriter(response.getWriter());
            StringBuilder rowBuilder = new StringBuilder();
            w.append("{\"rows\":[");
            int fieldCount = recordFields.size();
            boolean nc = false;
            boolean hasIgnoredRows = false;
            boolean responseFull = false;
            rowset.reset();
            while (rowset.next()) {
                void var17_26;
                if (var17_26 == 131072) {
                    ++var17_27;
                    break;
                }
                Row row = rowset.getCurrentRow();
                if (row == null) {
                    throw new InformException("Can not get row at index " + (int)var17_26);
                }
                cache.writeRow(row);
                if (!responseFull && var17_26 >= executeParams.fetchRange0 && var17_26 <= executeParams.fetchRange1) {
                    rowBuilder.setLength(0);
                    if (nc) {
                        rowBuilder.append(',');
                    }
                    nc = true;
                    rowBuilder.append('[');
                    block16: for (int i = 0; i < fieldCount; ++i) {
                        FieldDescriptor field = recordFields.get(i);
                        if (i > 0) {
                            rowBuilder.append(',');
                        }
                        if (field.getIndex() < 0) {
                            rowBuilder.append(JSON.toString(row.getId()));
                            continue;
                        }
                        if (row.getNullFlag(field.getIndex())) {
                            rowBuilder.append("null");
                            continue;
                        }
                        switch (field.getType()) {
                            case BOOLEAN: {
                                boolean bool = row.getNumeric(field.getIndex()) != 0.0;
                                rowBuilder.append(JSON.toString(bool));
                                continue block16;
                            }
                            case INTEGER: 
                            case PRIMARY_KEY: 
                            case FLOAT: 
                            case INTERVAL: 
                            case DIRECTORY: 
                            case METATREE_NODE: {
                                double number = row.getNumeric(field.getIndex());
                                rowBuilder.append(JSON.toString(number));
                                continue block16;
                            }
                            case DATE_TIME: {
                                double number = row.getNumeric(field.getIndex());
                                rowBuilder.append(JSON.toString(number));
                                continue block16;
                            }
                            case STRING: 
                            case BIG_NUMBER: 
                            case UNICODE: {
                                String string = (String)row.getComplex(field.getIndex());
                                rowBuilder.append(JSON.toString(string));
                                continue block16;
                            }
                            default: {
                                rowBuilder.append("null");
                            }
                        }
                    }
                    rowBuilder.append(']');
                    if (w.count + rowBuilder.length() > executeParams.fetchSLimit) {
                        hasIgnoredRows = true;
                        responseFull = true;
                    } else {
                        w.append(rowBuilder);
                    }
                } else {
                    hasIgnoredRows = true;
                }
                ++var17_26;
            }
            w.append(']');
            if (hasIgnoredRows || cache.flushed) {
                cache.finish(var17_27 >= 131072);
            }
            if (hasIgnoredRows) {
                w.append(",\"salt\":").append(Long.toString(cache.salt));
            }
            w.append(",\"rcnt\":").append(Integer.toString((int)var17_27));
            w.append('}');
            w.flush();
            connectionManager.commit();
        }
        finally {
            connectionManager.release();
        }
    }

    private void executeQuery(SSContext ssContext, BasicNode queryNode, ExecuteParams executeParams, HttpServletResponse response) throws Exception {
        ParametersList queryParams = null;
        TableDescriptor tableDescriptor = null;
        java.io.ByteArrayOutputStream relations = null;
        if (executeParams.inputParams != null || executeParams.inputWhere != null || executeParams.sortInfoFields != null) {
            Object[] ee;
            queryParams = new ParametersList();
            TaggedReader in = new TaggedReader(queryNode.getContent());
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 153: {
                        if (executeParams.inputParams == null) break;
                        in.skip();
                        Constants constants = new Constants(executeParams.host.getUserID());
                        queryParams.load(constants, new TaggedReader(in.getSubStream()), Core.serverTimeZoneHost);
                        break;
                    }
                    case 1: {
                        in.skip();
                        double tableId = in.getDouble(151);
                        BasicNode node = MtdEngine.getValidTranslatedNode(tableId);
                        tableDescriptor = ((TableNode)node).getDescriptor();
                    }
                }
            }
            assert (null != tableDescriptor) : "Node content doesn't have table descriptor";
            TaggedWriter out = null;
            if (executeParams.inputWhere != null) {
                block11: for (Object e : executeParams.inputWhere) {
                    ee = (Object[])e;
                    Map f = (Map)ee[0];
                    if (!"=".equals(ee[1])) {
                        throw new UnsupportedOperationException();
                    }
                    int fieldId = ((Number)f.get("f")).intValue();
                    if (relations == null) {
                        relations = new ByteArrayOutputStream();
                        out = new TaggedWriter(relations);
                    }
                    FieldDescriptor field = tableDescriptor.getExistingFieldDescriptor(fieldId);
                    Object value = ee[2];
                    out.putInt32(10, fieldId);
                    if (value == null) {
                        out.putEmpty(12);
                        continue;
                    }
                    switch (field.getType()) {
                        case BOOLEAN: 
                        case INTEGER: {
                            out.putInt32(13, ValueCaster.toInt(value));
                            continue block11;
                        }
                        case PRIMARY_KEY: 
                        case FLOAT: 
                        case INTERVAL: 
                        case DIRECTORY: 
                        case METATREE_NODE: {
                            out.putDouble(14, ValueCaster.toDouble(value));
                            continue block11;
                        }
                        case DATE_TIME: {
                            out.putDouble(14, ValueCaster.toDouble(value));
                            continue block11;
                        }
                        case STRING: 
                        case BIG_NUMBER: 
                        case UNICODE: {
                            out.putString(15, ValueCaster.toString(value));
                            continue block11;
                        }
                        default: {
                            out.putEmpty(12);
                        }
                    }
                }
            }
            if (out != null) {
                out.flush();
            }
            if (executeParams.inputParams != null) {
                for (Object e : executeParams.inputParams) {
                    ee = (Object[])e;
                    int paramId = ((Number)ee[0]).intValue();
                    Parameter p = queryParams.get(paramId);
                    if (p == null) continue;
                    Object value = ee[1];
                    if (value == null) {
                        p.clear();
                        continue;
                    }
                    if (value instanceof Map) {
                        p.setIgnore();
                        continue;
                    }
                    p.setRawValue(value);
                }
            }
        }
        if (queryParams != null) {
            queryParams = queryParams.cloneModifiedParams();
        }
        QueryDescriptor descriptor = new QueryDescriptor(queryParams, executeParams.host, null, "servlet FetchRecords", 0, null, 0);
        if (relations != null) {
            descriptor.setDataRelations(relations.toByteArray());
        }
        Collection<SortingField> sorting = ServerTableExecutor.sortingInfoToSortingFields(tableDescriptor, 0, executeParams.sortInfoFields);
        if (executeParams.sortInfoFields != null) {
            descriptor.setSortFields(new QuerySortFieldList(sorting));
        }
        QueryGeneratedSql generatedSql = Query.generateSqlText(queryNode.getId(), executeParams.host, descriptor, null);
        if (tableDescriptor == null) {
            tableDescriptor = generatedSql.getTableDescriptor();
        }
        this.sendData(ssContext, response, generatedSql, tableDescriptor, generatedSql.getExtraFields(), executeParams, true);
    }

    private void executeSearch(SSContext ssContext, BasicNode searchNode, ExecuteParams executeParams, HttpServletResponse response) throws Exception {
        Collection<SortingField> sorting;
        Object[] ee;
        SqlGenerator sqlGenerator = new SqlGenerator(executeParams.host, executeParams.host);
        ParametersList searchParams = new ParametersList();
        TableDescriptor tableDescriptor = null;
        byte[] searchContent = searchNode.getContent();
        TaggedReader in = new TaggedReader(searchContent);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 153: {
                    in.skip();
                    Constants constants = new Constants(executeParams.host.getUserID());
                    searchParams.load(constants, new TaggedReader(in.getSubStream()), Core.serverTimeZoneHost);
                    break;
                }
                case 1: {
                    in.skip();
                    double tableId = in.getDouble(151);
                    Object[] node = MtdEngine.getValidTranslatedNode(tableId);
                    tableDescriptor = ((TableNode)node).getDescriptor();
                    sqlGenerator.setTableId(tableId);
                }
            }
        }
        assert (null != tableDescriptor) : "Node content doesn't have table descriptor";
        sqlGenerator.setSearchId(searchNode.getId());
        SqlGenerator.Method generationMethod = SqlGenerator.extractSearchGenerationMethod(searchContent);
        sqlGenerator.setSearchContent(searchContent);
        ByteArrayOutputStream relations = null;
        if (executeParams.inputWhere != null) {
            relations = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(relations);
            block11: for (Object e : executeParams.inputWhere) {
                ee = (Object[])e;
                Map f = (Map)ee[0];
                if (!"=".equals(ee[1])) {
                    throw new UnsupportedOperationException();
                }
                int fieldId = ((Number)f.get("f")).intValue();
                FieldDescriptor field = tableDescriptor.getExistingFieldDescriptor(fieldId);
                Object value = ee[2];
                out.putInt32(10, fieldId);
                if (value == null) {
                    out.putEmpty(12);
                    continue;
                }
                switch (field.getType()) {
                    case BOOLEAN: 
                    case INTEGER: {
                        out.putInt32(13, ValueCaster.toInt(value));
                        continue block11;
                    }
                    case PRIMARY_KEY: 
                    case FLOAT: 
                    case INTERVAL: 
                    case DIRECTORY: 
                    case METATREE_NODE: {
                        out.putDouble(14, ValueCaster.toDouble(value));
                        continue block11;
                    }
                    case DATE_TIME: {
                        out.putDouble(14, ValueCaster.toDouble(value));
                        continue block11;
                    }
                    case STRING: 
                    case BIG_NUMBER: 
                    case UNICODE: {
                        out.putString(15, ValueCaster.toString(value));
                        continue block11;
                    }
                    default: {
                        out.putEmpty(12);
                    }
                }
            }
            out.flush();
        }
        if (executeParams.inputParams != null) {
            SearchParameters sqlParams = sqlGenerator.getParameters();
            for (Object e : executeParams.inputParams) {
                ee = (Object[])e;
                int paramId = ((Number)ee[0]).intValue();
                Parameter p = searchParams.get(paramId);
                if (p == null) continue;
                p.setParamBinding(paramId);
                Object value = ee[1];
                if (value == null) {
                    p.clear();
                } else if (value instanceof Map) {
                    p.setIgnore();
                } else {
                    p.setRawValue(value);
                }
                sqlParams.addParameter(paramId);
                if (p.getIsIgnored()) {
                    sqlParams.setIgnored();
                    continue;
                }
                SearchParameters.addParamValue(p, sqlParams);
            }
        }
        if (relations != null) {
            sqlGenerator.setRelation(relations.toByteArray());
        }
        if ((sorting = ServerTableExecutor.sortingInfoToSortingFields(tableDescriptor, 0, executeParams.sortInfoFields)) != null) {
            for (SortingField f : sorting) {
                f.transferTo(sqlGenerator);
            }
        }
        GeneratedSql generatedSql = sqlGenerator.getGeneratedSql(generationMethod, -500);
        this.sendData(ssContext, response, generatedSql, tableDescriptor, null, executeParams, true);
    }

    private static String enquoteKey(String key) throws NoSuchAlgorithmException {
        String HEX = "0123456789abcdef";
        MessageDigest md = MessageDigest.getInstance("md5");
        byte[] digest = md.digest(key.getBytes(TaggedWriter.ANSI));
        char[] result = new char[digest.length * 2];
        for (int i = 0; i < digest.length; ++i) {
            int b = digest[i] & 0xFF;
            result[i * 2 + 0] = "0123456789abcdef".charAt(b >> 4 & 0xF);
            result[i * 2 + 1] = "0123456789abcdef".charAt(b >> 0 & 0xF);
        }
        return new String(result);
    }

    private static String syncKey(String keyTemplate, long salt) {
        return salt + "-" + keyTemplate;
    }

    private static String chunkKey(String keyTemplate, long salt, int chunkNo) {
        return salt + "-" + keyTemplate + "-" + chunkNo;
    }

    static {
        String tempDirProp = Core.getTempDir();
        if (tempDirProp == null) {
            throw new InformException("Can not determine temp directory path");
        }
        File dir = new File(tempDirProp, "PHA_CACHE/WEB_FETCH_RECORDS");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new InformException("Cannot create directory:" + dir);
        }
        CACHE = new FileCache(dir, 1024, 0x40000000L);
    }

    private static class CountedWriter
    implements Appendable,
    Flushable {
        final PrintWriter out;
        int count;

        CountedWriter(PrintWriter out) {
            this.out = out;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.out.append(csq);
            this.count += csq.length();
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.out.append(csq, start, end);
            this.count += end - start;
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.out.append(c);
            ++this.count;
            this.out.flush();
            return this;
        }

        @Override
        public void flush() {
            this.out.flush();
        }
    }

    private static class CacheWriter {
        static final int TAG_DEBUG = 1;
        static final int TAG_METADATA = 2;
        static final int TAG_ROW = 3;
        static final int TAG_EOF = 4;
        final long salt;
        final String keyTemplate;
        final double tableId;
        final int primaryKeyFieldIndex;
        final ArrayList<FieldDescriptor> fields;
        final PackedRowContent packer;
        final ByteArrayOutputStream chunk = new ByteArrayOutputStream();
        final ByteArrayOutputStream row = new ByteArrayOutputStream();
        final ByteArrayOutputStream metadata = new ByteArrayOutputStream();
        final TaggedWriter writer = new TaggedWriter(this.chunk);
        int chunkRows;
        int chunkNoGen;
        boolean flushed;

        CacheWriter(String debug, String key, TableDescriptor table, ArrayList<FieldDescriptor> fields, int primaryKeyFieldIndex, TimeZoneHost timeZoneHost) throws IOException, SQLException {
            this.salt = (long)Core.generateId();
            this.keyTemplate = key;
            this.tableId = table.getNodeId();
            this.primaryKeyFieldIndex = primaryKeyFieldIndex;
            this.fields = fields;
            this.packer = new PackedRowContent(0, 0, true, timeZoneHost, false);
            this.packer.packMetadata(fields, (OutputStream)this.metadata);
            this.writer.putString(1, debug);
            this.writer.putRaw(2, this.metadata);
        }

        void writeRow(ResultSet rs, int[] columnsMap) throws IOException, SQLException {
            this.row.reset();
            double rowId = this.primaryKeyFieldIndex == 0 ? 0.0 : rs.getDouble(this.primaryKeyFieldIndex);
            this.packer.packRecordContent(rs, this.fields, columnsMap, this.tableId, rowId, this.row);
            this.writer.putRaw(3, this.row);
            ++this.chunkRows;
            if (this.chunkRows == 4096) {
                this.flush();
            }
        }

        void writeRow(Row r) throws IOException {
            this.row.reset();
            this.packer.packRecordContent(r, this.row);
            this.writer.putRaw(3, this.row);
            ++this.chunkRows;
            if (this.chunkRows == 4096) {
                this.flush();
            }
        }

        void flush() throws IOException {
            this.writer.flush();
            if (this.chunkRows == 0) {
                return;
            }
            CACHE.put(FetchRecords.chunkKey(this.keyTemplate, this.salt, this.chunkNoGen++), this.chunk);
            this.flushed = true;
            this.chunk.reset();
            this.chunkRows = 0;
            this.writer.putRaw(2, this.metadata);
        }

        void finish(boolean overflow) throws IOException {
            this.writer.putBool(4, overflow);
            this.flush();
        }
    }

    private static class ExecuteParams {
        String debug;
        String key;
        Object[] inputParams = null;
        Object[] inputWhere = null;
        ArrayList<ServerTableExecutor.SortInfo> sortInfoFields = null;
        int[] resultFields = null;
        WebServerSideHost host = null;
        int fetchRange0;
        int fetchRange1 = Integer.MAX_VALUE;
        int fetchSLimit = Integer.MAX_VALUE;
        int fetchLimit = -1;

        private ExecuteParams() {
        }
    }
}

