/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.rq;

import inform.agent.FieldValueGenerator;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.SSContext;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class GenerateFieldValue
extends AsmoServlet.WithSession {
    public GenerateFieldValue() {
        super(AsmoServlet.Type.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, Session session) throws Throwable {
        response.setCharacterEncoding("WINDOWS-1251");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/json");
        TableDescriptor td = TableDescriptor.get(Double.parseDouble(request.getParameter("table")));
        String param = request.getParameter("field");
        if (param == null) {
            param = "";
        }
        String[] _fields = param.split(",");
        int[] fields = new int[_fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = Integer.parseInt(_fields[i]);
        }
        double ownerId = ValueCaster.toDouble(request.getParameter("owner"));
        int uid = ValueCaster.toInt(request.getParameter("uid"));
        SSContext.WebRequest ssContext = new SSContext.WebRequest(session.newRequestNo(), 5, session);
        ssContext.ownerId = ownerId;
        ssContext.nodeId = td.getNodeId();
        ssContext.uid = uid;
        try (WebServerSideHost host = new WebServerSideHost(td.getNodeId(), session.user(), (AbstractConnection)((Request)request).getConnection());){
            host.setSSContext(ssContext);
            FieldValueGenerator generators = new FieldValueGenerator(td.getNodeId(), -1);
            for (int fid : fields) {
                FieldDescriptor fd = td.getFieldDescriptor(fid);
                FieldValueGenerator.Generator gen = new FieldValueGenerator.Generator();
                gen.fieldId = fid;
                gen.generator = fd.getAutoValueGenerator().toInt();
                gen.name = fd.getValueGeneratorName();
                generators.add(gen);
            }
            generators.generate(ssContext, host);
            generators.interpretResult();
            PrintWriter w = response.getWriter();
            w.append('[');
            boolean nc = false;
            for (FieldValueGenerator.Generator g : generators) {
                if (nc) {
                    w.append(',');
                }
                nc = true;
                if (g.stringResult != null) {
                    w.append(JSON.toString(g.stringResult));
                    continue;
                }
                if (g.bigResult != null) {
                    w.append(JSON.toString(g.bigResult));
                    continue;
                }
                w.append(JSON.toString(g.result));
            }
            w.append(']');
        }
    }
}

