/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.rq;

import inform.adt.collections.DoubleList;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.mtd.request.GetNodeInfo;
import inform.agent.net.Security;
import inform.agent.web.AsmoServlet;
import inform.agent.web.JSON;
import inform.agent.web.Session;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NodeInfo
extends AsmoServlet.WithSession {
    private static final int[] NT2IMG = new int[]{2, 15, 5, 12, 14, 0, 18, 23, 24, 28, 3, 4, 6, 0, 7, 9, 11, 2001, 16, 17, 19, 2501, 20, 21, 22, 25, 26, 4100, 0, 4102, 4105, 4106, 27, 4107, 0, 0, 0, 0, 0, 0, 6100, 7100, 31, 43, 44, 45, 46, 2301, 48, 49, 2206, 0, 0, 0, 51, 0, 53};
    private static final int O_NAME = 1;
    private static final int O_IMAGE = 2;
    private static final int O_FIO = 4;
    private static final int O_PATH = 8;
    private static final int O_TYPE = 16;

    public NodeInfo() {
        super(AsmoServlet.Type.JSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, Session session) throws Throwable {
        Session.User user = session.user();
        response.setCharacterEncoding("WINDOWS-1251");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/json");
        String nodes = request.getParameter("nodes");
        int options = 0;
        String _children = request.getParameter("children");
        BitSet filter = null;
        if (_children == null) {
            options = Integer.parseInt(request.getParameter("options"));
        } else if (!_children.isEmpty()) {
            filter = new BitSet();
            for (String tid : _children.split(",")) {
                filter.set(Integer.parseInt(tid));
            }
        }
        PrintWriter w = response.getWriter();
        boolean nc = false;
        try (Connector.Metabase metabaseConnector = new Connector.Metabase("wrq:NodeInfo");){
            w.append('[');
            if (nodes != null) {
                for (String n : nodes.split(",")) {
                    UserNode.Props p;
                    double nodeId = Double.parseDouble(n);
                    Node node = MtdEngine.getNode(nodeId);
                    if (node == null) {
                        node = VirtualUser.getUser(nodeId);
                    }
                    if (node == null) continue;
                    if (nc) {
                        w.append(',');
                    }
                    nc = true;
                    w.append("{\"id\":").append(JSON.toString(node.getId()));
                    if ((options & 1) != 0) {
                        w.append(",\"name\":").append(JSON.toString(node.getName()));
                    }
                    if ((options & 2) != 0) {
                        int nt;
                        BasicNode rn;
                        int img = node.getUiImageId();
                        if (img == 0 && (img = (rn = node.getRealNode()).getUiImageId()) == 0 && (nt = rn.getType()) < NT2IMG.length) {
                            img = NT2IMG[nt];
                        }
                        if (img != 0) {
                            w.append(",\"image\":").append(JSON.toString(img));
                        }
                    }
                    if ((options & 4) != 0 && node instanceof UserNode && (p = ((UserNode)node).props()) != null) {
                        w.append(",\"fio\":").append(JSON.toString(p.getFio()));
                    }
                    if ((options & 8) != 0) {
                        double[] symPath;
                        double rootNodeId = user.rootNodeId();
                        double[] path = node.getNodeIDPath(rootNodeId);
                        if (path[0] != rootNodeId && (symPath = GetNodeInfo.getSymlinkPath(rootNodeId, path, 32)) != null) {
                            path = symPath;
                        }
                        w.append(",\"path\":").append(JSON.toString(path));
                    }
                    if ((options & 0x10) != 0) {
                        w.append(",\"type\":").append(JSON.toString(node.getType()));
                    }
                    if (_children != null) {
                        DoubleList ids = new DoubleList(0);
                        for (double cid : node.getRealNode().getChildren(metabaseConnector, filter)) {
                            Node cn = MtdEngine.getValidNode(cid);
                            BasicNode cr = cn.getRealNode();
                            if (cr == null) continue;
                            int mask = user.accessMask(Security.acl(cr));
                            if (cr.getOwnerId() != user.id() && AccessMask.accessDenied(Integer.MIN_VALUE, mask)) continue;
                            ids.add(cid);
                        }
                        w.append(",\"ch\":").append(JSON.toString(ids.toArray()));
                    }
                    w.append('}');
                }
            }
            w.append(']');
        }
    }
}

