/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import inform.agent.web.utils.TypedValue;
import org.mozilla.javascript.NativeJavaObject;

public class FormattedValue
extends TypedValue {
    Format format = null;

    public FormattedValue(DataType dataType, Object value, Format format, int summaryFunction) {
        super(dataType, value, summaryFunction);
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void update(DataType type, Format format) {
        this.dataType = type;
        this.format = format;
    }

    public boolean isEmpty() {
        return this.value == null || this.dataType == null || this.dataType == DataType.NONE;
    }

    public boolean isZero() {
        if (this.value == null) {
            return false;
        }
        try {
            if (this.dataType != null && this.dataType.isNumeric()) {
                double v = ValueCaster.toDouble(this.value);
                return v == 0.0;
            }
            return false;
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            return false;
        }
    }

    public String asText() throws InformException {
        Object jo;
        if (this.isEmpty()) {
            return null;
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof NativeJavaObject && (jo = ((NativeJavaObject)this.value).unwrap()) instanceof String) {
            return (String)jo;
        }
        if (this.format == null) {
            this.format = FormatManager.createFormat(0, this.dataType, null);
        }
        return this.format.format(this.value);
    }
}

