/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.utils;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.Task;
import inform.agent.web.data.Datamodel;
import inform.agent.web.utils.KeyValues;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.Scriptable;

public class KeySet {
    private final Task task;
    private final ArrayList<KeyField> fields = new ArrayList();
    private final KeyValues values;
    private ArrayList<KeyItem> items = null;
    private static final int TAG_DATASOURCE = 1;
    private static final int TAG_FIELD = 2;
    private static final int TAG_MODIFICATOR = 3;

    public KeySet(Task task, Scriptable scope) {
        this.task = task;
        this.values = new KeyValues(null, null);
    }

    public KeySet(Task task, Scriptable scope, KeySet keySet) {
        this.task = task;
        this.values = new KeyValues(null, null);
        if (keySet.items != null) {
            this.items = new ArrayList<KeyItem>(keySet.items);
        }
        for (KeyField field : keySet.fields) {
            this.fields.add(field);
        }
    }

    public KeyValues loadValues() throws Exception {
        if (!this.fields.isEmpty()) {
            this.values.clear();
            for (KeyField field : this.fields) {
                Object value;
                if (field.field == null) {
                    value = field.dataset.getRecordID();
                    this.values.addFieldValue(DataType.FLOAT, value);
                    continue;
                }
                value = field.field.getAvailableValue();
                this.values.addFieldValue(field.field.getDataType(), value);
            }
        }
        return this.values;
    }

    public void load(TaggedReader in) throws IOException, TaggedReaderException {
        this.items = new ArrayList();
        int modificator = 0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    KeyItem item = new KeyItem();
                    item.datasourceId = in.getInt();
                    if (in.getCurrentTagSize() != 0) {
                        item.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                    }
                    item.modificator = modificator;
                    modificator = 0;
                    this.items.add(item);
                    break;
                }
                case 3: {
                    modificator = in.getInt();
                }
            }
        }
    }

    public void afterLoad() throws InformException {
        if (this.items == null) {
            return;
        }
        this.fields.clear();
        for (KeyItem item : this.items) {
            Dataset dataset = this.task.getComponents().findDataset(item.datasourceId);
            if (dataset == null) continue;
            if (item.fieldIdPath.length == 1 && item.fieldIdPath[0] == -1) {
                this.fields.add(new KeyField(dataset, null));
                continue;
            }
            DatasetField field = dataset.findFieldPath(item.fieldIdPath);
            if (field == null) continue;
            this.fields.add(new KeyField(dataset, field));
        }
        this.items = null;
    }

    public String getClassName() {
        return "KeySet";
    }

    public void clear() {
        this.fields.clear();
    }

    public int size() {
        return this.fields.size();
    }

    public int getLength() {
        return this.fields.size();
    }

    public KeyValues getValues() {
        return this.values;
    }

    public void setupDatamodel(Datamodel datamodel) {
        if (this.fields.isEmpty()) {
            return;
        }
        for (KeyField field : this.fields) {
            datamodel.add(field.dataset);
        }
    }

    private static class KeyField {
        final Dataset dataset;
        final DatasetField field;

        private KeyField(Dataset dataset, DatasetField field) {
            this.dataset = dataset;
            this.field = field;
        }
    }

    private static class KeyItem {
        int datasourceId;
        int[] fieldIdPath = null;
        int modificator;

        private KeyItem() {
        }
    }
}

