/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.AdapterShapefileJGeom;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;
import oracle.sql.STRUCT;

public class ShapefileFeatureJGeom {
    public static String getRelSchema(DBFReaderJGeom dBFReaderJGeom) {
        int n = dBFReaderJGeom.numFields();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = dBFReaderJGeom.getFieldType(i);
        }
        String string = "";
        block10: for (int i = 0; i < n; ++i) {
            switch (byArray[i]) {
                case 66: {
                    System.out.println("Field type B not yet supported");
                    continue block10;
                }
                case 67: 
                case 76: {
                    if (i != 0) {
                        string = string + ", " + dBFReaderJGeom.getFieldName(i).toLowerCase() + " VARCHAR2(" + dBFReaderJGeom.getFieldLength(i) + ")";
                        continue block10;
                    }
                    string = dBFReaderJGeom.getFieldName(i).toLowerCase() + " VARCHAR2(" + dBFReaderJGeom.getFieldLength(i) + ")";
                    continue block10;
                }
                case 68: {
                    if (i != 0) {
                        string = string + ", " + dBFReaderJGeom.getFieldName(i).toLowerCase() + " NUMBER(38)";
                        continue block10;
                    }
                    string = dBFReaderJGeom.getFieldName(i).toLowerCase() + " NUMBER(38)";
                    continue block10;
                }
                case 71: {
                    System.out.println("Field type G not yet supported");
                    continue block10;
                }
                case 73: {
                    if (i != 0) {
                        string = string + ", " + dBFReaderJGeom.getFieldName(i).toLowerCase() + " NUMBER(38)";
                        continue block10;
                    }
                    string = dBFReaderJGeom.getFieldName(i).toLowerCase() + " NUMBER(38)";
                    continue block10;
                }
                case 70: 
                case 78: {
                    if (i != 0) {
                        string = string + ", " + dBFReaderJGeom.getFieldName(i).toLowerCase() + " NUMBER";
                        continue block10;
                    }
                    string = dBFReaderJGeom.getFieldName(i).toLowerCase() + " NUMBER";
                    continue block10;
                }
                case 77: {
                    System.out.println("Field type M not yet supported");
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Undefined DBF field type (1) " + byArray[i]);
                }
            }
        }
        string = string + ", geometry MDSYS.SDO_GEOMETRY";
        return string;
    }

    public static String getRelSchema(DBFReaderJGeom dBFReaderJGeom, String string) {
        String string2 = ShapefileFeatureJGeom.getRelSchema(dBFReaderJGeom);
        if (string != null) {
            return string + " NUMBER(38), " + string2;
        }
        return string2;
    }

    public static String[] getOraFieldNames(DBFReaderJGeom dBFReaderJGeom, byte[] byArray, int n) throws IOException {
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            switch (byArray[i]) {
                case 66: {
                    System.out.println("Field type B not yet supported");
                    break;
                }
                case 67: 
                case 76: {
                    stringArray[n2] = dBFReaderJGeom.getFieldName(i).toLowerCase();
                    break;
                }
                case 68: {
                    stringArray[n2] = dBFReaderJGeom.getFieldName(i).toLowerCase();
                    break;
                }
                case 71: {
                    System.out.println("Field type G not yet supported");
                    break;
                }
                case 73: {
                    stringArray[n2] = dBFReaderJGeom.getFieldName(i).toLowerCase();
                    break;
                }
                case 70: 
                case 78: {
                    stringArray[n2] = dBFReaderJGeom.getFieldName(i).toLowerCase();
                    break;
                }
                case 77: {
                    System.out.println("Field type M not yet supported");
                    break;
                }
                default: {
                    throw new RuntimeException("Undefined DBF field type (1) " + byArray[i]);
                }
            }
            ++n2;
        }
        return stringArray;
    }

    public static Hashtable fromRecordToFeature(DBFReaderJGeom dBFReaderJGeom, ShapefileReaderJGeom shapefileReaderJGeom, byte[] byArray, int n, int n2, int n3) throws IOException {
        String string;
        AdapterShapefileJGeom adapterShapefileJGeom = new AdapterShapefileJGeom();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        block14: for (int i = 0; i < n; ++i) {
            switch (byArray[i]) {
                case 66: {
                    System.out.println("Field type B not yet supported");
                    continue block14;
                }
                case 67: 
                case 76: {
                    hashtable.put(dBFReaderJGeom.getFieldName(i).toLowerCase(), dBFReaderJGeom.getFieldData(i, dBFReaderJGeom.getRecord(n2)));
                    continue block14;
                }
                case 68: {
                    Integer n4;
                    string = dBFReaderJGeom.getFieldData(i, dBFReaderJGeom.getRecord(n2));
                    string = string.trim();
                    try {
                        n4 = new Integer(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n4 = new Integer(0);
                    }
                    hashtable.put(dBFReaderJGeom.getFieldName(i).toLowerCase(), n4);
                    continue block14;
                }
                case 71: {
                    System.out.println("Field type G not yet supported");
                    continue block14;
                }
                case 70: 
                case 73: 
                case 78: {
                    Double d;
                    try {
                        d = new Double(dBFReaderJGeom.getFieldData(i, dBFReaderJGeom.getRecord(n2)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        d = new Double(0.0);
                    }
                    hashtable.put(dBFReaderJGeom.getFieldName(i).toLowerCase(), d);
                    continue block14;
                }
                case 77: {
                    System.out.println("Field type M not yet supported");
                    continue block14;
                }
                default: {
                    throw new RuntimeException("Undefined DBF field type (1) " + byArray[i]);
                }
            }
        }
        byte[] byArray2 = shapefileReaderJGeom.getGeometryBytes(n2);
        string = null;
        try {
            string = adapterShapefileJGeom.importGeometry(byArray2, n3);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        if (string != null) {
            hashtable.put("geometry", string);
        }
        return hashtable;
    }

    public static boolean isGeodetic(OracleConnection oracleConnection, int n) throws SQLException {
        PreparedStatement preparedStatement = oracleConnection.prepareStatement("SELECT COUNT(*) cnt FROM MDSYS.GEODETIC_SRIDS WHERE srid = ?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        if (resultSet.next() && resultSet.getInt("cnt") > 0) {
            bl = true;
        }
        preparedStatement.close();
        return bl;
    }

    public static String getDimArray(int n, String string, String string2, String string3, String string4, String string5, double d, double d2, double d3, double d4) {
        String string6 = null;
        if (n == 2 || n == 0) {
            string6 = "MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', " + string2 + ", " + string3 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('Y', " + string4 + ", " + string5 + ", " + string + "))";
        } else if (n == 3 && Double.isNaN(d4)) {
            string6 = "MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', " + string2 + ", " + string3 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('Y', " + string4 + ", " + string5 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('Z', " + d + ", " + d2 + ", " + string + "))";
        } else if (n == 3) {
            string6 = "MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', " + string2 + ", " + string3 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('Y', " + string4 + ", " + string5 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('M', " + d3 + ", " + d4 + ", " + string + "))";
        } else if (n == 4) {
            string6 = "MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', " + string2 + ", " + string3 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('Y', " + string4 + ", " + string5 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('Z', " + d + ", " + d2 + ", " + string + "), " + "MDSYS.SDO_DIM_ELEMENT('M', " + d3 + ", " + d4 + ", " + string + "))";
        }
        return string6;
    }

    public static void prepareTableForData(OracleConnection oracleConnection, DBFReaderJGeom dBFReaderJGeom, String string, String string2, String string3, int n, String string4) throws IOException, SQLException {
        String string5;
        String string6;
        System.out.println("Dropping old table...");
        Statement statement = null;
        try {
            statement = oracleConnection.createStatement();
            string6 = "DROP TABLE " + string;
            statement.executeUpdate(string6);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            statement = oracleConnection.createStatement();
            string6 = "DELETE FROM user_sdo_geom_metadata WHERE table_name = '" + string.toUpperCase() + "'" + " AND column_name = '" + string3.toUpperCase() + "'";
            statement.executeUpdate(string6);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            string5 = ShapefileFeatureJGeom.getRelSchema(dBFReaderJGeom, string2);
            String string7 = ShapefileFeatureJGeom.replaceAllWords(string5, "geometry", string3);
            System.out.println("Creating new table...");
            statement = oracleConnection.createStatement();
            string6 = "CREATE TABLE " + string + " (" + string7 + ")";
            statement.executeUpdate(string6);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        string5 = "NULL";
        if (n > 0) {
            string5 = String.valueOf(n);
        }
        try {
            statement = oracleConnection.createStatement();
            string6 = "INSERT INTO user_sdo_geom_metadata VALUES ('" + string.toUpperCase() + "', '" + string3.toUpperCase() + "', " + string4 + ", " + string5 + ")";
            statement.executeUpdate(string6);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
    }

    static String replaceAllWords(String string, String string2, String string3) {
        String string4 = "";
        String string5 = "+-*/(),. ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string5, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            if (string6.equals(string2)) {
                string4 = string4 + string3;
                continue;
            }
            string4 = string4 + string6;
        }
        return string4;
    }

    public static void insertFeatures(OracleConnection oracleConnection, DBFReaderJGeom dBFReaderJGeom, ShapefileReaderJGeom shapefileReaderJGeom, String string, String string2, int n, int n2, int n3, int n4, String string3) throws SQLException, IOException {
        int n5 = 0;
        int n6 = dBFReaderJGeom.numFields();
        int n7 = dBFReaderJGeom.numRecords();
        byte[] byArray = new byte[n6];
        for (int i = 0; i < n6; ++i) {
            byArray[i] = dBFReaderJGeom.getFieldType(i);
        }
        Hashtable hashtable = null;
        hashtable = ShapefileFeatureJGeom.fromRecordToFeature(dBFReaderJGeom, shapefileReaderJGeom, byArray, n6, 0, n4);
        int n8 = hashtable.size();
        String string4 = null;
        String string5 = null;
        string4 = string2 == null ? "(" : "(?,";
        for (int i = 0; i < n8; ++i) {
            string4 = i == 0 ? string4 + " ?" : string4 + ", ?";
        }
        string4 = string4 + ")";
        string5 = string4.substring(0, string4.length() - 2) + "MDSYS.SDO_MIGRATE.TO_CURRENT(?, " + string3 + "))";
        String[] stringArray = ShapefileFeatureJGeom.getOraFieldNames(dBFReaderJGeom, byArray, n6);
        String string6 = "INSERT INTO " + string + " VALUES" + string4;
        PreparedStatement preparedStatement = oracleConnection.prepareStatement(string6);
        PreparedStatement preparedStatement2 = oracleConnection.prepareStatement("COMMIT");
        String string7 = "INSERT INTO " + string + " VALUES" + string5;
        PreparedStatement preparedStatement3 = oracleConnection.prepareStatement(string7);
        Object var24_26 = null;
        STRUCT sTRUCT = null;
        int n9 = shapefileReaderJGeom.getShpFileType();
        for (int i = 0; i < n7; ++i) {
            block39: {
                if ((i + 1) % n3 == 0) {
                    System.out.println("Converting record #" + (i + 1) + " of " + n7);
                }
                hashtable = ShapefileFeatureJGeom.fromRecordToFeature(dBFReaderJGeom, shapefileReaderJGeom, byArray, n6, i, n4);
                if (string2 == null) {
                    try {
                        JGeometry jGeometry;
                        if (n9 == 5 || n9 == 15 || n9 == 25) {
                            for (int j = 0; j < stringArray.length; ++j) {
                                if (hashtable.get(stringArray[j]) instanceof String) {
                                    preparedStatement3.setString(j + 1, (String)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                if (hashtable.get(stringArray[j]) instanceof Integer) {
                                    preparedStatement3.setInt(j + 1, (Integer)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                if (hashtable.get(stringArray[j]) instanceof Double) {
                                    preparedStatement3.setDouble(j + 1, (Double)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                throw new RuntimeException("Unsupported Column Type");
                            }
                            jGeometry = (JGeometry)hashtable.get("geometry");
                            if (jGeometry != null) {
                                sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)oracleConnection);
                                preparedStatement3.setObject(stringArray.length + 1, sTRUCT);
                            } else {
                                preparedStatement3.setNull(stringArray.length + 1, 2002, "MDSYS.SDO_GEOMETRY");
                            }
                            preparedStatement3.executeUpdate();
                            break block39;
                        }
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (hashtable.get(stringArray[j]) instanceof String) {
                                preparedStatement.setString(j + 1, (String)hashtable.get(stringArray[j]));
                                continue;
                            }
                            if (hashtable.get(stringArray[j]) instanceof Integer) {
                                preparedStatement.setInt(j + 1, (Integer)hashtable.get(stringArray[j]));
                                continue;
                            }
                            if (hashtable.get(stringArray[j]) instanceof Double) {
                                preparedStatement.setDouble(j + 1, (Double)hashtable.get(stringArray[j]));
                                continue;
                            }
                            throw new RuntimeException("Unsupported Column Type");
                        }
                        jGeometry = (JGeometry)hashtable.get("geometry");
                        if (jGeometry != null) {
                            sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)oracleConnection);
                            preparedStatement.setObject(stringArray.length + 1, sTRUCT);
                        } else {
                            preparedStatement.setNull(stringArray.length + 1, 2002, "MDSYS.SDO_GEOMETRY");
                        }
                        preparedStatement.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        ++n5;
                        System.out.println(sQLException + "\nRecord #" + (i + 1) + " not converted.");
                    }
                } else {
                    int n10 = i + n;
                    try {
                        JGeometry jGeometry;
                        if (n9 == 5 || n9 == 15 || n9 == 25) {
                            preparedStatement3.setInt(1, n10);
                            for (int j = 0; j < stringArray.length; ++j) {
                                if (hashtable.get(stringArray[j]) instanceof String) {
                                    preparedStatement3.setString(j + 2, (String)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                if (hashtable.get(stringArray[j]) instanceof Integer) {
                                    preparedStatement3.setInt(j + 2, (Integer)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                if (hashtable.get(stringArray[j]) instanceof Double) {
                                    preparedStatement3.setDouble(j + 2, (Double)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                throw new RuntimeException("Unsupported Column Type");
                            }
                            jGeometry = (JGeometry)hashtable.get("geometry");
                            if (jGeometry != null) {
                                sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)oracleConnection);
                                preparedStatement3.setObject(stringArray.length + 2, sTRUCT);
                            } else {
                                preparedStatement3.setNull(stringArray.length + 2, 2002, "MDSYS.SDO_GEOMETRY");
                            }
                            preparedStatement3.executeUpdate();
                        } else {
                            preparedStatement.setInt(1, n10);
                            for (int j = 0; j < stringArray.length; ++j) {
                                if (hashtable.get(stringArray[j]) instanceof String) {
                                    preparedStatement.setString(j + 2, (String)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                if (hashtable.get(stringArray[j]) instanceof Integer) {
                                    preparedStatement.setInt(j + 2, (Integer)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                if (hashtable.get(stringArray[j]) instanceof Double) {
                                    preparedStatement.setDouble(j + 2, (Double)hashtable.get(stringArray[j]));
                                    continue;
                                }
                                throw new RuntimeException("Unsupported Column Type");
                            }
                            jGeometry = (JGeometry)hashtable.get("geometry");
                            if (jGeometry != null) {
                                sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)oracleConnection);
                                preparedStatement.setObject(stringArray.length + 2, sTRUCT);
                            } else {
                                preparedStatement.setNull(stringArray.length + 2, 2002, "MDSYS.SDO_GEOMETRY");
                            }
                            preparedStatement.executeUpdate();
                        }
                    }
                    catch (SQLException sQLException) {
                        ++n5;
                        System.out.println(sQLException + "\nRecord #" + (i + 1) + " not converted.");
                    }
                }
            }
            if (n2 == -1) {
                if ((i + 1) % 1000 != 0) continue;
                oracleConnection.commit();
                continue;
            }
            if ((i + 1) % n2 != 0) continue;
            oracleConnection.commit();
        }
        oracleConnection.commit();
        preparedStatement.close();
        preparedStatement3.close();
        preparedStatement2.close();
        if (n5 > 0) {
            System.out.println(n5 + " record(s) not converted.");
        }
        System.out.println(n7 - n5 + " record(s) converted.");
        System.out.println("Done.");
    }

    public static void insertFeatures(OracleConnection oracleConnection, DBFReaderJGeom dBFReaderJGeom, ShapefileReaderJGeom shapefileReaderJGeom, String string, int n, int n2, String string2) throws SQLException, IOException {
        String string3 = null;
        int n3 = 1;
        int n4 = 10;
        ShapefileFeatureJGeom.insertFeatures(oracleConnection, dBFReaderJGeom, shapefileReaderJGeom, string, string3, n3, n, n4, n2, string2);
    }
}

