/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class SslConnection
extends AbstractConnection
implements AsyncConnection {
    private final Logger _logger = Log.getLogger((String)"org.eclipse.jetty.io.nio.ssl");
    private static final NIOBuffer __ZERO_BUFFER = new IndirectNIOBuffer(0);
    private static final ThreadLocal<SslBuffers> __buffers = new ThreadLocal();
    private final SSLEngine _engine;
    private final SSLSession _session;
    private AsyncConnection _connection;
    private final SslEndPoint _sslEndPoint;
    private int _allocations;
    private SslBuffers _buffers;
    private NIOBuffer _inbound;
    private NIOBuffer _unwrapBuf;
    private NIOBuffer _outbound;
    private AsyncEndPoint _aEndp;
    private boolean _allowRenegotiate = true;
    private boolean _handshook;
    private boolean _ishut;
    private boolean _oshut;
    private final AtomicBoolean _progressed = new AtomicBoolean();

    public SslConnection(SSLEngine engine, EndPoint endp) {
        this(engine, endp, System.currentTimeMillis());
    }

    public SslConnection(SSLEngine engine, EndPoint endp, long timeStamp) {
        super(endp, timeStamp);
        this._engine = engine;
        this._session = this._engine.getSession();
        this._aEndp = (AsyncEndPoint)endp;
        this._sslEndPoint = this.newSslEndPoint();
    }

    protected SslEndPoint newSslEndPoint() {
        return new SslEndPoint();
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._allowRenegotiate = allowRenegotiate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateBuffers() {
        SslConnection sslConnection = this;
        synchronized (sslConnection) {
            if (this._allocations++ == 0 && this._buffers == null) {
                this._buffers = __buffers.get();
                if (this._buffers == null) {
                    this._buffers = new SslBuffers(this._session.getPacketBufferSize() * 2, this._session.getApplicationBufferSize() * 2);
                }
                this._inbound = this._buffers._in;
                this._outbound = this._buffers._out;
                this._unwrapBuf = this._buffers._unwrap;
                __buffers.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffers() {
        SslConnection sslConnection = this;
        synchronized (sslConnection) {
            if (--this._allocations == 0 && this._buffers != null && this._inbound.length() == 0 && this._outbound.length() == 0 && this._unwrapBuf.length() == 0) {
                this._inbound = null;
                this._outbound = null;
                this._unwrapBuf = null;
                __buffers.set(this._buffers);
                this._buffers = null;
            }
        }
    }

    @Override
    public Connection handle() throws IOException {
        try {
            this.allocateBuffers();
            boolean progress = true;
            while (progress) {
                AsyncConnection next;
                progress = false;
                if (this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    progress = this.process(null, null);
                }
                if ((next = (AsyncConnection)this._connection.handle()) != this._connection && next != null) {
                    this._connection = next;
                    progress = true;
                }
                this._logger.debug("{} handle {} progress={}", new Object[]{this._session, this, progress});
            }
        }
        finally {
            this.releaseBuffers();
            if (!this._ishut && this._sslEndPoint.isInputShutdown() && this._sslEndPoint.isOpen()) {
                this._ishut = true;
                try {
                    this._connection.onInputShutdown();
                }
                catch (Throwable x) {
                    this._logger.warn("onInputShutdown failed", x);
                    try {
                        this._sslEndPoint.close();
                    }
                    catch (IOException e2) {
                        this._logger.ignore((Throwable)e2);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public boolean isIdle() {
        return false;
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    @Override
    public void onClose() {
        Connection connection = this._sslEndPoint.getConnection();
        if (connection != null && connection != this) {
            connection.onClose();
        }
    }

    @Override
    public void onIdleExpired(long idleForMs) {
        try {
            this._logger.debug("onIdleExpired {}ms on {}", new Object[]{idleForMs, this});
            if (this._endp.isOutputShutdown()) {
                this._sslEndPoint.close();
            } else {
                this._sslEndPoint.shutdownOutput();
            }
        }
        catch (IOException e) {
            this._logger.warn((Throwable)e);
            super.onIdleExpired(idleForMs);
        }
    }

    @Override
    public void onInputShutdown() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean process(Buffer toFill, Buffer toFlush) throws IOException {
        boolean some_progress = false;
        try {
            this.allocateBuffers();
            if (toFill == null) {
                this._unwrapBuf.compact();
                toFill = this._unwrapBuf;
            } else {
                if (toFill.capacity() < this._session.getApplicationBufferSize()) {
                    boolean progress = this.process(null, toFlush);
                    if (this._unwrapBuf != null && this._unwrapBuf.hasContent()) {
                        this._unwrapBuf.skip(toFill.put(this._unwrapBuf));
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = progress;
                    return bl;
                }
                if (this._unwrapBuf != null && this._unwrapBuf.hasContent()) {
                    this._unwrapBuf.skip(toFill.put(this._unwrapBuf));
                    boolean progress = true;
                    return progress;
                }
            }
            if (toFlush == null) {
                toFlush = __ZERO_BUFFER;
            }
            boolean progress = true;
            while (progress) {
                progress = false;
                int filled = 0;
                int flushed = 0;
                try {
                    if (this._inbound.space() > 0 && (filled = this._endp.fill(this._inbound)) > 0) {
                        progress = true;
                    }
                    if (this._outbound.hasContent() && (flushed = this._endp.flush(this._outbound)) > 0) {
                        progress = true;
                    }
                }
                catch (IOException e) {
                    try {
                        this._endp.close();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this._logger.debug("{} {} {} filled={}/{} flushed={}/{}", new Object[]{this._session, this, this._engine.getHandshakeStatus(), filled, this._inbound.length(), flushed, this._outbound.length()});
                        throw throwable;
                    }
                }
                this._logger.debug("{} {} {} filled={}/{} flushed={}/{}", new Object[]{this._session, this, this._engine.getHandshakeStatus(), filled, this._inbound.length(), flushed, this._outbound.length()});
                switch (this._engine.getHandshakeStatus()) {
                    case FINISHED: {
                        throw new IllegalStateException();
                    }
                    case NOT_HANDSHAKING: {
                        if (toFill.space() > 0 && this._inbound.hasContent() && this.unwrap(toFill)) {
                            progress = true;
                        }
                        if (!toFlush.hasContent() || this._outbound.space() <= 0 || !this.wrap(toFlush)) break;
                        progress = true;
                        break;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            progress = true;
                            task.run();
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        if (this._handshook && !this._allowRenegotiate) {
                            this._endp.close();
                            break;
                        }
                        if (!this.wrap(toFlush)) break;
                        progress = true;
                        break;
                    }
                    case NEED_UNWRAP: {
                        if (this._handshook && !this._allowRenegotiate) {
                            this._endp.close();
                            break;
                        }
                        if (!this._inbound.hasContent() && filled == -1) {
                            this._endp.shutdownInput();
                            break;
                        }
                        if (!this.unwrap(toFill)) break;
                        progress = true;
                    }
                }
                if (this._endp.isOpen() && this._endp.isInputShutdown() && !this._inbound.hasContent()) {
                    this.closeInbound();
                }
                if (this._endp.isOpen() && this._engine.isOutboundDone() && !this._outbound.hasContent()) {
                    this._endp.shutdownOutput();
                }
                some_progress |= progress;
            }
            if (toFill == this._unwrapBuf && this._unwrapBuf.hasContent() && !this._connection.isSuspended()) {
                this._aEndp.dispatch();
            }
        }
        finally {
            this.releaseBuffers();
            if (some_progress) {
                this._progressed.set(true);
            }
        }
        return some_progress;
    }

    private void closeInbound() {
        try {
            this._engine.closeInbound();
        }
        catch (SSLException x) {
            this._logger.debug((Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean wrap(Buffer buffer) throws IOException {
        SSLEngineResult result;
        ByteBuffer bbuf = this.extractByteBuffer(buffer);
        int encrypted_produced = 0;
        int decrypted_consumed = 0;
        ByteBuffer byteBuffer = bbuf;
        synchronized (byteBuffer) {
            ByteBuffer out_buffer;
            this._outbound.compact();
            ByteBuffer byteBuffer2 = out_buffer = this._outbound.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    bbuf.position(buffer.getIndex());
                    bbuf.limit(buffer.putIndex());
                    int decrypted_position = bbuf.position();
                    out_buffer.position(this._outbound.putIndex());
                    out_buffer.limit(out_buffer.capacity());
                    int encrypted_position = out_buffer.position();
                    result = this._engine.wrap(bbuf, out_buffer);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("{} wrap {} {} consumed={} produced={}", new Object[]{this._session, result.getStatus(), result.getHandshakeStatus(), result.bytesConsumed(), result.bytesProduced()});
                    }
                    decrypted_consumed = bbuf.position() - decrypted_position;
                    buffer.skip(decrypted_consumed);
                    encrypted_produced = out_buffer.position() - encrypted_position;
                    this._outbound.setPutIndex(this._outbound.putIndex() + encrypted_produced);
                }
                catch (SSLException e) {
                    this._logger.debug(String.valueOf(this._endp), (Throwable)e);
                    this._endp.close();
                    throw e;
                }
                catch (IOException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new IOException(x);
                }
                finally {
                    out_buffer.position(0);
                    out_buffer.limit(out_buffer.capacity());
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                throw new IllegalStateException();
            }
            case BUFFER_OVERFLOW: {
                break;
            }
            case OK: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._handshook = true;
                break;
            }
            case CLOSED: {
                this._logger.debug("wrap CLOSE {} {}", new Object[]{this, result});
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._endp.close();
                break;
            }
            default: {
                this._logger.debug("{} wrap default {}", new Object[]{this._session, result});
                throw new IOException(result.toString());
            }
        }
        return decrypted_consumed > 0 || encrypted_produced > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean unwrap(Buffer buffer) throws IOException {
        SSLEngineResult result;
        if (!this._inbound.hasContent()) {
            return false;
        }
        ByteBuffer bbuf = this.extractByteBuffer(buffer);
        int encrypted_consumed = 0;
        int decrypted_produced = 0;
        ByteBuffer byteBuffer = bbuf;
        synchronized (byteBuffer) {
            ByteBuffer in_buffer;
            ByteBuffer byteBuffer2 = in_buffer = this._inbound.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    bbuf.position(buffer.putIndex());
                    bbuf.limit(buffer.capacity());
                    int decrypted_position = bbuf.position();
                    in_buffer.position(this._inbound.getIndex());
                    in_buffer.limit(this._inbound.putIndex());
                    int encrypted_position = in_buffer.position();
                    result = this._engine.unwrap(in_buffer, bbuf);
                    if ((result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW || result.getStatus() == SSLEngineResult.Status.OK && result.bytesConsumed() == 0 && result.bytesProduced() == 0) && in_buffer.capacity() - in_buffer.limit() == 0) {
                        this._inbound.clear();
                        throw new SSLHandshakeException("Encrypted buffer max length exceeded");
                    }
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("{} unwrap {} {} consumed={} produced={}", new Object[]{this._session, result.getStatus(), result.getHandshakeStatus(), result.bytesConsumed(), result.bytesProduced()});
                    }
                    encrypted_consumed = in_buffer.position() - encrypted_position;
                    this._inbound.skip(encrypted_consumed);
                    this._inbound.compact();
                    decrypted_produced = bbuf.position() - decrypted_position;
                    buffer.setPutIndex(buffer.putIndex() + decrypted_produced);
                }
                catch (SSLException e) {
                    this._logger.debug(String.valueOf(this._endp), (Throwable)e);
                    this._endp.close();
                    throw e;
                }
                catch (IOException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new IOException(x);
                }
                finally {
                    in_buffer.position(0);
                    in_buffer.limit(in_buffer.capacity());
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                if (!this._endp.isInputShutdown()) break;
                this._inbound.clear();
                break;
            }
            case BUFFER_OVERFLOW: {
                if (!this._logger.isDebugEnabled()) break;
                this._logger.debug("{} unwrap {} {}->{}", new Object[]{this._session, result.getStatus(), this._inbound.toDetailString(), buffer.toDetailString()});
                break;
            }
            case OK: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._handshook = true;
                break;
            }
            case CLOSED: {
                this._logger.debug("unwrap CLOSE {} {}", new Object[]{this, result});
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._endp.close();
                break;
            }
            default: {
                this._logger.debug("{} wrap default {}", new Object[]{this._session, result});
                throw new IOException(result.toString());
            }
        }
        return encrypted_consumed > 0 || decrypted_produced > 0;
    }

    private ByteBuffer extractByteBuffer(Buffer buffer) {
        if (buffer.buffer() instanceof NIOBuffer) {
            return ((NIOBuffer)buffer.buffer()).getByteBuffer();
        }
        byte[] bufferArray = buffer.array();
        if (bufferArray != null) {
            return ByteBuffer.wrap(bufferArray);
        }
        return null;
    }

    public AsyncEndPoint getSslEndPoint() {
        return this._sslEndPoint;
    }

    @Override
    public String toString() {
        return String.format("%s %s", super.toString(), this._sslEndPoint);
    }

    public class SslEndPoint
    implements AsyncEndPoint {
        public SSLEngine getSslEngine() {
            return SslConnection.this._engine;
        }

        public AsyncEndPoint getEndpoint() {
            return SslConnection.this._aEndp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownOutput() throws IOException {
            SslConnection sslConnection = SslConnection.this;
            synchronized (sslConnection) {
                try {
                    SslConnection.this._logger.debug("{} ssl endp.oshut {}", new Object[]{SslConnection.this._session, this});
                    SslConnection.this._oshut = true;
                    SslConnection.this._engine.closeOutbound();
                }
                catch (Exception x) {
                    throw new IOException(x);
                }
            }
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isOutputShutdown() {
            SslConnection sslConnection = SslConnection.this;
            synchronized (sslConnection) {
                return SslConnection.this._oshut || !this.isOpen() || SslConnection.this._engine.isOutboundDone();
            }
        }

        @Override
        public void shutdownInput() throws IOException {
            SslConnection.this._logger.debug("{} ssl endp.ishut!", new Object[]{SslConnection.this._session});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInputShutdown() {
            SslConnection sslConnection = SslConnection.this;
            synchronized (sslConnection) {
                return !(!SslConnection.this._endp.isInputShutdown() || SslConnection.this._unwrapBuf != null && SslConnection.this._unwrapBuf.hasContent() || SslConnection.this._inbound != null && SslConnection.this._inbound.hasContent());
            }
        }

        @Override
        public void close() throws IOException {
            SslConnection.this._logger.debug("{} ssl endp.close", new Object[]{SslConnection.this._session});
            SslConnection.this._endp.close();
        }

        @Override
        public int fill(Buffer buffer) throws IOException {
            int size = buffer.length();
            SslConnection.this.process(buffer, null);
            int filled = buffer.length() - size;
            if (filled == 0 && this.isInputShutdown()) {
                return -1;
            }
            return filled;
        }

        @Override
        public int flush(Buffer buffer) throws IOException {
            int size = buffer.length();
            SslConnection.this.process(null, buffer);
            return size - buffer.length();
        }

        @Override
        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            if (header != null && header.hasContent()) {
                return this.flush(header);
            }
            if (buffer != null && buffer.hasContent()) {
                return this.flush(buffer);
            }
            if (trailer != null && trailer.hasContent()) {
                return this.flush(trailer);
            }
            return 0;
        }

        @Override
        public boolean blockReadable(long millisecs) throws IOException {
            long end;
            long now = System.currentTimeMillis();
            long l = end = millisecs > 0L ? now + millisecs : Long.MAX_VALUE;
            while (now < end && !SslConnection.this.process(null, null)) {
                SslConnection.this._endp.blockReadable(end - now);
                now = System.currentTimeMillis();
            }
            return now < end;
        }

        @Override
        public boolean blockWritable(long millisecs) throws IOException {
            return SslConnection.this._endp.blockWritable(millisecs);
        }

        @Override
        public boolean isOpen() {
            return SslConnection.this._endp.isOpen();
        }

        @Override
        public Object getTransport() {
            return SslConnection.this._endp;
        }

        @Override
        public void flush() throws IOException {
            SslConnection.this.process(null, null);
        }

        @Override
        public void dispatch() {
            SslConnection.this._aEndp.dispatch();
        }

        @Override
        public void asyncDispatch() {
            SslConnection.this._aEndp.asyncDispatch();
        }

        @Override
        public void scheduleWrite() {
            SslConnection.this._aEndp.scheduleWrite();
        }

        @Override
        public void onIdleExpired(long idleForMs) {
            SslConnection.this._aEndp.onIdleExpired(idleForMs);
        }

        @Override
        public void setCheckForIdle(boolean check) {
            SslConnection.this._aEndp.setCheckForIdle(check);
        }

        @Override
        public boolean isCheckForIdle() {
            return SslConnection.this._aEndp.isCheckForIdle();
        }

        @Override
        public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
            SslConnection.this._aEndp.scheduleTimeout(task, timeoutMs);
        }

        @Override
        public void cancelTimeout(Timeout.Task task) {
            SslConnection.this._aEndp.cancelTimeout(task);
        }

        @Override
        public boolean isWritable() {
            return SslConnection.this._aEndp.isWritable();
        }

        @Override
        public boolean hasProgressed() {
            return SslConnection.this._progressed.getAndSet(false);
        }

        @Override
        public String getLocalAddr() {
            return SslConnection.this._aEndp.getLocalAddr();
        }

        @Override
        public String getLocalHost() {
            return SslConnection.this._aEndp.getLocalHost();
        }

        @Override
        public int getLocalPort() {
            return SslConnection.this._aEndp.getLocalPort();
        }

        @Override
        public String getRemoteAddr() {
            return SslConnection.this._aEndp.getRemoteAddr();
        }

        @Override
        public String getRemoteHost() {
            return SslConnection.this._aEndp.getRemoteHost();
        }

        @Override
        public int getRemotePort() {
            return SslConnection.this._aEndp.getRemotePort();
        }

        @Override
        public boolean isBlocking() {
            return false;
        }

        @Override
        public int getMaxIdleTime() {
            return SslConnection.this._aEndp.getMaxIdleTime();
        }

        @Override
        public void setMaxIdleTime(int timeMs) throws IOException {
            SslConnection.this._aEndp.setMaxIdleTime(timeMs);
        }

        @Override
        public Connection getConnection() {
            return SslConnection.this._connection;
        }

        @Override
        public void setConnection(Connection connection) {
            SslConnection.this._connection = (AsyncConnection)connection;
        }

        public String toString() {
            NIOBuffer inbound = SslConnection.this._inbound;
            NIOBuffer outbound = SslConnection.this._outbound;
            NIOBuffer unwrap = SslConnection.this._unwrapBuf;
            int i = inbound == null ? -1 : inbound.length();
            int o = outbound == null ? -1 : outbound.length();
            int u = unwrap == null ? -1 : unwrap.length();
            return String.format("SSL %s i/o/u=%d/%d/%d ishut=%b oshut=%b {%s}", new Object[]{SslConnection.this._engine.getHandshakeStatus(), i, o, u, SslConnection.this._ishut, SslConnection.this._oshut, SslConnection.this._connection});
        }
    }

    private static class SslBuffers {
        final NIOBuffer _in;
        final NIOBuffer _out;
        final NIOBuffer _unwrap;

        SslBuffers(int packetSize, int appSize) {
            this._in = new IndirectNIOBuffer(packetSize);
            this._out = new IndirectNIOBuffer(packetSize);
            this._unwrap = new IndirectNIOBuffer(appSize);
        }
    }
}

