/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.OutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ValuesOnlyLDAPResultWriter
extends LDAPResultWriter {
    public ValuesOnlyLDAPResultWriter(@NotNull OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void writeComment(@NotNull String comment) {
    }

    @Override
    public void writeHeader() {
    }

    @Override
    public void writeSearchResultEntry(@NotNull SearchResultEntry entry) {
        try {
            for (Attribute a : entry.getAttributes()) {
                for (byte[] value : a.getValueByteArrays()) {
                    this.getPrintStream().write(value);
                    this.getPrintStream().write(StaticUtils.EOL_BYTES);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.OTHER, ToolMessages.ERR_VALUES_ONLY_OUTPUT_FORMAT_WRITE_ERROR.get(StaticUtils.getExceptionMessage(e)), e));
        }
    }

    @Override
    public void writeSearchResultReference(@NotNull SearchResultReference ref) {
    }

    @Override
    public void writeResult(@NotNull LDAPResult result) {
        this.getPrintStream().flush();
    }

    @Override
    public void writeUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        this.getPrintStream().flush();
    }
}

