/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.SocketReceiveBufferAllocator;

public class NioWorker
extends AbstractNioWorker {
    private final SocketReceiveBufferAllocator recvBufferPool = new SocketReceiveBufferAllocator();

    public NioWorker(Executor executor) {
        super(executor);
    }

    @Override
    protected boolean read(SelectionKey k) {
        SocketChannel ch = (SocketChannel)k.channel();
        NioSocketChannel channel = (NioSocketChannel)k.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        int predictedRecvBufSize = predictor.nextReceiveBufferSize();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        int ret = 0;
        int readBytes = 0;
        boolean failure = true;
        ByteBuffer bb = this.recvBufferPool.get(predictedRecvBufSize).order(bufferFactory.getDefaultOrder());
        try {
            while ((ret = ch.read(bb)) > 0) {
                readBytes += ret;
                if (bb.hasRemaining()) continue;
            }
            failure = false;
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (readBytes > 0) {
            bb.flip();
            ChannelBuffer buffer = bufferFactory.getBuffer(readBytes);
            buffer.setBytes(0, bb);
            buffer.writerIndex(readBytes);
            predictor.previousReceiveBufferSize(readBytes);
            Channels.fireMessageReceived(channel, (Object)buffer);
        }
        if (ret < 0 || failure) {
            k.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    @Override
    protected boolean scheduleWriteIfNecessary(AbstractNioChannel<?> channel) {
        Thread workerThread;
        Thread currentThread = Thread.currentThread();
        if (currentThread != (workerThread = this.thread)) {
            Selector workerSelector;
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                boolean offered = this.writeTaskQueue.offer(channel.writeTask);
                assert (offered);
            }
            if ((!(channel instanceof NioAcceptedSocketChannel) || ((NioAcceptedSocketChannel)channel).bossThread != currentThread) && (workerSelector = this.selector) != null && this.wakenUp.compareAndSet(false, true)) {
                workerSelector.wakeup();
            }
            return true;
        }
        return false;
    }

    @Override
    protected Runnable createRegisterTask(AbstractNioChannel<?> channel, ChannelFuture future) {
        boolean server = !(channel instanceof NioClientSocketChannel);
        return new RegisterTask((NioSocketChannel)channel, future, server);
    }

    private final class RegisterTask
    implements Runnable {
        private final NioSocketChannel channel;
        private final ChannelFuture future;
        private final boolean server;

        RegisterTask(NioSocketChannel channel, ChannelFuture future, boolean server) {
            this.channel = channel;
            this.future = future;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                InetSocketAddress localAddress = this.channel.getLocalAddress();
                InetSocketAddress remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null || remoteAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    if (this.server) {
                        ((SocketChannel)this.channel.channel).configureBlocking(false);
                    }
                    Object object = this.channel.interestOpsLock;
                    synchronized (object) {
                        ((SocketChannel)this.channel.channel).register(NioWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                    }
                    if (this.future != null) {
                        this.channel.setConnected();
                        this.future.setSuccess();
                    }
                    if (this.server || !((NioClientSocketChannel)this.channel).boundManually) {
                        Channels.fireChannelBound(this.channel, (SocketAddress)localAddress);
                    }
                    Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block11;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
        }
    }
}

