define([
    'static.wcl.Core'
], function(Core) {
    function SizeConstrain(parent, container, arg) {
        var item = Core._mk(parent, container, arg.item);
        var minx = arg.minx !== undefined ? Core.unit2px(arg.minx) : 0;
        var miny = arg.miny !== undefined ? Core.unit2px(arg.miny) : 0;
        var maxx = arg.maxx !== undefined ? Core.unit2px(arg.maxx) : Core.Control.UNBOUND_MAX.x;
        var maxy = arg.maxy !== undefined ? Core.unit2px(arg.maxy) : Core.Control.UNBOUND_MAX.y;
        if(arg.wdiID)
        {
            this.dbg = "SizeConstrain";
            this.wdiID = arg.wdiID;
        }
        if(arg.wdiNAME)
            this.wdiName = arg.wdiNAME;
        this.flowType = arg.flowType||0;
        this.calculate = function() {
            var c = item.calculate();
            return {
                _ic: c,
                min: {
                    x: Math.max(c.min.x, minx),
                    y: Math.max(c.min.y, miny)
                },
                max: {
                    x: Math.max(c.min.x, Math.min(c.max.x, maxx)),
                    y: Math.max(c.min.y, Math.min(c.max.y, maxy))
                }
            };
        };
        this.validate = function(arg) {
            item.validate({rect: arg.rect, calc: arg.calc._ic});
        };
    }
    return SizeConstrain;
});
