define([
    'static.wcl.Core',
    'static.wcl.Theme',
    'inform.agent.web.Styles'
], function(Core, Theme, Styles) {
    Styles.sheet().rules({
        '.wcl-button': {
            'border': '1px solid #D0D0D0',
            'border-radius': '3px',
            'background-color': '#E0E0E0',
            'background-image': ['url(' + asmo.root + '/static/images/btn_normal.png)', 'linear-gradient(top, #FFFFFF, #E0E0E0)'],
            'background-repeat': 'repeat-x',
            'padding': '1px 12px',
            'font': 'inherit',
            'color': '#0080F0',
            '>span': {
                'background-repeat': 'no-repeat',
                'background-position': '0 50%',
                'background-size': '24px',
                'display': 'inline-block',
                'height': (Theme.LINECONTROL_HEIGHT - 4) + 'px',
                'line-height': (Theme.LINECONTROL_HEIGHT - 4) + 'px',
                'white-space': 'nowrap',
                'cursor': 'default'
            },
            '::-moz-focus-inner': {
                'padding': 0,
                'margin': '-1px'
            },
            ':hover': {
                'background-color': '#F0F0F0',
                'background-image': 'none'
            },
            ':active': {
                'background-color': '#E0E0E0',
                'background-image': ['url(' + asmo.root + '/static/images/btn_pressed.png)', 'linear-gradient(top, #E0E0E0, #FFFFFF)']
            },
            '[disabled]>span': {
                'filter': 'grayscale(100%) gray alpha(opacity = 33)',
                '-webkit-filter': 'grayscale(100%)',
                'opacity': '0.3',
                'color': 'black',
                'text-shadow': '1px 1px 0 white'
            }
        }
    });
    return function(parent, container, arg) {
        var element = document.createElement('button');
        element.className = 'wcl-button';
        function accessRightsChanged(enabled){
            var xEditModeOnly = (element.getAttribute("editmodeonly") === "true") ? true : false;
            var xEditMode = (element.getAttribute("editmode") === "true") ? true : false;
            element.disabled = !(enabled /*&&((Mask and AB_EXECUTE) <> 0) */ 
                && (!xEditModeOnly || (xEditModeOnly && xEditMode))
                && element.onclick); 
        }
        function bindIfDefined(prop, func) {
            if (prop !== undefined)
                Core._modelUpdater(prop, func);
        }
        this.flowType = arg.flowType||0;
        arg.style && Styles.apply(element.style, arg.style);
        bindIfDefined(arg.className, function(className) {
            element.className = 'wcl-button ' + className;
        });
        Core._modelUpdater(arg.editmodeonly, function(editmodeonly) {
            element.setAttribute("editmodeonly", editmodeonly || false);
            element.setAttribute("editmode", false);
        });        
                
        Core._modelUpdater(arg.onclick, function(onclick) {
            element.onclick = onclick || null;
            accessRightsChanged(onclick);
        });
        var content = document.createElement('span');
        element.appendChild(content);
        function updatePaddings(icon) {
            if (icon) {
                if (content.innerHTML) {
                    content.style.paddingLeft = '27px';
                    content.style.marginLeft = '-3px';
                    element.style.padding = '';
                } else {
                    content.style.paddingLeft = '24px';
                    content.style.marginLeft = '';
                    element.style.padding = '1px 2px 0';
                }
            } else {
                content.style.backgroundImage = '';
                content.style.paddingLeft = '';
                content.style.marginLeft = '';
                element.style.padding = '';
            }
        }
        var has_icon;
        var iconIndex;
        function changeIcon(icon){
            has_icon = !!icon;
            iconIndex = icon;
            if (has_icon)
                content.style.backgroundImage = 'url(' + asmo.root + '/images/icons/24/' + iconIndex + ')';
            updatePaddings(has_icon);
            parent.invalidate();
        }
        Core._modelUpdater(arg.icon, function(icon) {
            changeIcon(icon);
        });
        if((arg.scriptName || arg.scriptclick) && arg.formScript)
        {
            var scriptName = (arg.scriptName == null || arg.scriptName == undefined)? "":arg.scriptName;
            var so = {};
            Object.defineProperty(so, "name", {value: scriptName});
            Object.defineProperty(so, "imageIndex", 
            {
                get: function()
                {
                    return iconIndex ? iconIndex : 0;
                },
                set: function(v)
                {
                    changeIcon(typeof(v) === 'number' ? v : 0);
                }
            });
            Object.defineProperty(so, "tag", 
            {
                get: function() 
                { 
                    var res = element.getAttribute("tag");
                    if (!res)
                        res = '';
                    return res; 
                }, 
                set: function(v)
                { 
                    element.setAttribute("tag", typeof(v) === 'string' ? v : '');
                } 
            });
            Object.defineProperty(so, "visible", 
            {
                get: function() 
                { 
                    var style = window.getComputedStyle(element);
                    return (style.display !== 'none')                    
                }, 
                set: function(v)
                { 
                    if (!v)
                        element.style.display = "none";
                    else
                        element.style.display = "";
                } 
            });
            Object.defineProperty(so, "enabled", 
            {
                get: function() 
                { 
                    return !element.disabled; 
                }, 
                set: function(v)
                { 
                    accessRightsChanged(v);
                } 
            });
            var text =
            {
                 get: function() { return content.innerHTML; }
                ,set: function(v)
                {
                    content.innerHTML = String(v);
                    updatePaddings(has_icon);
                    parent.invalidate();
                }
            };
            Object.defineProperty(so, "text", text);
            Object.defineProperty(so, "caption", text);
            if(arg.scriptclick)
            {
                element.onclick = arg.scriptclick.bind(so);
                accessRightsChanged(true);
            }
            if(arg.scriptName)
                arg.formScript._reg_component(arg.scriptName, so);
        }
        Core._modelUpdater(arg.text, function(text) {
            content.innerHTML = text || '';
            updatePaddings(content.style.backgroundImage !== '');
            parent.invalidate();
        });
        Core._modelUpdater(arg.hint, function(hint) {
            element.title = hint || '';
        });
        (arg.enabled !== undefined) && Core._modelUpdater(arg.enabled, function(enabled) {
            accessRightsChanged(enabled);
        });
        Core._modelUpdater(arg.tag, function(tag) {
            element.setAttribute("tag", tag || "");
        });        
        
        container.appendChild(element);
        this.calculate = function() {
            var h = Theme.LINECONTROL_HEIGHT;
            var sz = Core._measure(element);
            return {
                min: {x: sz.x, y: h},
                max: {x: sz.x, y: h}
            };
        };
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            recter(arg.rect);
        };
        this._remove = function() {
            container.removeChild(element);
        };
        element._wcl_invalidate = function() {
            parent.invalidate();
        };
    };
});
