define([
    'static.wcl.Core',
    'inform.agent.web.Styles'
], function(Core, Styles) {
    Styles.sheet().rules({        
        '.wcl-label': {
            'white-space': 'nowrap',
            '.wcl-measure': {
                'line-height': 'inherit !important'                
            },
            cursor: 'default'
        },
        '.wcl-input-label' : {
            cursor: 'default'
        }
    });
    function Label(parent, container, arg) {
        var element = document.createElement('span');
        element.className = 'wcl-label';
        arg.style && Styles.apply(element.style, arg.style);
        Core._modelUpdater(arg.tag, function(tag) {
            element.setAttribute("tag", tag || "");
        });        
        Core._modelUpdater(arg.text, function(text) {
            element.innerHTML = text || '';
            parent.invalidate();
        });
        Core._modelUpdater(arg.onclick, function(onclick) {
            element.onclick = onclick || null;
        });
        
        if((arg.scriptName || arg.scriptclick) && arg.formScript)
        {
            var scriptName = (arg.scriptName === null || arg.scriptName === undefined)? "":arg.scriptName;
            var so = {};
            Object.defineProperty(so, "name", {value: scriptName});
            Object.defineProperty(so, "tag", 
            {
                get: function() 
                { 
                    var res = element.getAttribute("tag");
                    if (!res)
                        res = '';
                    return res; 
                }, 
                set: function(v)
                { 
                    element.setAttribute("tag", typeof(v) === 'string' ? v : '');
                } 
            });
            Object.defineProperty(so, "enabled", {get: function() { return !element.disabled; }, set: function(v){ element.disabled = !v;} });
            Object.defineProperty(so, "visible", 
            {
                get: function() 
                { 
                    var style = window.getComputedStyle(element);
                    return (style.display !== 'none')                    
                }, 
                set: function(v)
                { 
                    if (!v)
                        element.style.display = "none";
                    else
                        element.style.display = "";
                } 
            });
            var text =
            {
                 get: function() { return element.innerHTML; }
                ,set: function(v)
                {
                    element.innerHTML = String(v);                    
                    parent.invalidate();
                }
            };
            Object.defineProperty(so, "text", text)
            
            if(arg.scriptclick)
            {
                element.onclick = arg.scriptclick.bind(so);
                element.disabled = false;
            }
            if(arg.scriptName)
                arg.formScript._reg_component(arg.scriptName, so);
        }
        element.style.cursor = element.onclick ? "pointer" : "default";
        container.appendChild(element);
        this.flowType = arg.flowType|0;
        this.calculate = function() {
            var szMin = Core._measure(element);
            var szMax = { x: szMin.x, y: szMin.y };
            if((this.flowType&0x3) == 3)
            {
                if((this.flowType&0xC) == 1)
                    szMax.y = Core.Control.UNBOUND_MAX.y;
                else
                    szMax.x = Core.Control.UNBOUND_MAX.x;
            }
            return {
                min: szMin,
                max: szMax
            };
        };
        var recter = Core._mkRecter(element, function(h) {
            element.style.lineHeight = h + 'px';
            return true;
        });
        this.validate = function(arg) {
            element.title = arg.rect.s.x < arg.calc.min.x ? element.innerText : '';
            recter(arg.rect);
        };
    }
    Label.ForInput = function(parent, container, arg) {
        var element = document.createElement('label');
        element.className = 'wcl-input-label';
        var lbl = Core._mk(parent, element, {_: Label, text: arg.text});
        var inp = Core._mk(parent, element, arg.input);
        var GAP = 2;
        this.calculate = function() {
            var lc = lbl.calculate(), ic = inp.calculate();
            var sz = {
                x: lc.min.x + ic.min.x + GAP,
                y: Math.max(lc.min.y, ic.min.y)
            };
            return {
                min: sz,
                max: sz,
                _lc: lc,
                _ic: ic
            };
        };
        var textleft = !!arg.textleft;
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            var r = arg.rect, c = arg.calc;
            recter(r);
            var ly = (r.s.y - c._lc.min.y) / 2;
            var ry = (r.s.y - c._ic.min.y) / 2;
            if (textleft) {
                lbl.validate({rect: {p: {x: 0, y: ly}, s: c._lc.min}, calc: c._lc});
                inp.validate({rect: {p: {x: c._lc.min.x + GAP, y: ry}, s: c._ic.min}, calc: c._ic});
            } else {
                inp.validate({rect: {p: {x: 0, y: ry}, s: c._ic.min}, calc: c._ic});
                lbl.validate({rect: {p: {x: c._ic.min.x + GAP, y: ly}, s: c._lc.min}, calc: c._lc});
            }
        };
        container.appendChild(element);
    };
    return Label;
});
