define([
    'static.wcl.Core'
  , 'inform.agent.web.Styles'
], function(Core, Styles) {
    Styles.sheet().rules({
        '.wcl-radio': {
            'margin': 0
        }
    });
    function Radio(parent, container, arg) {
        var element = document.createElement('input');
        element.className = 'wcl-radio';
        element.type = 'radio';
        Core._modelUpdater(arg.group, function(group) {
            element.setAttribute("name", group);
        });        
        Core._modelUpdater(arg.model, function(mval) {
            element.checked = mval === arg.value;
        });
        if (arg.model && arg.model.set)
            element.onclick = function() {
                arg.model.set(arg.value);
            };
        else
            element.disabled = true;
        container.appendChild(element);
        this.calculate = function() {
            var sz = Core._measure(element);
            return {
                min: sz,
                max: sz
            };
        };
        var recter = Core._mkRecter(element);
        this.validate = function(arg) {
            recter(arg.rect);
        };
    }
    return Radio;
});
