define([
    'inform.agent.web.Styles',
    'static.wcl.Core',
    'static.wcl.Theme'
], function(Styles, Core, Theme)
{
    var Flow = function(parent, container, arg)
    {
        var block;
        if(arg.block)
        {
            var element = document.createElement('div');
            element.className = 'wcl-panel';
            arg.style && Styles.apply(element.style, arg.style);
            container.appendChild(element);
            container = element;
            block = Core._mkRecter(element);
        }
        var items = [], gap = arg.gap === undefined ? Theme.GAP : arg.gap;
        if (arg.items)
            for (var i = 0, l = arg.items.length; i < l; i++)
                items.push(Core._mk(parent, container, arg.items[i]));
        var t = arg.type;
        this.flowType = arg.flowType||0;
        this.validFlowType = arg.flowType != undefined;
        if(arg.wdiID)
        {
            this.dbg = "Flow";
            this.wdiID = arg.wdiID;
        }
        if(arg.wdiNAME)
            this.wdiName = arg.wdiNAME;
        this.appendItem = function(arg)
        {
            var it = Core._mk(parent, container, arg);
            items.push(it);
            this.invalidate();
            return it;
        };
        this.removeItem = function(item)
        {
            for (var i = 0, l = items.length; i < l; i++)
                if (items[i] === item) {
                    items.splice(i, 1);
                    item._remove && item._remove();
                    this.invalidate();
                }
        };
        var halign = arg.halign || Flow.HALIGN.JUSTIFY;
        this.calculate = function()
        {
            var r =
            {
                min: {x: 0, y: 0},
                max: {x: 0, y: 0}
            };
            var chld = [];
            for (var i = 0, l = items.length; i < l; i++)
            {
                var item = items[i];
                var c = item.calculate();
                c.flowType = (item.flowType||0) & 0x33;
                chld.push(c);
                r.min[t.m] += c.min[t.m];
                r.max[t.m] += c.max[t.m];
                if (i !== 0) {
                    r.min[t.m] += gap;
                    r.max[t.m] += gap;
                }
                if (r.min[t.o] < c.min[t.o])
                    r.min[t.o] = c.min[t.o];
                if (r.max[t.o] < c.max[t.o])
                    r.max[t.o] = c.max[t.o];
            }
            var rr = halign.calc(r);
            rr.chld = chld;
            if((this.flowType & 0x30) == 0x30)
                rr.max[t.m] = Core.Control.UNBOUND_MAX[t.m];
            return rr;
        };
        this.validate = function(arg)
        {
            var ii = [];
            var r = halign.vald(arg.rect, arg.calc), s = r.s, c = arg.calc;
            if(block)
            {
                block(r);
                r.p.x = 0;
                r.p.y = 0;
            }
            for (var i = 0, l = items.length; i < l; i++)
            {
                var ci = c.chld[i];
                ii.push({item: items[i], flowType: (items[i].flowType||0)&0x3, calc: ci, max: ci.max[t.m], val: ci.min[t.m], d: 0});
            }
            if(this.validFlowType)
                Flow._algorithmComplex(ii, s[t.m], s[t.m] - c.min[t.m], gap);
            else
                Flow._algorithm(ii, s[t.m] - c.min[t.m]);
            var pp = {x: r.p.x, y: r.p.y};
            var ppp = {x: 0, y: 0};
            for (var i = 0, l = ii.length; i < l; i++)
            {
                var n = ii[i], x = {};
                x[t.m] = n.val;
                x[t.o] = s[t.o];
                ppp.x = pp.x;
                ppp.y = pp.y;
                if(n.d > 0)
                    ppp[t.m] = r.p[t.m]+n.d;
                n.item.validate({rect: {p: ppp, s: x}, calc: n.calc});
                pp[t.m] += n.val + gap;
            }
        };
        this.invalidate = function()
        {
            parent.invalidate();
        };
    };
    Flow._algorithmComplex = function(items, s, dm, gap)
    {
        function _distributeDelta(items, delta, fi, li)
        {
            var ns = items.slice(fi, fi+li);
            for (var i = 0, l = ns.length; i < l; i++)
            {
                var n = ns[i];
                if(i != 0)
                    delta += gap;
                n.d = delta;
                delta += n.val;
            }
        }
        function _distribute(items, fi, li)
        {
            var ns = items.slice(fi, fi+li);
            var dm = 0;
            do
            {
                var ndm = 0;
                var nns = [];
                for (var i = 0, l = ns.length; i < l; i++)
                {
                    var n = ns[i];
                    var nv = n.val;
                    if (nv > n.max)
                    {
                        ndm += nv - n.max;
                        nv = n.max;
                    }
                    else
                        nns.push(n);
                    n.val = nv;
                }
                dm = ndm;
                ns = nns;
            } while (ns.length && (dm > 0.1));
        }
        var sis = Array(items.length);
        var sii = -1;
        var fc = 0, jfc = 0, cc = 0, jlc = 0, lc = 0;
        var fw = 0, cw = 0, lw = 0;
        for (var i = 0, l = items.length; i < l; ++i)
        {
            var item = items[i];
            if(!item.flowType || (item.flowType&0x3)==0)
            {
                sis[++sii] = item;
                ++fc;
                fw += item.val;
            }
        }
        var cs = -1;
        for (var i = 0, l = items.length; i < l; ++i)
        {
            var item = items[i];
            if((item.flowType&0x3) == 1)
            {
                cs = i;
                ce = i;
                break;
            }
            else if((item.flowType&0x3) == 3)
            {
                sis[++sii] = item;
                ++jfc;
            }
        }
        if(cs >= 0)
        {
            var ce = cs;
            for (var i = cs+1, l = items.length; i < l; ++i)
            {
                var item = items[i];
                if((item.flowType&0x3) == 1)
                {
                    if(cs < 0)
                        cs = i;
                    ce = i;
                }
            }
            for(var i = cs, l = ce+1; i < l; ++i)
            {
                var item = items[i];
                sis[++sii] = item;
                ++cc;
                cw += item.val;
            }
            for (var i = ce+1, l = items.length; i < l; ++i)
            {
                var item = items[i];
                if((item.flowType&0x3) == 3)
                {
                    sis[++sii] = item;
                    ++jlc;
                }
            }
        }
        for (var i = 0, l = items.length; i < l; ++i)
        {
            var item = items[i];
            if((item.flowType&0x3) == 2)
            {
                sis[++sii] = item;
                ++lc;
                lw += item.val;
            }
        }
        if(fc > 0)
        {
            fw += (fc-1)*gap;
            _distribute(sis, 0, fc);
            _distributeDelta(sis, 0, 0, fc);
        }
        if(lc > 0)
        {
            lw += (lc-1)*gap;
            var d = s-lw+0.55;
            var i = fc+jfc+cc+jlc;
            _distribute(sis, i, lc);
            _distributeDelta(sis, d, i, lc);
        }
        var cd = 0;
        if(cc > 0)
        {
            cw += (cc-1)*gap;
            cd = Math.round((s-cw)*50)/100;
            var i = fc+jfc;
            _distribute(sis, i, cc);
            _distributeDelta(sis, cd, i, cc);
        }
        var jc = jfc+jlc;
        var jli = fc+jfc+cc;
        if(jfc > 0)
            _distribute(sis, fc, jfc);
        if(jlc > 0)
            _distribute(sis, jli, jlc);
        if(jc > 0 && dm > 0.1)
        {
            var ii = 0;
            for (var i = 0; i < jfc; i++)
            {
                var d = (dm / (jc - ii)) | 0;
                var item = items[fc+i];
                if(item.val+d > item.max)
                    d = item.max-item.val;
                dm -= d;
                item.val += d;
                ++ii;
            }
            for (var i = 0; i < jlc; i++)
            {
                var d = (dm / (jc - ii)) | 0;
                var item = items[jli+i];
                if(item.val+d > item.max)
                    d = item.max-item.val;
                dm -= d;
                item.val += d;
                ++ii;
            }
            if(jfc > 0)
            {
                if(fc != 0)
                    fw += gap;
                _distributeDelta(sis, fw, fc, jfc);
            }
            if(jlc > 0)
                _distributeDelta(sis, cd+cw+gap, jli, jlc);
        }
    }
    Flow._algorithm = function(items, dm)
    {
        var ns = items.slice();
        do{
            var ndm = 0;
            var nns = [];
            for (var i = 0, l = ns.length; i < l; i++)
            {
                var d = (dm / (l - i)) | 0;
                var n = ns[i];
                dm -= d;
                var nv = n.val + d;
                if (nv > n.max)
                {
                    ndm += nv - n.max;
                    nv = n.max;
                } else
                    nns.push(n);
                n.val = nv;
            }
            dm = ndm;
            ns = nns;
        } while (ns.length && (dm > 0.1));
        if (dm > 0.1)
        {
            for (var i = 0, l = items.length; i < l; i++)
            {
                if(items[i].flowType == 3)
                {
                    var d = (dm / (l - i)) | 0;
                    dm -= d;
                    items[i].val += d;
                }
            }
        }
    };
    Flow.HORZ = {m: 'x', o: 'y'};
    Flow.VERT = {m: 'y', o: 'x'};
    function smin(s){return{min:s.min,max:{x:s.min.x, y:s.max.y}};};
    function pass(x){return x;};
    Flow.HALIGN =
    {
        LEFT:
        {
            calc:smin,
            vald:function(r,c) { return { p:r.p, s:{x:c.min.x, y:r.s.y}}; }
        },
        CENTER:
        {
            calc:smin,
            vald:function(r,c) { return {p:{x:r.p.x+(r.s.x-c.min.x)/2,y:r.p.y},s:{x:c.min.x,y:r.s.y}}; }
        },
        RIGHT:
        {
            calc:smin,
            vald:function(r,c) { return {p:{x:r.p.x+r.s.x-c.min.x,y:r.p.y},s:{x:c.min.x,y:r.s.y}};}
        },
        JUSTIFY:
        {
            calc:pass,
            vald:pass
        }
    };
    return Flow;
});
