define(function()
{
    function makeStruct(typeName, fieldNames)
    {
        if (!typeName || !fieldNames || (fieldNames && (fieldNames.length === 0)))
            throw "Incorrect arguments!";
        return function(){
            var struct = {
                class: typeName
            };        
            for (var i = 0; i < fieldNames.length; i++)
                Object.defineProperty(struct, fieldNames[i], {
                    enumerable: true,
                    writable: true
                });
            struct.toString = function(){
                var result = "[object " + typeName + "({";
                for (var i = 0; i < fieldNames.length; ++i)
                {
                    if (i !== 0)
                        result += ",";
                    result += fieldNames[i] + ":" + JSON.stringify(this[fieldNames[i]]);
                }
                result += "})]";
                return result;
            };
            Object.seal(struct);
            return struct;
        };
    }
    
    return {
         PRIMARY_KEY: -1
        ,NONE: 0
        ,INTEGER: 1
        ,FLOAT: 2
        ,STRING: 3
        ,DATE_TIME: 4
        ,TIMESPAN: 5
        ,REFERENCE: 6
        ,BOOLEAN: 7
        ,BLOB: 8
        ,FILE: 9
        ,METATREE_NODE: 10
        ,VARIANT: 11
        ,BIGNUMBER: 12
        ,UNICODE: 13
        ,GEOMETRY: 14
        ,makeStruct: makeStruct
    }; 
});
