define( [
    "inform.agent.web.forms.Requests",
    "inform.agent.web.forms.Actioner"
], function( RQ, Actioner ) {
    var self, queue = [], LIMIT = 128;
    function exec() {
        if (queue.length === 0)
            return;
        var d = queue.shift(), ids;
        var arg = function() {
            if (d.ids.length > LIMIT) {
                ids = d.ids.slice(0, LIMIT);
                d.keys.splice(0, ids.length);
                queue.push(d);
            } else {
                ids = d.ids;
                d.ids = [];
            }
            var url = '/rq/nodeInfo?nodes=' + ids + '&' + d.tail;
            return {
                url: url
            };
        };
        arg.caption = d.done.caption;
        RQ.execute(arg).then(function(r) {
            d.done(JSON.parse(r), d.tail, ids, d.arg);
            exec();
        }, function(e) {
            d.fail && d.fail(e, d.tail, ids);
            exec();
            throw e;
        });
    }
    var map = {};
    function groupfetch(tail, id, done, fail, arg) {
        var d = map[tail];
        if (!d)
            map[tail] = d = {
                ids: [],
                tail: tail,
                done: done,
                fail: fail,
                arg: arg
            };
        var needInitialRq = queue.length === 0;
        var needDelay = false;
        if (d.ids.length === 0) {
            queue.push(d);
            needDelay = true;
        }
        d.ids.push(id);
        if (needInitialRq) {
            if (needDelay)
                setTimeout(exec);
            else
                exec();
        }
    }
    function fetch_ready(rr, tail, ids, arg) {
        for (var i = 0; i < rr.length; i++) {
            var ni = rr[i], e = self.cache[ni.id];
            if (e.opts & ~arg)
                continue;
            e.info = ni;
        }
        for (var i = 0, l = ids.length; i < l; ++i) {
            var id = ids[i], e = self.cache[id];
            if (!e.info)
                e.info = {name: '???[' + id + ']'};
        }
        self._touch();
    }
    fetch_ready.caption = '   ';
    var fetchChildren_map = {};
    function fetchChildren_ready(rr, tail, ids) {
        for (var i = 0; i < rr.length; i++) {
            var ni = rr[i];
            var mkey = ni.id + tail;
            var e = fetchChildren_map[mkey];
            if (!e)
                throw Error('item (key=' + mkey + ') not found');
            delete fetchChildren_map[mkey];
            e.resolve(ni.ch);
        }
        for (var i = 0, l = ids.length; i < l; ++i) {
            var mkey = ids[i] + tail;
            var e = fetchChildren_map[mkey];
            if (!e)
                continue;
            delete fetchChildren_map[mkey];
            e.resolve(undefined);
        }
    }
    fetchChildren_ready.caption = '   ';
    function fetchChildren_fail(e, tail, ids) {
        for (var i = 0; i < ids.length; i++) {
            var mkey = ids[i].id + tail;
            var e = fetchChildren_map[mkey];
            if (!e)
                throw Error('item (key=' + mkey + ') not found');
            delete fetchChildren_map[mkey];
            e.reject(e);
        }
    }
    return self = new (CLASS( {
        Options: {
            NAME: 0x0001, IMAGE: 0x0002, FIO: 0x0004, PATH: 0x0008, TYPE: 0x0010
        },
        constructor: function() {
            Actioner.constructor.call( this );
            this.cache = {};
        },
        fetch: function( node, options ) {
            var e = this.cache[node];
            if ( e && !(options & ~e.opts) )
                return e.info;
            if ( !e )
                this.cache[node] = e = {
                    opts: options | 0
                };
            else {
                e.opts |= options;
                e.info = undefined;
            }
            groupfetch('options=' + e.opts, node, fetch_ready, null, e.opts);
            return null;
        },
        fetchChildren: function( node, filter ) {
            var key = 'children';
            if (filter)
                key += '=' + filter;
            var mkey = node + key;
            var r = fetchChildren_map[mkey];
            if (!r) {
                r = Asyncs.create();
                fetchChildren_map[mkey] = r;
                groupfetch(key, node, fetchChildren_ready, fetchChildren_fail);
            }
            return r.promise();
        }
    }, Actioner ));
} );