define( [
    "inform.agent.web.forms.Datamodel",
    'static.wcl.Core'
  , 'static.wcl.controls.Label'
  , 'static.wcl.controls.CheckBox'
], function(DM, Wcl, Label, CheckBox) {
    return {
        WclControl: function(parent, container, arg) {
            var model = null;
            if (arg.fpath) {
                var f = arg.fpath[arg.fpath.length - 1], ds = f._datasource, row = null;
                var row = null;
                var fmodel = Wcl.createFModel(function() {
                    row = ds._row();
                    if (!row)
                        return DM.fetchFPathValue.WAIT;
                    var v = DM.fetchFPathValue(arg.fpath, row);
                    if (v === DM.fetchFPathValue.WAIT)
                        return v;
                    return !!v;
                }, ds._modify && function(val) {
                    row = ds._modify( row );
                    row[f.index] = val;
                    ds._touch();
                });
                model = fmodel.model;
                function update() {
                    var v = model();
                    if (v === DM.fetchFPathValue.WAIT)
                        return;
                    fmodel.notify(v);
                }
                for (var i in arg.fpath)
                    arg.fpath[i]._datasource._listen(update);
                update();
            }
            var params = new DM.Parameters({
                1: {type: DM.DataType.BOOLEAN}
            }, {
                1: null
            });
            Wcl._modelUpdater(model, function(checked) {
                params._row()[0] = checked;
                params._touch();
            });
            arg.cmps[arg.id] = params;
            return Wcl._mk(parent, container, {
                _: Label.ForInput, textleft: arg.cleft, text: arg.caption,
                input: {_: CheckBox, checked: model}
            });
        }
    };
} );
