define( [
    "inform.agent.web.forms.Actioner",
    "inform.agent.web.forms.WebForm",
    "inform.agent.web.forms.WebGridCommon",
    "inform.agent.web.forms.Formats",
    "inform.agent.web.forms.Datamodel",
    "inform.agent.web.utils.Strings",
    "inform.agent.web.Expressions",
    "inform.agent.web.Modal",
    "inform.agent.web.NodeInfo",
    "inform.agent.web.Styles"
    , 'static.wcl.Core'
    , 'static.wcl.Theme'
    , 'inform.agent.web.forms.WebGridVeer'
], function(Actioner, F, WebGridCommon, Formats, DM, Strings, Expressions, Modal, 
        NodeInfo, Styles, Wcl, Theme, GridVeer) {
    function fetchOptional( expressions, ctx ) {
        var result = {};
        for ( var i in expressions ) {
            var e = expressions[i];
            if ( !e )
                continue;
            var v = e.evaluate( ctx );
            if ( v === Expressions.WAIT )
                return null;
            if ( (v !== Expressions.NVAL) && (v !== null) )
                result[i] = v;
        }
        return result;
    }
    function showDebug(datasource, rcount) {
        var info = document.createElement('table');
        info.className = 'grid-info';
        function mkrow() {
            var tr = info.insertRow(info.rows.length);
            for (var i = 0; i < arguments.length; i++)
                tr.appendChild(arguments[i]);
        }
        function mkcell(cls, v, title) {
            var td = document.createElement(cls);
            v && F.setTextContent(td, v);
            title && (td.title = title);
            return td;
        }
        function l0(n, v) {
            mkrow(mkcell('th', n + ':'), mkcell('td', v));
        }
        function l1(n, v) {
            mkrow(mkcell('td', n + ':'), mkcell('td', v, n));
        }
        l0("- ", rcount);
        var d = datasource._descriptor;
        function bv(p, t) {
            if (p instanceof DM.Datasource.Field) {
                var ds = p._datasource;
                var r = ds._row();
                if (r === null)//not loaded
                    return 'W';
                if (r === undefined)//no row
                    return 'X';
                p = r[p.index];
            }
            if (p === DM.ALLVAL)
                return "";
            if (t.type === 4)//datatime
                return Formats.DATETIME_DD_MM_YYYY_HH_MM_SS.format(p);
            return JSON.stringify(p);
        }
        var prms = [];
        for (var i in d.p_bindings)
            prms.push({caption: d.parameters[i].caption, value: bv(d.p_bindings[i], d.parameters[i])});
        if (prms.length) {
            var td = mkcell('th'); td.colSpan = 2; td.innerHTML = '<hr/> :';
            mkrow(td);
            for (var i in prms)
                l1(prms[i].caption, prms[i].value);
        }
        var flds = [];
        for (var i in d.f_bindings)
            flds.push({caption: d.fields[i].caption, value: bv(d.f_bindings[i], d.fields[i])});
        if (flds.length) {
            var td = mkcell('th'); td.colSpan = 2; td.innerHTML = '<hr/>  :';
            mkrow(td);
            for (var i in flds)
                l1(flds[i].caption, flds[i].value);
        }
        Modal.show({
            caption: "Debug",
            content: info
        });
    }
    function updateRowIndicator(tr) {
        var ind = tr.firstChild;
        ind.innerHTML = Styles.hasClass(tr, 'selected') ? '&#9658;' : (Styles.hasClass(tr, 'active') ? '&#5125;' : '');
    }
    function selected(tr, value) {
        if (arguments.length === 1)
            return Styles.hasClass(tr, 'selected');
        (value ? Styles.addClass : Styles.removeClass)(tr, 'selected');
        updateRowIndicator(tr);
    }
    function active(tr, value) {
        if (arguments.length === 1)
            return Styles.hasClass(tr, 'active');
        (value ? Styles.addClass : Styles.removeClass)(tr, 'active');
        updateRowIndicator(tr);
    }
    var GridActioner = CLASS( {
        constructor: function(datasource, rows) {
            Actioner.constructor.call( this );
            this._datasource = datasource;
            this._rows = rows;
            this._dependOn( [datasource] );
        },
        _action: function( id ) {
            switch ( id ) {
                case 2://delete
                    var self = this, can = !!this._datasource._action( 2 );
                    return can ? function() {
                        if ( !confirm( "  ?" ) )
                            return;
                        var rows = self._rows, selection = [];
                        if (typeof rows === 'function')
                            rows = rows();
                        for ( var i = 0, l = rows.length; i < l; i++ ) {
                            var r = rows[i];
                            if ( selected(r) )
                                selection.push( r._crow );
                        }
                        for ( var i = 0; i < selection.length; i++ )
                            self._datasource._delete( selection[i] );
                        self._datasource._touch();
                    } : null;
                default:
                    return null;
            }
        }
    }, Actioner );
    function Arrays_shrink(arr, nl) {
        var l = arr.length;
        if (l > nl)
            arr.splice(nl, l - nl);
    }
    function getColMap(columns, gdsid) {
        var colMap = new Object();
        for ( var i = 1; i < columns.length; i++ ) {
            var col = columns[i];
            if (col.getAttribute("isveer"))
                continue;            
            var key = col.id + ":" + gdsid;
            colMap[key] = {
                colExpr: Elements.dataset(col, 'expression'),
                colExprColor: Elements.dataset(col, 'color-expression'),
                colExprTextColor: Elements.dataset(col, 'textcolor-expression'),
                colExprTextStyle: Elements.dataset(col, 'textstyle-expression')                    
            };
        }        
        return colMap;        
    }
    function makeScrolled(gbody, components) {
        gbody.parentNode._upsize = function() {
            gbody.style.width = this.style.width;
            gbody.style.height = this.style.height;
        };
        var divgrid = gbody.parentNode;
        var datasources = components.datamodel._datasources;
        var hdrdiv, ftrdiv;
        for (var cc = divgrid.children, i = 0, l = cc.length; i < l; ++i) {
            var e = cc[i];
            switch (e.className) {
                case 'ghead':
                    hdrdiv = e;
                    break;

                case 'gfoot':
                    ftrdiv = e;
                    break;
            }
        }
        var hdrcut = hdrdiv.firstChild, hdrrest = hdrcut.lastChild, hdr = hdrrest.lastChild;
        var ftr;
        var sheet = Styles.sheet(divgrid);
        var rows_rule = sheet.rule('.grid[id="' + hdr.id + '"] .row');
        var cuts_rule = sheet.rule('.grid[id="' + hdr.id + '"] .cutter');
        var scrl_rule = sheet.rule('table.grid[id="' + hdr.id + '"]');
        var hgap = document.createElement('div');
        hgap.className = 'gap';
        gbody.insertBefore(hgap, gbody.firstChild);
        var fgap;
        if (ftrdiv) {
            fgap = document.createElement('div');
            fgap.className = 'gap';
            gbody.appendChild(fgap);
            var ftrcut = ftrdiv.firstChild;
            var ftrrest = ftrcut.lastChild;
            ftr = ftrrest.lastChild;
        }
        var ROWS_PER_BLOCK = 50;
        var BLOCK_LINE_HEIGHT = 23;//20px(1.5em-height) + 2px(padding) + 1px(border)
        var columns = [], autosizedColumns = [], blocks = [];
        var columnsChangeNo = 0;
        var hcells = hdr.getElementsByTagName('th');
        var hcellbyid = {};
        var veercolids = [];
        var veerDefs = [];
        var lastColId = -1;
        var firstColId = -1;
        var cols = hdr.getElementsByTagName('col');
        var colMap = getColMap(cols, hdr.id);
        
        for ( var i = 1; i < cols.length; i++ ) {
            var colItem = cols[i];            
            if (GridVeer.checkVeer(colItem)) {
                veercolids[colItem.id] = true;
                lastColId = colItem.id;                
                if (firstColId === -1)
                    firstColId = colItem.id;
            }
        }
        var gridVeerList = GridVeer.makeGridVeerList();
        
        for ( var i = 1; i < cols.length; i++ ) {
            var colItem = cols[i];            
            var tmpVeerDef = GridVeer.veerDef(colItem, datasources);
            if (tmpVeerDef){
                veerDefs[colItem.id] = tmpVeerDef;
                var isLastVeer = (colItem.id === lastColId);
                var isFirstVeer = (colItem.id === firstColId);
                colItem.setAttribute("isveer", "true");                
                var veerIndex = i;                
                gridVeerList.updateVeerColumns(veerDefs[colItem.id], columns, 
                    autosizedColumns, datasources, gbody, hcells, cols, 
                    hdr, veerIndex, veerUpdate, isLastVeer, isFirstVeer, colMap);
            }
        }
                
        for (var i = 0; i < hcells.length; i++) {
            var colId = Elements.dataset(hcells[i], 'colid');
            hcellbyid[colId] = hcells[i];
            if (veercolids[colId]) {  
                var buffHeader = hcells[i];
                buffHeader.setAttribute("style","display:none");            
            }
        }
        var hasWordWrapColumn = false;
        var hasDiffRowFont = false;
        function visibleRange(elements) {
            var ti = (function( arr, v ) {
                var l = 0, r = arr.length - 1;
                while ( r > l ) {
                    var m = (l + r) >> 1, e = arr[m], mv = e.offsetTop + e.offsetHeight;
                    if ( mv < v )
                        l = m + 1;
                    else
                        r = m;
                }
                return l;
            })(elements, gbody.scrollTop + hdrcut.clientHeight - 200);
            var bi = (function( arr, v, ti ) {
                var l = ti, r = arr.length - 1;
                while ( r > l ) {
                    var m = (l + r + 1) >> 1, e = arr[m], mv = e.offsetTop;
                    if (mv > v)
                        r = m - 1;
                    else
                        l = m;
                }
                return r;
            })(elements, gbody.scrollTop + gbody.clientHeight + 200, ti);
            return [ti, bi];
        }
        var strictW = divgrid.style.width && divgrid.offsetWidth;
        var strictH = divgrid.style.height && divgrid.offsetHeight;
        Styles.addClass(divgrid, 'wcl-grid');
        var firstCalc = true;
        var TWO_BORDER_WIDTHS = 2;
        divgrid._wcl_calculate = function() {
            if (divgrid._wcl_calccache)
                return divgrid._wcl_calccache;
            var so = {x: gbody.scrollLeft, y: gbody.scrollTop};
            var cw = [];
            for (var i = 0; i < autosizedColumns.length; i++) {
                var aci = autosizedColumns[i];
                cw[aci] = columns[aci].rule.style('width');
            }
            try {
            if (firstCalc) {
                var prevFont = null;
                var font = null;
                for (var i = 0; i < columns.length; i++) {
                    var c = columns[i];
                    if (!c.header || !c.rule || c.keyValue)
                        continue;
                    var cwpx = Number(c.startWidth);
                    if (c.rule.style('max-width'))
                        c.rule.style('max-width', cwpx + 'px');
                    c.rule.style('width', cwpx);
                    font = c.fontDesc;
                    if (!prevFont)
                        prevFont = font;
                    if (prevFont !== font)
                        hasDiffRowFont = true;                        
                }
                firstCalc = false;
            }
            for (var i = 0; i < autosizedColumns.length; i++)
                columns[autosizedColumns[i]].rule.style('width', '');
            var hhg = hdr.offsetHeight + TWO_BORDER_WIDTHS;
            if (ftr)
                hhg += ftr.offsetHeight + TWO_BORDER_WIDTHS;
            var mn = {
                x: 50/*magic*/,
                y: hhg + (divgrid._minh ? divgrid._minh : Theme.LINECONTROL_HEIGHT * 2)
            };
            var mx = {
                x: Wcl.Control.UNBOUND_MAX.x,
                y: divgrid._maxh ? hhg + divgrid._maxh : Wcl.Control.UNBOUND_MAX.y
            };
            if (strictW)
                mn.x = strictW;
            if (strictH)
                mn.y = strictH;
            if (mx.y < mn.y)
                mx.y = mn.y;
            if (mx.x < mn.x)
                mx.x = mn.x;
            var cc = [];
            for (var i = 0; i < columns.length; i++) 
                if (columns[i].header) 
                    cc[i] = columns[i].startWidth ? Number(columns[i].startWidth) : columns[i].header.clientWidth;
            return divgrid._wcl_calccache = {
                min: mn,
                max: mx,
                _cc: cc,
                _hx: hdr.offsetWidth
            };
            } finally {
                for (var i = 0; i < autosizedColumns.length; i++) {
                    var aci = autosizedColumns[i];
                    columns[aci].rule.style('width', cw[aci]);
                }
                gbody.scrollLeft = so.x;
                gbody.scrollTop = so.y;
            }
        };
        var rctr = Wcl._mkRecter(divgrid);
        var wcledSize = {x: 0, y: 0};
        var lastScrollTop = 0;
        function updateHdrDiv2() {
            cuts_rule.style('width', gbody.clientWidth + 'px');
        }
        function updateHeader() {
            hgap.style.height = (hdr.offsetHeight - 1) + 'px';
            if (fgap)
                fgap.style.height = (ftr.offsetHeight - 1) + 'px';
            rows_rule.style('width', hdr.clientWidth + 'px');
            updateHdrDiv2();
            for (var i = 0; i < columns.length; i++) {
                var th = columns[i].header;
                th && th._updateSorter && th._updateSorter();
            }
        }
        function getEffectiveAutoSizedColLength(){
            var sum = 0;
            for (var i = 0; i < autosizedColumns.length; i++) {
                var aci = autosizedColumns[i];
                if (!columns[aci].isveer)
                    sum++;
            }
            return sum;
        }
        divgrid._wcl_validate = function(arg) {
            rctr(arg.rect);
            var cw = (arg.rect.s.x | 0) - TWO_BORDER_WIDTHS, ch = (arg.rect.s.y | 0) - TWO_BORDER_WIDTHS;
            gbody.style.width = cw + 'px';
            gbody.style.height = ch + 'px';
            var len = getEffectiveAutoSizedColLength();
            if (len) {
                var dw = cw - arg.calc._hx - TWO_BORDER_WIDTHS;
                if (dw > 0) {
                    var dcwi = len ? Math.floor(dw / len) : 0;
                    var last_aci = -1;
                    for (var i = 0; i < autosizedColumns.length; i++) {
                        var aci = autosizedColumns[i];
                        if (columns[aci].isveer)
                            continue;
                        if (!columns[aci].keyValue)
                            last_aci = aci;
                        dw -= dcwi;
                        columns[aci].rule.style('width', Math.floor(arg.calc._cc[aci] + dcwi) + 'px');
                    }
                    if (last_aci > -1){
                        dcwi += dw;
                        columns[last_aci].rule.style('width', Math.floor(arg.calc._cc[last_aci] + dcwi) + 'px');
                    }
                } 
            }
            updateHeader();
            wcledSize = {x: cw, y: ch};
        };
        var lastGBodySize = {x: 0, y: 0};
        var lastGBodyCW = 0, lastGBodyCH = 0;
        var needValidateGrid = false;
        function validateGrid() {
            var cw = gbody.clientWidth, ch = gbody.clientHeight;
            var needUpdateRowHeights = false, forceCalculateRowHeights = false;
            if (cw) {//if visible
                if ((wcledSize.x !== lastGBodySize.x) || (wcledSize.y !== lastGBodySize.y)) {
                    lastGBodySize = wcledSize;
                    updateHeader();
                    needUpdateRowHeights = forceCalculateRowHeights = hasWordWrapColumn;
                } if (cw !== lastGBodyCW) {
                    lastGBodyCW = cw;
                    divgrid._soft_invalidate();
                }
                if (ch !== lastGBodyCH) {
                    lastGBodyCH = ch;
                    if (ftrdiv)
                        ftrdiv.style.bottom = (gbody.offsetHeight - ch) + 'px';
                }
                var vb = null;
                if (needValidateGrid) {
                    vb = visibleRange(blocks);
                    for (var i = 0; i < vb[0]; i++)
                        blocks[i]._stub();
                    for (var i = vb[0]; i <= vb[1]; i++) {
                        var block = blocks[i], stub = block.className.indexOf('stub') >= 0;
                        if (stub || block._hasInvalidColumns()) {
                            datasource._scan(function(cursor) {
                                var rcount = cursor._rowsCount();
                                if (rcount === DM.fetchFPathValue.WAIT)
                                    return;
                                var ridx = cursor._ridx;
                                for (; i <= vb[1]; i++) {
                                    var block = blocks[i], stub = block.className.indexOf('stub') >= 0;
                                    if (stub)
                                        block._updateWithCursor(cursor, rcount, ridx);
                                    else if (block._hasInvalidColumns())
                                        block._validateColumns(cursor);
                                }
                            });
                        }
                    }
                    needUpdateRowHeights = hasWordWrapColumn || hasDiffRowFont;
                    for (var i = vb[1] + 1; i < blocks.length; i++)
                        blocks[i]._stub();
                    needValidateGrid = false;
                }
                if (needUpdateRowHeights) {
                    if (vb === null)
                        vb = visibleRange(blocks);
                    for (var i = vb[0]; i <= vb[1]; i++)
                        blocks[i]._calculateRowHeights(forceCalculateRowHeights);
                    for (var i = vb[0]; i <= vb[1]; i++)
                        blocks[i]._applyCalculatedRowHeights();
                }
            }
            setTimeout(validateGrid, 250);
        }
            gbody.onscroll = function() {
                scrl_rule.style('left', (-gbody.scrollLeft) + 'px');
                var st = gbody.scrollTop;
                if (st !== lastScrollTop) {
                    lastScrollTop = st;
                    needValidateGrid = true;
                }
            };
            var action = Elements.dataset(hdr, 'action');
            if (action)
                action = new (F.ActionList)(action, components);
            var gdsid = Elements.dataset(hdr, 'datasource');
            var datasource = gdsid && datasources[gdsid];
            var rcount;
            var debug = document.createElement('div');
            debug.className = 'debug';
            debug.innerHTML = '@';
            divgrid.insertBefore(debug, divgrid.firstChild);
            debug.onclick = function() {
                showDebug( datasource, rcount );
            };
            var exprRowColor = Elements.dataset(hdr, 'color-expression');
            var exprRowTextColor = Elements.dataset(hdr, 'textcolor-expression');
            var exprRowTextStyle = Elements.dataset(hdr, 'textstyle-expression');
            if (hcells.length)
                columns.push({
                    header: hcells[0],
                    exprColor: exprRowColor ? Expressions.make(exprRowColor, datasources, colMap, "color", []) : null,
                    exprTextColor: exprRowTextColor ? Expressions.make(exprRowTextColor, datasources, colMap, "textColor", []) : null,
                    exprTextStyle: exprRowTextStyle ? Expressions.make(exprRowTextStyle, datasources, colMap, "textStyle", []) : null,
                    changeno: 0,
                    rule: sheet.rule('.grid[id="' + hdr.id + '"] .ci'),
                    rule_width: undefined,
                    validate: function(ctx, cell) {
                        var v;
                        if (!(v = fetchOptional({
                            rc: this.exprColor,
                            tc: this.exprTextColor,
                            ts: this.exprTextStyle
                        }, ctx)))
                            return false;
                        var tr = cell.parentNode;
                        tr.style.backgroundColor = F.color2hex(v.rc);
                        tr.style.color = F.color2hex(v.tc);
                        F.assignTextStyle(tr.style, v.ts);
                        return true;
                    }
                });
            for ( var i = 1; i < cols.length; i++ ) {                
                var col = cols[i];
                var rule = sheet.rule('.grid[id="' + hdr.id + '"] .c' + col.id);
                if (Elements.dataset(col, 'wordwrap') !== undefined) {
                    rule.style('line-height', 'inherit !important');
                    hasWordWrapColumn = true;
                }
                if (col.getAttribute("isveer")) {
                    columns.push({
                        id: col.id,                    
                        header: hcellbyid[col.id],
                        type: 0,
                        expr: null,
                        exprColor: null,
                        exprTextColor: null,
                        exprTextStyle: null,            
                        cells: [],
                        fmt: null,            
                        changeno: 0,
                        rule: rule,
                        isveer: true,
                        startWidth: col.getAttribute("start-width"),
                        fontDesc: col.getAttribute("font-descr"),
                        validate: function(ctx, cell) {
                            return true;
                        }
                    });
                    continue;
                }
                var type = parseInt(Elements.dataset(col, 'datatype'));
                var dsid = Elements.dataset(col, 'datasource');
                var fid = Elements.dataset(col, 'datafield');
                var sfp = null, fp = null;
                if ( dsid && fid ) {
                    sfp = fid.split( ',' );
                    fp = DM.mkFieldPath( sfp, dsid || gdsid, datasources );
                }
                var fmt = Elements.dataset(col, 'format');
                var expr = Elements.dataset(col, 'expression');
                var exprColor = Elements.dataset(col, 'color-expression');
                var exprTextColor = Elements.dataset(col, 'textcolor-expression');
                var exprTextStyle = Elements.dataset(col, 'textstyle-expression');
                var colact = Elements.dataset(col, 'action');
                if ( fmt ) {
                    var fmtopt = Elements.dataset(col, 'format-option');
                    fmt = Formats.byIdAndOption(fmt, fmtopt && Strings.base64_to_bytestr(fmtopt));
                    if ( !fmt )
                        col.style.color = 'red';
                }
                
                var column = {
                    id: col.id,                    
                    header: hcellbyid[col.id],
                    type: (fp && fp.length) ? (type || (fp && fp[fp.length-1]._descriptor.type)) : (type || 0),
                    expr: expr ? Expressions.make(expr, datasources, colMap, "data", []) : null,
                    exprColor: exprColor ? Expressions.make(exprColor, datasources, colMap, "color", []) : null,
                    exprTextColor: exprTextColor ? Expressions.make(exprTextColor, datasources, colMap, "textColor", []) : null,
                    exprTextStyle: exprTextStyle ? Expressions.make(exprTextStyle, datasources, colMap, "textStyle", []) : null,
                    action: colact && new (F.ActionList)(colact, components),
                    cells: [],
                    fmt: fmt,
                    rule: rule,
                    changeno: 0, 
                    startWidth: col.getAttribute("start-width"),
                    fontDesc: col.getAttribute("font-descr"),
                    validate: function(ctx, cell) {
                        var v = undefined;
                        if (this.expr) {
                            v = this.expr.evaluate(ctx);
                            if (v === Expressions.WAIT)
                                return false;
                            if (v === Expressions.NVAL)
                                v = undefined;
                        }
                        var vo;
                        if (!(vo = fetchOptional({
                            bc: this.exprColor,
                            tc: this.exprTextColor,
                            ts: this.exprTextStyle
                        }, ctx)))
                            return false;
                        if (!F.formatCellValue(cell, v, this.type, this.fmt, this.expr))
                            return false;
                        cell.style.backgroundColor = F.color2hex(vo.bc);
                        cell.style.color = F.color2hex(vo.tc);
                        F.assignTextStyle(cell.style, vo.ts);
                        return true;
                    }
                };
                columns.push(column);

                if (Elements.dataset(col, "ranging") !== "fixed")
                    autosizedColumns.push(i);
                if ((dsid === gdsid) && sfp && datasource && datasource._sort) {
                    var sr = document.createElement( "div" );
                    var th = hcellbyid[col.id];
                    th.insertBefore( sr, th.firstChild );
                    var _ = th._fpath = [];
                    for ( var xi in sfp )
                        _.push( sfp[xi] | 0 );
                    function eqs_arrays( a, b ) {
                        if ( a.length !== b.length )
                            return false;
                        for ( var i = 0, l = a.length; i < l; i++ )
                            if ( a[i] !== b[i] )
                                return false;
                        return true;
                    }
                    function indexOfSortingByPath( sorting, fp ) {
                        for ( var i = 0, l = sorting.length; i < l; i++ )
                            if ( eqs_arrays(sorting[i][1], fp) )
                                return i;
                        return -1;
                    }
                    th._sorder = 3;
                    var resort = function( e ) {
                        e = e || window.event;
                        var ds = datasource._descriptor.sorting;
                        var so = (this._sorder + 1) % (ds ? 3 : 2);
                        var sort;
                        if ( so === 2 ) {
                            if ( e.ctrlKey ) {
                                var si = indexOfSortingByPath( datasource._sorting, this._fpath );
                                sort = datasource._sorting.slice();
                                if ( si >= 0 )
                                    sort.splice( si, 1 );
                            } else
                                sort = [];
                            if ( sort.length )
                                datasource._sort( sort );
                            else {
                                if ( ds && ds.paths && (ds.paths.length === 1) && eqs_arrays(ds.paths[0][1], this._fpath) )
                                    datasource._sort( [[(this._sorder+1)%2, this._fpath]] );
                                else
                                    datasource._sort();
                            }
                        } else {
                            var ns = [so, this._fpath];
                            if ( e.ctrlKey ) {
                                var si = indexOfSortingByPath( datasource._sorting, this._fpath );
                                sort = datasource._sorting.slice();
                                if ( si < 0 )
                                    sort.push( ns );
                                else
                                    sort[si] = ns;
                            } else
                                sort = [ns];
                            datasource._sort( sort );
                        }
                        lastGBodySize = {x: 0, y: 0};
                    };
                    th._updateSorter = function() {
                        var sr = this.firstChild;
                        if ( datasource._canSort() ) {
                            sr.className = 'sort';
                            this.onclick = resort;
                        } else {
                            sr.className = 'sort disabled';
                            this.onclick = null;
                        }
                        var si = indexOfSortingByPath( datasource._sorting, this._fpath );
                        var so = si < 0 ? 2 : datasource._sorting[si][0];
                        this._sorder = so;
                        if ( so === 2 )
                            sr.innerHTML = "";
                        else {
                            sr.innerHTML = (so ? "&#9660;" : "&#9650;") + (si?(new Array(si+1)).join('\''):"");
                            sr.style.left = (this.offsetLeft + this.offsetWidth - sr.offsetWidth - 1) + "px";
                            sr.style.top = (this.offsetTop + 1) + "px";
                        }
                    };
                    th._updateSorter();
                }
            }
            if (autosizedColumns.length)
                Styles.addClass(divgrid, 'hasflex');
            validateGrid();
          if (hcells.length)
            hcells[0].onclick = function() {
                for (var i = 0; i < blocks.length; i++) {
                    var brows = blocks[i].childNodes;
                    for (var j = 0; j < brows.length; j++)
                        selected(brows[j], false);
                }
            };
            components[hdr.id] = new GridActioner(datasource, function(){
                var result = [];
                for (var i = 0; i < blocks.length; i++) {
                    var brows = blocks[i].childNodes;
                    for (var j = 0; j < brows.length; j++)
                        result.push(brows[j]);
                }
                return result;
            });
            var thisActiveRow = null;
            function activate(row) {
                var r = thisActiveRow !== row;
                if (r) {
                    thisActiveRow && active(thisActiveRow, false);
                    thisActiveRow = row;
                }
                thisActiveRow && active(thisActiveRow, true);
                return r;
            }
            function createBlock(offs, count) {
                var block = document.createElement('div');                
                block.className = 'stub';
                block.style.height = (count * BLOCK_LINE_HEIGHT) + 'px';
                var bcolchnos = [];
                block._colsChn = columnsChangeNo;
                block._opts = {
                    offset: offs,
                    count: count
                };
                block._stub = function() {
                    if (this.className === 'stub')
                        return;
                    if (this.childNodes.length)
                        this.style.height = this.scrollHeight + 'px';
                    else
                        this.style.height = (this._opts.count * BLOCK_LINE_HEIGHT) + 'px';
                    this.className = 'stub';
                };
                var executing = false;
                block._updateWithCursor = function(cursor, rcount, ridx) {
                    var rcnt = rcount - this._opts.offset;
                    if (rcnt > ROWS_PER_BLOCK)
                        rcnt = ROWS_PER_BLOCK;
                    this._cursor = cursor;
                    assert(rcnt > 0);
                    var needCount = rcnt;
                    if (this._colsChn !== columnsChangeNo)
                    {
                        this._colsChn = columnsChangeNo;
                        needCount = 0;
                    }
                    while (this.childNodes.length > needCount)
                        this.removeChild(this.lastChild);
                    while (this.childNodes.length < rcnt) {
                        var tr = document.createElement('div');
                        tr.className= 'row waiting';
                        tr._ridx = this.childNodes.length + this._opts.offset;
                        if (action)
                            tr.ondblclick = function(e) {
                                e = e || window.event;
                                e.stopPropagation ? e.stopPropagation() : (e.cancelBubble = true);
                                var act = action._action();
                                if (executing || !act)
                                    return;
                                executing = true;
                                block._cursor._ridx = this._ridx;
                                datasource._touch();
                                function always() { executing = false; }
                                act({event: e}).then(always, always);
                            };
                        var tr_tdclick = function() {
                            if (window.getSelection && !window.getSelection().isCollapsed)
                                return;
                            var row = this.parentNode;
                            activate(row);
                            block._cursor._ridx = row._ridx;
                            datasource._touch();
                        };
                        var tr_tdmousedown = function(e) {
                            e = e || window.event;
                            if (e.button === 0)
                                tr_tdclick.apply(this, arguments);
                        };
                        var ci = document.createElement('span');
                        ci.className = 'ci';
                        tr.appendChild(ci);
                        ci.onclick = function(e) {
                            e = e || window.event;
                            if (e.button === 0) {
                                selected(this.parentNode, !selected(this.parentNode));
                                if (!thisActiveRow || !selected(thisActiveRow))
                                    tr_tdclick.apply(this, arguments);
                            }
                        };
                        var veerBaseColId = -1;
                        for (var i = 1, l = columns.length; i < l; i++) {
                            var col = columns[i];
                            var td = document.createElement('span');
                            if (col.isveer) {
                                td.setAttribute("style", "display:none;");
                                veerBaseColId = col.id;
                            }
                            if (!col.keyValue)
                                td.className = 'c' + col.id;
                            else
                                td.className = 'c' + veerBaseColId;
                            tr.appendChild(td);
                            td.onclick = tr_tdclick;
                            td.onmousedown = tr_tdmousedown;
                            td._col = col;
                            if (col.action)
                                td.ondblclick = function(e) {
                                    e = e || window.event;
                                    e.stopPropagation ? e.stopPropagation() : (e.cancelBubble = true);
                                    var act = this._col.action._action();
                                    if (executing || !act)
                                        return;
                                    executing = true;
                                    block._cursor._ridx = tr._ridx;
                                    datasource._touch();
                                    function always() { executing = false; }
                                    act({event: e}).then(always, always);
                                };
                        }
                        this.appendChild(tr);
                    }
                    this._opts.count = rcnt;
                    Styles.removeClass(this, 'stub');
                    var ri = ridx - this._opts.offset;
                    if ((ri >= 0) && (ri < rcnt)) {
                        var r = this.childNodes[ri];
                        if (activate(r)) {
                            var rt = r.offsetTop, rb = rt + r.offsetHeight;
                            if (rb > gbody.clientHeight)
                                gbody.scrollTop = rb - gbody.clientHeight;
                            else if (rt < hgap.offsetHeight)
                                gbody.scrollTop = hgap.offsetHeight - rt;
                        }
                    }
                    this.style.height = '';
                    this._validateColumns(cursor);
                };
                block._hasInvalidColumns = function() {
                    for (var i = 0; i < columns.length; i++)
                        if (columns[i].changeno !== bcolchnos[i])
                            return true;
                    return false;
                };
                block._validateColumns = function(cursor) {
                    var ctx = DM.createCachedContext(), oks = [], ok = true;
                    for (var i = 0; i < columns.length; i++)
                        oks[i] = true;
                    
                    for (var i = 0; i < this.childNodes.length; i++) {
                        var tr = this.childNodes[i];
                        cursor._ridx = tr._ridx;
                        var row = cursor._row();
                        if (!row) {
                            Styles.addClass(tr, 'waiting');
                            ok = false;
                            continue;
                        }
                        Styles.removeClass(tr, 'waiting');
                        ctx.init(datasource, row);
                        
                        for (var ci = 0; ci < columns.length; ci++) {
                            var col = columns[ci];                            

                            if (col.changeno === bcolchnos[ci])
                                continue;
                            var cell = tr.childNodes[ci];
                            if (!cell)
                                continue;
                            if ((col.changeno === cell._chno)) 
                                continue;
                            if (!col.validate(ctx, cell)) {
                                Styles.addClass(cell, 'waiting');
                                oks[ci] = false;
                                continue;
                            }
                            Styles.removeClass(cell, 'waiting');
                            tr._needCalculateRowHeight = true;
                            cell._chno = col.changeno;
                        }
                    }
                    if (ok)
                        if (oks[i]){
                            bcolchnos[i] = columns[i].changeno;
                        }
                };
                block._calculateRowHeights = function(force) {
                    var rows = this.childNodes;
                    for (var i = 0; i < rows.length; i++) {
                        var row = rows[i];
                        if (!row._needCalculateRowHeight && !force)
                            continue;
                        row._needCalculateRowHeight = false;
                        var cells = row.childNodes;
                        var h = 0;
                        for (var j = 0; j < cells.length; j++)
                            h = Math.max(h, cells[j].scrollHeight);
                        h -= 2;//padding
                        if (row._height !== h) {
                            row._needApplyCalculatedRowHeight = true;
                            row._height = h;
                        }
                    }
                };
                block._applyCalculatedRowHeights = function() {
                    var rows = this.childNodes;
                    for (var i = 0; i < rows.length; i++) {
                        var row = rows[i];
                        if (!row._needApplyCalculatedRowHeight)
                            continue;
                        row._needApplyCalculatedRowHeight = false;
                        var cells = row.childNodes;
                        var h = rows[i]._height + 'px';
                        for (var j = 0; j < cells.length; j++)
                            cells[j].style.height = h;
                    }
                };
                return block;
            }
            function veerUpdate()
            {
                ++columnsChangeNo;
                for (var i = 0; i < columns.length; i++) {
                    if (columns[i].keyValue && columns[i].veerIndex){
                        var fup = (function(i) {
                            return function() {
                                columns[i] && columns[i].changeno++;
                                needValidateGrid = true;
                            };
                        })(i); 
                        fup(i);
                        gridVeerList.listenVeerData(fup, columns[i].veerIndex);
                    }
                }
                firstCalc = true;
                divgrid._wcl_calccache = undefined;
                divgrid._wcl_calculate();
                divgrid._wcl_invalidate && divgrid._wcl_invalidate();
                update();
            }
            function update() {
                rcount = undefined;
                var ok = true;
                if (datasource && !datasource._scan(function(cursor) {
                    rcount = cursor._rowsCount();
                    if (rcount === DM.fetchFPathValue.WAIT) {
                        ok = false;
                        return;
                    }
                    var ridx = cursor._ridx;
                    var bc = rcount ? (((rcount - 1) / ROWS_PER_BLOCK) | 0) + 1 : 0;
                    if (bc < blocks.length) {
                        for (var i = bc, l = blocks.length; i < l; i++)
                            gbody.removeChild(blocks[i]);
                        Arrays_shrink(blocks, bc);
                    }
                    if (bc !== 0) {
                        while (blocks.length < bc) {
                            var rc = blocks.length === (bc - 1) ? ((rcount - 1) % ROWS_PER_BLOCK) + 1 : ROWS_PER_BLOCK;
                            var block = createBlock(blocks.length * ROWS_PER_BLOCK, rc);
                            if (fgap)
                                gbody.insertBefore(block, fgap);
                            else
                            gbody.appendChild(block);
                            blocks.push(block);
                        }
                        var vb = visibleRange(blocks);
                        for (var i = vb[0]; i <= vb[1]; i++)
                        {
                            blocks[i]._updateWithCursor(cursor, rcount, ridx);
                        }
                        if (!thisActiveRow || (thisActiveRow._ridx !== ridx)) {
                            activate(null);
                            if (ridx >= 0) {
                                var bi = (ridx / ROWS_PER_BLOCK) | 0;
                                if ((bi < vb[0]) || (bi > vb[1])) {
                                    gbody.scrollTop = blocks[bi].offsetTop;
                                    needValidateGrid = true;
                                }
                            }
                        }
                        Styles.removeClass(gbody, 'empty');
                    } else
                        Styles.addClass(gbody, 'empty');
                }) || !ok)
                    Styles.addClass(gbody, 'waiting');
                else
                    Styles.removeClass(gbody, 'waiting');
            }
        divgrid._wcl_firstvalidate = function() {
            datasource && datasource._listen( update );
            function listenIfNotScroll( expr, func ) {
                var thisCursor = null, thisCursorChNo = 0;
                for ( var i in expr.dependencies ) {
                    var d = expr.dependencies[i];
                    if ( d === datasource )
                        d._listen( function( ds ) {
                            var cs = ds._cursor();
                            if ( !cs || (cs !== thisCursor) || (cs._changeno !== thisCursorChNo) ) {
                                thisCursor = cs;
                                thisCursorChNo = cs ? cs._changeno : 0;
                                func( ds );
                            }
                        } );
                    else
                        d._listen( func );
                }
            }
            for (var i = 0; i < columns.length; i++) {
                var fup = (function(i) {
                    return function() {
                        columns[i].changeno++;
                        needValidateGrid = true;
                    };
                })(i);
                var col = columns[i];
                col.expr && listenIfNotScroll( col.expr, fup );
                (col.type === DM.DataType.METATREE_NODE) && NodeInfo._listen( fup );
                col.exprColor && listenIfNotScroll( col.exprColor, fup );
                col.exprTextColor && listenIfNotScroll( col.exprTextColor, fup );
                col.exprTextStyle && listenIfNotScroll( col.exprTextStyle, fup );
            }
            update();
            if (ftr)
                WebGridCommon.initFooter(ftr.tFoot, datasources);
        };
    }
    function makePaging( element, components ) {
        var TWO_BORDER_WIDTHS = 2;
        var divgrid = element.parentNode;
        divgrid._wcl_calculate = function() {
            element.style.width = '';
            var o = {x:divgrid.style.width, y:divgrid.style.height};
            try {
            divgrid.style.width = '';
            divgrid.style.height = '';
            return {
                min: {
                    x: element.offsetWidth + TWO_BORDER_WIDTHS,
                    y: divgrid.offsetHeight
                },
                max: {
                    x: element.tHead.offsetWidth + TWO_BORDER_WIDTHS,
                    y: divgrid.offsetHeight
                }
            };
            } finally {
                divgrid.style.height = o.y;
                divgrid.style.width = o.x;
            }
        };
        Styles.addClass(divgrid, 'wcl-grid');
        var rctr = Wcl._mkRecter(divgrid);
        divgrid._wcl_validate = function(arg) {
            rctr(arg.rect);
        };
        function mkbtn( caption, onclick, title ) {
            var b = document.createElement( "button" );
            b.innerHTML = caption;
            b.onclick = onclick;
            b.title = title;
            return b;
        }
        var gdsid = Elements.dataset(element, 'datasource');
        if ( gdsid ) {
            var datasources = components.datamodel._datasources;
            var exprRowColor = Elements.dataset(element, 'color-expression');
            exprRowColor = exprRowColor && Expressions.make( exprRowColor, datasources );
            var exprRowTextColor = Elements.dataset(element, 'textcolor-expression');
            exprRowTextColor = exprRowTextColor && Expressions.make( exprRowTextColor, datasources );
            var exprRowTextStyle = Elements.dataset(element, 'textstyle-expression');
            exprRowTextStyle = exprRowTextStyle && Expressions.make( exprRowTextStyle, datasources );
            var datasource = datasources[gdsid];
            var action = Elements.dataset(element, 'action');
            if (action)
                action = new (F.ActionList)(action, components);
            var columns = [];
            var cols = element.getElementsByTagName('col');
            var colMap = getColMap(cols, divgrid.id);            
            for ( var i = 1; i < cols.length; i++ ) {
                var col = cols[i];
                if (col.getAttribute("isveer")) {
                    columns.push({
                        id: col.id,                    
                        type: 0,
                        expr: null,
                        fmt: null,
                        exprColor: null,
                        exprTextColor: null,
                        exprTextStyle: null,
                        isveer: true,
                        changeno: 0
                    });                    
                    continue;
                }
                var type = parseInt(Elements.dataset(col, 'datatype'));
                var dsid = Elements.dataset(col, 'datasource');
                var fid = Elements.dataset(col, 'datafield');
                var fp = null;
                if ( dsid && fid )
                    fp = DM.mkFieldPath( fid.split( ',' ), dsid || gdsid, datasources );
                var fmt = Elements.dataset(col, 'format');
                var expr = Elements.dataset(col, 'expression');
                if ( fmt ) {
                    var fmtopt = Elements.dataset(col, 'format-option');
                    fmt = Formats.byIdAndOption(fmt, fmtopt && Strings.base64_to_bytestr(fmtopt));
                    if ( !fmt )
                        col.style.color = 'red';
                }
                var exprColor = Elements.dataset(col, 'color-expression');
                var exprTextColor = Elements.dataset(col, 'textcolor-expression');
                var exprTextStyle = Elements.dataset(col, 'textstyle-expression');
                var colact = Elements.dataset(col, 'action');
                columns.push( {
                    id: col.id,                    
                    type: (type || (fp && fp[fp.length-1]._descriptor.type)) | 0,
                    expr: expr ? Expressions.make(expr, datasources, colMap, "data", []) : null,
                    fmt: fmt,
                    exprColor: exprColor ? Expressions.make(exprColor, datasources, colMap, "color", []) : null,
                    exprTextColor: exprTextColor ? Expressions.make(exprTextColor, datasources, colMap, "textColor", []) : null,
                    exprTextStyle: exprTextStyle ? Expressions.make(exprTextStyle, datasources, colMap, "textStyle", []) : null,
                    action: colact && new (F.ActionList)(colact, components),
                    changeno: 0
                } );
            }
            var offset = 0, pagesize = Elements.dataset(element, 'pagesize') | 0, rcount = Actioner.WAIT, pcount = Actioner.WAIT;
            var debug = document.createElement('div');
            debug.className = 'debug';
            debug.innerHTML = '@';
            divgrid.insertBefore(debug, element);
            debug.onclick = function() {
                showDebug( datasource, rcount );
            };
            var tbody = element.getElementsByTagName('tbody')[0];
            var tfoot = element.getElementsByTagName('thead')[0], tfc = tfoot.rows[0].cells[0];
            var dpagr = document.createElement( "span" );
            var bfrst, bprev, bnext, blast;
            dpagr.appendChild( bfrst = mkbtn( "&lt;&lt;", function() {
                offset = 0;
                update();
            }, " " ) );
            dpagr.appendChild( bprev = mkbtn( "&lt;", function() {
                offset = Math.max( 0, offset - 1 );
                update();
            }, " " ) );
            bfrst.disabled = bprev.disabled = true;
            bfrst.style.borderLeft = bprev.style.borderLeft = "none";
            var pags = document.createElement( "input" );
            pags.setAttribute("type", "number");//IE8
            pags.title = "   ";
            pags.style.borderRight = "1px solid #C0C0C0";
            pags.style.textAlign = "center";
            pags.value = pagesize;
            pags.onchange = function() {
                pagesize = Math.max(this.value, 1);
                if (rcount !== Actioner.WAIT)
                    pagesize = Math.min(pagesize, rcount);
                pagesize = Math.min(pagesize, 1000);
                this.value = pagesize;
                upgenrows();
                update();
            };
            dpagr.appendChild(pags);
            var indc = document.createElement( "input" );
            indc.setAttribute("type", "number");//IE8
            indc.onchange = function() {
                offset = Math.min(Math.max(this.value - 1, 0), pcount - 1);
                this.value = offset + 1;
                update();
            };
            dpagr.appendChild( indc );
            var pcnt = document.createElement( "span" );
            dpagr.appendChild( pcnt );
            indc.title = pcnt.title = " ";
            dpagr.appendChild( bnext = mkbtn( "&gt;", function() {
                offset++;
                update();
            }, " " ) );
            dpagr.appendChild( blast = mkbtn( "&gt;&gt;", function() {
                offset = pcount - 1;
                update();
            }, " " ) );
            blast.disabled = bnext.disabled = true;
            blast.style.borderRight = bnext.style.borderRight = "none";
            tfc.appendChild( dpagr );
            var gridWaiterTimeout = null;
            var thisCursor = null, thisCursorChNo = 0, thisOffset = 0, thisPagesize = pagesize, thisActiveRow = null, _fakeCell = null;
            var executing = false;
            function fakeCell() {
                if ( _fakeCell === null ) {
                    _fakeCell = document.createElement( "tr" ).insertCell();
                    _fakeCell.colSpan = columns.length + 1;
                    _fakeCell.className = "fake waiting";
                }
                return _fakeCell;
            }
            components[element.id] = new GridActioner(datasource, tbody.rows);
            function activate( row ) {
                thisActiveRow && active(thisActiveRow, false);
                thisActiveRow = row;
                thisActiveRow && active(thisActiveRow, true);
            }
            function upgenrows() {
            var trows = tbody.rows;
            while (trows.length > pagesize)
                tbody.removeChild( tbody.lastChild );
            while (trows.length < pagesize) {
                var tr = tbody.insertRow(trows.length);
                if (action)
                    tr.ondblclick = function(e) {
                        e = e || window.event;
                        e.stopPropagation ? e.stopPropagation() : (e.cancelBubble = true);
                        var act = action._action();
                        if (executing || !act)
                            return;
                        executing = true;
                        var row = this;
                        row._cursor._ridx = row._ridx;
                        datasource._touch();
                        function always() { executing = false; }
                        act({event: e}).then(always, always);
                    };
                var tr_tdclick = function() {
                    if (window.getSelection && !window.getSelection().isCollapsed)
                        return;
                    var row = this.parentNode;
                    activate(row);
                    row._cursor._ridx = row._ridx;
                    datasource._touch();
                };
                var tr_tdmousedown = function(e) {
                    e = e || window.event;
                    if (e.button === 0)
                        tr_tdclick.apply(this, arguments);
                };
                tr_td_dblclick = function(e) {
                    e = e || window.event;
                    e.stopPropagation ? e.stopPropagation() : (e.cancelBubble = true);
                    var act = this._col.action._action();
                    if (executing || !act)
                        return;
                    executing = true;
                    var row = this;
                    row._cursor._ridx = row._ridx;
                    datasource._touch();
                    function always() { executing = false; }
                    act({event: e}).then(always, always);
                };
                var ind = tr.insertCell(tr.cells.length);
                ind.className = "default-font ci";
                ind.onclick = function(e) {
                    e = e || window.event;
                    if (e.button === 0) {
                        selected(this.parentNode, !selected(this.parentNode));
                        if (!thisActiveRow || !selected(thisActiveRow))
                            tr_tdclick.apply(this, arguments);
                    }
                };
                for (var j = 0; j < columns.length; j++) {
                    var col = columns[j];
                    var td = tr.insertCell(tr.cells.length);
                    td.className = 'c' + col.id;
                    td.onclick = tr_tdclick;
                    td.onmousedown = tr_tdmousedown;
                    td._col = col;
                    if (td._col.action)
                        td.ondblclick = tr_td_dblclick;
                }
            }
            }
            upgenrows();
            function update() {
                var ok = true;
                if ( !datasource._scan( function( cursor ) {
                    var ridx= cursor._ridx;
                    var firstrow = offset * pagesize, lastrow = firstrow + pagesize;
                    bfrst.disabled = bprev.disabled = offset === 0;
                    var rebuild = !!gridWaiterTimeout || (thisCursor !== cursor) || (thisCursorChNo !== cursor._changeno) || (thisOffset !== offset) || (thisPagesize !== pagesize);
                    clearTimeout( gridWaiterTimeout );
                    gridWaiterTimeout = null;
                    var trows = tbody.rows;
                    if ( rebuild ) {
                        if ( (_fakeCell !== null) && (_fakeCell.parentNode.parentNode === tbody) )
                            tbody.removeChild( _fakeCell.parentNode );
                        thisCursor = cursor;
                        thisOffset = offset;
                        thisPagesize = pagesize;
                        tbody.className = "";
                        var ctx = DM.createCachedContext();
                        blast.disabled = bnext.disabled = false;
                        if ((rcount = cursor._rowsCount()) === Actioner.WAIT)
                            blast.disabled = true;
                        else {
                            pcount = (((rcount - 1) / pagesize) | 0) + 1;
                            pcnt.innerHTML = '/' + pcount;
                            offset = Math.min(offset, pcount - 1);
                            firstrow = offset * pagesize;
                            lastrow = firstrow + pagesize;
                        }
                        indc.value = offset+1;
                        for ( var i = 0; i < pagesize; i++ ) {
                            var _ridx = cursor._ridx = firstrow + i;
                            var crow = cursor._row();
                            if ( !crow ) {
                                if ( cursor._lost ) {
                                    var fc = fakeCell();
                                    fc.style.backgroundColor = "#FFFFDD";
                                    fc.innerHTML = "    -    ";
                                    tbody.insertBefore( fc.parentNode, trows[i] );
                                    var className = offset ? "hide" : "skip";
                                    while (i < trows.length)
                                        trows[i++].className = className;
                                    break;
                                }
                                if ( crow === undefined ) {//end of cursor
                                    blast.disabled = bnext.disabled = true;
                                    if ( cursor._lmax ) {
                                        var fc = fakeCell();
                                        fc.style.backgroundColor = "#FFDDDD";
                                        fc.innerHTML = "     ";
                                        tbody.insertBefore( fc.parentNode, trows[i] );
                                        trows[i++].className = "hide";
                                    }
                                    var className = offset ? "hide" : "skip";
                                    while (i < trows.length)
                                        trows[i++].className = className;
                                    break;
                                }
                                ok = false;
                                continue;
                            }
                            ctx.init( datasource, crow );
                            var row = trows[i];
                            row.className = "";
                            row._ridx = _ridx;
                            row._crow = crow;
                            row._cursor = cursor;
                            if ( !(v = fetchOptional( {
                                rc: exprRowColor,
                                tc: exprRowTextColor,
                                ts: exprRowTextStyle
                            }, ctx )) ) {
                                ok = false;
                                continue;
                            }
                            row.style.backgroundColor = F.color2hex( v.rc );
                            row.style.color = F.color2hex( v.tc );
                            F.assignTextStyle( row.style, v.ts );
                            for ( var j = 0; j < columns.length; j++ ) {
                                var cell = row.cells[j+1], col = columns[j];
                                var v;
                                if ( !(v = fetchOptional( {
                                    bc: col.exprColor,
                                    tc: col.exprTextColor,
                                    ts: col.exprTextStyle
                                }, ctx )) ) {
                                    ok = false;
                                    continue;
                                }
                                cell.style.backgroundColor = F.color2hex( v.bc );
                                cell.style.color = F.color2hex( v.tc );
                                F.assignTextStyle( cell.style, v.ts );
                                var v = undefined;
                                if (col.expr)
                                    v = col.expr.evaluate(ctx);
                                if ( v === Expressions.WAIT ) {
                                    ok = false;
                                    continue;
                                }
                                if ( v === Expressions.NVAL )
                                    v = undefined;
                                if ( !F.formatCellValue( cell, v, col.type, col.fmt, col.expr ) ) {
                                    ok = false;
                                    continue;
                                }
                            }
                        }
                        if ( !ok )
                            return;
                        thisCursorChNo = cursor._changeno;
                    }
                    if ( thisActiveRow ) {
                        active(thisActiveRow, false);
                        thisActiveRow = null;
                    }
                    if ( (ridx >= firstrow) && (ridx < lastrow) )
                        activate( trows[ridx - firstrow] );
                    divgrid._wcl_invalidate && divgrid._wcl_invalidate();
                } ) || !ok ) {
                    if ( !gridWaiterTimeout )
                        gridWaiterTimeout = setTimeout( function() {
                            if ( !gridWaiterTimeout )//IE8 bug
                                return;
                            Styles.addClass(tbody, 'waiting');
                        }, 250 );
                } else
                    Styles.removeClass(tbody, 'waiting');
            }
            divgrid._wcl_firstvalidate = function() {
            datasource._listen( update );
            function listenIfNotScroll( expr, func ) {
                for ( var i in expr.dependencies ) {
                    var d = expr.dependencies[i];
                    if ( d === datasource )
                        d._listen( function( ds ) {
                            var cs = ds._cursor();
                            if ( !cs || (cs !== thisCursor) || (cs._changeno !== thisCursorChNo) )
                                func( ds );
                        } );
                    else
                        d._listen( func );
                }
            }
            for ( var ci in columns ) {
                var col = columns[ci];
                col.expr && listenIfNotScroll( col.expr, update );
                (col.type === DM.DataType.METATREE_NODE) && NodeInfo._listen( update );
                col.exprColor && listenIfNotScroll( col.exprColor, update );
                col.exprTextColor && listenIfNotScroll( col.exprTextColor, update );
                col.exprTextStyle && listenIfNotScroll( col.exprTextStyle, update );
            }
            exprRowColor && listenIfNotScroll( exprRowColor, update );
            exprRowTextColor && listenIfNotScroll( exprRowTextColor, update );
            exprRowTextStyle && listenIfNotScroll( exprRowTextStyle, update );
            update();
            };
        }
    }
    return {
        WclControl: function(parent, container, arg) {
            var grid = arg.item;
            container.appendChild(grid);
            grid._minh = arg.minh && (arg.minh * Theme.LINECONTROL_HEIGHT - 2);
            if(grid._minh < 0)
                grid._minh = 0;
            grid._maxh = arg.maxh && (arg.maxh * Theme.LINECONTROL_HEIGHT - 2);
            if(grid._maxh < 0)
                grid._maxh = 0;
            this.flowType = arg.flowType||0;
            this.calculate = function() {
                return grid._wcl_calculate();
            };
            this.validate = function(arg) {
                var fv = grid._wcl_firstvalidate;
                if (fv) {
                    fv();
                    grid._wcl_firstvalidate = undefined;
                }
                grid._wcl_validate(arg);
            };
            grid._wcl_invalidate = function() {
                grid._wcl_calccache = undefined;
                parent.invalidate();
            };
            grid._soft_invalidate = function() {
                parent.invalidate();
            };
        },
        initialization: function(root, components) {
            root.find('div.gbody').each(function() {
                makeScrolled(this, components);
            } );
            root.find('table.grid.paging').each(function() {
                makePaging( this, components );
            } );
        }
    };
} );
