﻿define(["require", "exports", '../Styles', '../Expressions', './Datamodel', './WebForm', './Formats', '../utils/Strings', 'css!inform.agent.web.forms.WebGridCommon'], function (require, exports, Styles_1, Expressions, DM, F, Formats, Strings_1) {
    "use strict";
    var Column = (function () {
        function Column(id) {
            this.id = id;
        }
        return Column;
    }());
    exports.Column = Column;
    function initColumns(table, sheet, columnFactory) {
        var result = [];
        var ths = table.getElementsByTagName('th');
        for (var i = 0, l = ths.length; i < l; ++i) {
            var th = ths[i], id = Elements.dataset(th, 'colid');
            if (!id)
                continue;
            var col = columnFactory(th);
            if (!col)
                continue;
            col.header = th;
            col.rule = sheet.rule('.grid[id="' + table.id + '"] .c' + id);
            result.push(col);
        }
        return result;
    }
    exports.initColumns = initColumns;
    function initFooter(footer, datasources) {
        function tryup(expr, cell, dt, fmt) {
            var v = expr.evaluate(DM.DefaultContext);
            if (v === Expressions.WAIT)
                return false;
            if (v === Expressions.NVAL)
                v = undefined;
            return F.formatCellValue(cell, v, dt, fmt, expr);
        }
        function setlistener(expr, cell) {
            var fmt_str = Elements.dataset(cell, 'format');
            var fmt = undefined;
            if (fmt_str) {
                var fmtopt = Elements.dataset(cell, 'format-option');
                fmt = Formats.byIdAndOption(Number(fmt_str), fmtopt && Strings_1.base64_to_bytestr(fmtopt));
            }
            var dt = Number(Elements.dataset(cell, 'datatype') || '0');
            function update() {
                if (tryup(expr, cell, dt, fmt))
                    Styles_1.removeClass(cell, 'waiting');
                else
                    Styles_1.addClass(cell, 'waiting');
            }
            expr._listen(update);
            update();
        }
        var tds = footer.getElementsByTagName('td');
        for (var i = 0, l = tds.length; i < l; ++i) {
            var td = tds[i], expr_str = Elements.dataset(td, 'expression');
            if (!expr_str)
                continue;
            var expr = Expressions.make(expr_str, datasources);
            setlistener(expr, td);
        }
    }
    exports.initFooter = initFooter;
});
