/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;

public class GML2 {
    protected static Connection _conn;
    protected static String _srsNameSpace;
    protected static String _srsAlias;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static void setsrsAlias(String string) {
        _srsAlias = string;
    }

    protected void CCWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + "," + d3 + " " + d2 + "," + d3 + " " + d2 + "," + d4 + " " + d + "," + d4 + " " + d + "," + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            stringBuffer.append(d + "," + d3 + "," + d5 + " " + d2 + "," + d3 + "," + d5 + " " + d2 + "," + d4 + "," + d5 + " " + d + "," + d4 + "," + d5 + " " + d + "," + d3 + "," + d5 + " ");
        }
    }

    protected void CWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + "," + d3 + " " + d + "," + d4 + " " + d2 + "," + d4 + " " + d2 + "," + d3 + " " + d + "," + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            stringBuffer.append(d + "," + d3 + "," + d5 + " " + d + "," + d4 + "," + d5 + " " + d2 + "," + d4 + "," + d5 + " " + d2 + "," + d3 + "," + d5 + " " + d + "," + d3 + "," + d5 + " ");
        }
    }

    protected void outputCoordinates(int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) throws IOException {
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(dArray[n3 + (i - 1) * n] + "," + dArray[n3 + (i - 1) * n + 1]);
            if (n == 3) {
                stringBuffer.append("," + dArray[n3 + (i - 1) * n + 2]);
            }
            stringBuffer.append(" ");
        }
    }

    public boolean geometryHasArcs(JGeometry jGeometry) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 2] == 2 && nArray[3 * i + 1] % 10 > 1) {
                bl = true;
                continue;
            }
            if (nArray[3 * i + 1] % 10 == 3 && nArray[3 * i + 2] == 4) {
                bl = true;
                continue;
            }
            if (nArray[3 * i + 1] % 10 <= 3) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean geometryHasEtypeZero(JGeometry jGeometry) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 1] % 10 != 0) continue;
            bl = true;
        }
        return bl;
    }

    protected void toGML(JGeometry jGeometry, StringBuffer stringBuffer) throws SQLException, IOException, DataException {
        String string;
        AutoCloseable autoCloseable;
        double[] dArray;
        int[] nArray;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        String string2 = "Unknown";
        int n3 = 0;
        int n4 = 0;
        String string3 = "<gml:coordinates decimal=\".\" cs=\",\" ts=\" \">";
        String string4 = "</gml:coordinates>";
        String string5 = "<gml:geometryMember>";
        String string6 = "</gml:geometryMember>";
        String string7 = "<gml:pointMember>";
        String string8 = "</gml:pointMember>";
        String string9 = "<gml:lineStringMember>";
        String string10 = "</gml:lineStringMember>";
        String string11 = "<gml:polygonMember>";
        String string12 = "</gml:polygonMember>";
        String string13 = "<gml:outerBoundaryIs>";
        String string14 = "</gml:outerBoundaryIs>";
        String string15 = "<gml:innerBoundaryIs>";
        String string16 = "</gml:innerBoundaryIs>";
        String string17 = "<gml:LinearRing>";
        String string18 = "</gml:LinearRing>";
        String string19 = "";
        String string20 = "";
        if (jGeometry == null) {
            throw new DataException("NULL Geometry ");
        }
        if (this.geometryHasArcs(jGeometry)) {
            throw new DataException("Arcs are  not supported in GML");
        }
        if (this.geometryHasEtypeZero(jGeometry)) {
            throw new DataException("Etype zero not supported in GML");
        }
        if (jGeometry.isLRSGeometry()) {
            throw new DataException("LRS  not supported in GML");
        }
        int n5 = jGeometry.getType();
        int n6 = jGeometry.getSRID();
        n2 = jGeometry.getDimensions();
        if (n2 == 0) {
            n2 = 2;
        }
        if ((nArray = jGeometry.getElemInfo()) != null) {
            n = nArray.length / 3;
        }
        if ((dArray = jGeometry.getOrdinatesArray()) != null) {
            n4 = dArray.length / n2;
        }
        if (n5 == 1) {
            string2 = "Point";
            if (nArray != null && nArray[2] > 1) {
                string2 = "MultiPoint";
                n5 = 5;
            }
        } else if (n5 == 2) {
            string2 = "LineString";
        } else if (n5 == 3) {
            string2 = "Polygon";
            if (n == 1) {
                if (nArray != null && nArray[1] % 10 == 3 && nArray[2] == 3) {
                    string2 = "Box";
                } else {
                    string19 = string13 + string17;
                    string20 = string18 + string14;
                }
            }
        } else if (n5 == 4) {
            string2 = "MultiGeometry";
        } else if (n5 == 5) {
            string2 = "MultiPoint";
        } else if (n5 == 6) {
            string2 = "MultiLineString";
        } else if (n5 == 7) {
            string2 = "MultiPolygon";
        }
        if (n6 == 0) {
            stringBuffer.append("<gml:" + string2 + " srsName=\"SDO:\" xmlns:gml=\"http://www.opengis.net/gml\">");
        } else if (_srsNameSpace == null) {
            stringBuffer.append("<gml:" + string2 + " srsName=\"SDO:" + n6 + "\" xmlns:gml=\"http://www.opengis.net/gml\">");
        } else {
            if (_conn == null) {
                throw new DataException("GML Converter needs a valid connection and SrsNameSpace");
            }
            String string21 = " select srsname   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and sdo_srid = ? ";
            PreparedStatement preparedStatement = _conn.prepareStatement(string21);
            preparedStatement.setString(1, _srsNameSpace);
            preparedStatement.setInt(2, n6);
            autoCloseable = preparedStatement.executeQuery();
            if (!autoCloseable.next()) {
                throw new DataException("GML has unregistered SrsNameSpace/SrsName");
            }
            string = autoCloseable.getString("srsname");
            stringBuffer.append("<gml:" + string2 + " srsName='" + _srsAlias + ":" + string + "'" + " xmlns:gml=\"http://www.opengis.net/gml" + "\" xmlns:" + _srsAlias + "=\"" + _srsNameSpace + "\" >");
        }
        if (n5 == 1) {
            double[] dArray2 = jGeometry.getPoint();
            if (dArray2 != null) {
                n2 = dArray2.length;
                stringBuffer.append(string3);
                this.outputCoordinates(n2, 1, dArray2, 0, stringBuffer);
                stringBuffer.append(string4 + "</gml:" + string2 + ">");
            }
        } else if (n5 < 3 && dArray != null) {
            stringBuffer.append(string3);
            this.outputCoordinates(n2, n4, dArray, 0, stringBuffer);
            stringBuffer.append(string4 + "</gml:" + string2 + ">");
        } else if (n5 == 3 && n == 1) {
            stringBuffer.append(string19 + string3);
            this.outputCoordinates(n2, n4, dArray, 0, stringBuffer);
            stringBuffer.append(string4 + string20 + "</gml:" + string2 + ">");
        } else if (n5 == 3 && n > 1) {
            n4 = (nArray[3] - nArray[0]) / n2;
            stringBuffer.append(string13 + string17 + string3);
            n3 = 0;
            if (nArray[2] == 3) {
                this.CCWOutputRectangle(n2, dArray, n3, stringBuffer);
            } else {
                this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
            }
            stringBuffer.append(string4 + string18 + string14);
            for (int i = 2; i <= n; ++i) {
                stringBuffer.append(string15 + string17 + string3);
                n4 = i == n ? (dArray.length - nArray[3 * (i - 1)] + 1) / n2 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n2;
                n3 = nArray[3 * (i - 1)] - 1;
                if (nArray[3 * (i - 1) + 2] == 3) {
                    this.CWOutputRectangle(n2, dArray, n3, stringBuffer);
                } else {
                    this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                }
                stringBuffer.append(string4 + string18 + string16);
            }
            stringBuffer.append("</gml:" + string2 + ">");
        } else if (n5 == 4) {
            int n7;
            int n8 = 0;
            for (n7 = 0; n7 < n; ++n7) {
                int n9 = nArray[3 * n7 + 1];
                if (n9 != 1003 && n9 != 1 && n9 != 2) continue;
                ++n8;
            }
            if (n8 > 0) {
                for (n7 = 1; n7 <= n8; ++n7) {
                    stringBuffer.append(string5);
                    autoCloseable = _conn.prepareCall("{ ? = call mdsys.sdo_util.extract(?, ?)}");
                    autoCloseable.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                    autoCloseable.setObject(2, JGeometry.store((JGeometry)jGeometry, (Connection)_conn));
                    autoCloseable.setInt(3, n7);
                    autoCloseable.execute();
                    string = (STRUCT)autoCloseable.getObject(1);
                    JGeometry jGeometry2 = JGeometry.load((STRUCT)string);
                    this.toGML(jGeometry2, stringBuffer);
                    autoCloseable.close();
                    stringBuffer.append(string6);
                }
            }
            stringBuffer.append("</gml:" + string2 + ">");
        } else if (n5 == 5) {
            if (n == 1 && nArray[2] > 1) {
                n4 = nArray[2];
            } else if (n > 1) {
                n4 = n;
            }
            for (int i = 1; i <= n4; ++i) {
                n3 = n2 * (i - 1);
                if (nArray.length >= n3 + 2 && nArray[n3 + 2] == 0) continue;
                stringBuffer.append(string7 + "<gml:Point>" + string3);
                this.outputCoordinates(n2, 1, dArray, n3, stringBuffer);
                stringBuffer.append(string4 + "</gml:Point>" + string8);
            }
            stringBuffer.append("</gml:" + string2 + ">");
        } else if (n5 == 6) {
            for (int i = 1; i <= n; ++i) {
                stringBuffer.append(string9 + "<gml:LineString>" + string3);
                n4 = i == n ? (dArray.length - nArray[3 * (i - 1)] + 1) / n2 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n2;
                n3 = nArray[3 * (i - 1)] - 1;
                this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                stringBuffer.append(string4 + "</gml:LineString>" + string10);
            }
            stringBuffer.append("</gml:" + string2 + ">");
        } else if (n5 == 7) {
            boolean bl2 = true;
            for (int i = 1; i <= n; ++i) {
                boolean bl3;
                n4 = i == n ? (dArray.length - nArray[3 * (i - 1)] + 1) / n2 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n2;
                n3 = nArray[3 * (i - 1)] - 1;
                boolean bl4 = bl3 = nArray[3 * (i - 1) + 2] == 3;
                if (bl2) {
                    stringBuffer.append(string11 + "<gml:Polygon>" + string13 + string17 + string3);
                    if (bl3) {
                        this.CCWOutputRectangle(n2, dArray, n3, stringBuffer);
                    } else {
                        this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                    }
                    stringBuffer.append(string4 + string18 + string14);
                } else {
                    stringBuffer.append(string15 + string17 + string3);
                    if (bl3) {
                        this.CWOutputRectangle(n2, dArray, n3, stringBuffer);
                    } else {
                        this.outputCoordinates(n2, n4, dArray, n3, stringBuffer);
                    }
                    stringBuffer.append(string4 + string18 + string16);
                }
                if (i == n) {
                    stringBuffer.append("</gml:Polygon>" + string12);
                    continue;
                }
                if (nArray[3 * i + 1] == 2003) {
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                stringBuffer.append("</gml:Polygon>" + string12);
            }
            stringBuffer.append("</gml:" + string2 + ">");
        }
    }

    public static CLOB to_GMLGeometryCLOB(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML2.to_GMLGeometry(sTRUCT);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return cLOB;
    }

    public static String to_GMLGeometry(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        GML2.setsrsNameSpace(string);
        GML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        String string3 = GML2.to_GMLGeometry(sTRUCT);
        GML2.setsrsNameSpace(null);
        GML2.setsrsAlias(null);
        return string3;
    }

    public static String to_GMLGeometry(STRUCT sTRUCT) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML2.to_GMLGeometry(jGeometry);
    }

    public static CLOB to_GMLGeometryCLOB(STRUCT sTRUCT) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML2.to_GMLGeometry(sTRUCT);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static String to_GMLGeometry(JGeometry jGeometry) throws SQLException, IOException {
        GML2 gML2 = new GML2();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            gML2.toGML(jGeometry, stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        _srsAlias = "Non-SDO";
    }
}

