/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

abstract class AbstractList {
    protected int capacity;
    protected int size;

    public AbstractList(int initialCapacity) {
        this.capacity = initialCapacity;
    }

    public int size() {
        return this.size;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    protected void upgrow() {
        if (this.size < this.capacity) {
            return;
        }
        this.capacity = (this.capacity + 1) * 3 / 2;
        this.grow();
    }

    protected abstract void grow();

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                result.append(',');
            }
            if (i >= 32) {
                result.append("...");
                break;
            }
            this.itemToString(i, result);
        }
        result.append(']');
        return result.toString();
    }

    protected abstract void itemToString(int var1, StringBuilder var2);
}

