/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.taggedio.TaggedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    private Charset utf16 = null;

    public LittleEndianDataOutputStream(OutputStream stream) {
        super(stream);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(v & 0xFF);
        this.write((v & 0xFF00) >> 8);
    }

    @Override
    public void writeChar(int v) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.write(v & 0xFF);
        this.write((v & 0xFF00) >> 8);
        this.write((v & 0xFF0000) >> 16);
        this.write((v & 0xFF000000) >> 24);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeInt((int)v);
        this.writeInt((int)(v >> 32));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (this.utf16 == null) {
            this.utf16 = Charset.forName("UTF-16LE");
        }
        this.write(s.getBytes(this.utf16));
    }

    public void writeUTF8(String s) throws IOException {
        this.write(s.getBytes(TaggedWriter.UTF8));
    }

    public void writeUnsignedInt(long v) throws IOException {
        this.write((int)(v & 0xFFL));
        this.write((int)(v >> 8 & 0xFFL));
        this.write((int)(v >> 16 & 0xFFL));
        this.write((int)(v >> 24 & 0xFFL));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public static abstract class With {
        public abstract void write(DataOutput var1) throws Throwable;

        public static final byte[] toBytes(With writer) throws Throwable {
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
            LittleEndianDataOutputStream datastream = new LittleEndianDataOutputStream(bytestream);
            writer.write(datastream);
            datastream.flush();
            return bytestream.toByteArray();
        }
    }
}

