/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.InformException;
import java.io.File;
import java.security.CodeSource;

public class AgentJARVersion {
    public static final int MAJOR;
    public static final int MINOR;
    public static final int RELEASE;
    public static final int UPDATE;
    public static final String CHANNEL;
    public static final long BUILD_DATE;
    public static final String ETAG;

    private static long getLastModified() throws Throwable {
        CodeSource codeSource = AgentJARVersion.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return 0L;
        }
        File file = new File(codeSource.getLocation().toURI());
        return file.lastModified();
    }

    public static String asString() {
        return String.format("%d.%d.%d%s%d", MAJOR, MINOR, RELEASE, CHANNEL, UPDATE);
    }

    static {
        try {
            Package pkg = AgentJARVersion.class.getPackage();
            if (pkg == null) {
                throw new InformException("AgentJARVersion doesn't contain Package");
            }
            String iv = pkg.getImplementationVersion();
            if (iv == null) {
                throw new InformException("agent.jar doesn't have implementation version");
            }
            String[] sp = iv.split("\\.");
            MAJOR = Integer.valueOf(sp[0]);
            MINOR = Integer.valueOf(sp[1]);
            RELEASE = Integer.valueOf(sp[2]);
            UPDATE = Integer.valueOf(sp[3]);
            CHANNEL = sp[4];
            BUILD_DATE = AgentJARVersion.getLastModified();
            ETAG = MAJOR + "." + MINOR + "." + RELEASE + CHANNEL + UPDATE + "_" + BUILD_DATE;
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
    }
}

