/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.collections.DoubleHash;
import inform.common.SmartScriptableObject;

public class DatasourceStatistics
extends SmartScriptableObject
implements DoubleHash.Entry {
    private final double key;
    private int sqlCount = 0;
    private long sqlTime = 0L;
    private int sqlRowsFetched = 0;
    private boolean logged = false;
    private String log = "";

    public DatasourceStatistics(double key, boolean logged) {
        this.key = key;
        this.logged = logged;
    }

    public synchronized void addSQLCount(int count) {
        this.sqlCount += count;
    }

    public synchronized void addSQLTime(long duration) {
        this.sqlTime += duration;
    }

    public synchronized void addSQLRowsFetched(int count) {
        this.sqlRowsFetched += count;
    }

    @SmartScriptableObject.FunctionTag
    public synchronized int getCount() {
        return this.sqlCount;
    }

    @SmartScriptableObject.FunctionTag
    public synchronized long getTime() {
        return this.sqlTime;
    }

    @SmartScriptableObject.FunctionTag
    public synchronized int getRowsFetched() {
        return this.sqlRowsFetched;
    }

    public void pushLog(String text) {
        this.log = this.log + text + "\n\n";
    }

    @SmartScriptableObject.FunctionTag
    public String getSummaries() {
        if (this.logged) {
            return this.log;
        }
        return String.format("Time (ms) = %d\nNumber of SQLs = %d\nRows fetched = %d\n", this.getTime(), this.getCount(), this.getRowsFetched());
    }

    @Override
    public double key() {
        return this.key;
    }
}

