/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.ObjectSizer;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActionHooks;
import inform.agent.CancelRequestException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.InputChunkQueue;
import inform.agent.LogContext;
import inform.agent.PhaThread;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestProfile;
import inform.agent.RequestStatistics;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.am.Telemeter;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Client;
import inform.agent.net.RequestExecutor;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import inform.common.Empty;
import inform.common.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.Future;
import org.slf4j.impl.AsmoLogger;

public abstract class Request
implements ServerSideHost,
Runnable,
LogContext,
IntegerHash.Entry {
    public static final int TAG_REQUEST_STATE_CAPTION = 1;
    public static final int TAG_REQUEST_STATE_TEXT = 2;
    public static final int TAG_REQUEST_STATE_LOG = 3;
    public static final int TAG_REQUEST_STATE_PROGRESS_MIN = 4;
    public static final int TAG_REQUEST_STATE_PROGRESS_MAX = 5;
    public static final int TAG_REQUEST_STATE_PROGRESS_POSITION = 6;
    public static final int TAG_REQUEST_STATE_PROGRESS_VISIBLE = 7;
    public static final int TAG_REQUEST_STATE_INSTRUCTION_TEXT = 8;
    public static final int TAG_LOG_TEXT = 9;
    public static final int TAG_LOG_LINE = 10;
    public static final int TAG_REQUEST_STATE_ENTER = 11;
    public static final int TAG_REQUEST_STATE_LEAVE = 12;
    public static final int TAG_REQUEST_PROFILE = 13;
    public static final int TAG_REQUEST_STATE_SYSLOG_INFO = 14;
    public static final int TAG_REQUEST_STATE_TRACE_LABEL = 15;
    public static final int TAG_REQUEST_STATE_RESULT_TEXT = 16;
    public static final int TAG_REQUEST_STATE_TRACE_LABEL_CONTEXT = 1;
    public static final int TAG_REQUEST_STATE_TRACE_LABEL_TEXT = 2;
    public static final int RQS_CREATING = 0;
    public static final int RQS_READING = 1;
    public static final int RQS_POOLING = 2;
    public static final int RQS_STARTING = 3;
    public static final int RQS_RUNNING = 4;
    public static final int RQS_COMPLETING = 5;
    public static final int RQS_DISPOSING = 6;
    public static final int RQS_DISPOSED = 7;
    public final RequestDuration duration;
    private long outChunkSize = 0L;
    @ObjectSizer.HintShared
    private Future<?> future = null;
    @ObjectSizer.HintShared
    protected final RequestHeader rq;
    @ObjectSizer.HintShared
    private final Client client;
    private volatile boolean canceled;
    private String cancelReason;
    private final RequestProfile profile;
    private byte[] requestContent;
    private byte[] requestExtraParams;
    private boolean isResultSended = false;
    private final long hostId = Core.newHostID();
    @ObjectSizer.HintShared
    private volatile Thread thread;
    private InputChunkQueue inputChunkQueue = null;
    private volatile int state = 0;
    private int pulse;
    private final int taskId = Telemeter.genId();
    private final long created;
    private long lastHangCallstackTime = this.created = System.currentTimeMillis();
    private final AsmoLogger.Level longRequestLevel;
    private boolean cancelThrowed;
    protected RequestStatistics.Value rqstat;
    private int lastLoggedState = -1;
    protected final SSContext.Request ssContext;
    private volatile int vlongOpDepth;

    public Request(RequestHeader rq, RequestDuration duration) {
        this(rq, duration, AsmoLogger.Level.WARN);
    }

    public Request(RequestHeader rq, RequestDuration duration, AsmoLogger.Level longRequestLevel) {
        this.ssContext = new SSContext.Request(rq);
        this.rq = rq;
        this.duration = duration;
        this.client = rq.client;
        this.canceled = false;
        this.profile = new RequestProfile();
        this.profile.tp_receivedNano = Core.nanoClock();
        this.requestContent = Empty.byteArray;
        this.requestExtraParams = Empty.byteArray;
        this.longRequestLevel = longRequestLevel;
    }

    public synchronized void traceLog() {
        Core.logger.info("[RUNNING REQUEST] id {} rq {} node {} time {}", this.rq.id, this.rq.request, NumberConverter.doubleToString(this.rq.nodeId), (Core.nanoClock() - this.profile.tp_start_processingNano) / 1000000L);
    }

    public synchronized Future<?> getFuture() {
        return this.future;
    }

    public synchronized void setFuture(Future<?> future) {
        this.future = future;
    }

    public int getID() {
        return this.rq.id;
    }

    public int getTypeID() {
        return this.rq.request;
    }

    public RequestHeader getRequestHeader() {
        return this.rq;
    }

    @Override
    public long getHostID() {
        return this.hostId;
    }

    @Override
    public String toLogString() {
        return this.toString();
    }

    @Override
    public synchronized boolean isCancelled() {
        if (this.future != null && this.future.isCancelled() && !this.canceled) {
            this.cancelRun(null);
        } else if (this.canceled && this.future != null) {
            this.future.cancel(true);
        }
        return this.canceled;
    }

    @Override
    public final synchronized String getCancelReason() {
        return this.cancelReason;
    }

    protected void throwNodeAccessDenied(double id, int permissions) throws InformException {
        throw new InformException(AccessMask.deniedMessage(permissions) + " \u044d\u0442\u043e\u0433\u043e \u0443\u0437\u043b\u0430").detail(String.format("Access denied NodeID: %.0f, requested permissions: %08x", id, permissions));
    }

    protected final void checkAccess(Node node, int permissions) throws InformException {
        int mask = this.security().accessMask(node);
        if ((mask & permissions) != permissions) {
            this.throwNodeAccessDenied(node.getId(), permissions);
        }
        this.idle();
    }

    protected void checkNodeAccess(Node node, int permission, String message) throws InformException {
        if (AccessMask.accessDenied(permission, this.security().accessMask(node))) {
            StringBuilder msg = new StringBuilder();
            msg.append(message);
            MtdEngine.appendNodeNameForLog(msg, node.getId());
            throw new InformException(msg.toString());
        }
        this.idle();
    }

    protected void checkRequestAccess(Node node, int permissions) throws InformException {
        this.checkNodeAccess(node, permissions, "\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0443\u0437\u043b\u0443");
    }

    public abstract void execute() throws Throwable;

    protected final boolean analyzeThrowable(Throwable ex, AnalyzeThrowable analyze) {
        boolean interrupt = false;
        for (Throwable t = ex; t != null; t = t.getCause()) {
            if (t instanceof CancelRequestException) {
                interrupt = true;
                break;
            }
            if (!(t instanceof InterruptedException)) continue;
            interrupt = true;
            break;
        }
        analyze.message = ex.getMessage();
        StringBuilder detailing = new StringBuilder();
        StringBuilder callstack = new StringBuilder();
        if (interrupt) {
            Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u043e rq: {}", (Object)this.rq.request);
        } else {
            Core.logger.error("java exception rq: {} u: {} node: {}", new Object[]{this.getTypeID(), NumberConverter.doubleToString(this.client.getUserId()), NumberConverter.doubleToString(this.rq.nodeId), ex});
            analyze.message = Exceptions.toString(ex, detailing, callstack);
        }
        detailing.append((CharSequence)callstack);
        analyze.detailing = detailing.toString();
        return interrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            Request startExecuteTime23332;
            this.setState(3);
            this.profile.tp_start_processingNano = Core.nanoClock();
            RequestExecutor.requestStarted(this, (this.profile.tp_start_processingNano - this.profile.tp_receivedNano) / 1000000L);
            if (this.isCancelled()) {
                return;
            }
            this.rqstat = RequestStatistics.THREAD_VALUE();
            this.rqstat.reset(this.rq.request, this.client.getUserId(), this.rq.nodeId);
            this.rqstat.rqReadingTime = (this.profile.tp_pooledNano - this.profile.tp_receivedNano) / 1000000L;
            this.rqstat.rqPoolingTime = (this.profile.tp_start_processingNano - this.profile.tp_pooledNano) / 1000000L;
            LogContext.CURRENT.set(this);
            try {
                this.thread = Thread.currentThread();
                if (Ini.verbose) {
                    this.tryLogRqState(true);
                }
                this.setState(4);
                long startExecuteTime23332 = System.currentTimeMillis();
                this.execute();
                long endExecuteTime = System.currentTimeMillis();
                long executeTime = endExecuteTime - startExecuteTime23332;
                if (this.duration.duration() < executeTime) {
                    Core.logger.log(AsmoLogger.Level.WARN, "! \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 " + executeTime / 1000L + "." + executeTime % 1000L + " \u0441\u0435\u043a\u0443\u043d\u0434", null, this);
                }
                this.setState(5);
                if (!this.isResultSended) {
                    this.sendResult();
                }
                if (this.canceled) {
                    Core.logger.info("request cancel done");
                }
                startExecuteTime23332 = this;
            }
            catch (Throwable ex2222) {
                try {
                    try {
                        AnalyzeThrowable analyze = new AnalyzeThrowable();
                        boolean interrupt = this.analyzeThrowable(ex2222, analyze);
                        this.sendError(analyze.message, null, analyze.detailing);
                        return;
                    }
                    catch (Throwable t) {
                        Core.logger.error(null, t);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (this.canceled) {
                        Core.logger.info("request cancel done");
                    }
                    Request ex2222 = this;
                    synchronized (ex2222) {
                        this.thread = null;
                    }
                    try {
                        this.setState(6);
                        this.client.disposeRequest(this);
                    }
                    catch (Throwable e) {
                        Core.logger.error(null, e);
                    }
                    this.setState(7);
                    if (this.lastLoggedState != -1) {
                        this.tryLogRqState(true);
                    }
                    LogContext.CURRENT.remove();
                    long duration = (Core.nanoClock() - this.profile.tp_start_processingNano) / 1000000L;
                    Core.stat.request(duration);
                    this.rqstat.apply(duration);
                }
            }
            synchronized (startExecuteTime23332) {
                this.thread = null;
            }
            try {
                this.setState(6);
                this.client.disposeRequest(this);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            this.setState(7);
            if (this.lastLoggedState != -1) {
                this.tryLogRqState(true);
            }
            LogContext.CURRENT.remove();
            long duration = (Core.nanoClock() - this.profile.tp_start_processingNano) / 1000000L;
            Core.stat.request(duration);
            this.rqstat.apply(duration);
            return;
        }
        catch (Throwable e) {
            Core.logger.error("Oops! Uncathed exception:", e);
            return;
        }
        finally {
            RequestExecutor.requestCompleted();
        }
    }

    private void tryLogRqState(boolean inRqThread) {
        if (this.state == this.lastLoggedState) {
            return;
        }
        String ss = this.getState();
        if (inRqThread) {
            Core.logger.info("rq({})", (Object)ss);
        } else if (this.lastLoggedState == -1) {
            Core.logger.info("rq({},tn:{},id:{},rq:{},s:{},u:{},n:{})", ss, this.thread == null ? null : this.thread.getName(), this.rq.id, this.rq.request, (long)this.client.getLoginId(), (long)this.client.getUserId(), (long)this.rq.nodeId);
        } else {
            Core.logger.info("rq({},id:{},s:{})", ss, this.rq.id, (long)this.client.getLoginId());
        }
        this.lastLoggedState = this.state;
    }

    protected void processInputChunk(byte[] chunk) throws Throwable {
        throw new IllegalStateException("Request.processInputChunk is not implemented");
    }

    public synchronized void cancelRun(String reason) {
        boolean wasCanceled = this.canceled;
        if (this.cancelReason == null) {
            this.cancelReason = reason;
        }
        this.canceled = true;
        if (wasCanceled) {
            Core.logger.info("\u041e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: Request.cancelRun \u0437\u0430\u043f\u0440\u043e\u0441 \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d {}", (Object)this);
        }
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(true);
            Core.logger.info("\u041e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: Request.cancelRun future.cancel(true)");
            if (this.state < 3) {
                this.client.disposeRequest(this);
            }
        }
        if (!wasCanceled && this.thread != null) {
            Core.logger.info("\u041e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: Request.cancelRun ActionHooks.hookThreadActions");
            ActionHooks.hookThreadActions(this.thread.getId(), "Request.cancelRun");
        }
    }

    public final byte[] getRequestContent() {
        return this.requestContent;
    }

    protected TaggedReader createRequestContentReader() throws IOException {
        return new TaggedReader(this.requestContent);
    }

    public void setRequestContent(byte[] content) {
        this.requestContent = content;
    }

    public byte[] getRequestExtraParams() {
        return this.requestExtraParams;
    }

    public void setRequestExtraParams(byte[] requestExtraParams, long clock) {
        this.requestExtraParams = requestExtraParams;
        if (this.profile.tp_receivedNano > clock) {
            this.profile.tp_receivedNano = clock;
        }
    }

    protected TaggedReader createRequestExtraParamsReader() throws IOException {
        return new TaggedReader(new ByteArrayInputStream(this.requestExtraParams));
    }

    public boolean hasRequestExtraParams() {
        return this.requestExtraParams != null && this.requestExtraParams.length != 0;
    }

    public void sendError(String message, String detailing) throws Exception {
        this.client.sendError(this.rq, this.profile, message, null, detailing);
        this.isResultSended = true;
    }

    public void sendError(String message, String text, String extra) throws Exception {
        this.client.sendError(this.rq, this.profile, message, text, extra);
        this.isResultSended = true;
    }

    public void sendResult(byte[] buffer, int befferLen) throws Exception {
        this.idle();
        this.profile.tp_end_processingNano = Core.nanoClock();
        this.client.sendResult(this.rq, this.profile, buffer, befferLen, null, 0);
        this.isResultSended = true;
    }

    public void sendResult(byte[] buffer, int befferLen, byte[] info, int infoLength) throws Exception {
        this.idle();
        this.profile.tp_end_processingNano = Core.nanoClock();
        this.client.sendResult(this.rq, this.profile, buffer, befferLen, info, infoLength);
        this.isResultSended = true;
    }

    public void sendChunk(byte[] buffer, int len) throws Exception {
        this.idle();
        this.client.sendChunk(this.rq, buffer, len);
        this.outChunkSize += (long)len;
    }

    public void sendChunk(byte[] buffer) throws Exception {
        this.idle();
        this.client.sendChunk(this.rq, buffer, buffer.length);
        this.outChunkSize += (long)buffer.length;
    }

    public long getOutChunkSize() {
        return this.outChunkSize;
    }

    public void sendRequestState(byte[] buffer, int len) throws IOException {
        this.idle();
        this.client.sendRequestState(this.rq, this.profile, buffer, len);
    }

    @Override
    public void idle() {
        if (!this.cancelThrowed) {
            if (this.isCancelled()) {
                this.cancelThrowed = true;
                throw new CancelRequestException();
            }
            ++this.pulse;
        }
    }

    public void sendResult(byte[] buffer) throws Exception {
        this.sendResult(buffer, buffer.length, null, 0);
    }

    public void sendResultI(byte[] buffer, byte[] info) throws Exception {
        this.sendResult(buffer, buffer.length, info, info.length);
    }

    @Override
    public void sendResult() throws Exception {
        this.sendResult(null, 0);
    }

    @Override
    public double getUserID() {
        this.idle();
        return this.client.getUserId();
    }

    @Override
    public int getTimeZoneOffset() {
        return this.client.getTimeZoneOffset();
    }

    @Override
    public double getEffectiveUserID() {
        this.idle();
        return this.client.getEffectiveUserId();
    }

    @Override
    public double getNodeID() {
        this.idle();
        return this.rq.nodeId;
    }

    public double getRootNodeID() {
        this.idle();
        return this.client.getRootNodeId();
    }

    public double getTranslatedNodeID() {
        this.idle();
        if (this.rq.nodeId == 0.0) {
            return this.client.getRootNodeId();
        }
        return this.rq.nodeId;
    }

    protected final <T extends Node> T getNode(double id) throws InformException, ClassCastException {
        this.idle();
        return (T)this.getNode(id, Node.class);
    }

    protected final <T extends Node> T getNode(double id, Class<? extends T> cls) throws InformException, ClassCastException {
        Node result = MtdEngine.getValidNode(id);
        if (cls.isAssignableFrom(result.getClass())) {
            return (T)result;
        }
        throw new InformException(String.format("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f %s \u0443\u0437\u043b\u0430: %s", result.getClass().getSimpleName(), NumberConverter.doubleToString(id)));
    }

    @Override
    public void writeLog(String msg) throws Exception {
        this.putRequestStateText(9, msg);
    }

    @Override
    public void writeLogLine(String msg) throws Exception {
        this.putRequestStateText(10, msg);
    }

    private void putRequestStateInt(int tag, int value) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(outStream);
        writer.putInt32(tag, value);
        writer.flush();
        this.sendRequestState(outStream.internalBuffer(), outStream.size());
    }

    private void putRequestStateText(int tag, String msg) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(outStream);
        writer.putAnsi(tag, msg);
        writer.flush();
        this.sendRequestState(outStream.internalBuffer(), outStream.size());
    }

    private void putRequestStateBin(int tag, ByteArrayOutputStream data) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(outStream);
        writer.putRaw(tag, data.internalBuffer(), data.size());
        writer.flush();
        this.sendRequestState(outStream.internalBuffer(), outStream.size());
    }

    public void putRequestStateSysLogInfo(String msg) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(outStream);
        writer.putAnsi(14, msg);
        writer.flush();
        this.sendRequestState(outStream.internalBuffer(), outStream.size());
    }

    @Override
    public void putRequestStateText(String msg) throws IOException {
        this.putRequestStateText(2, msg);
    }

    @Override
    public void putRequestStateLog(String msg) throws Exception {
        this.putRequestStateText(3, msg);
    }

    @Override
    public void putRequestStateCaption(String caption) throws Exception {
        this.putRequestStateText(1, caption);
    }

    @Override
    public void putRequestStateResultText(String text) throws Exception {
        this.putRequestStateText(16, text);
    }

    @Override
    public void putRequestStateProgressMin(int min) throws Exception {
        this.putRequestStateInt(4, min);
    }

    @Override
    public void putRequestStateProgressMax(int max) throws Exception {
        this.putRequestStateInt(5, max);
    }

    @Override
    public void putRequestStateProgressPosition(int pos) throws Exception {
        this.putRequestStateInt(6, pos);
    }

    @Override
    public void putRequestStateProgressVisible(boolean isVisible) throws Exception {
        this.putRequestStateInt(7, isVisible ? 1 : 0);
    }

    @Override
    public void putRequestStateInstruction(String message) throws Exception {
        this.putRequestStateText(8, message);
    }

    @Override
    public void sendTraceLabel(SSContext context, String text) throws Exception {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        context.storeAs(1, out);
        out.putString(2, text);
        out.flush();
        this.putRequestStateBin(15, data);
    }

    @Override
    public void putRequestStateEnter() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(outStream);
        writer.putEmpty(11);
        writer.flush();
        this.sendRequestState(outStream.internalBuffer(), outStream.size());
    }

    @Override
    public void putRequestStateLeave() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(outStream);
        writer.putEmpty(12);
        writer.flush();
        this.sendRequestState(outStream.internalBuffer(), outStream.size());
    }

    @Override
    public VersionInfo getClientVersion() {
        this.idle();
        return this.client.getVersion();
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public Security security() {
        return this.client().security();
    }

    public int getRequestSessionID() {
        this.idle();
        return this.rq.sessionId;
    }

    @Override
    public double getSessionID() {
        return this.client.getSessionId();
    }

    public final void addInputChunk(byte[] chunk) throws InterruptedException {
        this.setChunkedInput();
        InputChunkQueue queue = this.getInputChunkQueue();
        if (queue != null) {
            queue.add(chunk);
        }
        this.idle();
    }

    public final void endInputChunk() {
        InputChunkQueue queue = this.getInputChunkQueue();
        if (queue != null) {
            queue.close();
        }
    }

    private synchronized InputChunkQueue getInputChunkQueue() {
        this.idle();
        return this.inputChunkQueue;
    }

    public final synchronized void setChunkedInput() {
        if (this.inputChunkQueue == null) {
            this.inputChunkQueue = new InputChunkQueue(this);
        }
    }

    protected final void processChunkedInput() throws Throwable {
        InputChunkQueue queue = this.getInputChunkQueue();
        if (queue == null) {
            return;
        }
        while (queue.hasChunk()) {
            this.idle();
            byte[] chunk = queue.next();
            if (chunk == null) continue;
            this.processInputChunk(chunk);
        }
    }

    protected long timingLog(String msg, long startTime) {
        long time = (System.currentTimeMillis() - startTime) / 1000L;
        Core.logger.info("{}: {}", (Object)msg, (Object)time);
        return System.currentTimeMillis();
    }

    @Override
    public void appendToLog(String msg) throws Exception {
    }

    public synchronized void setState(int state) {
        this.state = state;
        if (state == 2) {
            this.profile.tp_pooledNano = Core.nanoClock();
        }
    }

    public synchronized String getState() {
        switch (this.state) {
            case 0: {
                return "Created";
            }
            case 1: {
                return "Reading";
            }
            case 2: {
                return "Pooling";
            }
            case 3: {
                return "Starting";
            }
            case 4: {
                return "Running";
            }
            case 5: {
                return "Completing";
            }
            case 6: {
                return "Disposing";
            }
            case 7: {
                return "Disposed";
            }
        }
        return Integer.toString(this.state);
    }

    public synchronized void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
        long time = gatherer.time();
        long duration = time - this.created;
        Thread t = this.thread;
        if (t != null && time - this.lastHangCallstackTime > 300000L) {
            StringBuilder tmp = new StringBuilder();
            PhaThread.dumpStackTrace(tmp, t);
            Core.logger.log(this.longRequestLevel, "Long request (id:{},time:{},pulse:{}) {}", this.taskId, duration, this.pulse, tmp);
            this.lastHangCallstackTime = time;
        }
        LogContext.Builder cMsg = new LogContext.Builder();
        this.contextMessage(cMsg);
        if (duration > 5000L) {
            this.tryLogRqState(false);
        }
        gatherer.request(this.taskId, this.rq.request, this.getClass().getSimpleName(), duration, this.client, this.pulse, this.getState(), this.thread, cMsg.toString(), this.vlongOpDepth > 0);
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        if (this.client != null) {
            this.client.contextMessage(out);
        }
        out.append("rq", this.rq.request);
        out.append("id", this.rq.id);
        if (this.rq.nodeId != 0.0) {
            out.append("n", (long)this.rq.nodeId);
        }
    }

    @Override
    public SSContext getSSContext() {
        return this.ssContext;
    }

    @Override
    public RequestStatistics.Value rqstat() {
        return this.rqstat;
    }

    @Override
    public void rqstat(RequestStatistics.Value value) {
        this.rqstat = value;
    }

    public String toString() {
        if (this.rq.nodeId == 0.0) {
            return String.format("rq(id:%d,type:%d,session:%.0f,user:%.0f)", this.rq.id, this.rq.request, this.client.getLoginId(), this.client.getUserId());
        }
        return String.format("rq(id:%d,type:%d,session:%.0f,user:%.0f,node:%.0f)", this.rq.id, this.rq.request, this.client.getLoginId(), this.client.getUserId(), this.rq.nodeId);
    }

    @Override
    public DatabaseDescriptor getDBLogin(DatabaseDescriptor db) throws InformException, SQLException {
        return this.client.getDBLogin(db);
    }

    @Override
    public void personalSessionCreated(ConnectionManager ps) {
        this.client.personalSessionCreated(ps);
    }

    @Override
    public void personalSessionClosed(ConnectionManager ps) {
        this.client.personalSessionClosed(ps);
    }

    @Override
    public int key() {
        return this.rq.id;
    }

    public void vlongOp_begin() {
        ++this.vlongOpDepth;
    }

    public void vlongOp_end() {
        --this.vlongOpDepth;
    }

    boolean isAlreadyExecuted() {
        return this.state >= 5;
    }

    @Override
    public void standing(long time) {
        this.profile.standingNano += time;
    }

    public static class AnalyzeThrowable {
        public String message;
        public String detailing;
    }
}

