/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.AgentJARVersion;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.net.RequestExecutor;
import inform.agent.web.JSON;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class RequestStatistics {
    private static final ThreadLocal<Value> THREAD_VALUE = new ThreadLocal();
    private static final long SLICES_TAIL = 604800000L;
    private static final long SLICE_INTERVAL = 600000L;
    private static final long SLICE_LONG_INTERVAL = 3600000L;
    private static final ConcurrentMap<Value, Value> STATISTICS0 = new ConcurrentHashMap<Value, Value>();
    private static final ConcurrentMap<Value, Value> STATISTICS1 = new ConcurrentHashMap<Value, Value>();
    private static volatile ConcurrentMap<Value, Value> STATISTICS = STATISTICS0;
    private static boolean STATISTICS_USE1;
    private static final Calendar CALENDAR;
    private static final int TIMESPAMP_LENGTH = 17;
    private static final File sliceFileFolder;
    private static final String fileNamePrefix;
    private static final String fileNameSuffix = ".sts";
    private static int idgen;
    private static long lastSliceTime;
    private static long lastSliceCpuKrn;
    private static long lastSliceCpuUsr;
    private static long lastDBPoolWaitTime;
    private static long lastGCTime;
    private static long lastSliceSysCpuKrn;
    private static long lastSliceSysCpuUsr;
    private static long lastSliceMemFaults;
    private static int lastDBPoolWaitsCount;

    public static Value THREAD_VALUE() {
        Value v = THREAD_VALUE.get();
        if (v == null) {
            v = new Value();
            THREAD_VALUE.set(v);
        }
        return v;
    }

    static void sliceIfTimeout(long time) {
        long dt = time - lastSliceTime;
        if (dt > 600000L) {
            RequestStatistics.slice(time, dt > 3600000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void slice(long time, boolean force) {
        ConcurrentMap<Value, Value> ss = STATISTICS;
        STATISTICS_USE1 = !STATISTICS_USE1;
        ConcurrentMap<Value, Value> concurrentMap = STATISTICS = STATISTICS_USE1 ? STATISTICS1 : STATISTICS0;
        if (force || !ss.isEmpty()) {
            if (sliceFileFolder != null) {
                try {
                    File sliceFile = new File(sliceFileFolder, fileNamePrefix + RequestStatistics.formatTimespamp(time) + fileNameSuffix);
                    try (OutputStreamWriter sw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(sliceFile)), TaggedWriter.ANSI);){
                        double dt = (double)(time - lastSliceTime) / 1000.0;
                        long[] cpu = new long[2];
                        long[] syscpu = new long[2];
                        long[] sysmem = new long[2];
                        long[] mem = new long[3];
                        Core.getCurrentProcessTimes(cpu);
                        Core.getCurrentSystemTimes(syscpu);
                        Core.getSystemMemoryUsage(sysmem);
                        Core.getProcessMemoryUsage(mem);
                        long cpuKrn = cpu[0] - lastSliceCpuKrn;
                        long cpuUsr = cpu[1] - lastSliceCpuUsr;
                        ((Writer)sw).append(String.format("# %s (-%s)\n# CPU: %.2f%%\n", RequestStatistics.formatTimespampForHumanoids(time), RequestStatistics.formatTimespan(time - lastSliceTime), (double)(cpuKrn + cpuUsr) / 1.0E7 / dt * 100.0).replace(',', '.')).append("{header:").append("{timespan:[").append(Long.toString(lastSliceTime)).append(',').append(Long.toString(time)).append(']');
                        if (!Strings.isVoid(Ini.AgentName)) {
                            ((Writer)sw).append(",agentname:").append(JSON.toString(Ini.AgentName));
                        }
                        long dbwt = DatabaseDescriptor.getCurrentTotalWaitTime();
                        int dbwc = DatabaseDescriptor.getCurrentTotalWaitsCount();
                        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
                        MemoryUsage heap = mb.getHeapMemoryUsage();
                        MemoryUsage nonheap = mb.getNonHeapMemoryUsage();
                        long gcTime = 0L;
                        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
                            long t = b.getCollectionTime();
                            if (t <= 0L) continue;
                            gcTime += t;
                        }
                        ((Writer)sw).append(",cpu:{krn:").append(Long.toString(cpuKrn)).append(",usr:").append(Long.toString(cpuUsr)).append('}').append(",mem:").append("{heap:{used:").append(Long.toString(heap.getUsed())).append(",max:").append(Long.toString(heap.getMax())).append('}').append(",nonheap:{used:").append(Long.toString(nonheap.getUsed())).append(",max:").append(Long.toString(nonheap.getMax())).append('}').append(",sys:{priv:").append(Long.toString(mem[0])).append(",work:").append(Long.toString(mem[1])).append(",pfs:").append(Long.toString(mem[2] - lastSliceMemFaults)).append('}').append(",gctime:").append(Long.toString(gcTime - lastGCTime)).append('}').append(",pid:").append(Integer.toString(Ini.ProcessID)).append(",no:").append(Integer.toString(idgen++)).append(",slid:").append(Long.toString((long)Core.generateId())).append(",ver:").append(JSON.toString(AgentJARVersion.asString())).append(",dbpool:{waits:{time:").append(Long.toString(dbwt - lastDBPoolWaitTime)).append(",count:").append(Integer.toString(dbwc - lastDBPoolWaitsCount)).append('}').append(",limit:").append(Integer.toString(Ini.DbConnectionsLimit)).append('}').append(",thpool:{mxrq:").append(Integer.toString(RequestExecutor.pollMaximumRequestCountSTS())).append(",limit:").append(Integer.toString(Ini.MaxThreads)).append('}').append(",sys:").append("{cpu:{krn:").append(Long.toString(syscpu[0] - lastSliceSysCpuKrn)).append(",usr:").append(Long.toString(syscpu[1] - lastSliceSysCpuUsr)).append('}').append(",mem:{total:").append(Long.toString(sysmem[0])).append(",avail:").append(Long.toString(sysmem[1])).append("}}").append("}}\n");
                        DatabaseDescriptor.poolGatheredWorkloadInfoSTS(sw);
                        lastSliceMemFaults = mem[2];
                        lastGCTime = gcTime;
                        lastSliceSysCpuKrn = syscpu[0];
                        lastSliceSysCpuUsr = syscpu[1];
                        lastSliceTime = time;
                        lastSliceCpuKrn = cpu[0];
                        lastSliceCpuUsr = cpu[1];
                        lastDBPoolWaitTime = dbwt;
                        lastDBPoolWaitsCount = dbwc;
                        for (Value k : ss.keySet()) {
                            ((Writer)sw).append("{rq:").append(Integer.toString(k.rqType));
                            if (k.userId != 0.0) {
                                ((Writer)sw).append(",u:").append(Long.toString((long)k.userId));
                            }
                            if (k.nodeId != 0.0) {
                                ((Writer)sw).append(",n:").append(Long.toString((long)k.nodeId));
                            }
                            if (k.ownerId != 0.0) {
                                ((Writer)sw).append(",o:").append(Long.toString((long)k.ownerId));
                            }
                            if (k.ownerDatasourceId != 0) {
                                ((Writer)sw).append(",od:").append(Integer.toString(k.ownerDatasourceId));
                            }
                            ((Writer)sw).append(",rc:").append(Integer.toString(k.rqCount));
                            if (k.rqTime != 0L) {
                                ((Writer)sw).append(",rt:").append(Long.toString(k.rqTime));
                            }
                            if (k.rqReadingTime != 0L) {
                                ((Writer)sw).append(",rrt:").append(Long.toString(k.rqReadingTime));
                            }
                            if (k.rqPoolingTime != 0L) {
                                ((Writer)sw).append(",rpt:").append(Long.toString(k.rqPoolingTime));
                            }
                            if (k.sqlCount != 0) {
                                ((Writer)sw).append(",sc:").append(Integer.toString(k.sqlCount));
                            }
                            if (k.sqlTime != 0L) {
                                ((Writer)sw).append(",st:").append(Long.toString(k.sqlTime));
                            }
                            if (k.sqlRFetch != 0L) {
                                ((Writer)sw).append(",sr:").append(Long.toString(k.sqlRFetch));
                            }
                            if (k.cpuKrnTime != 0L) {
                                ((Writer)sw).append(",ck:").append(Long.toString(k.cpuKrnTime));
                            }
                            if (k.cpuUsrTime != 0L) {
                                ((Writer)sw).append(",cu:").append(Long.toString(k.cpuUsrTime));
                            }
                            ((Writer)sw).append("}\n");
                        }
                    }
                }
                catch (Throwable e) {
                    Core.logger.error("writeslice", e);
                }
            }
            ss.clear();
        }
    }

    static String formatTimespan(long delta) {
        long s = delta / 1000L;
        long m = s / 60L;
        long h = m / 60L;
        return String.format("%02d:%02d:%02d", h, m - h * 60L, s - m * 60L);
    }

    static String formatTimespamp(long time) {
        CALENDAR.setTimeInMillis(time);
        return String.format("%04d-%02d-%02d-%02d%02d%02d", CALENDAR.get(1), CALENDAR.get(2) + 1, CALENDAR.get(5), CALENDAR.get(11), CALENDAR.get(12), CALENDAR.get(13));
    }

    static String formatTimespampForHumanoids(long time) {
        CALENDAR.setTimeInMillis(time);
        return String.format("%04d.%02d.%02d %02d:%02d:%02d", CALENDAR.get(1), CALENDAR.get(2) + 1, CALENDAR.get(5), CALENDAR.get(11), CALENDAR.get(12), CALENDAR.get(13));
    }

    static {
        CALENDAR = Calendar.getInstance();
        if (!Ini.StatSlices) {
            sliceFileFolder = null;
            fileNamePrefix = null;
        } else if (Strings.isVoid(Ini.AgentID)) {
            Core.logger.warn("cannot setup agent statistics storage: agentid is empty");
            sliceFileFolder = null;
            fileNamePrefix = null;
        } else if (Strings.isVoid(Ini.SysLogFileName)) {
            Core.logger.warn("cannot setup agent statistics storage: logfilename is empty");
            sliceFileFolder = null;
            fileNamePrefix = null;
        } else {
            File logpatt = new File(Ini.SysLogFileName);
            sliceFileFolder = new File(logpatt.getParent(), "stat");
            if (!sliceFileFolder.mkdirs() && !sliceFileFolder.exists()) {
                Core.logger.error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \"" + sliceFileFolder.getAbsolutePath() + "\"");
            }
            fileNamePrefix = Ini.AgentID + "-";
            final long currentTime = System.currentTimeMillis();
            File[] old = sliceFileFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.length() != fileNamePrefix.length() + RequestStatistics.fileNameSuffix.length() + 17) {
                        return false;
                    }
                    if (!name.startsWith(fileNamePrefix)) {
                        return false;
                    }
                    if (!name.endsWith(RequestStatistics.fileNameSuffix)) {
                        return false;
                    }
                    String timestamp = name.substring(fileNamePrefix.length(), fileNamePrefix.length() + 17);
                    try {
                        CALENDAR.set(Integer.parseInt(timestamp.substring(0, 4)), Integer.parseInt(timestamp.substring(5, 7)) - 1, Integer.parseInt(timestamp.substring(8, 10)), Integer.parseInt(timestamp.substring(11, 13)), Integer.parseInt(timestamp.substring(13, 15)), Integer.parseInt(timestamp.substring(15, 17)));
                        long ts = CALENDAR.getTimeInMillis();
                        return currentTime - ts > 604800000L;
                    }
                    catch (NumberFormatException e) {
                        Core.logger.error("stat:parsetimespamp", e);
                        return false;
                    }
                }
            });
            if (old != null) {
                for (File o : old) {
                    if (o.delete()) continue;
                    Core.logger.error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b \"" + o.getAbsolutePath() + "\"");
                }
            }
        }
        lastSliceTime = System.currentTimeMillis();
    }

    public static class Value {
        private static final AtomicIntegerFieldUpdater<Value> AFU_rqCount = AtomicIntegerFieldUpdater.newUpdater(Value.class, "rqCount");
        private static final AtomicIntegerFieldUpdater<Value> AFU_sqlCount = AtomicIntegerFieldUpdater.newUpdater(Value.class, "sqlCount");
        private static final AtomicLongFieldUpdater<Value> AFU_rqTime = AtomicLongFieldUpdater.newUpdater(Value.class, "rqTime");
        private static final AtomicLongFieldUpdater<Value> AFU_rqReadingTime = AtomicLongFieldUpdater.newUpdater(Value.class, "rqReadingTime");
        private static final AtomicLongFieldUpdater<Value> AFU_rqPoolingTime = AtomicLongFieldUpdater.newUpdater(Value.class, "rqPoolingTime");
        private static final AtomicLongFieldUpdater<Value> AFU_sqlTime = AtomicLongFieldUpdater.newUpdater(Value.class, "sqlTime");
        private static final AtomicLongFieldUpdater<Value> AFU_sqlRFetch = AtomicLongFieldUpdater.newUpdater(Value.class, "sqlRFetch");
        private static final AtomicLongFieldUpdater<Value> AFU_cpuKrnTime = AtomicLongFieldUpdater.newUpdater(Value.class, "cpuKrnTime");
        private static final AtomicLongFieldUpdater<Value> AFU_cpuUsrTime = AtomicLongFieldUpdater.newUpdater(Value.class, "cpuUsrTime");
        private double userId;
        private int rqType;
        public double nodeId;
        public double ownerId;
        public int ownerDatasourceId;
        private volatile int rqCount;
        private volatile int sqlCount;
        public volatile long rqReadingTime;
        public volatile long rqPoolingTime;
        private volatile long rqTime;
        private volatile long sqlTime;
        private volatile long sqlRFetch;
        private volatile long cpuKrnTime;
        private volatile long cpuUsrTime;
        private final long[] tmp = new long[2];

        public Value() {
        }

        Value(Value that) {
            this.userId = that.userId;
            this.rqType = that.rqType;
            this.nodeId = that.nodeId;
            this.ownerId = that.ownerId;
            this.ownerDatasourceId = that.ownerDatasourceId;
            this.rqCount = that.rqCount;
            this.sqlCount = that.sqlCount;
            this.rqTime = that.rqTime;
            this.rqReadingTime = that.rqReadingTime;
            this.rqPoolingTime = that.rqPoolingTime;
            this.sqlTime = that.sqlTime;
            this.sqlRFetch = that.sqlRFetch;
            this.cpuKrnTime = that.cpuKrnTime;
            this.cpuUsrTime = that.cpuUsrTime;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (int)(Double.doubleToLongBits(this.nodeId) ^ Double.doubleToLongBits(this.nodeId) >>> 32);
            hash = 47 * hash + (int)(Double.doubleToLongBits(this.ownerId) ^ Double.doubleToLongBits(this.ownerId) >>> 32);
            hash = 47 * hash + (int)(Double.doubleToLongBits(this.userId) ^ Double.doubleToLongBits(this.userId) >>> 32);
            hash = 47 * hash + this.rqType;
            hash = 47 * hash + this.ownerDatasourceId;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return Double.doubleToLongBits(this.nodeId) == Double.doubleToLongBits(other.nodeId) && Double.doubleToLongBits(this.ownerId) == Double.doubleToLongBits(other.ownerId) && Double.doubleToLongBits(this.userId) == Double.doubleToLongBits(other.userId) && this.rqType == other.rqType && this.ownerDatasourceId == other.ownerDatasourceId;
        }

        public void reset(int rqType, double userId, double nodeId) {
            this.rqType = rqType;
            this.userId = userId;
            this.nodeId = nodeId;
            this.ownerId = 0.0;
            this.ownerDatasourceId = 0;
            this.rqCount = 1;
            this.sqlCount = 0;
            this.sqlRFetch = 0L;
            this.sqlTime = 0L;
            this.rqPoolingTime = 0L;
            this.rqReadingTime = 0L;
            this.rqTime = 0L;
            Core.getCurrentThreadTimes(this.tmp);
            this.cpuKrnTime = this.tmp[0];
            this.cpuUsrTime = this.tmp[1];
        }

        public void sql(long duration) {
            ++this.sqlCount;
            this.sqlTime += duration;
        }

        public void sqlFetchsDuration(long duration) {
            this.sqlTime += duration;
        }

        public void sqlRowsFetched(int rowsCount) {
            this.sqlRFetch += (long)rowsCount;
        }

        public void apply(long rqDuration) {
            Core.getCurrentThreadTimes(this.tmp);
            this.cpuKrnTime = this.tmp[0] - this.cpuKrnTime;
            this.cpuUsrTime = this.tmp[1] - this.cpuUsrTime;
            Value alias = (Value)STATISTICS.get(this);
            if (alias == null) {
                Value clone = new Value(this);
                clone.rqCount = 1;
                clone.rqTime = rqDuration;
                alias = STATISTICS.putIfAbsent(clone, clone);
                if (alias == null) {
                    return;
                }
            }
            AFU_rqCount.incrementAndGet(alias);
            AFU_rqTime.addAndGet(alias, rqDuration);
            AFU_rqReadingTime.addAndGet(alias, this.rqReadingTime);
            AFU_rqPoolingTime.addAndGet(alias, this.rqPoolingTime);
            AFU_sqlCount.addAndGet(alias, this.sqlCount);
            AFU_sqlTime.addAndGet(alias, this.sqlTime);
            AFU_sqlRFetch.addAndGet(alias, this.sqlRFetch);
            AFU_cpuKrnTime.addAndGet(alias, this.cpuKrnTime);
            AFU_cpuUsrTime.addAndGet(alias, this.cpuUsrTime);
        }
    }
}

