/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.am;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.LongHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ActionHooks;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.PhaThread;
import inform.agent.Statistics;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.net.Client;
import inform.agent.net.ClientSession;
import inform.agent.net.RequestExecutor;
import inform.agent.sched.Sched;
import inform.agent.web.HttpServer;
import inform.agent.web.Session;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Telemeter
extends PhaThread {
    public static final AtomicInteger ID_GEN = new AtomicInteger();
    private static final int OFFS_LONG_OPERATION = 10001;
    private static final int OFFS_VERY_LONG_OPERATION = 20001;
    private static final int TAG_AT_THREAD_HEADER = 1;
    private static final int TAG_AT_REQUEST = 2;
    private static final int TAG_AT_USER_ID = 3;
    private static final int TAG_AT_THREAD_BLOCKED = 4;
    private static final int TAG_AT_DESCR = 5;
    private static final int TAG_AT_THREAD_ID = 6;
    private static final int TAG_AT_REQUEST_TIME = 7;
    private static final int TAG_AT_STATISTICS = 8;
    private static final int TAG_AT_IMPORTANT_TASK = 9;
    private static final int TAG_AT_CONTEXT_MESSAGE = 10;
    private static final int TAG_AT_PROCESS_MEMORY_USAGE = 11;
    private static final int TAG_AT_THREAD_CPU_USAGE = 12;
    private static final int TAG_AT_THREAD_CALLSTACK = 13;
    private static final int TAG_AT_HISTORY_DESCR = 14;
    private static final int TAG_AT_SESSION_COUNT = 15;
    private static final int TAG_AT_DESCR_ID = 1;
    private static final int TAG_AT_DESCR_VALUE = 2;
    private static final int TAG_AT_OPS_DESCR = 3;
    private static final int TAG_AT_RQS_DESCR = 4;
    private static final int TAG_AT_THR_DESCR = 5;
    private static final int STATE_NO = 0;
    private static final int STATE_READY = 1;
    private static final int STATE_GATHERING = 2;
    private static final int STATE_GATHERING_CORE = 3;
    private static final int STATE_GATHERING_SCHED = 4;
    private static final int STATE_GATHERING_CLIENTS = 5;
    private static final int STATE_GATHERING_HTTP = 6;
    private static final int STATE_COMPLETING = 7;
    private static final int STATE_SENDING = 8;
    private static Telemeter instance = new Telemeter();
    private byte[] cache;
    private int state = 0;
    private int pulse;
    private LongHash<ThreadTimes> threadTimes = new LongHash();

    private Telemeter() {
        super("Telemeter", PhaThread.Type.DAEMON);
    }

    public synchronized int status() {
        return this.state;
    }

    private synchronized byte[] gatheredTelemetry() {
        return this.cache;
    }

    private synchronized void gatherTelemetry() {
        this.cache = null;
        if (!this.isAlive()) {
            this.start();
        } else {
            this.notify();
        }
    }

    private static void writeAtDescrEntry(double id, String val, TaggedWriter writer) throws Throwable {
        if (id <= 255.0) {
            writer.putInt08(1, (byte)id);
        } else if (id <= 65535.0) {
            writer.putInt16(1, (short)id);
        } else if (id <= -1.0) {
            writer.putInt32(1, (int)id);
        } else {
            writer.putDouble(1, id);
        }
        writer.putAnsi(2, val);
    }

    private static <A, B> Map<B, A> transpose(Map<A, B> m) {
        HashMap<B, A> result = new HashMap<B, A>();
        for (Map.Entry<A, B> e : m.entrySet()) {
            result.put(e.getValue(), e.getKey());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long startExceptionTime = System.currentTimeMillis();
            int exceptionsLeft = 16;
            final ByteBuffer header = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
            while (true) {
                this.state = 1;
                long TS_ready = System.nanoTime();
                Telemeter telemeter = this;
                synchronized (telemeter) {
                    while (this.cache != null) {
                        this.wait();
                    }
                }
                long exceptionTime = System.currentTimeMillis();
                if (exceptionTime - startExceptionTime > 5000L) {
                    startExceptionTime = exceptionTime;
                    exceptionsLeft = 16;
                }
                this.state = 2;
                long TS_gathering = System.nanoTime();
                final SMap smapOp = new SMap();
                final SMap smapOpLong = new SMap(10001);
                final SMap smapOpVeryLong = new SMap(20001);
                final HashMap smapRq = new HashMap();
                final HashMap smapUsers = new HashMap();
                final HashMap smapThreads = new HashMap();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                final TaggedWriter writer = new TaggedWriter(out);
                long[] memUsages = new long[3];
                Core.getProcessMemoryUsage(memUsages);
                int memUsage = (int)(memUsages[0] / 1024L);
                if (memUsage >= 0x3FFFFF) {
                    writer.putInt32(11, memUsage);
                }
                writer.putInt32(15, ClientSession.clientSessionCount());
                final LongHash newThreadTimes = new LongHash();
                Gatherer gatherer = new Gatherer(){
                    ThreadMXBean tb;

                    void writeThread(Thread thread) throws IOException {
                        if (thread == null) {
                            return;
                        }
                        long tid = thread.getId();
                        smapThreads.put(thread.getName(), (int)tid);
                        writer.putInt32(6, (int)tid);
                        if (1.pending(thread)) {
                            writer.putEmpty(4);
                        }
                        if (this.tb == null) {
                            this.tb = ManagementFactory.getThreadMXBean();
                        }
                        long tick = Core.clock();
                        long totalTime = this.tb.getThreadCpuTime(tid);
                        long userTime = this.tb.getThreadUserTime(tid);
                        ThreadTimes tt = Telemeter.this.threadTimes.get(tid);
                        if (tt != null) {
                            byte[] usage = new byte[]{0, 0};
                            long dt = 1000000L * (tick - tt.sliceTick);
                            if (totalTime != -1L && tt.totalTime != -1L) {
                                usage[0] = this.l2ub_clamp(100L * (totalTime - tt.totalTime) / dt);
                            }
                            if (userTime != -1L && tt.userTime != -1L) {
                                usage[1] = this.l2ub_clamp(100L * (userTime - tt.userTime) / dt);
                            }
                            writer.putRaw(12, usage);
                        }
                        StringBuffer callstack = new StringBuffer();
                        for (StackTraceElement e : thread.getStackTrace()) {
                            callstack.append("\n\t").append(e);
                        }
                        writer.putAnsi(13, callstack.toString());
                        tt = new ThreadTimes(tid, tick, totalTime, userTime);
                        newThreadTimes.add(tt);
                    }

                    byte l2ub_clamp(long l) {
                        return (byte)(l < 0L ? 0L : (l > 255L ? 255L : l));
                    }

                    @Override
                    public void task(int taskId, int taskType, String state, Thread thread) throws IOException {
                        header.putInt(0, taskId);
                        header.putInt(4, taskType);
                        header.putInt(8, smapOp.gen(state));
                        header.putInt(12, Telemeter.this.pulse++);
                        writer.putRaw(1, header.array(), header.limit());
                        this.writeThread(thread);
                    }

                    @Override
                    public void job(int taskId, long duration, int pulse, boolean isImportantTask, String state, Thread thread) throws IOException {
                        header.putInt(0, taskId);
                        header.putInt(4, 48);
                        header.putInt(8, smapOpLong.gen(state));
                        header.putInt(12, pulse);
                        writer.putRaw(1, header.array(), header.limit());
                        writer.putInt32(7, (int)duration);
                        this.writeThread(thread);
                        if (isImportantTask) {
                            writer.putEmpty(9);
                        }
                    }

                    @Override
                    public void request(int taskId, int rqType, String rqName, long duration, Client client, int pulse, String state, Thread thread, String contextMessage, boolean vlong) throws IOException {
                        ActionHooks.Duration dur;
                        if (client != null) {
                            smapUsers.put(client.getUserName(), client.getUserId());
                        }
                        header.putInt(0, taskId);
                        header.putInt(4, 12);
                        if (vlong) {
                            dur = ActionHooks.Duration.VERY_LONG;
                        } else {
                            switch (rqType) {
                                case 63: 
                                case 67: 
                                case 501: 
                                case 511: 
                                case 512: {
                                    dur = ActionHooks.Duration.LONG;
                                    break;
                                }
                                case 99: {
                                    dur = ActionHooks.Duration.VERY_LONG;
                                    break;
                                }
                                default: {
                                    dur = ActionHooks.Duration.NORMAL;
                                }
                            }
                        }
                        SMap smap = this.smapForThread(thread, dur);
                        header.putInt(8, smap.gen(state));
                        header.putInt(12, pulse);
                        writer.putRaw(1, header.array(), header.limit());
                        writer.putInt32(2, rqType);
                        smapRq.put(rqName, rqType);
                        writer.putInt32(7, (int)duration);
                        if (client != null) {
                            writer.putDouble(3, client.getUserId());
                        }
                        this.writeThread(thread);
                        if (!Strings.isVoid(contextMessage)) {
                            writer.putAnsi(10, contextMessage);
                        }
                    }

                    @Override
                    public void webRequest(int taskId, long duration, Session client, String state, Thread thread) throws IOException {
                        Session.User u;
                        header.putInt(0, taskId);
                        header.putInt(4, 80);
                        SMap smap = this.smapForThread(thread, ActionHooks.Duration.NORMAL);
                        header.putInt(8, smap.gen(state));
                        header.putInt(12, Telemeter.this.pulse++);
                        writer.putRaw(1, header.array(), header.limit());
                        writer.putInt32(7, (int)duration);
                        if (client != null && (u = client.getCurrentUser()) != null) {
                            smapUsers.put(u.name(), u.id());
                            writer.putDouble(3, u.id());
                        }
                        this.writeThread(thread);
                    }

                    private SMap smapForThread(Thread thread, ActionHooks.Duration duration) {
                        ActionHooks.Duration mx;
                        if (thread != null && (mx = ActionHooks.maxThreadDuration(thread.getId())).ordinal() > duration.ordinal()) {
                            duration = mx;
                        }
                        switch (duration) {
                            case LONG: {
                                return smapOpLong;
                            }
                            case VERY_LONG: {
                                return smapOpVeryLong;
                            }
                        }
                        return smapOp;
                    }
                };
                try {
                    this.state = 3;
                    long TS_core = System.nanoTime();
                    Core.gatherTelemetry(gatherer);
                    this.state = 4;
                    long TS_sched = System.nanoTime();
                    Sched.gatherTelemetry(gatherer);
                    this.state = 5;
                    long TS_clients = System.nanoTime();
                    ClientSession.gatherTelemetries(gatherer);
                    this.state = 6;
                    long TS_http = System.nanoTime();
                    HttpServer.gatherTelemetry(gatherer);
                    this.state = 7;
                    this.threadTimes = newThreadTimes;
                    long TS_heap = System.nanoTime();
                    MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
                    MemoryUsage heap = mb.getHeapMemoryUsage();
                    long javaHeap = heap.getUsed();
                    long javaMaxHeap = heap.getMax();
                    long javaNonHeap = mb.getNonHeapMemoryUsage().getUsed();
                    long TS_gcTime = System.nanoTime();
                    long gcTime = 0L;
                    for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
                        long t = b.getCollectionTime();
                        if (t <= 0L) continue;
                        gcTime += t;
                    }
                    long TS_completing = System.nanoTime();
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    TaggedWriter wrt = new TaggedWriter(tmp);
                    for (Map.Entry e : Telemeter.transpose(smapUsers).entrySet()) {
                        Telemeter.writeAtDescrEntry((Double)e.getKey(), (String)e.getValue(), wrt);
                    }
                    ByteArrayOutputStream o = new ByteArrayOutputStream();
                    TaggedWriter w = new TaggedWriter(o);
                    smapOp.write(w);
                    smapOpLong.write(w);
                    smapOpVeryLong.write(w);
                    w.flush();
                    if (o.size() > 0) {
                        wrt.putRaw(3, o);
                    }
                    o = new ByteArrayOutputStream();
                    w = new TaggedWriter(o);
                    for (Map.Entry e : Telemeter.transpose(smapRq).entrySet()) {
                        Telemeter.writeAtDescrEntry(((Integer)e.getKey()).intValue(), (String)e.getValue(), w);
                    }
                    w.flush();
                    if (o.size() > 0) {
                        wrt.putRaw(4, o);
                    }
                    o = new ByteArrayOutputStream();
                    w = new TaggedWriter(o);
                    for (Map.Entry e : Telemeter.transpose(smapThreads).entrySet()) {
                        Telemeter.writeAtDescrEntry(((Integer)e.getKey()).intValue(), (String)e.getValue(), w);
                    }
                    w.flush();
                    if (o.size() > 0) {
                        wrt.putRaw(5, o);
                    }
                    wrt.flush();
                    writer.putRaw(5, tmp);
                    tmp = new ByteArrayOutputStream();
                    wrt = new TaggedWriter(tmp);
                    Statistics s = Core.stat;
                    wrt.putDouble(20, Core.getApplicationId());
                    wrt.putInt32(2, s.rqCount.get());
                    wrt.putDouble(3, DateTime.fromMillis(s.rqTime.get()));
                    wrt.putInt32(4, s.sqlCount.get());
                    wrt.putDouble(5, DateTime.fromMillis(s.sqlTime.get()));
                    wrt.putInt32(7, s.sqlRowsFetched.get());
                    wrt.putInt32(6, s.sqlRowsModified.get());
                    Object wl = DatabaseDescriptor.poolGatheredWorkloadInfo();
                    wrt.putInt32(9, ((DatabaseDescriptor.WorkloadInfo)wl).all);
                    wrt.putInt32(10, ((DatabaseDescriptor.WorkloadInfo)wl).used);
                    ByteArrayOutputStream mtmp = new ByteArrayOutputStream();
                    TaggedWriter mwrt = new TaggedWriter(mtmp);
                    mwrt.putInt32(1, (int)(javaHeap / 1024L));
                    mwrt.putInt32(5, (int)(javaMaxHeap / 1024L));
                    mwrt.putInt32(2, (int)(javaNonHeap / 1024L));
                    mwrt.putInt32(4, memUsage);
                    mwrt.putDouble(3, DateTime.fromMillis(gcTime));
                    mwrt.flush();
                    wrt.putRaw(12, mtmp);
                    wrt.putInt32(13, DatabaseDescriptor.getCurrentTotalWaitsCount());
                    wrt.putDouble(14, DateTime.fromMillis(DatabaseDescriptor.getCurrentTotalWaitTime()));
                    int maxrq = RequestExecutor.pollMaximumRequestCountTLM();
                    wrt.putInt32(15, maxrq);
                    wrt.putDouble(16, DateTime.fromMillis(RequestExecutor.getCurrentTotalRequestWaitForExecuteTime()));
                    double load = Math.max(((DatabaseDescriptor.WorkloadInfo)wl).load, (double)maxrq / (double)Ini.MaxThreads);
                    wrt.putDouble(17, load);
                    wrt.putInt32(18, Ini.MaxThreads);
                    wrt.putInt32(19, Ini.DbConnectionsLimit);
                    wrt.flush();
                    writer.putRaw(8, tmp);
                    writer.flush();
                    byte[] bytes = out.toByteArray();
                    this.state = 8;
                    long TS_sending = System.nanoTime();
                    wl = this;
                    synchronized (wl) {
                        this.cache = bytes;
                    }
                    long TS_end = System.nanoTime();
                    if (TS_end - TS_gathering <= 100000000L) continue;
                    Core.logger.warn("LONG telemetry gathering {} ms (wait: {}, init: {}, core: {} sh: {}, rq: {}, web: {}, heap: {}, gc: {}, tag: {}, out: {}", (TS_end - TS_gathering) / 1000000L, (TS_gathering - TS_ready) / 1000000L, (TS_core - TS_gathering) / 1000000L, (TS_sched - TS_core) / 1000000L, (TS_clients - TS_sched) / 1000000L, (TS_http - TS_clients) / 1000000L, (TS_heap - TS_http) / 1000000L, (TS_gcTime - TS_heap) / 1000000L, (TS_completing - TS_gcTime) / 1000000L, (TS_sending - TS_completing) / 1000000L, (TS_end - TS_sending) / 1000000L);
                }
                catch (Throwable e) {
                    Core.logger.error("Telemeter exception", e);
                    if (--exceptionsLeft >= 0) continue;
                    exceptionsLeft = 16;
                    TimeUnit.SECONDS.sleep(5L);
                }
            }
        }
        catch (Throwable e) {
            Core.logger.error("Telemeter died!", e);
            return;
        }
    }

    public static int genId() {
        return ID_GEN.incrementAndGet();
    }

    public static int JNI_status() {
        return instance.status();
    }

    public static byte[] JNI_gatheredTelemetry() {
        return instance.gatheredTelemetry();
    }

    public static void JNI_gatherTelemetry() {
        instance.gatherTelemetry();
    }

    public static String getRunningTaskLog() {
        return instance.doGetRunningTaskLog();
    }

    private String doGetRunningTaskLog() {
        Gatherer gatherer = new Gatherer(){
            final StringBuffer log = new StringBuffer();
            ThreadMXBean tb;

            public String toString() {
                return this.log.toString();
            }

            void writeThread(Thread thread) throws IOException {
                if (thread == null) {
                    return;
                }
                long tid = thread.getId();
                this.log.append(" thread: ").append(tid).append(" \"").append(thread.getName()).append('\"').append(" (state: ").append((Object)thread.getState()).append(')');
            }

            byte l2ub_clamp(long l) {
                return (byte)(l < 0L ? 0L : (l > 255L ? 255L : l));
            }

            @Override
            public void task(int taskId, int taskType, String state, Thread thread) throws IOException {
                this.log.append("\nTASK taskId: ").append(taskId).append(" type: ");
                switch (taskType) {
                    case 48: {
                        this.log.append("JOB");
                        break;
                    }
                    case 64: {
                        this.log.append("AUTHENTICATION");
                        break;
                    }
                    case 12: {
                        this.log.append("REQUEST");
                        break;
                    }
                    case 80: {
                        this.log.append("WEB");
                        break;
                    }
                    default: {
                        this.log.append(taskType);
                    }
                }
                this.log.append(" state: \"").append(state).append('\"').append(" pulse: ").append(Telemeter.this.pulse);
                this.writeThread(thread);
            }

            @Override
            public void job(int taskId, long duration, int pulse, boolean isImportantTask, String state, Thread thread) throws IOException {
                this.log.append("\nJOB taskId: ").append(taskId).append(" state: \"").append(state).append('\"').append(" time: ").append(duration).append(" pulse: ").append(pulse);
                if (isImportantTask) {
                    this.log.append(" important");
                }
                this.writeThread(thread);
            }

            @Override
            public void request(int taskId, int rqType, String rqName, long duration, Client client, int pulse, String state, Thread thread, String contextMessage, boolean vlong) throws IOException {
                ActionHooks.Duration dur;
                if (vlong) {
                    dur = ActionHooks.Duration.VERY_LONG;
                } else {
                    switch (rqType) {
                        case 63: 
                        case 67: 
                        case 501: 
                        case 511: 
                        case 512: {
                            dur = ActionHooks.Duration.LONG;
                            break;
                        }
                        case 99: {
                            dur = ActionHooks.Duration.VERY_LONG;
                            break;
                        }
                        default: {
                            dur = ActionHooks.Duration.NORMAL;
                        }
                    }
                }
                this.log.append("\nREQUEST taskId: ").append(taskId).append(" rqType: ").append(rqType).append(" (").append(rqName).append(')').append(" state: \"").append(state).append('\"').append(" duration: ").append((Object)dur).append(" time: ").append(duration).append(" pulse: ").append(pulse);
                if (!Strings.isVoid(contextMessage)) {
                    this.log.append(" context: ").append(contextMessage);
                } else if (client != null) {
                    this.log.append(" user: ").append(NumberConverter.doubleToString(client.getUserId()));
                }
                this.writeThread(thread);
            }

            @Override
            public void webRequest(int taskId, long duration, Session client, String state, Thread thread) throws IOException {
                Session.User u;
                this.log.append("\nWEB_REQUEST taskId: ").append(taskId).append(" state: \"").append(state).append('\"').append(" time: ").append(duration).append(" pulse: ").append(Telemeter.this.pulse);
                if (client != null && (u = client.user()) != null) {
                    this.log.append(" user: ").append(NumberConverter.doubleToString(u.id()));
                }
                this.writeThread(thread);
            }
        };
        try {
            this.state = 3;
            Core.gatherTelemetry(gatherer);
            this.state = 4;
            Sched.gatherTelemetry(gatherer);
            this.state = 5;
            ClientSession.gatherTelemetries(gatherer);
            this.state = 6;
            HttpServer.gatherTelemetry(gatherer);
            this.state = 7;
        }
        catch (Throwable e) {
            Core.logger.error("Telemeter.getRunningTaskLog() exception ", e);
        }
        return gatherer.toString();
    }

    private static class ThreadTimes
    implements LongHash.Entry {
        final long threadId;
        final long sliceTick;
        final long totalTime;
        final long userTime;

        ThreadTimes(long threadId, long sliceTick, long totalTime, long userTime) {
            this.threadId = threadId;
            this.sliceTick = sliceTick;
            this.totalTime = totalTime;
            this.userTime = userTime;
        }

        @Override
        public long key() {
            return this.threadId;
        }
    }

    private static class SMap {
        private final Map<String, Integer> map = new LinkedHashMap<String, Integer>();
        private final int offset;

        SMap(int offset) {
            this.offset = offset;
        }

        SMap() {
            this(0);
        }

        public int gen(String s) {
            if (s == null) {
                return 0;
            }
            Integer r = this.map.get(s);
            if (r == null) {
                r = this.map.size() + this.offset;
                this.map.put(s, r);
            }
            return r;
        }

        public void write(TaggedWriter writer) throws Throwable {
            if (this.map.isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, String> e : Telemeter.transpose(this.map).entrySet()) {
                Telemeter.writeAtDescrEntry(e.getKey().intValue(), e.getValue(), writer);
            }
        }
    }

    public static abstract class Gatherer {
        private final long time = System.currentTimeMillis();

        public long time() {
            return this.time;
        }

        public static boolean pending(Thread t) {
            switch (t.getState()) {
                case BLOCKED: 
                case TIMED_WAITING: 
                case WAITING: {
                    return true;
                }
            }
            return false;
        }

        public abstract void task(int var1, int var2, String var3, Thread var4) throws IOException;

        public abstract void request(int var1, int var2, String var3, long var4, Client var6, int var7, String var8, Thread var9, String var10, boolean var11) throws IOException;

        public abstract void webRequest(int var1, long var2, Session var4, String var5, Thread var6) throws IOException;

        public abstract void job(int var1, long var2, int var4, boolean var5, String var6, Thread var7) throws IOException;
    }
}

