/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.aves;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.aves.LocalRequest;
import inform.agent.aves.LocalRequestState;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.DxfWriter;
import inform.agent.schemes.MifWriter;
import inform.agent.schemes.OdgReader;
import inform.agent.schemes.OdgWriter;
import inform.agent.schemes.PdfWriter;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemesManager;
import inform.agent.schemes.SvgWriter;
import inform.agent.schemes.VisioOldFormatsConverter;
import inform.agent.schemes.VsdxReader;
import inform.agent.schemes.VsdxWriter;
import inform.agent.srv.ExternalConverter;
import inform.agent.srv.ProxyConverterService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;

public class Converter {
    private static final AtomicInteger requestCounter = new AtomicInteger();
    private static final ConcurrentHashMap<Integer, LocalRequest> requests = new ConcurrentHashMap();

    private static byte[] loadFile(String fileName) throws Exception {
        File file = new File(fileName);
        byte[] content = Files.readAllBytes(file.toPath());
        return content;
    }

    public static byte[] vsdxToAves(String fileName) throws Exception {
        Core.logger.info("start convert vsdx: " + fileName);
        byte[] content = Converter.loadFile(fileName);
        VsdxReader converter = new VsdxReader();
        byte[] result = converter.importVsdx(content);
        return result;
    }

    public static byte[] vssxToAves(String fileName) throws Exception {
        Core.logger.info("start convert vssx: " + fileName);
        byte[] content = Converter.loadFile(fileName);
        VsdxReader converter = new VsdxReader();
        byte[] result = converter.importVssx(content);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] convertAvesToVDX(byte[] avesContent) throws Exception {
        ConnectionManager connectionManager = new ConnectionManager(null, "");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Scheme scheme = SchemesManager.getScheme(0.0, avesContent, connectionManager.getSSHost(), null);
            VsdxWriter vsdxWriter = new VsdxWriter(scheme);
            vsdxWriter.setStateHost(connectionManager.getSSHost());
            vsdxWriter.saveToStream(connectionManager, out);
        }
        finally {
            connectionManager.release();
        }
        return out.toByteArray();
    }

    private static byte[] exportScheme(ConnectionManager dbMgr, TaggedReader reader, ServerSideHost host) throws InformException, IOException, TaggedReaderException, Exception {
        Scheme scheme = null;
        byte[] content = null;
        if (!reader.next()) {
            return null;
        }
        if (reader.getCurrentTag() == 103) {
            reader.takeNextTag();
            content = reader.getRaw();
            if (content == null || content.length == 0) {
                return null;
            }
            SchemeKeepSettings keepSettings = null;
            if (reader.getNextTag() == 49) {
                keepSettings = new SchemeKeepSettings(reader.getSubStreamReader());
                reader.takeNextTag();
            }
            scheme = SchemesManager.getScheme(0.0, content, dbMgr.getSSHost(), keepSettings);
        }
        if (reader.getCurrentTag() != 102) {
            return null;
        }
        int ext = reader.getInt();
        if (reader.getNextTag() == 106) {
            scheme.exportPageId = reader.getDouble();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        switch (ext) {
            case 1: {
                DxfWriter dxfWriter = new DxfWriter(scheme);
                dxfWriter.setStateHost(host);
                dxfWriter.saveToStream(dbMgr, out);
                break;
            }
            case 2: {
                SvgWriter svgWriter = new SvgWriter(scheme);
                svgWriter.setStateHost(host);
                svgWriter.saveToStream(dbMgr, out);
                break;
            }
            case 3: {
                PdfWriter pdfWriter = new PdfWriter(scheme);
                pdfWriter.setStateHost(host);
                pdfWriter.saveToStream(dbMgr, out);
                break;
            }
            case 4: {
                MifWriter mifWriter = new MifWriter(scheme);
                mifWriter.setStateHost(host);
                mifWriter.saveToStream(dbMgr, out);
                break;
            }
            case 5: {
                VsdxWriter vsdxWriter = new VsdxWriter(scheme);
                vsdxWriter.setStateHost(host);
                vsdxWriter.saveToStream(dbMgr, out);
                break;
            }
            case 8: {
                SvgWriter svgzWriter = new SvgWriter(scheme);
                svgzWriter.setStateHost(host);
                svgzWriter.saveToStream(dbMgr, new GZIPOutputStream(out));
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                OdgWriter odfWriter = new OdgWriter(scheme);
                odfWriter.setStateHost(host);
                odfWriter.saveToStream(dbMgr, out, ext == 15);
                break;
            }
            default: {
                throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442(" + ext + ") \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0441\u0445\u0435\u043c\u044b");
            }
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] contentToExport(byte[] content) throws Exception {
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(content));
        ConnectionManager dbMgr = new ConnectionManager(null, "");
        try {
            byte[] byArray = Converter.exportScheme(dbMgr, reader, null);
            return byArray;
        }
        finally {
            dbMgr.release();
        }
    }

    public static int startContentToExport(byte[] content) {
        LocalRequestState requestState = new LocalRequestState();
        CompletableFuture<Void> requestTask = new CompletableFuture<Void>();
        LocalRequest request = new LocalRequest(requestTask, requestState);
        int requestID = requestCounter.incrementAndGet();
        requests.put(requestID, request);
        CompletableFuture.runAsync(() -> {
            requestState.setState(LocalRequestState.ProcessState.EXECUTE);
            ConnectionManager dbMgr = new ConnectionManager(null, "");
            try {
                requestState.setState(LocalRequestState.ProcessState.EXECUTE);
                TaggedReader reader = new TaggedReader(new ByteArrayInputStream(content));
                byte[] res = Converter.exportScheme(dbMgr, reader, requestState);
                request.setResultRequest(res);
            }
            catch (UnsatisfiedLinkError err) {
                Converter.informRequestLinkError(request, err);
            }
            catch (Exception ex) {
                Converter.informRequestException(request, ex, "\u041e\u0448\u0438\u0431\u043a\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430");
            }
            catch (Throwable thr) {
                Converter.informRequestUnpredictableError(request, thr);
            }
            finally {
                requestTask.complete(null);
                dbMgr.release();
            }
        });
        return requestID;
    }

    public static int startWmfToAves(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 wmf/emf: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 wmf/emf", request -> {
            byte[] content = Converter.loadFile(fileName);
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(request.getRequestState());
            byte[] result = converter.importWmf(content);
            request.setResultRequest(result);
        });
    }

    public static int startWmfToAves(byte[] content) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 wmf/emf \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 wmf/emf \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", request -> {
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(request.getRequestState());
            byte[] result = converter.importWmf(content);
            request.setResultRequest(result);
        });
    }

    public static int startVsdxToAves(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsdx: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsdx", request -> {
            byte[] content = Converter.loadFile(fileName);
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(request.getRequestState());
            byte[] result = converter.importVsdx(content);
            request.setResultRequest(result);
        });
    }

    public static int startOdgToAves(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 odg/otg: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 odg/otg", request -> {
            byte[] content = Converter.loadFile(fileName);
            OdgReader converter = new OdgReader();
            converter.setStateHost(request.getRequestState());
            byte[] result = converter.importOdg(content, false);
            request.setResultRequest(result);
        });
    }

    public static int startFodgToAves(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 fodg: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 fodg", request -> {
            byte[] content = Converter.loadFile(fileName);
            OdgReader converter = new OdgReader();
            converter.setStateHost(request.getRequestState());
            byte[] result = converter.importOdg(content, true);
            request.setResultRequest(result);
        });
    }

    public static int startFodgToAves(byte[] content) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 odg/fodg/otg \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 odg/fodg/otg \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", request -> {
            OdgReader converter = new OdgReader();
            converter.setStateHost(request.getRequestState());
            byte[] result = converter.importOdg(content, true);
            request.setResultRequest(result);
        });
    }

    public static int startVsdToAvesLocal(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsd: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsd", request -> {
            LocalRequestState requestState = request.getRequestState();
            byte[] content = ExternalConverter.convertVsdToVsdx(fileName, requestState);
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(requestState);
            byte[] result = converter.importVsdx(content);
            request.setResultRequest(result);
        });
    }

    public static int startExportToVsdLocal(byte[] avesContent) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0432 \u0444\u0430\u0439\u043b vsd", "\u041e\u0448\u0438\u0431\u043a\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0432 \u0444\u0430\u0439\u043b vsd", request -> {
            byte[] result = ExternalConverter.convertVSDXtoVSD(Converter.convertAvesToVDX(avesContent), request.getRequestState());
            request.setResultRequest(result);
        });
    }

    public static int startVsdToAvesConverter(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsd \u0432 vsdx: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsd", request -> {
            byte[] content = Converter.loadFile(fileName);
            LocalRequestState requestState = request.getRequestState();
            VisioOldFormatsConverter vsdToVsdxConverter = new VisioOldFormatsConverter(requestState);
            content = vsdToVsdxConverter.convertOldVisioFormatToNew(content, VisioOldFormatsConverter.SaveFormat.VSDX);
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(requestState);
            converter.setImportFromOldFormat();
            byte[] result = converter.importVsdx(content);
            request.setResultRequest(result);
        });
    }

    public static int startVsdToAvesService(String server, String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsd:  " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vsd", request -> {
            LocalRequestState requestState = request.getRequestState();
            byte[] content = ProxyConverterService.convertVsdToVsdx(server, 4999, "\u0421\u0435\u0440\u0432\u0438\u0441", requestState, Converter.loadFile(fileName));
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(requestState);
            byte[] result = converter.importVsdx(content);
            request.setResultRequest(result);
        });
    }

    public static int startExportToVsdService(String server, byte[] avesContent) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0432 \u0444\u0430\u0439\u043b vsd", "\u041e\u0448\u0438\u0431\u043a\u0430 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0432 \u0444\u0430\u0439\u043b vsd", request -> {
            byte[] result = ProxyConverterService.convertVSDXtoVSD(server, 4999, "\u0421\u0435\u0440\u0432\u0438\u0441", request.getRequestState(), Converter.convertAvesToVDX(avesContent));
            request.setResultRequest(result);
        });
    }

    public static int startVssxToAves(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vssx: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vssx", request -> {
            byte[] content = Converter.loadFile(fileName);
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(request.getRequestState());
            byte[] result = converter.importVssx(content);
            request.setResultRequest(result);
        });
    }

    public static int startVssToAves(String fileName) {
        return Converter.startLocalImportRequest("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vss: " + fileName, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vss", request -> {
            byte[] content = Converter.loadFile(fileName);
            VisioOldFormatsConverter vssToVssxConverter = new VisioOldFormatsConverter(request.getRequestState());
            content = vssToVssxConverter.convertOldVisioFormatToNew(content, VisioOldFormatsConverter.SaveFormat.VSSX);
            Core.logger.info("\u0421\u0442\u0430\u0440\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 vssx: " + fileName);
            VsdxReader converter = new VsdxReader();
            converter.setStateHost(request.getRequestState());
            converter.setImportFromOldFormat();
            byte[] result = converter.importVssx(content);
            request.setResultRequest(result);
        });
    }

    public static int stateLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return -1;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getState().getValue();
    }

    public static byte[] resultLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return null;
        }
        return request.getResultRequest();
    }

    public static int progressMinLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return -1;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getProgressMin();
    }

    public static int progressMaxLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return -1;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getProgressMax();
    }

    public static int progressPositionLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return -1;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getProgressPosition();
    }

    public static String captionLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return null;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getCaption();
    }

    public static String textLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return null;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getText();
    }

    public static String instructionLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return null;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getInstruction();
    }

    public static String logLineLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return null;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getLogAndClear();
    }

    public static String errorTextLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return null;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getErrorText();
    }

    public static String errorDetailLocalRequest(int requestID) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return null;
        }
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        return requestState.getErrorTrace();
    }

    public static int cancelLocalRequest(int requestID, String message) {
        LocalRequest request = requests.getOrDefault(requestID, null);
        if (request == null) {
            return -1;
        }
        CompletableFuture<Void> requestTask = request.getRequestTask();
        assert (requestTask != null);
        if (requestTask.isDone()) {
            return -2;
        }
        requestTask.cancel(true);
        LocalRequestState requestState = request.getRequestState();
        assert (requestState != null);
        String str = message == null ? "\u041f\u0440\u0435\u0440\u0432\u0430\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c" : message;
        Core.logger.warn("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a JVM \u043f\u0440\u0435\u0440\u0432\u0430\u043d: " + str);
        requestState.setError(str, null);
        return 0;
    }

    public static int removeLocalRequest(int requestID) {
        LocalRequest request = null;
        try {
            request = requests.remove(requestID);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (request == null) {
            return -1;
        }
        CompletableFuture<Void> requestTask = request.getRequestTask();
        assert (requestTask != null);
        if (!requestTask.isDone()) {
            requestTask.cancel(true);
            return -2;
        }
        return 0;
    }

    private static void informRequestException(LocalRequest request, Throwable ex, String msg) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        LocalRequestState state = request.getRequestState();
        if (null != state) {
            state.setError(msg, sw.toString());
        }
        CompletableFuture<Void> task = request.getRequestTask();
        Core.logger.error(msg, ex);
    }

    private static void informRequestLinkError(LocalRequest request, UnsatisfiedLinkError err) {
        String msg = "\u041e\u0442\u0441\u0443\u0442\u0432\u0443\u0435\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430\u044f java.\n\u0415\u0441\u043b\u0438 \u0443 \u0432\u0430\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 Headless \u0432\u0435\u0440\u0441\u0438\u044f java, \u043d\u0443\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e";
        Converter.informRequestException(request, err, msg);
        throw InformException.wrap(err);
    }

    private static void informRequestUnpredictableError(LocalRequest request, Throwable thr) {
        String msg = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430, \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043e \u043d\u0435\u0439 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c.\n\u041f\u0440\u0438\u043b\u043e\u0436\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438:\n\u0421\u043f\u0440\u0430\u0432\u043a\u0430 -> \u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 -> \u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430 -> \u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0432 \u0444\u0430\u0439\u043b";
        Converter.informRequestException(request, thr, msg);
        throw InformException.wrap(thr);
    }

    private static int startLocalImportRequest(String startMsg, String errorMsg, StartableLocalImportRequest actions) {
        LocalRequestState requestState = new LocalRequestState();
        CompletableFuture<Void> requestTask = new CompletableFuture<Void>();
        LocalRequest request = new LocalRequest(requestTask, requestState);
        int requestID = requestCounter.incrementAndGet();
        requests.put(requestID, request);
        CompletableFuture.runAsync(() -> {
            Core.logger.info(startMsg);
            requestState.setState(LocalRequestState.ProcessState.EXECUTE);
            try {
                actions.start(request);
            }
            catch (Exception ex) {
                Converter.informRequestException(request, ex, errorMsg);
            }
            catch (UnsatisfiedLinkError err) {
                Converter.informRequestLinkError(request, err);
            }
            catch (Throwable thr) {
                Converter.informRequestUnpredictableError(request, thr);
            }
            finally {
                if (!requestTask.isCancelled() && !requestTask.isDone()) {
                    requestTask.complete(null);
                }
            }
        });
        return requestID;
    }

    static void waitLocalRequest(int requestID) {
        LocalRequest request = requests.get(requestID);
        if (null == request) {
            return;
        }
        CompletableFuture<Void> requestTask = request.getRequestTask();
        assert (requestTask != null);
        if (requestTask.isDone() || requestTask.isCompletedExceptionally() || requestTask.isCancelled()) {
            return;
        }
        requestTask.join();
    }

    private static interface StartableLocalImportRequest {
        public void start(LocalRequest var1) throws Throwable;
    }
}

