/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.LinkField;
import inform.agent.db.types.DataType;
import inform.agent.scripts.DatasetField;
import java.io.IOException;
import java.util.ArrayList;

public class LinkDescriptor
implements IntegerHash.Entry {
    public static final int TAG_LINKS_REL_FEILD_ID = 10;
    public static final int TAG_LINKS_MASTER_PRI_KEY = 11;
    public static final int TAG_LINKS_NULL_VAL = 12;
    public static final int TAG_LINKS_INTEGER_VAL = 13;
    public static final int TAG_LINKS_DOUBLE_VAL = 14;
    public static final int TAG_LINKS_STRING_VAL = 15;
    public static final int TAG_LINKS_DATETIME_VAL = 16;
    public static final int TAG_LINKS_RECORD_FIELDS = 17;
    public static final int TAG_LINKS_REL_PARAM_TYPE = 18;
    private int id = 0;
    private String name = null;
    private String caption = null;
    private double table = 0.0;
    private ArrayList<LinkField> fields = new ArrayList();
    private boolean updateKeys = false;
    private boolean rowsOwnership = false;

    public ArrayList<LinkField> getFields() {
        return this.fields;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public String toString() {
        return this.caption + " [" + this.id + "]";
    }

    public boolean isRowsOwnership() {
        return this.rowsOwnership;
    }

    public double getTable() {
        return this.table;
    }

    public boolean isUpdateKeys() {
        return this.updateKeys;
    }

    LinkField loadTag(int tag, TaggedReader reader, LinkField linkField) throws IOException, TaggedReaderException {
        switch (tag) {
            case 1: {
                this.id = reader.getInt();
                break;
            }
            case 2: {
                this.name = reader.getAnsi();
                break;
            }
            case 4: {
                this.caption = reader.getAnsi();
                break;
            }
            case 5: {
                this.updateKeys = true;
                break;
            }
            case 6: {
                this.rowsOwnership = true;
                break;
            }
            case 3: {
                this.table = reader.getNodeID();
                break;
            }
            case 10: {
                linkField = null;
                int fieldId = reader.getInt();
                for (LinkField field : this.fields) {
                    if (fieldId != field.getFieldId()) continue;
                    linkField = field;
                    break;
                }
                if (linkField != null) break;
                linkField = new LinkField(fieldId);
                this.fields.add(linkField);
                break;
            }
            case 11: {
                if (linkField == null) break;
                linkField.setFieldIdLink(reader.getInt());
                break;
            }
            case 12: {
                if (linkField == null) break;
                linkField.setPrimaryKeyLink();
                break;
            }
            case 15: {
                if (linkField == null) break;
                linkField.setConstIntLink(reader.getInt());
                break;
            }
            case 16: {
                if (linkField == null) break;
                linkField.setConstDoubleLink(reader.getDouble());
                break;
            }
            case 17: {
                if (linkField == null) break;
                linkField.setConstAnsiStringLink(reader.getAnsi());
                break;
            }
            case 18: {
                if (linkField == null) break;
                linkField.setConstDateTimeLink(reader.getDouble());
            }
        }
        return linkField;
    }

    public void loadRelations(TaggedReader reader) throws IOException, TaggedReaderException {
        LinkField linkField = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 10: {
                    int fieldId = reader.getInt();
                    linkField = new LinkField(fieldId);
                    this.fields.add(linkField);
                    break;
                }
                case 11: 
                case 14: {
                    assert (linkField != null);
                    linkField.appendConstNumberLink(reader.getDouble(), DataType.FLOAT);
                    break;
                }
                case 12: {
                    assert (linkField != null);
                    linkField.appendConstValueLink(null, null);
                    break;
                }
                case 13: {
                    assert (linkField != null);
                    linkField.appendConstNumberLink(reader.getInt(), DataType.INTEGER);
                    break;
                }
                case 15: {
                    assert (linkField != null);
                    linkField.appendConstValueLink(reader.getAnsi(), DataType.STRING);
                    break;
                }
                case 16: {
                    assert (linkField != null);
                    linkField.appendConstNumberLink(reader.getDouble(), DataType.DATE_TIME);
                    break;
                }
            }
        }
    }

    public static void generateRelationFieldValue(TaggedWriter out, DatasetField field) throws IOException {
        if (field.getIsNull()) {
            out.putEmpty(12);
        } else {
            switch (field.getDataType()) {
                case BOOLEAN: 
                case INTEGER: {
                    out.putInt32(13, (int)field.getAsNumber());
                    break;
                }
                case FLOAT: 
                case INTERVAL: 
                case DIRECTORY: 
                case METATREE_NODE: {
                    out.putDouble(14, field.getAsNumber());
                    break;
                }
                case DATE_TIME: {
                    out.putDouble(16, field.getAsNumber());
                    break;
                }
                case STRING: 
                case BIG_NUMBER: {
                    out.putAnsi(15, field.getAsString());
                    break;
                }
                default: {
                    out.putEmpty(12);
                }
            }
        }
    }

    @Override
    public int key() {
        return this.id;
    }
}

