/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;

public class SearchFilterExpressionBuilder {
    public static final int cndNone = 0;
    public static final int cndEqual = 1;
    public static final int cndNotEqual = 2;
    public static final int cndMore = 3;
    public static final int cndMoreOrEqual = 4;
    public static final int cndLess = 5;
    public static final int cndLessOrEqual = 6;
    public static final int cndLike = 7;
    public static final int cndNotLike = 8;
    public static final int cndLikeEx = 9;
    public static final int cndNotLikeEx = 10;
    public static final int cndExpression = 11;
    public static final int cndIn = 12;
    public static final int cndNotIn = 13;
    public static final int uoNone = 0;
    public static final int uoAND = 1;
    public static final int uoOR = 2;
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private TaggedWriter out = new TaggedWriter(this.data);

    public void addExpression(int braceCount, int condition, int unionOperator) throws IOException {
        ByteArrayOutputStream rec = new ByteArrayOutputStream();
        LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(rec);
        stream.writeInt(braceCount);
        stream.writeInt(condition);
        stream.writeInt(unionOperator);
        stream.flush();
        this.out.putRaw(1, rec);
    }

    public void setExpresionModificator(int modificator) throws IOException {
        this.out.putInt32(12, modificator);
    }

    public void setOperandProc(int proc) throws IOException {
        this.out.putInt32(13, proc);
    }

    public void addFieldOperand(int entryId, int fieldId, boolean isPrior) throws IOException {
        ByteArrayOutputStream rec = new ByteArrayOutputStream();
        LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(rec);
        stream.writeInt(entryId);
        stream.writeInt(fieldId);
        stream.flush();
        if (isPrior) {
            this.out.putRaw(10, rec);
        } else {
            this.out.putRaw(2, rec);
        }
    }

    public void addParamId(int val) throws IOException {
        this.out.putInt32(8, val);
    }

    public void addInt(int val) throws IOException {
        this.out.putInt32(3, val);
    }

    public void addDouble(double val) throws IOException {
        this.out.putDouble(4, val);
    }

    public void addRecordId(double val) throws IOException {
        this.out.putDouble(9, val);
    }

    public void addDateTime(double val) throws IOException {
        this.out.putDouble(6, val);
    }

    public void addString(String val) throws IOException {
        this.out.putAnsi(5, val);
    }

    public void addNull() throws IOException {
        this.out.putEmpty(7);
    }

    public void storeAs(int tag, TaggedWriter writer) throws IOException {
        this.out.flush();
        writer.putRaw(tag, this.data);
    }
}

