/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.GeneratedSql;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.DataType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class SearchGeneratedSql
extends GeneratedSql {
    private InputStream parameters;
    private boolean failedSort = false;

    public SearchGeneratedSql(byte[] data) throws IOException, TaggedReaderException {
        this(new ByteArrayInputStream(data));
    }

    public SearchGeneratedSql(ByteArrayInputStream data) throws IOException, TaggedReaderException {
        TaggedReader reader = new TaggedReader(data);
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.hasError = true;
                    this.error = reader.getAnsi();
                    break;
                }
                case 2: {
                    this.sqlText = reader.getAnsi();
                    break;
                }
                case 3: {
                    this.parameters = reader.getSubStream();
                    break;
                }
                case 4: {
                    this.emptyDataset = true;
                    break;
                }
                case 5: {
                    this.advanced = true;
                    break;
                }
                case 7: {
                    this.disabledLockRecords = true;
                    break;
                }
                case 8: {
                    this.validForSelectBlob = true;
                    break;
                }
                case 9: {
                    this.subject = true;
                    break;
                }
                case 10: {
                    this.failedSort = true;
                    break;
                }
                case 11: {
                    this.hasPrimaryKeyExpression = true;
                    break;
                }
                case 12: {
                    this.errorDetailing = reader.getAnsi();
                }
            }
        }
    }

    @Override
    public GeneratedSql.Sorting getSortingGeneration() {
        if (this.failedSort) {
            return GeneratedSql.Sorting.FAILED;
        }
        return GeneratedSql.Sorting.DEFAULT;
    }

    @Override
    public TaggedReader getParamersReader() {
        return new TaggedReader(this.parameters);
    }

    @Override
    public boolean appendParametersTo(PreparedStatement statement) throws IOException, SQLException, TaggedReaderException {
        boolean result = true;
        TaggedReader reader = new TaggedReader(this.parameters);
        int paramIndex = statement.getParamValuesCount();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    int typeId = reader.getInt();
                    DataType dataType = DataType.getDataTypeById(typeId);
                    if (dataType == null || dataType == DataType.NONE) {
                        result = false;
                        break;
                    }
                    statement.setNull(++paramIndex, dataType.toSqlDataType());
                    break;
                }
                case 8: {
                    statement.setBoolean(++paramIndex, reader.getInt() != 0);
                    break;
                }
                case 2: {
                    statement.setInt(++paramIndex, reader.getInt());
                    break;
                }
                case 3: {
                    statement.setDouble(++paramIndex, reader.getDouble());
                    break;
                }
                case 4: {
                    statement.setString(++paramIndex, reader.getAnsi());
                    break;
                }
                case 5: {
                    statement.setBlob(++paramIndex, reader.getRaw());
                    break;
                }
                case 6: {
                    double phenixDate = reader.getDouble();
                    statement.setDateTime(++paramIndex, phenixDate);
                    break;
                }
                case 7: {
                    statement.setString(++paramIndex, reader.getUnicode());
                }
            }
        }
        return result;
    }

    @Override
    public void logParameters(int index, StringBuilder log) {
        if (this.parameters == null) {
            return;
        }
        try {
            int comma = 123;
            TaggedReader reader = new TaggedReader(this.parameters);
            while (reader.getNextTag() != 0) {
                log.append((char)comma);
                switch (reader.getCurrentTag()) {
                    case 1: {
                        int typeId = reader.getInt();
                        DataType dataType = DataType.getDataTypeById(typeId);
                        this.logParameter(log, index++, dataType).append("null");
                        break;
                    }
                    case 8: {
                        this.logParameter(log, index++, DataType.BOOLEAN).append(reader.getInt() != 0);
                        break;
                    }
                    case 2: {
                        this.logParameter(log, index++, DataType.INTEGER).append(reader.getInt());
                        break;
                    }
                    case 3: {
                        this.logParameter(log, index++, DataType.FLOAT).append(NumberConverter.doubleToString(reader.getDouble()));
                        break;
                    }
                    case 4: {
                        this.logParameter(log, index++, DataType.STRING).append(reader.getAnsi());
                        break;
                    }
                    case 5: {
                        this.logParameter(log, index++, DataType.BLOB).append(reader.getCurrentTagSize()).append(" bytes");
                        break;
                    }
                    case 6: {
                        this.logParameter(log, index++, DataType.DATE_TIME).append(DateTime.toString(reader.getDouble()));
                        break;
                    }
                    case 7: {
                        this.logParameter(log, index++, DataType.UNICODE).append(reader.getAnsi());
                    }
                }
                comma = 44;
            }
            if (comma != 123) {
                log.append('}');
            }
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    public StringBuilder logParameter(StringBuilder log, int index, DataType type) {
        log.append(PreparedStatement.sqlDataType2char(type == null ? null : type.toSqlDataType())).append(index).append('@');
        return log;
    }
}

