/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.DateTimeFormat;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.Parameter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class SearchParameters {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private TaggedWriter writer = new TaggedWriter(this.data);

    public void addBlob(BinaryObject blob) throws IOException {
        this.writer.putRaw(10, blob.getInternalBuffer(), blob.getSize());
    }

    public void addParameter(int paramId) throws IOException {
        this.writer.putInt32(1, paramId);
    }

    public void setIgnored() throws IOException {
        this.writer.putEmpty(7);
    }

    public void addNull() throws IOException {
        this.writer.putEmpty(2);
    }

    public void addInt(int v) throws IOException {
        this.writer.putInt32(3, v);
    }

    public void addDouble(double v) throws IOException {
        this.writer.putDouble(4, v);
    }

    public void addDate(double v) throws IOException {
        this.writer.putDouble(5, v);
    }

    public void addDate(Date v) throws IOException {
        this.writer.putDate(5, v);
    }

    public void addDatePair(double beginDate, double endDate) throws IOException {
        this.writer.putDouble(8, beginDate);
        this.writer.putDouble(9, endDate);
    }

    public void addDatePair(Date startDate, Date endDate) throws IOException {
        this.writer.putDate(8, startDate);
        this.writer.putDate(9, endDate);
    }

    public void addString(String v) throws IOException {
        this.writer.putAnsi(6, v);
    }

    public void addUnicode(String v) throws IOException {
        this.writer.putUnicode(11, v);
    }

    public void load(byte[] bytes) throws IOException {
        this.writer.flush();
        this.data.write(bytes);
    }

    public void loadEx(byte[] content) throws IOException, TaggedReaderException {
        TaggedReader in = new TaggedReader(content);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    int[] header = LittleEndian.toIntArray(in.getRaw());
                    this.addParameter(header[0]);
                    break;
                }
                case 7: {
                    this.setIgnored();
                    break;
                }
                case 10: {
                    this.addInt(in.getInt());
                    break;
                }
                case 11: {
                    this.addDouble(in.getDouble());
                    break;
                }
                case 12: {
                    this.addString(in.getAnsi());
                    break;
                }
                case 13: {
                    this.addDate(in.getDouble());
                    break;
                }
                case 14: {
                    this.addNull();
                }
            }
        }
    }

    public void storeAs(TaggedWriter writer) throws IOException {
        this.writer.flush();
        writer.putRaw(15, this.data);
    }

    public byte[] getData() throws IOException {
        this.writer.flush();
        return this.data.toByteArray();
    }

    public static void addDate(double value, DateTimeFormat format, SearchParameters params) throws IOException, InformException {
        Calendar cal = DateTime.toCalendar(value);
        switch (format) {
            case DD: {
                break;
            }
            case DD_MM: {
                break;
            }
            case DD_MM_YYYY: {
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                long seconds = cal.getTimeInMillis() / 1000L;
                double startDate = DateTime.fromUnixTime(seconds * 1000L);
                cal.add(5, 1);
                seconds = cal.getTimeInMillis() / 1000L;
                double endDate = DateTime.fromUnixTime(seconds * 1000L);
                params.addDatePair(startDate, endDate);
                break;
            }
            case DD_MM_YYYY_HH_mm: {
                cal.set(13, cal.getActualMinimum(13));
                long seconds = cal.getTimeInMillis() / 1000L;
                double startDate = DateTime.fromUnixTime(seconds * 1000L);
                cal.add(12, 1);
                cal.set(13, cal.getActualMinimum(13));
                seconds = cal.getTimeInMillis() / 1000L;
                double endDate = DateTime.fromUnixTime(seconds * 1000L);
                params.addDatePair(startDate, endDate);
                break;
            }
            case HH: 
            case HH_mm: 
            case HH_mm_SS: 
            case DD_MM_YYYY_HH_mm_SS: {
                params.addDate(value);
                break;
            }
            case MM_YYYY: {
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                cal.set(5, cal.getActualMinimum(5));
                long seconds = cal.getTimeInMillis() / 1000L;
                double startDate = DateTime.fromUnixTime(seconds * 1000L);
                cal.set(5, cal.getActualMaximum(5));
                seconds = cal.getTimeInMillis() / 1000L;
                double endDate = DateTime.fromUnixTime(seconds * 1000L);
                params.addDatePair(startDate, endDate);
                break;
            }
            case YYYY: {
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                cal.set(5, cal.getActualMinimum(5));
                cal.set(2, cal.getActualMinimum(2));
                long seconds = cal.getTimeInMillis() / 1000L;
                double startDate = DateTime.fromUnixTime(seconds * 1000L);
                cal.set(2, cal.getActualMaximum(2));
                cal.set(5, cal.getActualMaximum(5));
                seconds = cal.getTimeInMillis() / 1000L;
                double endDate = DateTime.fromUnixTime(seconds * 1000L);
                params.addDatePair(startDate, endDate);
                break;
            }
            case QUARTER_YYYY: {
                double startDate;
                long seconds;
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                cal.set(5, cal.getActualMinimum(5));
                int month = cal.get(2);
                if (0 <= month && month <= 2) {
                    cal.set(2, 0);
                    seconds = cal.getTimeInMillis() / 1000L;
                    startDate = DateTime.fromUnixTime(seconds * 1000L);
                    cal.set(2, 3);
                } else if (3 <= month && month <= 5) {
                    cal.set(2, 3);
                    seconds = cal.getTimeInMillis() / 1000L;
                    startDate = DateTime.fromUnixTime(seconds * 1000L);
                    cal.set(2, 6);
                } else if (6 <= month && month <= 8) {
                    cal.set(2, 6);
                    seconds = cal.getTimeInMillis() / 1000L;
                    startDate = DateTime.fromUnixTime(seconds * 1000L);
                    cal.set(2, 9);
                } else if (9 <= month && month <= 11) {
                    cal.set(2, 9);
                    seconds = cal.getTimeInMillis() / 1000L;
                    startDate = DateTime.fromUnixTime(seconds * 1000L);
                    cal.add(2, 3);
                } else {
                    throw new InformException("\u0421\u0442\u0440\u0430\u043d\u043d\u0430\u044f \u0434\u0430\u0442\u0430: " + cal.getTime().toString());
                }
                cal.set(5, cal.getActualMaximum(5));
                seconds = cal.getTimeInMillis() / 1000L;
                double endDate = DateTime.fromUnixTime(seconds * 1000L);
                params.addDatePair(startDate, endDate);
            }
        }
    }

    public static void addParamValue(Parameter p, SearchParameters params) throws IOException, InformException {
        Object v = p.getRawValue();
        if (v == null) {
            params.addNull();
        } else {
            switch (p.getDataType()) {
                case BLOB: {
                    params.addBlob(p.getAsBinary());
                    break;
                }
                case DIRECTORY: 
                case FLOAT: 
                case INTERVAL: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addDouble(ValueCaster.toDouble(o));
                        }
                        break;
                    }
                    params.addDouble(ValueCaster.toDouble(v));
                    break;
                }
                case BOOLEAN: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addInt(ValueCaster.toBoolean(o) != false ? 1 : 0);
                        }
                        break;
                    }
                    params.addInt(ValueCaster.toBoolean(v) != false ? 1 : 0);
                    break;
                }
                case DATE_TIME: {
                    if (v instanceof DateTimeInterval) {
                        params.addDatePair(((DateTimeInterval)v).getStartDate(), ((DateTimeInterval)v).getEndDate());
                        break;
                    }
                    DateTimeFormat format = DateTimeFormat.getFormatById(p.getFormatId());
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            SearchParameters.addDate(ValueCaster.toDouble(o), format, params);
                        }
                        break;
                    }
                    SearchParameters.addDate(ValueCaster.toDouble(v), format, params);
                    break;
                }
                case INTEGER: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addInt(ValueCaster.toInt(o));
                        }
                        break;
                    }
                    params.addInt(ValueCaster.toInt(v));
                    break;
                }
                case BIG_NUMBER: 
                case STRING: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addString(ValueCaster.toString(o));
                        }
                        break;
                    }
                    params.addString(ValueCaster.toString(v));
                    break;
                }
                case UNICODE: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addUnicode(ValueCaster.toString(o));
                        }
                        break;
                    }
                    params.addUnicode(ValueCaster.toString(v));
                }
            }
        }
    }
}

