/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.commit;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerDoubleMap;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.FieldValueGenerator;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.PhenixLinks;
import inform.agent.db.ReplicationData;
import inform.agent.db.TableDescriptor;
import inform.agent.db.TableLinkList;
import inform.agent.db.commit.AuditInfo;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.CommitException;
import inform.agent.db.commit.DeleteEngine;
import inform.agent.db.commit.MultipleWriteProtectionInfo;
import inform.agent.db.commit.MultipleWriteProtectionInfoList;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.ParentRowInfo;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlCommandBatch;
import inform.agent.db.utils.SqlExecutor;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.db.utils.TableRelationInfo;
import inform.agent.files.BFS;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.net.AlertingEngine;
import inform.agent.replication.ReplicationRecord;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.ServerSideTableStorer;
import inform.agent.scripts.format.FormatManager;
import inform.agent.scripts.textutils.ExtractionDataInfo;
import inform.agent.scripts.textutils.TextExtractor;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class CommitRequest
extends Request
implements SqlCommandBatch.FlushListener {
    private static final int OUT_CHUNK_LIMIT = 0x1000000;
    private static final int WARN_TABLE_STATS_TIMEOUT = 5555;
    public static final int TAG_MODIFY_RECORD = 1;
    public static final int TAG_APPEND_RECORD = 2;
    public static final int TAG_DELETE_RECORD = 3;
    public static final int TAG_MODIFIED_FIELD_ID = 4;
    public static final int TAG_MODIFIED_TABLE_ID = 5;
    public static final int TAG_MAKE_LINK = 6;
    public static final int TAG_DROP_LINK = 7;
    public static final int TAG_NULL = 10;
    public static final int TAG_INTEGER_VAL = 11;
    public static final int TAG_DOUBLE_VAL = 12;
    public static final int TAG_STRING_VAL = 13;
    public static final int TAG_DATETIME_VAL = 14;
    public static final int TAG_RAW_DATA_VAL = 15;
    public static final int TAG_CLONE_RECORD = 16;
    public static final int TAG_CLONE_SOURCE_RECORD = 17;
    public static final int TAG_CLONE_ELEMENTS = 18;
    public static final int TAG_APPEND_PARENT = 19;
    public static final int TAG_UPDATE_RELATION = 20;
    public static final int TAG_UPDATE_PRIMARY_KEY = 22;
    public static final int TAG_CHANGED_PRIMARY_KEY = 23;
    public static final int TAG_UNICODE_VAL = 24;
    public static final int TAG_MULTIPLEWRITEPROTECTION_START_LABEL_NULL = 25;
    public static final int TAG_MULTIPLEWRITEPROTECTION_START_LABEL = 26;
    public static final int TAG_MULTIPLEWRITEPROTECTION_END_LABEL = 27;
    public static final int TAG_AUDIT_EVENT_ID = 28;
    public static final int TAG_COMMIT_OWNER_NODE_ID = 29;
    public static final int TAG_COMMIT_CURRENT_OWNER_NODE_ID = 30;
    public static final int TAG_COMMIT_CURRENT_UID = 31;
    public static final int TAG_MULTIPLE_PRIMARY_KEY = 32;
    public static final int TAG_DELETE_RECORD_MPK = 33;
    public static final int TAG_BOOLEAN_VAL = 34;
    public static final int TAG_BLOB_FILE_CHECKSUM = 35;
    public static final int TAG_COMMIT_CHECK_REFERENCES_MESSAGE = 36;
    public static final int TAG_ORIGINAL_VALUES = 37;
    public static final int TAG_MODIFICATION_ID = 38;
    public static final int TAG_MODIFICATION_RESULT_FIELD_ID = 39;
    public static final int TAG_MODIFICATION_RESULT_NUMBER = 40;
    public static final int TAG_MODIFICATION_RESULT_STRING = 41;
    public static final int TAG_MODIFICATION_SILENTLY = 42;
    public static final int TAG_MODIFIED_DATABASE_ID = 55;
    public static final int TAG_MULTIPLE_DATABASE = 56;
    private static final int TAG_CLONE_ELEMENTS_OPTS = 1;
    private static final int TAG_CLONE_ELEMENTS_LINKS = 2;
    private static final int TAG_TBL_LINK_TABLE = 3;
    private static final int TAG_TBL_LINK_ID = 1;
    private static final char comma = ',';
    private double tableNodeId = 0.0;
    private double currentDatabaseId = 0.0;
    private double ownerId = 0.0;
    private double eventId = 0.0;
    private double currentOwnerId = 0.0;
    private int currentUID = 0;
    private int currentModificationId = 0;
    private BFS blobfs = null;
    private boolean securityChanged;
    private UsersTable usersTable = null;
    private DatasourceLogContext dlcHead;
    private SSContext.CommitDatasource dsContext = null;
    private SSContext prevContext = null;
    private double committingDatabaseId = 0.0;
    private DatabaseConnection database = null;
    private DatabaseCaps caps = null;
    private TableDataAudit auditWriter = null;
    private DeleteEngine deleteEngine = null;
    private long warnTotalTime;
    private TableStat tableStat;
    private DoubleHash<TableStat> warnStat = new DoubleHash();
    private TSO warnTSO;

    public CommitRequest(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    private void updateContex() {
        SSContext.CommitDatasource context = this.dsContext;
        this.dsContext = SSContext.CommitDatasource.getContext(this.ssContext, this.currentOwnerId, this.currentUID, this.tableNodeId, this.dsContext);
        if (this.dsContext != context) {
            this.prevContext = this.dsContext;
            this.deleteEngine.setContext(this.dsContext);
            this.auditWriter.setContext(this.dsContext);
        }
    }

    private void updateConnection(double databaseId, double userNodeId, ReplicationData replications, ConnectionManager connectionManager) throws SQLException {
        if (this.committingDatabaseId == databaseId) {
            return;
        }
        this.committingDatabaseId = databaseId;
        this.database = connectionManager.getConnection(this.committingDatabaseId, "rq:CommitRequest.updateConnection");
        this.caps = this.database.getDescriptor().getDatabaseType().caps();
        this.auditWriter = this.database.getTableDataAudit();
        if (this.auditWriter != null) {
            this.deleteEngine = this.database.getDeleteEngine();
        } else {
            this.auditWriter = new TableDataAudit(this.ssContext, this.database, userNodeId, this.getEffectiveUserID(), 0.0, 0.0, this.getSessionID());
            this.auditWriter.setBatchMode(true);
            this.database.transaction(this.auditWriter);
            this.deleteEngine = new DeleteEngine(this.ssContext, connectionManager, replications, userNodeId, this);
            this.deleteEngine.setAuditWriter(this.auditWriter);
            this.database.setDeleteEngine(this.deleteEngine);
            this.auditWriter.setOwnerId(this.ownerId);
            this.auditWriter.setAuditEventId(this.eventId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            return;
        }
        long commitRequestTime = System.currentTimeMillis();
        this.securityChanged = false;
        ServerSideExecutable ssTable = null;
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:CommitRequest");
        try {
            long warnTime;
            double databaseNodeId = this.getNodeID();
            double userNodeId = this.getUserID();
            TableDescriptor tableInfo = null;
            int modificationId = 0;
            DoubleSet changedAuthSet = null;
            double usersTableId = new UsersTable(false).getTableID();
            ReplicationData replications = new ReplicationData();
            SqlCommandBatch modifyCommand = new SqlCommandBatch(this);
            TaggedReader in = this.createRequestContentReader();
            StringBuilder warnTimeLog = null;
            this.warnTotalTime = 0L;
            this.prevContext = this.ssContext;
            CommitCommand command = new CommitCommand();
            byte[] originalFields = Empty.byteArray;
            while (in.getNextTag() != 0) {
                this.idle();
                command.clear();
                this.currentModificationId = modificationId;
                modificationId = 0;
                switch (in.getCurrentTag()) {
                    case 28: {
                        this.eventId = in.getDouble();
                        break;
                    }
                    case 5: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        double nodeId = in.getDouble();
                        if (this.tableStat != null && tableInfo != null && tableInfo.getNodeId() != nodeId) {
                            this.tableStat.begin();
                            this.deleteEngine.applyDelete();
                            this.tableStat.update(TSO.DELETE);
                            warnTime = CommitRequest.flushModify(this.dsContext, this.database, modifyCommand);
                            this.tableStat.update(this.warnTSO, warnTime);
                            this.tableStat = null;
                        }
                        this.tableNodeId = nodeId;
                        command.silently = false;
                        this.updateContex();
                        if (tableInfo == null || tableInfo.getNodeId() != this.tableNodeId) {
                            if (ssTable != null) {
                                ssTable.save();
                                ServerSideExecutable sst = ssTable;
                                ssTable = null;
                                sst.close();
                            }
                            BasicNode tableNode = MtdEngine.getValidTranslatedNode(this.tableNodeId);
                            switch (tableNode.getType()) {
                                case 12: {
                                    tableInfo = ((TableNode)tableNode).getDescriptor();
                                    if (tableInfo.getKind() != TableDescriptor.Kind.VIRTUAL) break;
                                    throw new InformException("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439");
                                }
                                case 48: {
                                    ssTable = new ServerSideTableStorer(this.dsContext, tableNode, this, connectionManager);
                                    tableInfo = ((ServerSideTableStorer)ssTable).tableDescriptor();
                                    this.tableNodeId = tableInfo.getNodeId();
                                }
                            }
                            this.checkSecurityChanging();
                        }
                        if (this.tableStat == null) {
                            this.tableStat = this.warnStat.get(this.tableNodeId);
                            if (this.tableStat == null) {
                                this.tableStat = new TableStat(tableInfo.getNodeId());
                                this.warnStat.add(this.tableStat);
                            }
                        }
                        this.currentDatabaseId = tableInfo.getDbId();
                        modifyCommand.setTableDesc(tableInfo);
                        break;
                    }
                    case 37: {
                        originalFields = in.getRaw();
                        break;
                    }
                    case 42: {
                        command.silently = in.getBoolean();
                        break;
                    }
                    case 1: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        this.tableStat.count(TSO.UPDATE);
                        this.tableStat.begin();
                        this.deleteEngine.applyDelete();
                        this.tableStat.update(TSO.DELETE);
                        assert (tableInfo != null);
                        this.updateContex();
                        this.checkModifyTable(tableInfo);
                        double recordId = in.getDouble();
                        double newRecordId = 0.0;
                        if (in.getNextTag() == 23) {
                            command.silently = false;
                            newRecordId = in.getDouble();
                            replications.primaryKeyChanged(this.tableNodeId, newRecordId, recordId);
                        }
                        byte[] modifiedFields = in.getRaw(202);
                        if (ssTable != null) {
                            command.silently = false;
                            ((ServerSideTableStorer)ssTable).applyChange(recordId, modifiedFields, originalFields);
                            if (((ServerSideTableStorer)ssTable).virtualTable()) break;
                        }
                        originalFields = null;
                        this.generateUpdateSql(this.dsContext, this.database, command, new TaggedReader(modifiedFields), recordId, tableInfo, this.auditWriter, connectionManager, this.caps);
                        command.silently = false;
                        if (command.avoidBatch) {
                            warnTime = CommitRequest.flushModify(this.prevContext, this.database, modifyCommand);
                            this.tableStat.update(this.warnTSO, warnTime);
                            command.setTableDescriptor(tableInfo);
                            this.tableStat.begin();
                            int updatedRowCount = command.executeUpdate(this.dsContext, this.database);
                            this.tableStat.update(TSO.UPDATE);
                            if (updatedRowCount != 1) {
                                StringBuilder msg = new StringBuilder();
                                msg.append("\u041f\u0430\u0440\u0430\u043b\u043b\u0435\u043b\u044c\u043d\u043e\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 ").append(" [").append(tableInfo.getNodeId()).append("] ").append(tableInfo.getCaption()).append(" [row id: ").append(recordId).append("] ");
                                throw new CommitException(msg);
                            }
                        } else {
                            this.tableStat.begin();
                            modifyCommand.add(command, this.database, recordId, true, this.dsContext);
                            this.tableStat.update(this.warnTSO);
                            this.pushDsLogCtxIfNeed();
                        }
                        this.warnTSO = TSO.UPDATE;
                        if (newRecordId == 0.0) {
                            this.auditWriter.registrateModification(tableInfo, recordId, AuditModification.MODIFY);
                        } else {
                            this.auditWriter.registrateModification(tableInfo, newRecordId, AuditModification.MODIFY, recordId);
                        }
                        replications.add(this.tableNodeId, 0, recordId);
                        if (usersTableId != this.tableNodeId) break;
                        VirtualUser.outdateUser(recordId);
                        if (changedAuthSet == null) {
                            changedAuthSet = new DoubleSet();
                        }
                        changedAuthSet.add(recordId);
                        break;
                    }
                    case 2: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        command.silently = false;
                        this.tableStat.count(TSO.INSERT);
                        this.tableStat.begin();
                        this.deleteEngine.applyDelete();
                        this.tableStat.update(TSO.DELETE);
                        this.updateContex();
                        assert (tableInfo != null);
                        this.checkAddToTable(tableInfo);
                        double recordId = in.getDouble();
                        ParentRowInfo replicationRowParent = new ParentRowInfo();
                        if (in.getNextTag() == 19) {
                            LittleEndianDataInputStream stream = new LittleEndianDataInputStream(in.getStream());
                            replicationRowParent.setTagUploadedRowLink(stream);
                        }
                        byte[] modifiedFields = in.getRaw(202);
                        if (ssTable != null) {
                            ((ServerSideTableStorer)ssTable).applyAppend(recordId, modifiedFields);
                            if (((ServerSideTableStorer)ssTable).virtualTable()) break;
                        }
                        this.generateAppendSqlText(this.dsContext, this.database, command, new TaggedReader(modifiedFields), recordId, tableInfo, this.auditWriter, connectionManager, this.caps);
                        this.tableStat.begin();
                        modifyCommand.add(command, this.database, this.dsContext);
                        this.tableStat.update(this.warnTSO);
                        this.warnTSO = TSO.INSERT;
                        this.pushDsLogCtxIfNeed();
                        this.auditWriter.registrateModification(tableInfo, recordId, AuditModification.APPEND);
                        replications.add(this.tableNodeId, 1, recordId, replicationRowParent);
                        if (usersTableId != this.tableNodeId) break;
                        if (changedAuthSet == null) {
                            changedAuthSet = new DoubleSet();
                        }
                        changedAuthSet.add(recordId);
                        break;
                    }
                    case 36: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        this.deleteEngine.setCheckReferencesMessage(in.getAnsi());
                        break;
                    }
                    case 3: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        assert (tableInfo != null);
                        command.silently = false;
                        this.tableStat.count(TSO.DELETE);
                        this.updateContex();
                        this.checkTableAccess(tableInfo, 0x800000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                        double recordId = in.getDouble();
                        warnTime = CommitRequest.flushModify(this.prevContext, this.database, modifyCommand);
                        this.tableStat.update(this.warnTSO, warnTime);
                        if (ssTable != null) {
                            ((ServerSideTableStorer)ssTable).applyDelete(recordId, originalFields);
                            if (((ServerSideTableStorer)ssTable).virtualTable()) break;
                        }
                        originalFields = null;
                        if (this.blobfs == null) {
                            this.blobfs = new BFS();
                            this.deleteEngine.setBlobfs(this.blobfs);
                        }
                        this.deleteEngine.deleteRow(this.tableNodeId, recordId);
                        this.auditWriter.registrateModification(tableInfo, recordId, AuditModification.DELETE);
                        replications.add(this.tableNodeId, 2, recordId);
                        break;
                    }
                    case 33: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        assert (tableInfo != null);
                        command.silently = false;
                        this.tableStat.count(TSO.DELETE);
                        this.updateContex();
                        this.checkTableAccess(tableInfo, 0x800000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                        warnTime = CommitRequest.flushModify(this.prevContext, this.database, modifyCommand);
                        this.tableStat.update(this.warnTSO, warnTime);
                        this.deleteEngine.deleteRow(this.tableNodeId, in.getRaw());
                        break;
                    }
                    case 6: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        command.silently = false;
                        in.checkCurrentTag(6, 36);
                        PhenixLinks.LinkRecord link = new PhenixLinks.LinkRecord();
                        int linkId = link.setBinaryOptions(in.getRaw());
                        if (linkId < 0 || linkId > 4) break;
                        TableDescriptor rightInfo = TableDescriptor.get(link.right.table);
                        this.checkTableAccess(rightInfo, 0x1000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u0441\u0432\u044f\u0437\u0438 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                        this.tableStat.begin();
                        this.deleteEngine.applyDelete();
                        this.tableStat.update(TSO.DELETE);
                        this.updateContex();
                        warnTime = CommitRequest.flushModify(this.prevContext, this.database, modifyCommand);
                        this.tableStat.update(this.warnTSO, warnTime);
                        if (linkId == 2) {
                            this.createLinkedRelation(this.dsContext, link, this.database);
                            this.auditWriter.registrateModification(tableInfo, link.right.row, AuditModification.LINK_CREATE);
                            break;
                        }
                        if (linkId != 1) break;
                        this.linkElementRelation(this.dsContext, link, this.database);
                        break;
                    }
                    case 7: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        command.silently = false;
                        in.checkCurrentTag(7, 36);
                        PhenixLinks.LinkRecord link = new PhenixLinks.LinkRecord();
                        int linkId = link.setBinaryOptions(in.getRaw());
                        if (linkId != 2) break;
                        TableDescriptor rightInfo = TableDescriptor.get(link.right.table);
                        this.checkTableAccess(rightInfo, 0x1000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u0441\u0432\u044f\u0437\u0438 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                        this.tableStat.begin();
                        this.deleteEngine.applyDelete();
                        this.tableStat.update(TSO.DELETE);
                        this.updateContex();
                        warnTime = CommitRequest.flushModify(this.prevContext, this.database, modifyCommand);
                        this.tableStat.update(this.warnTSO, warnTime);
                        SqlExecutor drop = PhenixLinks.createDeleteExecutor(this.dsContext, linkId, this.database);
                        ((SqlParameter)drop.params.get(0)).setDouble(link.left.table);
                        ((SqlParameter)drop.params.get(1)).setDouble(link.left.row);
                        ((SqlParameter)drop.params.get(2)).setDouble(link.right.table);
                        ((SqlParameter)drop.params.get(3)).setDouble(link.right.row);
                        try {
                            drop.executeUpdateCached();
                            break;
                        }
                        finally {
                            drop.close();
                        }
                    }
                    case 18: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        command.silently = false;
                        this.updateContex();
                        PhenixLinks.LinkRecord link = new PhenixLinks.LinkRecord();
                        TaggedReader stream = in.getStreamReader();
                        stream.checkCurrentTag(1, 36);
                        int linkId = link.setBinaryOptions(stream.getRaw(1));
                        TableDescriptor rightInfo = TableDescriptor.get(link.right.table);
                        this.checkAddToTable(rightInfo);
                        ArrayList<LinkInfo> copiedLinks = new ArrayList<LinkInfo>();
                        if (stream.getNextTag() == 2) {
                            LinkInfo r = null;
                            while (stream.next()) {
                                switch (stream.getCurrentTag()) {
                                    case 3: {
                                        r = new LinkInfo();
                                        copiedLinks.add(r);
                                        stream.skip();
                                        r.table = stream.getDouble(151);
                                        break;
                                    }
                                    case 1: {
                                        assert (r != null);
                                        r.linkId = stream.getInt();
                                    }
                                }
                            }
                        }
                        if (this.tableNodeId == link.left.table) {
                            ArrayList<ClonedRowInfo> clonedRows = new ArrayList<ClonedRowInfo>();
                            ClonedRowInfo info = new ClonedRowInfo();
                            info.table = link.left.table;
                            info.sourceRow = link.left.row;
                            info.cloneRow = link.right.row;
                            this.cloneRelated(this.dsContext, tableInfo, link.left.row, link.right.row, this.database, this.auditWriter, copiedLinks, clonedRows);
                        }
                        this.cloneElement(this.dsContext, this.database, link, this.auditWriter);
                        break;
                    }
                    case 16: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        command.silently = false;
                        this.tableStat.count(TSO.INSERT);
                        this.tableStat.begin();
                        this.deleteEngine.applyDelete();
                        this.tableStat.update(TSO.DELETE);
                        this.updateContex();
                        warnTime = CommitRequest.flushModify(this.prevContext, this.database, modifyCommand);
                        this.tableStat.update(this.warnTSO, warnTime);
                        assert (tableInfo != null);
                        this.checkAddToTable(tableInfo);
                        double recordId = in.getDouble();
                        double sourceRecordId = in.getDouble(17);
                        TaggedReader fieldReader = in.getStreamReader(202);
                        this.generateCloneSqlText(this.dsContext, command, fieldReader, recordId, sourceRecordId, tableInfo, connectionManager);
                        this.tableStat.begin();
                        command.executeUpdate(this.dsContext, this.database);
                        this.tableStat.update(TSO.INSERT);
                        this.auditWriter.registrateModification(tableInfo, recordId, AuditModification.APPEND);
                        replications.add(this.tableNodeId, 1, recordId);
                        break;
                    }
                    case 20: {
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        command.silently = false;
                        this.tableStat.count(TSO.UPDATE);
                        this.tableStat.begin();
                        this.deleteEngine.applyDelete();
                        this.tableStat.update(TSO.DELETE);
                        this.updateContex();
                        warnTime = CommitRequest.flushModify(this.prevContext, this.database, modifyCommand);
                        this.tableStat.update(this.warnTSO, warnTime);
                        assert (tableInfo != null);
                        this.checkModifyTable(tableInfo);
                        this.generateUpdateLinkSqlText(this.dsContext, command, in, connectionManager);
                        this.tableStat.begin();
                        command.executeUpdate(this.dsContext, this.database);
                        this.tableStat.update(TSO.UPDATE);
                        break;
                    }
                    case 29: {
                        this.ssContext.ownerId = this.ownerId = in.getDouble();
                        this.rqstat.ownerId = this.ownerId;
                        break;
                    }
                    case 30: {
                        double tempDbl;
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        this.currentOwnerId = tempDbl = in.getDouble();
                        if (this.currentOwnerId == 0.0) {
                            this.auditWriter.setOwnerId(this.ownerId);
                            break;
                        }
                        this.auditWriter.setOwnerId(this.currentOwnerId);
                        break;
                    }
                    case 31: {
                        int tempInt;
                        this.currentUID = tempInt = in.getInt();
                        break;
                    }
                    case 38: {
                        command.silently = false;
                        modificationId = in.getInt();
                        break;
                    }
                    case 55: {
                        databaseNodeId = in.getDouble();
                        if (this.database != null) {
                            this.deleteEngine.applyDelete();
                            this.tableStat.update(TSO.DELETE);
                            warnTime = CommitRequest.flushModify(this.dsContext, this.database, modifyCommand);
                            this.tableStat.update(this.warnTSO, warnTime);
                            if (ssTable != null) {
                                ssTable.save();
                            }
                            this.auditWriter.flush();
                        }
                        this.updateConnection(databaseNodeId, userNodeId, replications, connectionManager);
                        break;
                    }
                    case 56: {
                        connectionManager.rootConnectionMode(true);
                    }
                }
            }
            this.tableStat.begin();
            if (this.database != null) {
                this.deleteEngine.applyDelete();
                this.tableStat.update(TSO.DELETE);
                warnTime = CommitRequest.flushModify(this.dsContext, this.database, modifyCommand);
                this.tableStat.update(this.warnTSO, warnTime);
                if (ssTable != null) {
                    ssTable.save();
                }
                this.auditWriter.flush();
            }
            connectionManager.commit();
            if (this.securityChanged) {
                AccountNode.invalidateSecurity();
            }
            if (this.blobfs != null) {
                this.blobfs.commit();
            }
            if (changedAuthSet != null) {
                for (Cursor.Double user : changedAuthSet) {
                    AuditJournal.registerAuthChangeEvent(this.ssContext, userNodeId, this.getSessionID(), user.value);
                }
            }
            if ((commitRequestTime = System.currentTimeMillis() - commitRequestTime) > 5555L) {
                long warnTotalTime = 0L;
                long warnTotalCount = 0L;
                for (TableStat s : this.warnStat) {
                    warnTimeLog = this.tableStat.flush(warnTimeLog, this.ownerId);
                    warnTotalTime += this.tableStat.warnTotalTime;
                    warnTotalCount += this.tableStat.warnTotalCount;
                }
                if (warnTimeLog != null) {
                    warnTimeLog.append("\n\u0412\u0441\u0435\u0433\u043e \u043f\u043e\u0442\u0440\u0430\u0447\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435, \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435, \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435: ").append(warnTotalCount).append(" \u0448\u0442, ").append(warnTotalTime).append(" \u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
                    warnTimeLog.append("\n\u041e\u0431\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430: ").append(commitRequestTime).append(" \u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
                    this.putRequestStateSysLogInfo(warnTimeLog.toString());
                }
            }
            this.sendResult();
            if (!replications.isEmpty()) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                TaggedWriter stream = new TaggedWriter(bytes);
                replications.serialize(stream);
                stream.flush();
                AlertingEngine.sendChangeNotification(this.client(), bytes.internalBuffer(), bytes.size(), 999L);
            }
        }
        catch (Throwable ex) {
            if (this.blobfs != null) {
                this.blobfs.rollback();
            }
            connectionManager.rollback();
            throw InformException.detail(ex, this.getLogInfo());
        }
        finally {
            if (ssTable != null) {
                try {
                    ssTable.close();
                }
                catch (Throwable e) {
                    Core.logger.error("ssTable.close", e);
                }
            }
            connectionManager.release();
        }
    }

    private static void throwUpdateCountError(TableDescriptor tableDescriptor) {
        throw new CommitException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430:" + tableDescriptor.toString() + ")");
    }

    private static void throwUpdateCountError(TableDescriptor tableDescriptor, double recordId) {
        throw new CommitException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430:" + tableDescriptor.toString() + ")").detail("[recordId: " + (long)recordId + "]");
    }

    private static void throwUpdateCountError(TableDescriptor tableDescriptor, double[] recordIds) {
        if (recordIds != null && recordIds.length > 0) {
            StringBuilder detail = new StringBuilder();
            int sep = 58;
            detail.append("[recordIds");
            for (double r : recordIds) {
                detail.append((char)sep).append(' ').append((long)r);
                sep = 44;
            }
            detail.append(']');
            throw new CommitException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430:" + tableDescriptor.toString() + ")").detail(detail.toString());
        }
        throw new CommitException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430:" + tableDescriptor.toString() + ")");
    }

    public static long flushModify(SSContext context, DatabaseConnection database, SqlCommandBatch modifyCommand) throws SQLException {
        long warnTime = System.currentTimeMillis();
        SqlCommandBatch.BatchResult r = modifyCommand.executeBatch(database, context);
        warnTime = System.currentTimeMillis() - warnTime;
        if (r == null) {
            return warnTime;
        }
        if (r.result != null) {
            boolean checked = true;
            for (int i = 0; i < r.result.length; ++i) {
                int count = r.result[i];
                if (count < 0) {
                    checked = false;
                    break;
                }
                if (count == 1) continue;
                if (r.records != null && r.records.length > 0) {
                    CommitRequest.throwUpdateCountError(modifyCommand.getTableDesc(), r.records[i]);
                    continue;
                }
                CommitRequest.throwUpdateCountError(modifyCommand.getTableDesc(), r.records);
            }
            if (checked) {
                return warnTime;
            }
        }
        int count = 0;
        if (r.result != null) {
            count = r.result.length;
        }
        if (count != r.updateCount || count != r.batchCount || r.batchCount != r.updateCount) {
            CommitRequest.throwUpdateCountError(modifyCommand.getTableDesc(), r.records);
        }
        return warnTime;
    }

    private boolean isInLinksList(ArrayList<LinkInfo> copiedLinks, double table, int linkId) {
        for (LinkInfo i : copiedLinks) {
            if (i.linkId != linkId || i.table != table) continue;
            return true;
        }
        return false;
    }

    private double findInClonedRows(ArrayList<ClonedRowInfo> clonedRows, double table, double row) {
        for (ClonedRowInfo i : clonedRows) {
            if (i.table != table || i.sourceRow != row && i.cloneRow != row) continue;
            return i.cloneRow;
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneRelated(SSContext context, TableDescriptor tableInfo, double leftRow, double rightRow, DatabaseConnection database, TableDataAudit auditWriter, ArrayList<LinkInfo> copiedLinks, ArrayList<ClonedRowInfo> clonedRows) throws IOException, InformException, SQLException {
        TableLinkList linkList = tableInfo.getLinkList();
        for (LinkDescriptor linkDescriptor : linkList.getLinks()) {
            if (!linkDescriptor.isUpdateKeys()) continue;
            for (LinkField linkField : linkDescriptor.getFields()) {
                if (linkField.getLinkType() != 3 || !this.isInLinksList(copiedLinks, linkDescriptor.getTable(), linkDescriptor.getId())) continue;
                TableDescriptor relInfo = TableDescriptor.get(linkDescriptor.getTable());
                SqlStringBuilder sql = new SqlStringBuilder();
                sql.append("select ").append(relInfo.getRecordIdField()).append(" from ").appendFull(relInfo).append(" where ").append(relInfo.getExistingFieldDescriptor(linkField.getFieldId())).append("=?");
                DoubleSet relatedRows = new DoubleSet();
                try (PreparedStatement statement = database.prepareStatement(this.getLogInfo(), sql.toString());){
                    statement.setQueryTimeout();
                    statement.setDouble(1, leftRow);
                    try (ResultSet fetch = statement.executeQuery(context);){
                        while (fetch.next()) {
                            relatedRows.add(fetch.getDouble(1));
                        }
                    }
                }
                for (Cursor.Double c : relatedRows) {
                    double relId = c.value;
                    double cloned_row_id = 0.0;
                    double ring_cloned_row_id = this.findInClonedRows(clonedRows, relInfo.getNodeId(), relId);
                    if (ring_cloned_row_id != 0.0) {
                        if (ring_cloned_row_id != relId) continue;
                        for (FieldDescriptor f : relInfo.getFields()) {
                            if (f.getId() != linkField.getFieldId()) continue;
                            sql = new SqlStringBuilder();
                            sql.append("update ").appendFull(relInfo).append(" set ").append(f).append(" = ? where ").append(relInfo.getRecordIdField()).append(" = ?");
                            statement = database.prepareStatement(this.getLogInfo(), sql.toString());
                            try {
                                statement.setDouble(1, rightRow);
                                statement.setDouble(2, ring_cloned_row_id);
                                statement.executeUpdate(context);
                            }
                            finally {
                                statement.close();
                            }
                        }
                        continue;
                    }
                    SqlStringBuilder fields1 = new SqlStringBuilder();
                    SqlStringBuilder fields2 = new SqlStringBuilder();
                    if (relInfo.getKind() == TableDescriptor.Kind.INTERNAL) {
                        fields1.append(relInfo.getRecordIdField());
                        cloned_row_id = Core.generateId();
                        fields2.append(cloned_row_id);
                    }
                    for (FieldDescriptor f : relInfo.getFields()) {
                        if (f.isVirtual()) continue;
                        fields1.append(',').append(f);
                        if (f.getId() == linkField.getFieldId()) {
                            fields2.append(',').append(rightRow);
                            continue;
                        }
                        if (relInfo.getKind() == TableDescriptor.Kind.EXTERNAL && f.isPrimaryKey()) {
                            cloned_row_id = Core.generateId();
                            fields2.append(',').append(cloned_row_id);
                            continue;
                        }
                        fields2.append(',').append(f);
                    }
                    sql = new SqlStringBuilder();
                    sql.append("insert into ").appendFull(relInfo).append(" (");
                    if (relInfo.getKind() == TableDescriptor.Kind.EXTERNAL) {
                        if (fields1.length() > 0) {
                            fields1.setChatAt(0, ' ');
                        }
                        if (fields2.length() > 0) {
                            fields2.setChatAt(0, ' ');
                        }
                    }
                    sql.append(fields1).append(") select ").append(fields2).append(" from ").appendFull(relInfo).append(" TSRC1 where TSRC1.").append(relInfo.getRecordIdField()).append('=').append(relId);
                    statement = database.prepareStatement(this.getLogInfo(), sql.toString());
                    try {
                        statement.executeUpdate(context);
                        if (!(cloned_row_id > 0.0)) continue;
                        ClonedRowInfo cloned_row = new ClonedRowInfo();
                        clonedRows.add(cloned_row);
                        cloned_row.sourceRow = relId;
                        cloned_row.cloneRow = cloned_row_id;
                        cloned_row.table = relInfo.getNodeId();
                        auditWriter.registrateModification(relInfo, cloned_row_id, AuditModification.APPEND);
                        this.cloneRelated(context, relInfo, relId, cloned_row_id, database, auditWriter, copiedLinks, clonedRows);
                    }
                    finally {
                        statement.close();
                    }
                }
            }
        }
    }

    private void prepareAppendExtractionTextFields(DatabaseCaps caps, AuditInfo auditInfo, TableDescriptor tableInfo, FieldDescriptor fieldInfo, double recordId, SqlCommand command, StringBuilder fields, StringBuilder values, char dlm, byte[] blobData) throws Exception {
        IntegerSet extractionFields;
        String text = null;
        ExtractionDataInfo info = new ExtractionDataInfo(tableInfo, fieldInfo, recordId);
        TextExtractor textExtractor = new TextExtractor(blobData, info);
        TextExtractor.DOCUMENT_FORMAT format = textExtractor.getFormat();
        if (format != null && format != TextExtractor.DOCUMENT_FORMAT.DOCUMENT_BINARY) {
            text = textExtractor.extractText();
        }
        if ((extractionFields = fieldInfo.getExtractionTextFields()) == null) {
            return;
        }
        block3: for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor extractionFieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
            fields.append(dlm).append(extractionFieldInfo.getRawName());
            values.append(dlm).append(caps.tranformSqlParameter(extractionFieldInfo));
            int size = TextExtractor.maxTextLength(extractionFieldInfo);
            if (size > 0 && text != null && text.length() > size) {
                command.params.add(new SqlParameter().setString(text.substring(0, size)));
            } else {
                command.params.add(new SqlParameter().setString(text));
            }
            command.addModifiedField(fieldId);
            switch (extractionFieldInfo.getType()) {
                case BLOB: {
                    if (extractionFieldInfo.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) continue block3;
                    auditInfo.setField(extractionFieldInfo);
                    auditInfo.setBlob(text != null ? text.getBytes() : null);
                    continue block3;
                }
            }
            auditInfo.setField(extractionFieldInfo);
            auditInfo.setString(text);
        }
    }

    private void prepareAppendExtractionTextFieldsAsNull(AuditInfo auditInfo, TableDescriptor tableInfo, IntegerSet extractionFields, SqlCommand command, StringBuilder fields, StringBuilder values, char dlm) throws SQLException {
        if (extractionFields == null) {
            return;
        }
        for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor extractionFieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
            fields.append(dlm).append(extractionFieldInfo.getRawName());
            values.append(dlm).append("NULL");
            command.addModifiedField(fieldId);
            auditInfo.setField(extractionFieldInfo);
            auditInfo.setNull();
        }
    }

    private int prepareUpdateExtractionTextFields(DatabaseCaps caps, AuditInfo auditInfo, TableDescriptor tableInfo, FieldDescriptor fieldInfo, double recordId, SqlCommand command, char dlm1, char dlm2, byte[] blobData) throws Exception {
        String text = null;
        ExtractionDataInfo info = new ExtractionDataInfo(tableInfo, fieldInfo, recordId);
        TextExtractor textExtractor = new TextExtractor(blobData, info);
        TextExtractor.DOCUMENT_FORMAT format = textExtractor.getFormat();
        if (format != null && format != TextExtractor.DOCUMENT_FORMAT.DOCUMENT_BINARY) {
            text = textExtractor.extractText();
        }
        char dlm = dlm1;
        int cnt = 0;
        IntegerSet extractionFields = fieldInfo.getExtractionTextFields();
        if (extractionFields == null) {
            return cnt;
        }
        for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor extractionFieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
            command.sqlText.append(dlm).append(extractionFieldInfo.getRawName());
            command.sqlText.append("=").append(caps.tranformSqlParameter(extractionFieldInfo));
            int size = TextExtractor.maxTextLength(extractionFieldInfo);
            if (size > 0 && text != null && text.length() > size) {
                command.params.add(new SqlParameter().setString(text.substring(0, size)));
            } else {
                command.params.add(new SqlParameter().setString(text));
            }
            command.addModifiedField(fieldId);
            switch (extractionFieldInfo.getType()) {
                case BLOB: {
                    if (extractionFieldInfo.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) break;
                    auditInfo.setField(extractionFieldInfo);
                    auditInfo.setBlob(text != null ? text.getBytes() : null);
                    break;
                }
                default: {
                    auditInfo.setField(extractionFieldInfo);
                    auditInfo.setString(text);
                }
            }
            dlm = dlm2;
            ++cnt;
        }
        return cnt;
    }

    private int prepareUpdateExtractionTextFieldsAsNull(AuditInfo auditInfo, TableDescriptor tableInfo, IntegerSet extractionFields, SqlCommand command, char dlm1, char dlm2) throws SQLException {
        char dlm = dlm1;
        int cnt = 0;
        if (extractionFields == null) {
            return cnt;
        }
        for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor extractionFieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
            command.sqlText.append(dlm).append(extractionFieldInfo.getRawName());
            command.sqlText.append("=NULL");
            command.addModifiedField(fieldId);
            auditInfo.setField(extractionFieldInfo);
            auditInfo.setNull();
            dlm = dlm2;
            ++cnt;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneElement(SSContext context, DatabaseConnection database, PhenixLinks.LinkRecord link, TableDataAudit auditWriter) throws InformException, SQLException {
        ArrayList<ClonedElementRecord> sou_elements = new ArrayList<ClonedElementRecord>();
        ClonedElementRecord elem_rec = new ClonedElementRecord();
        sou_elements.add(elem_rec);
        elem_rec.table = link.left.table;
        elem_rec.sourceRow = link.left.row;
        elem_rec.cloneRow = link.right.row;
        try (SqlExecutor selectRight = PhenixLinks.createSelectRightTableExecutor(context, 1, database);){
            for (int i = 0; i < sou_elements.size(); ++i) {
                double parent_table_id;
                ClonedElementRecord element = (ClonedElementRecord)sou_elements.get(i);
                if (i != 0) {
                    element.cloneRow = Core.generateId();
                    parent_table_id = element.table;
                } else {
                    parent_table_id = link.right.table;
                }
                ((SqlParameter)selectRight.params.get(0)).setDouble(element.table);
                ((SqlParameter)selectRight.params.get(1)).setDouble(element.sourceRow);
                try (ResultSet fetch = selectRight.executeQueryCached();){
                    while (fetch.next()) {
                        elem_rec = new ClonedElementRecord();
                        sou_elements.add(elem_rec);
                        elem_rec.table = fetch.getDouble(1);
                        elem_rec.sourceRow = fetch.getDouble(2);
                        elem_rec.cloneParentRow = element.cloneRow;
                        elem_rec.parentTable = parent_table_id;
                        elem_rec.cloneRow = 0.0;
                    }
                    continue;
                }
            }
        }
        if (sou_elements.size() <= 1) {
            return;
        }
        sou_elements.remove(0);
        try (SqlExecutor insert = PhenixLinks.createInsertExecutor(this.ssContext, 1, database);){
            for (ClonedElementRecord el : sou_elements) {
                ((SqlParameter)insert.params.get(0)).setDouble(el.parentTable);
                ((SqlParameter)insert.params.get(1)).setDouble(el.cloneParentRow);
                ((SqlParameter)insert.params.get(2)).setDouble(el.table);
                ((SqlParameter)insert.params.get(3)).setDouble(el.cloneRow);
                insert.executeUpdateCached();
            }
        }
        for (ClonedElementRecord el : sou_elements) {
            TableDescriptor table_info = TableDescriptor.getIfExists(el.table);
            if (table_info == null) continue;
            SqlStringBuilder fields = new SqlStringBuilder();
            for (FieldDescriptor f : table_info.getFields()) {
                if (f.isVirtual()) continue;
                fields.append(',').append(f);
            }
            SqlStringBuilder sql = new SqlStringBuilder();
            sql.append("insert into ").append(table_info).append(" (");
            if (table_info.getKind() == TableDescriptor.Kind.INTERNAL) {
                sql.append("ID");
            } else if (fields.length() > 0) {
                fields.setChatAt(0, ' ');
            }
            sql.append(fields).append(") select ");
            if (table_info.getKind() == TableDescriptor.Kind.INTERNAL) {
                sql.append(el.cloneRow);
            }
            sql.append(fields).append(" from ").append(table_info).append(" TSRC where TSRC.").append(table_info.getRecordIdField()).append("=?");
            try (PreparedStatement statement = database.prepareStatement(this.getLogInfo(), sql.toString());){
                statement.setQueryTimeout();
                statement.setDouble(1, el.sourceRow);
                statement.executeUpdate(context);
            }
            auditWriter.registrateModification(table_info, el.cloneRow, AuditModification.APPEND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkElementRelation(SSContext context, PhenixLinks.LinkRecord link, DatabaseConnection connection) throws SQLException {
        block13: {
            try (SqlExecutor select = PhenixLinks.createSelectRightTableExecutor(context, 1, connection);){
                ((SqlParameter)select.params.get(0)).setDouble(link.right.table);
                ((SqlParameter)select.params.get(1)).setDouble(link.right.row);
                try (ResultSet resultSet = select.executeQueryCached();){
                    if (resultSet.next()) {
                        try (SqlExecutor update = PhenixLinks.createUpdateLeftExecutor(context, 1, connection);){
                            ((SqlParameter)update.params.get(0)).setDouble(link.left.table);
                            ((SqlParameter)update.params.get(1)).setDouble(link.left.row);
                            ((SqlParameter)update.params.get(2)).setDouble(link.right.table);
                            ((SqlParameter)update.params.get(3)).setDouble(link.right.row);
                            update.executeUpdateCached();
                            this.idle();
                            break block13;
                        }
                    }
                    try (SqlExecutor insert = PhenixLinks.createInsertExecutor(context, 1, connection);){
                        ((SqlParameter)insert.params.get(0)).setDouble(link.left.table);
                        ((SqlParameter)insert.params.get(1)).setDouble(link.left.row);
                        ((SqlParameter)insert.params.get(2)).setDouble(link.right.table);
                        ((SqlParameter)insert.params.get(3)).setDouble(link.right.row);
                        insert.executeUpdateCached();
                        this.idle();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkedRelation(SSContext context, PhenixLinks.LinkRecord link, DatabaseConnection connection) throws SQLException {
        SqlExecutor drop = PhenixLinks.createDeleteExecutor(context, 2, connection);
        ((SqlParameter)drop.params.get(0)).setDouble(link.left.table);
        ((SqlParameter)drop.params.get(1)).setDouble(link.left.row);
        ((SqlParameter)drop.params.get(2)).setDouble(link.right.table);
        ((SqlParameter)drop.params.get(3)).setDouble(link.right.row);
        try {
            drop.executeUpdateCached();
        }
        finally {
            drop.close();
        }
        try (SqlExecutor insert = PhenixLinks.createInsertExecutor(context, 2, connection);){
            ((SqlParameter)insert.params.get(0)).setDouble(link.left.table);
            ((SqlParameter)insert.params.get(1)).setDouble(link.left.row);
            ((SqlParameter)insert.params.get(2)).setDouble(link.right.table);
            ((SqlParameter)insert.params.get(3)).setDouble(link.right.row);
            insert.executeUpdateCached();
            this.idle();
        }
    }

    public static boolean skipSetFieldValue(FieldDescriptor fieldInfo, boolean isInsert) {
        switch (fieldInfo.getAutoValueGenerator()) {
            case TIMESTAMP: 
            case USER: 
            case EFFECTIVE_USER: 
            case COMPUTER_NAME: 
            case WINDOWS_USER_NAME: 
            case COMPUTER_IP: 
            case SESSION: 
            case BLOBSIZE: {
                if (isInsert) {
                    return true;
                }
                return !fieldInfo.isCalcValueGeneratorForInsertOnly();
            }
        }
        return false;
    }

    public static void checkCanModifyField(TableDescriptor tableInfo, FieldDescriptor fieldInfo, boolean strongCheck) throws CommitException {
        if (strongCheck) {
            switch (fieldInfo.getAutoValueGenerator()) {
                case TIMESTAMP: 
                case USER: 
                case EFFECTIVE_USER: 
                case COMPUTER_NAME: 
                case WINDOWS_USER_NAME: 
                case COMPUTER_IP: 
                case SESSION: 
                case BLOBSIZE: {
                    StringBuilder msg = new StringBuilder();
                    msg.append("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f \"").append(fieldInfo.getCaption()).append("\"(\u0442\u0430\u0431\u043b\u0438\u0446\u0430: ").append(tableInfo.getNodeId()).append(", id \u043f\u043e\u043b\u044f: ").append(fieldInfo.getId()).append("), \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0433\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439(").append((Object)fieldInfo.getAutoValueGenerator()).append(")");
                    throw new CommitException(msg);
                }
            }
        }
        if (fieldInfo.isAbstract()) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f \"").append(fieldInfo.getCaption()).append("\"(\u0442\u0430\u0431\u043b\u0438\u0446\u0430: ").append(tableInfo.getNodeId()).append(", id \u043f\u043e\u043b\u044f: ").append(fieldInfo.getId()).append("), \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043d\u0435 \u0445\u0440\u0430\u043d\u0438\u0442\u0441\u044f \u0432 \u0421\u0423\u0411\u0414");
            throw new CommitException(msg);
        }
    }

    public static boolean generateGeneratedField(SSContext context, SqlCommand command, char intiComma, ServerSideHost ssHost, TableDescriptor tableInfo, IntegerSet modifiedFields, StringBuilder fieldsSql, StringBuilder valuesSql, AbstractConnectionManager connectionManager, boolean checkAllGenerators, AuditInfo auditInfo) throws SQLException {
        try {
            return CommitRequest.internalGenerateGeneratedField(context, command, intiComma, ssHost, tableInfo, modifiedFields, fieldsSql, valuesSql, connectionManager, checkAllGenerators, 0, null, auditInfo, null, false);
        }
        catch (Exception e) {
            throw InformException.wrap(e);
        }
    }

    private static boolean internalGenerateGeneratedField(SSContext context, SqlCommand command, char intiComma, ServerSideHost ssHost, TableDescriptor tableInfo, IntegerSet modifiedFields, StringBuilder fieldsSql, StringBuilder valuesSql, AbstractConnectionManager connectionManager, boolean checkAllGenerators, int modificationId, Request request, AuditInfo auditInfo, IntegerDoubleMap blobSizes, boolean isAppend) throws Exception {
        SqlParameter param;
        boolean result = false;
        double userNodeId = ssHost.getUserID();
        double effectiveUserNodeId = ssHost.getEffectiveUserID();
        ArrayList generated = null;
        FieldValueGenerator generatorList = null;
        int sqlComma = intiComma;
        for (FieldDescriptor field : tableInfo.getFields()) {
            FieldDescriptor.AutoValueGenerator generatorType = field.getAutoValueGenerator();
            switch (generatorType) {
                case TIMESTAMP: {
                    if (!checkAllGenerators && field.isCalcValueGeneratorForInsertOnly() || modifiedFields != null && field.getValueGeneratorField() != 0 && !modifiedFields.contains(field.getValueGeneratorField())) break;
                    fieldsSql.append((char)sqlComma).append(field.getRawName());
                    if (valuesSql == null) {
                        fieldsSql.append("=?");
                    } else {
                        valuesSql.append((char)sqlComma).append('?');
                    }
                    sqlComma = 44;
                    param = new SqlParameter();
                    double value = DateTime.currentDateTime();
                    param.setDateTime(value);
                    command.params.add(param);
                    if (auditInfo != null) {
                        auditInfo.setField(field);
                        auditInfo.setDateTime(value);
                    }
                    result = true;
                    command.addModifiedField(field.getId());
                    FieldValueGenerator.Generator g = new FieldValueGenerator.Generator();
                    g.fieldId = field.getId();
                    g.result = param.getDouble();
                    if (generated == null) {
                        generated = new FieldValueGenerator(tableInfo, 0);
                    }
                    generated.add(g);
                    break;
                }
                case USER: {
                    FieldValueGenerator.Generator inputArg;
                    if (!checkAllGenerators && field.isCalcValueGeneratorForInsertOnly() || modifiedFields != null && field.getValueGeneratorField() != 0 && !modifiedFields.contains(field.getValueGeneratorField())) break;
                    if (field.getType() == DataType.DIRECTORY) {
                        if (generatorList == null) {
                            generatorList = new FieldValueGenerator(tableInfo, connectionManager);
                        }
                        inputArg = new FieldValueGenerator.Generator();
                        inputArg.generator = FieldDescriptor.AutoValueGenerator.USER.toInt();
                        inputArg.fieldId = field.getId();
                        generatorList.add(inputArg);
                        command.addModifiedField(field.getId());
                        break;
                    }
                    fieldsSql.append((char)sqlComma).append(field.getRawName());
                    if (valuesSql == null) {
                        fieldsSql.append("=?");
                    } else {
                        valuesSql.append((char)sqlComma).append('?');
                    }
                    sqlComma = 44;
                    param = new SqlParameter();
                    param.setDouble(userNodeId);
                    command.params.add(param);
                    if (auditInfo != null) {
                        auditInfo.setField(field);
                        auditInfo.setNumber(userNodeId);
                    }
                    result = true;
                    command.addModifiedField(field.getId());
                    FieldValueGenerator.Generator g = new FieldValueGenerator.Generator();
                    g.fieldId = field.getId();
                    g.result = param.getDouble();
                    if (generated == null) {
                        generated = new FieldValueGenerator(tableInfo, 0);
                    }
                    generated.add(g);
                    break;
                }
                case EFFECTIVE_USER: {
                    FieldValueGenerator.Generator inputArg;
                    if (!checkAllGenerators && field.isCalcValueGeneratorForInsertOnly()) break;
                    if (field.getType() == DataType.DIRECTORY) {
                        if (generatorList == null) {
                            generatorList = new FieldValueGenerator(tableInfo, connectionManager);
                        }
                        inputArg = new FieldValueGenerator.Generator();
                        inputArg.generator = FieldDescriptor.AutoValueGenerator.EFFECTIVE_USER.toInt();
                        inputArg.fieldId = field.getId();
                        generatorList.add(inputArg);
                        command.addModifiedField(field.getId());
                        break;
                    }
                    fieldsSql.append((char)sqlComma).append(field.getRawName());
                    if (valuesSql == null) {
                        fieldsSql.append("=?");
                    } else {
                        valuesSql.append((char)sqlComma).append('?');
                    }
                    sqlComma = 44;
                    param = new SqlParameter();
                    param.setDouble(effectiveUserNodeId);
                    command.params.add(param);
                    if (auditInfo != null) {
                        auditInfo.setField(field);
                        auditInfo.setNumber(effectiveUserNodeId);
                    }
                    result = true;
                    command.addModifiedField(field.getId());
                    FieldValueGenerator.Generator g = new FieldValueGenerator.Generator();
                    g.fieldId = field.getId();
                    g.result = param.getDouble();
                    if (generated == null) {
                        generated = new FieldValueGenerator(tableInfo, 0);
                    }
                    generated.add(g);
                    break;
                }
                case MAX_VALUE: {
                    if (!checkAllGenerators || modifiedFields == null || modifiedFields.contains(field.getId())) break;
                    if (generatorList == null) {
                        generatorList = new FieldValueGenerator(tableInfo, connectionManager);
                    }
                    FieldValueGenerator.Generator inputArg = new FieldValueGenerator.Generator();
                    inputArg.generator = FieldDescriptor.AutoValueGenerator.MAX_VALUE.toInt();
                    inputArg.fieldId = field.getId();
                    generatorList.add(inputArg);
                    command.addModifiedField(field.getId());
                    break;
                }
                case ORACLE_SEQUENCE: {
                    if (!checkAllGenerators || modifiedFields == null || modifiedFields.contains(field.getId())) break;
                    if (generatorList == null) {
                        generatorList = new FieldValueGenerator(tableInfo, connectionManager);
                    }
                    FieldValueGenerator.Generator inputArg = new FieldValueGenerator.Generator();
                    inputArg.generator = FieldDescriptor.AutoValueGenerator.ORACLE_SEQUENCE.toInt();
                    inputArg.fieldId = field.getId();
                    inputArg.name = field.getValueGeneratorName();
                    generatorList.add(inputArg);
                    command.addModifiedField(field.getId());
                    break;
                }
                case ORACLE_PROC: {
                    if (!checkAllGenerators || modifiedFields == null || modifiedFields.contains(field.getId())) break;
                    if (generatorList == null) {
                        generatorList = new FieldValueGenerator(tableInfo, connectionManager);
                    }
                    FieldValueGenerator.Generator inputArg = new FieldValueGenerator.Generator();
                    inputArg.generator = FieldDescriptor.AutoValueGenerator.ORACLE_PROC.toInt();
                    inputArg.fieldId = field.getId();
                    inputArg.name = field.getValueGeneratorName();
                    generatorList.add(inputArg);
                    command.addModifiedField(field.getId());
                    break;
                }
                case COMPUTER_NAME: 
                case WINDOWS_USER_NAME: 
                case COMPUTER_IP: 
                case SESSION: {
                    if (!checkAllGenerators && field.isCalcValueGeneratorForInsertOnly() || modifiedFields == null || modifiedFields.contains(field.getId())) break;
                    if (generatorList == null) {
                        generatorList = new FieldValueGenerator(tableInfo, connectionManager);
                    }
                    FieldValueGenerator.Generator inputArg = new FieldValueGenerator.Generator();
                    inputArg.generator = generatorType.toInt();
                    inputArg.fieldId = field.getId();
                    generatorList.add(inputArg);
                    command.addModifiedField(field.getId());
                    break;
                }
                case BLOBSIZE: {
                    FieldDescriptor fd;
                    if (!checkAllGenerators && field.isCalcValueGeneratorForInsertOnly()) break;
                    int blobField = field.getValueGeneratorField();
                    if ((modifiedFields == null || !modifiedFields.contains(blobField)) && !isAppend || (fd = tableInfo.getFieldDescriptor(blobField)) == null) break;
                    DataType dt = fd.getType();
                    assert (dt == DataType.BLOB || dt == DataType.FILE);
                    fieldsSql.append((char)sqlComma).append(field.getRawName());
                    if (valuesSql == null) {
                        fieldsSql.append("=?");
                    } else {
                        valuesSql.append((char)sqlComma).append('?');
                    }
                    sqlComma = 44;
                    param = new SqlParameter();
                    double value = blobSizes != null ? blobSizes.get(blobField, 0.0) : 0.0;
                    param.setDouble(value);
                    command.params.add(param);
                    if (auditInfo != null) {
                        auditInfo.setField(field);
                        auditInfo.setNumber(value);
                    }
                    result = true;
                    command.addModifiedField(field.getId());
                    FieldValueGenerator.Generator g = new FieldValueGenerator.Generator();
                    g.fieldId = field.getId();
                    g.result = param.getDouble();
                    if (generated == null) {
                        generated = new FieldValueGenerator(tableInfo, 0);
                    }
                    generated.add(g);
                }
            }
        }
        if (generatorList != null) {
            generatorList.generate(context, ssHost);
            generatorList.interpretResult();
            for (FieldValueGenerator.Generator g : generatorList) {
                if (generated == null) {
                    generated = new FieldValueGenerator(tableInfo, 0);
                }
                generated.add(g);
                FieldDescriptor field = tableInfo.getExistingFieldDescriptor(g.fieldId);
                fieldsSql.append(',').append(field.getRawName());
                if (valuesSql == null) {
                    fieldsSql.append("=?");
                } else {
                    valuesSql.append(',').append('?');
                }
                param = new SqlParameter();
                if (g.stringResult != null) {
                    param.setString(g.stringResult);
                    if (auditInfo != null) {
                        auditInfo.setField(field);
                        auditInfo.setString(g.stringResult);
                    }
                } else if (g.bigResult != null) {
                    param.setString(g.bigResult);
                    if (auditInfo != null) {
                        auditInfo.setField(field);
                        auditInfo.setString(g.bigResult);
                    }
                } else {
                    param.setDouble(g.result);
                    if (auditInfo != null) {
                        auditInfo.setField(field);
                        auditInfo.setNumber(g.result);
                    }
                }
                command.params.add(param);
                result = true;
            }
        }
        if (generated != null && modificationId != 0 && request != null && request.getOutChunkSize() < 0x1000000L) {
            ByteArrayOutputStream chunk = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(chunk);
            out.putInt32(38, modificationId);
            for (FieldValueGenerator.Generator g : generated) {
                FieldDescriptor field = tableInfo.getExistingFieldDescriptor(g.fieldId);
                out.putInt32(39, field.getId());
                if (g.stringResult != null) {
                    out.putAnsi(41, g.stringResult);
                    continue;
                }
                if (g.bigResult != null) {
                    out.putAnsi(41, g.bigResult);
                    continue;
                }
                out.putDouble(40, g.result);
            }
            out.flush();
            request.sendChunk(chunk.internalBuffer(), chunk.size());
        }
        return result;
    }

    private void generateUpdateLinkSqlText(SSContext context, SqlCommand command, TaggedReader in, AbstractConnectionManager connectionManager) throws Exception {
        TableRelationInfo relationInfo = new TableRelationInfo();
        relationInfo.setTagUpdateRelation(new LittleEndianDataInputStream(in.getStream()));
        TableDescriptor tableInfo = TableDescriptor.get(relationInfo.tableNodeId);
        FieldDescriptor fieldInfo = tableInfo.getExistingFieldDescriptor(relationInfo.fieldId);
        CommitRequest.checkCanModifyField(tableInfo, fieldInfo, true);
        String fieldName = fieldInfo.getRawName();
        IntegerSet modifiedField = new IntegerSet();
        modifiedField.add(relationInfo.fieldId);
        command.sqlText.append("update ").appendFull(tableInfo).append(" set ").append(fieldName).append("=?");
        CommitRequest.internalGenerateGeneratedField(context, command, ',', this, tableInfo, modifiedField, command.sqlText.getBuilder(), null, connectionManager, false, this.currentModificationId, this, null, null, false);
        command.sqlText.append(" where ").append(fieldName).append("=?");
        in.takeNextTag();
        this.addFieldValueAsParam(in, command.params);
        in.takeNextTag();
        this.addFieldValueAsParam(in, command.params);
    }

    private void generateCloneSqlText(SSContext context, SqlCommand command, TaggedReader fieldReader, double recordId, double sourceRecordId, TableDescriptor tableInfo, AbstractConnectionManager connectionManager) throws Exception {
        String fieldName;
        StringBuilder fieldsDest = new StringBuilder();
        StringBuilder fieldsSource = new StringBuilder();
        IntegerSet modifiedFields = new IntegerSet();
        boolean primaryKeyAssigned = false;
        if (tableInfo.getKind() == TableDescriptor.Kind.INTERNAL) {
            fieldsDest.append(',').append("ID");
            fieldsSource.append(',').append('?');
            SqlParameter param = new SqlParameter();
            param.setDouble(recordId);
            command.params.add(param);
            primaryKeyAssigned = true;
        }
        FieldDescriptor fieldInfo = null;
        boolean skipField = false;
        while (fieldReader.getNextTag() != 0) {
            switch (fieldReader.getCurrentTag()) {
                case 4: {
                    int fieldId = fieldReader.getInt();
                    fieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
                    CommitRequest.checkCanModifyField(tableInfo, fieldInfo, true);
                    fieldName = fieldInfo.getRawName();
                    modifiedFields.add(fieldId);
                    fieldsDest.append(',').append(fieldName);
                    if (tableInfo.getKind() != TableDescriptor.Kind.EXTERNAL || tableInfo.getRecordIdField() != fieldInfo) break;
                    primaryKeyAssigned = true;
                    break;
                }
                case 10: {
                    fieldsSource.append(',').append("NULL");
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 24: 
                case 34: {
                    this.addFieldValueAsParam(fieldReader, command.params, fieldInfo);
                    fieldsSource.append(',').append('?');
                    break;
                }
                case 15: {
                    this.addFieldValueAsParam(fieldReader, command.params, fieldInfo);
                    fieldsSource.append(',').append('?');
                }
            }
        }
        for (FieldDescriptor fieldDescriptor : tableInfo.getFields()) {
            fieldInfo = fieldDescriptor;
            if (fieldInfo.isVirtual() || modifiedFields.contains(fieldInfo.getId()) || fieldInfo.getAutoValueGenerator() != FieldDescriptor.AutoValueGenerator.NONE) continue;
            modifiedFields.add(fieldInfo.getId());
            fieldName = fieldInfo.getRawName();
            fieldsDest.append(',').append(fieldName);
            if (!primaryKeyAssigned && tableInfo.getKind() == TableDescriptor.Kind.EXTERNAL && tableInfo.getRecordIdField() == fieldInfo) {
                fieldsSource.append(',').append('?');
                primaryKeyAssigned = true;
                SqlParameter param = new SqlParameter();
                param.setDouble(recordId);
                command.params.add(param);
                continue;
            }
            fieldsSource.append(',').append(fieldName);
        }
        CommitRequest.internalGenerateGeneratedField(context, command, ',', this, tableInfo, modifiedFields, fieldsDest, fieldsSource, connectionManager, true, this.currentModificationId, this, null, null, false);
        if (fieldsDest.length() > 0) {
            fieldsDest.setCharAt(0, ' ');
        }
        if (fieldsSource.length() > 0) {
            fieldsSource.setCharAt(0, ' ');
        }
        command.sqlText.append("insert into ").appendFull(tableInfo).append('(').append(fieldsDest).append(") select ").append(fieldsSource).append(" from ").appendFull(tableInfo).append(" TSRC where TSRC.").append(tableInfo.getRecordIdField().getRawName()).append("=?");
        SqlParameter param = new SqlParameter();
        param.setDouble(sourceRecordId);
        command.params.add(param);
    }

    private SqlParameter addFieldValueAsFile(SSContext context, DatabaseConnection databaseConnection, boolean modify, TaggedReader fieldReader, SqlParameterList params, AuditInfo auditInfo, TableDescriptor table, FieldDescriptor field, double recordId) throws IOException, SQLException, InformException {
        SqlParameter param;
        if (this.blobfs == null) {
            this.blobfs = new BFS();
        }
        if (fieldReader.getCurrentTag() == 10) {
            if (modify) {
                this.blobfs.delete(context, databaseConnection, table, field, recordId);
            }
            param = new SqlParameter();
            params.add(param);
            param.setNull();
            fieldReader.skip();
            if (auditInfo != null) {
                auditInfo.setNull();
            }
        } else {
            BFS.checkBlobFSField(table, field);
            byte[] blob = fieldReader.getRaw();
            String blobPoint = modify ? this.blobfs.modify(context, databaseConnection, recordId, table, field, blob) : this.blobfs.insert(table.getNodeId(), field, recordId, blob);
            param = new SqlParameter();
            params.add(param);
            param.setString(blobPoint);
            if (auditInfo != null) {
                auditInfo.setString(blobPoint);
            }
        }
        return param;
    }

    private byte[] addFieldValueAsFileAndGetBytes(SSContext context, DatabaseConnection databaseConnection, boolean modify, TaggedReader fieldReader, SqlParameterList params, AuditInfo auditInfo, TableDescriptor table, FieldDescriptor field, double recordId) throws IOException, SQLException, InformException {
        if (this.blobfs == null) {
            this.blobfs = new BFS();
        }
        byte[] blob = null;
        if (fieldReader.getCurrentTag() == 10) {
            if (modify) {
                this.blobfs.delete(context, databaseConnection, table, field, recordId);
            }
            SqlParameter param = new SqlParameter();
            params.add(param);
            param.setNull();
            fieldReader.skip();
            if (auditInfo != null) {
                auditInfo.setNull();
            }
        } else {
            BFS.checkBlobFSField(table, field);
            blob = fieldReader.getRaw();
            String blobPoint = modify ? this.blobfs.modify(context, databaseConnection, recordId, table, field, blob) : this.blobfs.insert(table.getNodeId(), field, recordId, blob);
            SqlParameter param = new SqlParameter();
            params.add(param);
            param.setString(blobPoint);
            if (auditInfo != null) {
                auditInfo.setString(blobPoint);
            }
        }
        return blob;
    }

    private SqlParameter addFieldValueAsCheckSum(SSContext context, DatabaseConnection databaseConnection, boolean modify, TaggedReader fieldReader, SqlParameterList params, AuditInfo auditInfo, TableDescriptor table, FieldDescriptor field, double recordId) throws IOException, SQLException, InformException {
        if (this.blobfs == null) {
            this.blobfs = new BFS();
        }
        BFS.checkBlobFSField(table, field);
        byte[] digest = fieldReader.getRaw();
        String blobPoint = this.blobfs.upload(context, this, databaseConnection, modify, recordId, table, field, digest);
        SqlParameter param = new SqlParameter();
        params.add(param);
        param.setString(blobPoint);
        if (auditInfo != null) {
            auditInfo.setString(blobPoint);
        }
        return param;
    }

    private SqlParameter addFieldValueAsParam(TaggedReader fieldReader, SqlParameterList params, AuditInfo auditInfo, FieldDescriptor fd) throws IOException, SQLException, InformException {
        SqlParameter param = null;
        switch (fieldReader.getCurrentTag()) {
            case 10: {
                param = new SqlParameter();
                params.add(param);
                param.setNull();
                fieldReader.skip();
                if (auditInfo == null) break;
                auditInfo.setNull();
                break;
            }
            case 11: {
                param = new SqlParameter();
                params.add(param);
                int vInt = fieldReader.getInt();
                param.setInteger(vInt);
                if (auditInfo == null) break;
                auditInfo.setNumber(vInt);
                break;
            }
            case 34: {
                param = new SqlParameter();
                params.add(param);
                byte v = fieldReader.getByte();
                if (v == 0) {
                    param.setBoolean(false);
                } else if (v == 1) {
                    param.setBoolean(true);
                } else {
                    throw new IllegalArgumentException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f int->bool " + v + "!=[0,1]");
                }
                if (auditInfo == null) break;
                auditInfo.setNumber(v);
                break;
            }
            case 12: {
                param = new SqlParameter();
                params.add(param);
                double vDbl = fieldReader.getDouble();
                param.setDouble(vDbl);
                if (auditInfo == null) break;
                auditInfo.setNumber(vDbl);
                break;
            }
            case 13: {
                param = new SqlParameter();
                params.add(param);
                String vStr = fieldReader.getString();
                param.setString(vStr);
                if (auditInfo == null) break;
                auditInfo.setString(vStr);
                break;
            }
            case 24: {
                param = new SqlParameter();
                params.add(param);
                String vUTF = fieldReader.getUnicode();
                param.setUnicode(vUTF);
                if (auditInfo == null) break;
                auditInfo.setUnicode(vUTF);
                break;
            }
            case 14: {
                param = new SqlParameter();
                params.add(param);
                double vDateTime = fieldReader.getDouble();
                if (!DateTime.isServerTimeZoneHost(this)) {
                    if (fd != null) {
                        if (FormatManager.hasTime(fd.getFormat())) {
                            vDateTime = FormatManager.toServerTime(vDateTime, fd.getFormat(), this);
                        }
                    } else {
                        vDateTime = DateTime.toServerTime(vDateTime, this);
                    }
                }
                param.setDateTime(vDateTime);
                if (auditInfo == null) break;
                auditInfo.setDateTime(vDateTime);
                break;
            }
            case 15: {
                param = new SqlParameter();
                params.add(param);
                int blobSize = 0;
                if (fd != null && fd.getType() == DataType.GEOMETRY) {
                    byte[] blob = fieldReader.getRaw();
                    blobSize = blob.length;
                    Geometry g = Geometry.deserialize(blob);
                    if (g == null) {
                        param.setNull(SqlDataType.GEOMETRY);
                    } else {
                        param.setGeom(g);
                    }
                } else if (fd != null && fd.getType() == DataType.BLOB && fd.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) {
                    String text = fieldReader.getString();
                    blobSize = text.length();
                    param.setString(text);
                } else {
                    FieldDescriptor.BlobRawType brt;
                    FieldDescriptor.BlobRawType blobRawType = brt = fd == null ? FieldDescriptor.BlobRawType.BINARY : fd.getBlobRawType();
                    if (brt == FieldDescriptor.BlobRawType.TEXT) {
                        String text = fieldReader.getString();
                        blobSize = text.length();
                        param.setString(text);
                    } else {
                        byte[] blob = fieldReader.getRaw();
                        blobSize = blob.length;
                        param.setBlob(blob);
                        if (auditInfo != null) {
                            auditInfo.setBlob(blob);
                        }
                    }
                }
                if (auditInfo == null) break;
                auditInfo.setNumber(blobSize);
            }
        }
        assert (param != null);
        return param;
    }

    private SqlParameter addFieldValueAsParam(TaggedReader fieldReader, SqlParameterList params) throws IOException, SQLException, InformException {
        return this.addFieldValueAsParam(fieldReader, params, null, null);
    }

    private SqlParameter addFieldValueAsParam(TaggedReader fieldReader, SqlParameterList params, FieldDescriptor fd) throws IOException, SQLException, InformException {
        return this.addFieldValueAsParam(fieldReader, params, null, fd);
    }

    private void generateAppendSqlText(SSContext context, DatabaseConnection databaseConnection, SqlCommand command, TaggedReader fieldReader, double recordId, TableDescriptor tableInfo, TableDataAudit auditWriter, AbstractConnectionManager connectionManager, DatabaseCaps caps) throws Exception {
        FieldDescriptor fieldInfo = null;
        String fieldName = null;
        int fieldId = 0;
        Enum fieldType = null;
        StringBuilder fields = new StringBuilder();
        StringBuilder values = new StringBuilder();
        AuditInfo auditInfo = new AuditInfo(auditWriter, tableInfo, recordId, AuditModification.APPEND);
        IntegerSet modifiedFields = new IntegerSet();
        SqlStringBuilder blobSql = null;
        SqlParameterList blobParams = null;
        SqlStringBuilder blobValues = null;
        IntegerSet extractionTextFields = null;
        if (tableInfo.getKind() == TableDescriptor.Kind.INTERNAL) {
            fields.append(',').append("ID");
            values.append(',').append('?');
            SqlParameter param = new SqlParameter();
            command.params.add(param);
            param.setDouble(recordId);
            auditInfo.setFieldId(-1);
            auditInfo.setNumber(recordId);
            command.addModifiedField(-1);
        }
        boolean skipField = false;
        IntegerDoubleMap blobSizes = null;
        while (fieldReader.getNextTag() != 0) {
            block0 : switch (fieldReader.getCurrentTag()) {
                case 22: {
                    fieldInfo = null;
                    fieldReader.skip();
                    double key = fieldReader.getDouble(12);
                    if (command.params.isEmpty()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("TAG_UPDATE_PRIMARY_KEY table: ").append(tableInfo.getNodeId()).append(" row: ").append(recordId);
                        throw new CommitException(msg);
                    }
                    ((SqlParameter)command.params.get(0)).setDouble(key);
                    auditInfo.setFieldId(-1);
                    auditInfo.setNumber(key);
                    skipField = false;
                    break;
                }
                case 4: {
                    fieldId = fieldReader.getInt();
                    fieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
                    CommitRequest.checkCanModifyField(tableInfo, fieldInfo, false);
                    boolean bl = skipField = CommitRequest.skipSetFieldValue(fieldInfo, true) || fieldInfo.isAutoFill();
                    if (skipField) break;
                    modifiedFields.add(fieldId);
                    fieldName = fieldInfo.getRawName();
                    fieldType = fieldInfo.getType();
                    switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                        case 1: 
                        case 2: {
                            if (blobSql == null) {
                                blobSql = new SqlStringBuilder();
                            }
                            blobSql.append(',').append(fieldName);
                            break;
                        }
                        default: {
                            command.addModifiedField(fieldId);
                            fields.append(',').append(fieldName);
                        }
                    }
                    auditInfo.setField(fieldInfo);
                    break;
                }
                case 10: {
                    if (skipField) break;
                    switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                        case 3: {
                            values.append(',').append("NULL");
                            extractionTextFields = fieldInfo.getExtractionTextFields();
                            if (extractionTextFields == null) break block0;
                            this.prepareAppendExtractionTextFieldsAsNull(auditInfo, tableInfo, extractionTextFields, command, fields, values, ',');
                            break block0;
                        }
                        case 1: {
                            if (blobValues == null) {
                                blobValues = new SqlStringBuilder();
                            }
                            blobValues.append(',').append("NULL");
                            extractionTextFields = fieldInfo.getExtractionTextFields();
                            if (extractionTextFields == null) break block0;
                            this.prepareAppendExtractionTextFieldsAsNull(auditInfo, tableInfo, extractionTextFields, command, fields, values, ',');
                            break block0;
                        }
                        case 2: {
                            if (blobValues == null) {
                                blobValues = new SqlStringBuilder();
                            }
                            blobValues.append(',').append("NULL");
                            break block0;
                        }
                    }
                    values.append(',').append("NULL");
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 24: 
                case 34: {
                    if (skipField) break;
                    this.addFieldValueAsParam(fieldReader, command.params, auditInfo, fieldInfo);
                    values.append(',').append('?');
                    break;
                }
                case 35: {
                    if (skipField) break;
                    SqlParameter fileParam = this.addFieldValueAsCheckSum(context, databaseConnection, true, fieldReader, command.params, auditInfo, tableInfo, fieldInfo, recordId);
                    values.append(',').append('?');
                    long fileLength = BFS.getFileSize(fieldInfo, fileParam.getString(), 0);
                    if (blobSizes == null) {
                        blobSizes = new IntegerDoubleMap();
                    }
                    blobSizes.put(fieldInfo.getId(), fileLength);
                    break;
                }
                case 15: {
                    if (skipField) break;
                    byte[] data = null;
                    switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                        case 3: {
                            data = this.addFieldValueAsFileAndGetBytes(context, databaseConnection, false, fieldReader, command.params, auditInfo, tableInfo, fieldInfo, recordId);
                            values.append(',').append('?');
                            if (blobSizes == null) {
                                blobSizes = new IntegerDoubleMap();
                            }
                            blobSizes.put(fieldInfo.getId(), data == null ? 0.0 : (double)data.length);
                            extractionTextFields = fieldInfo.getExtractionTextFields();
                            if (extractionTextFields == null) break block0;
                            this.prepareAppendExtractionTextFields(caps, auditInfo, tableInfo, fieldInfo, recordId, command, fields, values, ',', data);
                            break block0;
                        }
                        case 1: {
                            if (blobParams == null) {
                                blobParams = new SqlParameterList();
                            }
                            SqlParameter param = this.addFieldValueAsParam(fieldReader, blobParams, auditInfo, fieldInfo);
                            if (blobValues == null) {
                                blobValues = new SqlStringBuilder();
                            }
                            blobValues.append(',').append(caps.tranformSqlParameter(fieldInfo));
                            if (blobSizes == null) {
                                blobSizes = new IntegerDoubleMap();
                            }
                            data = param.getBlob();
                            blobSizes.put(fieldInfo.getId(), data == null ? 0.0 : (double)data.length);
                            if (fieldInfo.getBlobRawType() != FieldDescriptor.BlobRawType.BINARY || (extractionTextFields = fieldInfo.getExtractionTextFields()) == null) break block0;
                            this.prepareAppendExtractionTextFields(caps, auditInfo, tableInfo, fieldInfo, recordId, command, fields, values, ',', param.getBlob());
                            break block0;
                        }
                        case 2: {
                            if (blobParams == null) {
                                blobParams = new SqlParameterList();
                            }
                            this.addFieldValueAsParam(fieldReader, blobParams, auditInfo, fieldInfo);
                            if (blobValues == null) {
                                blobValues = new SqlStringBuilder();
                            }
                            blobValues.append(',').append('?');
                            break block0;
                        }
                    }
                    this.addFieldValueAsParam(fieldReader, command.params, auditInfo, fieldInfo);
                    values.append(',').append('?');
                }
            }
        }
        CommitRequest.internalGenerateGeneratedField(context, command, ',', this, tableInfo, modifiedFields, fields, values, connectionManager, true, this.currentModificationId, this, auditInfo, blobSizes, true);
        if (blobSql != null) {
            fields.append(blobSql);
        }
        if (blobValues != null) {
            values.append(blobValues);
        }
        if (blobParams != null) {
            command.params.addParameters(blobParams);
        }
        if (fields.length() > 0) {
            fields.setCharAt(0, ' ');
        }
        if (values.length() > 0) {
            values.setCharAt(0, ' ');
        }
        command.sqlText.append("insert into ").appendFull(tableInfo).append(" (").append(fields).append(") values (").append(values).append(')');
    }

    private void loadMultiplePrimaryKeyValue(ArrayList<ReplicationRecord.Value> pkValues, TableDescriptor tableInfo, TaggedReader in) throws IOException {
        int fieldId = in.getInt();
        FieldDescriptor fieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
        ReplicationRecord.Value value = new ReplicationRecord.Value(fieldInfo, -1);
        pkValues.add(value);
        switch (in.getNextTag()) {
            case 10: {
                value.setNull();
                break;
            }
            case 11: {
                value.setInteger(in.getInt());
                break;
            }
            case 12: {
                value.setDouble(in.getDouble());
                break;
            }
            case 13: {
                value.setString(in.getAnsi());
                break;
            }
            case 14: {
                double dateValue = in.getDouble();
                value.setDateTime(FormatManager.toServerTime(dateValue, fieldInfo.getFormat(), this));
                break;
            }
            case 15: {
                value.setBlob(in.getRaw());
                break;
            }
            case 24: {
                value.setUnicode(in.getUnicode());
            }
        }
    }

    private void generateUpdateSql(SSContext context, DatabaseConnection databaseConnection, CommitCommand command, TaggedReader fieldReader, double recordId, TableDescriptor tableInfo, TableDataAudit auditWriter, AbstractConnectionManager connectionManager, DatabaseCaps caps) throws Exception {
        SqlParameter param;
        ArrayList<FieldDescriptor> pkFields;
        command.avoidBatch = tableInfo.isHasMultipleWriteProtection();
        String fieldName = null;
        FieldDescriptor fieldInfo = null;
        int fieldId = 0;
        int commaText = 32;
        SqlParameter addedParam = null;
        ArrayList<ReplicationRecord.Value> pkValues = new ArrayList<ReplicationRecord.Value>();
        AuditInfo auditInfo = new AuditInfo(auditWriter, tableInfo, recordId, AuditModification.MODIFY);
        MultipleWriteProtectionInfoList mwp = new MultipleWriteProtectionInfoList();
        IntegerSet extractionTextFields = null;
        if (tableInfo.getMwpAllFieldsLabel() != 0) {
            FieldDescriptor mwpLabel = tableInfo.getExistingFieldDescriptor(tableInfo.getMwpAllFieldsLabel());
            mwp.get(mwpLabel);
        }
        IntegerSet modifiedFields = new IntegerSet();
        command.sqlText.append("update ").appendFull(tableInfo).append(" set ");
        SqlStringBuilder blobSql = null;
        SqlParameterList blobParams = null;
        boolean hasNonBlobFields = false;
        Enum fieldType = null;
        boolean intricatePK = false;
        boolean skipField = false;
        IntegerDoubleMap blobSizes = null;
        block34: while (fieldReader.getNextTag() != 0) {
            block0 : switch (fieldReader.getCurrentTag()) {
                case 22: {
                    fieldReader.skip();
                    fieldInfo = null;
                    FieldDescriptor primaryKeyField = tableInfo.getRecordIdField();
                    command.sqlText.append((char)commaText).append(primaryKeyField.getRawName()).append("=");
                    commaText = 44;
                    auditInfo.setFieldId(-1);
                    hasNonBlobFields = true;
                    skipField = false;
                    break;
                }
                case 4: {
                    fieldId = fieldReader.getInt();
                    fieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
                    fieldType = fieldInfo.getType();
                    CommitRequest.checkCanModifyField(tableInfo, fieldInfo, false);
                    boolean bl = skipField = CommitRequest.skipSetFieldValue(fieldInfo, false) || fieldInfo.isAutoFill();
                    if (skipField) break;
                    modifiedFields.add(fieldId);
                    fieldName = fieldInfo.getRawName();
                    switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                        case 1: 
                        case 2: {
                            if (blobSql == null) {
                                blobSql = new SqlStringBuilder();
                            } else {
                                blobSql.append(',');
                            }
                            blobSql.append(fieldName).append("=");
                            break;
                        }
                        default: {
                            command.addModifiedField(fieldId);
                            command.sqlText.append((char)commaText).append(fieldName).append("=");
                            commaText = 44;
                            hasNonBlobFields = true;
                        }
                    }
                    auditInfo.setField(fieldInfo);
                    break;
                }
                case 10: {
                    if (skipField) break;
                    switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                        case 3: {
                            byte[] data = this.addFieldValueAsFileAndGetBytes(context, databaseConnection, true, fieldReader, command.params, auditInfo, tableInfo, fieldInfo, recordId);
                            command.sqlText.append('?');
                            auditInfo.setNull();
                            extractionTextFields = fieldInfo.getExtractionTextFields();
                            if (extractionTextFields == null || this.prepareUpdateExtractionTextFieldsAsNull(auditInfo, tableInfo, extractionTextFields, command, (char)commaText, ',') <= 0) break block0;
                            hasNonBlobFields = true;
                            commaText = 44;
                            break block0;
                        }
                        case 1: {
                            if (blobSql != null) {
                                blobSql.append("NULL ");
                            } else {
                                command.sqlText.append("NULL ");
                            }
                            auditInfo.setNull();
                            extractionTextFields = fieldInfo.getExtractionTextFields();
                            if (extractionTextFields == null || this.prepareUpdateExtractionTextFieldsAsNull(auditInfo, tableInfo, extractionTextFields, command, (char)commaText, ',') <= 0) break block0;
                            hasNonBlobFields = true;
                            commaText = 44;
                            break block0;
                        }
                        case 2: {
                            if (blobSql != null) {
                                blobSql.append("NULL ");
                            } else {
                                command.sqlText.append("NULL ");
                            }
                            auditInfo.setNull();
                            break block0;
                        }
                    }
                    command.sqlText.append("NULL ");
                    auditInfo.setNull();
                    break;
                }
                case 11: 
                case 12: 
                case 14: 
                case 34: {
                    if (skipField) break;
                    command.sqlText.append('?');
                    this.addFieldValueAsParam(fieldReader, command.params, auditInfo, fieldInfo);
                    break;
                }
                case 35: {
                    command.sqlText.append('?');
                    SqlParameter fileParam = this.addFieldValueAsCheckSum(context, databaseConnection, true, fieldReader, command.params, auditInfo, tableInfo, fieldInfo, recordId);
                    long fileLength = BFS.getFileSize(fieldInfo, fileParam.getString(), 0);
                    if (blobSizes == null) {
                        blobSizes = new IntegerDoubleMap();
                    }
                    blobSizes.put(fieldInfo.getId(), fileLength);
                    break;
                }
                case 15: {
                    if (skipField) break;
                    byte[] data = null;
                    switch (1.$SwitchMap$inform$agent$db$types$DataType[fieldType.ordinal()]) {
                        case 3: {
                            command.sqlText.append('?');
                            data = this.addFieldValueAsFileAndGetBytes(context, databaseConnection, true, fieldReader, command.params, auditInfo, tableInfo, fieldInfo, recordId);
                            if (blobSizes == null) {
                                blobSizes = new IntegerDoubleMap();
                            }
                            blobSizes.put(fieldInfo.getId(), data == null ? 0.0 : (double)data.length);
                            extractionTextFields = fieldInfo.getExtractionTextFields();
                            if (extractionTextFields == null || this.prepareUpdateExtractionTextFields(caps, auditInfo, tableInfo, fieldInfo, recordId, command, (char)commaText, ',', data) <= 0) break block0;
                            hasNonBlobFields = true;
                            commaText = 44;
                            break block0;
                        }
                        case 1: {
                            SqlParameter param2;
                            if (blobSql != null) {
                                if (blobParams == null) {
                                    blobParams = new SqlParameterList();
                                }
                                blobSql.append(caps.tranformSqlParameter(fieldInfo));
                                param2 = this.addFieldValueAsParam(fieldReader, blobParams, auditInfo, fieldInfo);
                            } else {
                                command.sqlText.append('?');
                                param2 = this.addFieldValueAsParam(fieldReader, command.params, auditInfo, fieldInfo);
                            }
                            if (blobSizes == null) {
                                blobSizes = new IntegerDoubleMap();
                            }
                            data = param2.getBlob();
                            blobSizes.put(fieldInfo.getId(), data == null ? 0.0 : (double)data.length);
                            if (fieldInfo.getBlobRawType() != FieldDescriptor.BlobRawType.BINARY || (extractionTextFields = fieldInfo.getExtractionTextFields()) == null || this.prepareUpdateExtractionTextFields(caps, auditInfo, tableInfo, fieldInfo, recordId, command, (char)commaText, ',', param2.getBlob()) <= 0) break block0;
                            hasNonBlobFields = true;
                            commaText = 44;
                            break block0;
                        }
                        case 2: {
                            if (blobSql != null) {
                                if (blobParams == null) {
                                    blobParams = new SqlParameterList();
                                }
                                blobSql.append('?');
                                this.addFieldValueAsParam(fieldReader, blobParams, auditInfo, fieldInfo);
                                break block0;
                            }
                            command.sqlText.append('?');
                            this.addFieldValueAsParam(fieldReader, command.params, auditInfo, fieldInfo);
                            break block0;
                        }
                    }
                    command.sqlText.append('?');
                    this.addFieldValueAsParam(fieldReader, command.params, auditInfo, fieldInfo);
                    break;
                }
                case 13: 
                case 24: {
                    if (skipField) break;
                    command.sqlText.append('?');
                    addedParam = this.addFieldValueAsParam(fieldReader, command.params, auditInfo, fieldInfo);
                    if (addedParam.getType() != SqlDataType.STRING && addedParam.getType() != SqlDataType.UNICODE || fieldInfo == null) break;
                    String value = addedParam.getString();
                    if (value.length() <= fieldInfo.getSize()) continue block34;
                    StringBuilder msg = new StringBuilder();
                    msg.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f \"").append(fieldInfo.getCaption()).append("\"(\u0442\u0430\u0431\u043b\u0438\u0446\u0430: ").append(NumberConverter.doubleToString(tableInfo.getNodeId())).append(", id \u043f\u043e\u043b\u044f: ").append(fieldInfo.getId()).append(") \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a (\u0444\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439: ").append(value.length()).append(",  \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439: ").append(fieldInfo.getSize()).append(")");
                    throw new CommitException(msg);
                }
                case 25: {
                    FieldDescriptor f = tableInfo.getFieldDescriptor(auditInfo.getFieldId());
                    if (f == null) continue block34;
                    MultipleWriteProtectionInfo l = mwp.get(f);
                    l.hasStartLabel = true;
                    l.startLabelIsNull = true;
                    break;
                }
                case 26: {
                    FieldDescriptor f = tableInfo.getFieldDescriptor(auditInfo.getFieldId());
                    if (f == null) continue block34;
                    MultipleWriteProtectionInfo l = mwp.get(f);
                    l.hasStartLabel = true;
                    l.startLabelIsNull = false;
                    l.startLabel = fieldReader.getDouble();
                    break;
                }
                case 27: {
                    double value = fieldReader.getDouble();
                    FieldDescriptor f = tableInfo.getFieldDescriptor(auditInfo.getFieldId());
                    if (f == null) continue block34;
                    command.sqlText.append('?');
                    MultipleWriteProtectionInfo l = mwp.get(f);
                    l.hasEndLabel = true;
                    l.endLabel = value;
                    SqlParameter param3 = new SqlParameter();
                    command.params.add(param3);
                    switch (f.getType()) {
                        case INTEGER: {
                            param3.setInteger((int)value);
                            break;
                        }
                        case DATE_TIME: {
                            param3.setDateTime(value);
                            break;
                        }
                        default: {
                            param3.setDouble(value);
                        }
                    }
                    auditInfo.setNumber(value);
                    break;
                }
                case 32: {
                    this.loadMultiplePrimaryKeyValue(pkValues, tableInfo, fieldReader);
                    intricatePK = true;
                    skipField = false;
                }
            }
        }
        if (!command.silently && CommitRequest.internalGenerateGeneratedField(context, command, (char)commaText, this, tableInfo, modifiedFields, command.sqlText.getBuilder(), null, connectionManager, false, this.currentModificationId, this, auditInfo, blobSizes, false)) {
            hasNonBlobFields = true;
        }
        commaText = 44;
        if (blobSql != null) {
            if (hasNonBlobFields) {
                command.sqlText.append(',');
            }
            command.sqlText.append(blobSql);
            if (blobParams != null) {
                command.params.addParameters(blobParams);
            }
        }
        if ((pkFields = tableInfo.getPrimaryKeyFields()).isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e").append("\n\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \"").append(tableInfo.getCaption()).append("\" [").append((long)tableInfo.getNodeId()).append("] \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
            throw new InformException(msg.toString());
        }
        command.sqlText.append(" where ");
        FieldDescriptor primaryKeyDescriptor = tableInfo.getRecordIdField();
        if (!intricatePK && pkFields.size() == 1 && primaryKeyDescriptor != null) {
            command.sqlText.append(primaryKeyDescriptor.getRawName()).append("=?");
            param = new SqlParameter();
            command.params.add(param);
            param.setDouble(recordId);
            command.addModifiedField(primaryKeyDescriptor.getId());
        } else {
            if (pkFields.size() != pkValues.size()) {
                StringBuilder msg = new StringBuilder();
                msg.append("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e").append("\n\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \"").append(tableInfo.getCaption()).append("\" [").append((long)tableInfo.getNodeId()).append("] \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0435 \u043a\u043b\u044e\u0447\u0438");
                throw new InformException(msg.toString());
            }
            String and = "";
            for (ReplicationRecord.Value v : pkValues) {
                command.addModifiedField(v.field.getId());
                command.sqlText.append(and).append(v.field);
                and = " AND ";
                if (v.isNull()) {
                    command.sqlText.append(" IS NULL");
                    continue;
                }
                command.sqlText.append("=?");
                command.params.add(v);
            }
        }
        if (tableInfo.isHasMultipleWriteProtection() && !mwp.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append(" [").append(tableInfo.getNodeId()).append("] ").append(tableInfo.getRawName());
            for (MultipleWriteProtectionInfo l : mwp) {
                if (!l.hasStartLabel) {
                    throw new CommitException(msg.insert(0, "\u041e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u043a\u0438 \u0437\u0430\u0449\u0438\u0442\u044b \u043e\u0442 \u043f\u0430\u0440\u0430\u043b\u0435\u043b\u044c\u043d\u044b\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0434\u0430\u043d\u043d\u044b\u0445"));
                }
                if (!l.hasEndLabel) {
                    throw new CommitException(msg.insert(0, "\u041e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442 \u043c\u0435\u0442\u043a\u0430 \u0437\u0430\u0449\u0438\u0442\u044b \u043e\u0442 \u043f\u0430\u0440\u0430\u043b\u0435\u043b\u044c\u043d\u044b\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0434\u0430\u043d\u043d\u044b\u0445"));
                }
                if (!l.startLabelIsNull && l.startLabel == l.endLabel) {
                    throw new CommitException(msg.insert(0, "\u041e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0435 \u0438 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043c\u0435\u0442\u043a\u0438 \u043e\u0442 \u043f\u0430\u0440\u0430\u043b\u0435\u043b\u044c\u043d\u044b\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0434\u0430\u043d\u043d\u044b\u0445"));
                }
                command.sqlText.append(" and ").append(l.mvpLabel.getRawName());
                if (l.startLabelIsNull) {
                    command.sqlText.append(" IS NULL");
                    continue;
                }
                param = new SqlParameter();
                command.params.add(param);
                command.sqlText.append("=?");
                switch (l.mvpLabel.getType()) {
                    case INTEGER: {
                        param.setInteger((int)l.startLabel);
                        break;
                    }
                    case DATE_TIME: {
                        param.setDateTime(l.startLabel);
                        break;
                    }
                    default: {
                        param.setDouble(l.startLabel);
                    }
                }
                auditInfo.setNumber(l.startLabel);
            }
        }
    }

    private void checkTableAccess(TableDescriptor tableInfo, int permission, String message) throws InformException {
        Node node = MtdEngine.getValidNode(tableInfo.getNodeId());
        if (AccessMask.accessDenied(permission, this.security().accessMask(node))) {
            StringBuilder msg = new StringBuilder();
            msg.append(message).append(" [").append(tableInfo.getNodeId()).append("] ");
            throw new InformException(msg.toString());
        }
    }

    private void checkModifyTable(TableDescriptor tableInfo) throws InformException {
        this.checkTableAccess(tableInfo, 0x1000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
    }

    private void checkAddToTable(TableDescriptor tableInfo) throws InformException {
        this.checkTableAccess(tableInfo, 0x2000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
    }

    public String getLogInfo() {
        StringBuilder result = new StringBuilder();
        this.contextMessage(new LogContext.Builder(result, true));
        return result.toString();
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        super.contextMessage(out);
        if (this.dlcHead != null) {
            if (this.dlcHead.database != 0.0) {
                out.append("d", (long)this.dlcHead.database);
            }
            if (this.dlcHead.table != 0.0) {
                out.append("t", (long)this.dlcHead.table);
            }
            if (this.dlcHead.owner != 0.0) {
                out.append("o", (long)this.dlcHead.owner);
            }
            if (this.dlcHead.datasource != 0) {
                out.append("uid", this.dlcHead.datasource);
            }
            DatasourceLogContext c = this.dlcHead.previous;
            while (c != null) {
                StringBuilder tmpsb = new StringBuilder();
                tmpsb.append('{');
                LogContext.Builder tmp = new LogContext.Builder(tmpsb, true);
                if (c.database != 0.0 && c.database != this.dlcHead.database) {
                    tmp.append("d", (long)c.database);
                }
                if (c.table != 0.0 && c.table != this.dlcHead.table) {
                    tmp.append("t", (long)c.table);
                }
                if (c.owner != 0.0 && c.owner != this.dlcHead.owner) {
                    tmp.append("o", (long)c.owner);
                }
                if (c.datasource != 0 && c.datasource != this.dlcHead.datasource) {
                    tmp.append("uid", c.datasource);
                }
                tmpsb.append('}');
                out.append("or", tmpsb);
                c = c.previous;
            }
            return;
        }
        if (this.currentDatabaseId != 0.0) {
            out.append("d", (long)this.currentDatabaseId);
        }
        if (this.tableNodeId != 0.0) {
            out.append("t", (long)this.tableNodeId);
        }
        if (this.ownerId != 0.0) {
            out.append("o", (long)this.ownerId);
        }
        if (this.currentOwnerId != 0.0) {
            out.append("o2", (long)this.currentOwnerId);
        }
        if (this.currentUID != 0) {
            out.append("uid", this.currentUID);
        }
    }

    private void checkSecurityChanging() throws IOException {
        if (this.securityChanged) {
            return;
        }
        if (this.usersTable == null) {
            this.usersTable = new UsersTable();
        }
        if (this.usersTable.enabled() && this.usersTable.getTableID() == this.tableNodeId) {
            this.securityChanged = true;
        }
    }

    private void pushDsLogCtxIfNeed() {
        double ownId;
        double d = ownId = this.currentOwnerId != 0.0 ? this.currentOwnerId : this.ownerId;
        if (this.dlcHead == null || this.dlcHead.database != this.currentDatabaseId || this.dlcHead.table != this.tableNodeId || this.dlcHead.owner != ownId || this.dlcHead.datasource != this.currentUID) {
            this.dlcHead = new DatasourceLogContext(this.dlcHead, this.currentDatabaseId, this.tableNodeId, ownId, this.currentUID);
        }
    }

    @Override
    public void sqlCommandFlushed(SqlCommandBatch cmd) {
        this.dlcHead = null;
    }

    private static class TableStat
    implements DoubleHash.Entry {
        final double tableNodeId;
        long startTime;
        long warnDeleteCount;
        long warnDeleteTime;
        long warnInsertCount;
        long warnInsertTime;
        long warnUpdateCount;
        long warnUpdateTime;
        long warnTotalTime;
        long warnTotalCount;

        TableStat(double tableNodeId) {
            this.tableNodeId = tableNodeId;
            this.warnTotalCount = 0L;
            this.warnTotalTime = 0L;
            this.warnUpdateTime = 0L;
            this.warnUpdateCount = 0L;
            this.warnInsertTime = 0L;
            this.warnInsertCount = 0L;
            this.warnDeleteTime = 0L;
            this.warnDeleteCount = 0L;
        }

        void begin() {
            this.startTime = System.currentTimeMillis();
        }

        void update(TSO tso) {
            if (tso == null) {
                return;
            }
            switch (tso) {
                case DELETE: {
                    this.warnDeleteTime += System.currentTimeMillis() - this.startTime;
                    break;
                }
                case INSERT: {
                    this.warnInsertTime += System.currentTimeMillis() - this.startTime;
                    break;
                }
                case UPDATE: {
                    this.warnUpdateTime += System.currentTimeMillis() - this.startTime;
                }
            }
        }

        void update(TSO tso, long time) {
            if (tso == null) {
                return;
            }
            switch (tso) {
                case DELETE: {
                    this.warnDeleteTime += time;
                    break;
                }
                case INSERT: {
                    this.warnInsertTime += time;
                    break;
                }
                case UPDATE: {
                    this.warnUpdateTime += time;
                }
            }
        }

        void count(TSO tso) {
            switch (tso) {
                case DELETE: {
                    ++this.warnDeleteCount;
                    break;
                }
                case INSERT: {
                    ++this.warnInsertCount;
                    break;
                }
                case UPDATE: {
                    ++this.warnUpdateCount;
                }
            }
        }

        private StringBuilder flush(StringBuilder msg, double ownerId) {
            if (msg == null) {
                msg = new StringBuilder();
                msg.append("\u0414\u043e\u043b\u0433\u043e\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 [\u0444\u043e\u0440\u043c\u0430: ").append((long)ownerId).append(']');
            }
            msg.append("\n     \u0422\u0430\u0431\u043b\u0438\u0446\u0430[\u0443\u0437\u0435\u043b: ").append((long)this.tableNodeId);
            msg.append(']');
            if (this.warnDeleteCount != 0L || this.warnDeleteTime != 0L) {
                msg.append("\n       ").append("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.warnDeleteCount).append(" \u0448\u0442, ").append(this.warnDeleteTime).append(" \u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
            }
            if (this.warnUpdateCount != 0L || this.warnUpdateTime != 0L) {
                msg.append("\n       ").append("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.warnUpdateCount).append(" \u0448\u0442, ").append(this.warnUpdateTime).append(" \u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
            }
            if (this.warnInsertCount != 0L || this.warnInsertTime != 0L) {
                msg.append("\n       ").append("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.warnInsertCount).append(" \u0448\u0442, ").append(this.warnInsertTime).append(" \u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
            }
            this.warnTotalTime = this.warnDeleteTime + this.warnInsertTime + this.warnUpdateTime;
            this.warnTotalCount = this.warnDeleteCount + this.warnInsertCount + this.warnUpdateCount;
            msg.append("\n       ").append("\u0412\u0435\u0441\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 ").append(this.warnTotalCount).append(" \u0448\u0442, ").append(this.warnTotalTime).append(" \u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
            return msg;
        }

        @Override
        public double key() {
            return this.tableNodeId;
        }
    }

    private static enum TSO {
        DELETE,
        INSERT,
        UPDATE;

    }

    private static class DatasourceLogContext {
        final DatasourceLogContext previous;
        final double database;
        final double table;
        final double owner;
        final int datasource;

        DatasourceLogContext(DatasourceLogContext previous, double database, double table, double owner, int datasource) {
            this.previous = previous;
            this.database = database;
            this.table = table;
            this.owner = owner;
            this.datasource = datasource;
        }
    }

    private static class ClonedRowInfo {
        double table = 0.0;
        double sourceRow = 0.0;
        double cloneRow = 0.0;

        private ClonedRowInfo() {
        }
    }

    private static class LinkInfo {
        double table = 0.0;
        int linkId = 0;

        private LinkInfo() {
        }
    }

    private static class ClonedElementRecord {
        double table = 0.0;
        double parentTable = 0.0;
        double sourceRow = 0.0;
        double cloneRow = 0.0;
        double cloneParentRow = 0.0;

        private ClonedElementRecord() {
        }
    }

    static class CommitCommand
    extends SqlCommand {
        boolean silently = false;

        CommitCommand() {
        }
    }
}

