/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.DateTime;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.SqlDataType;
import inform.agent.scripts.SSContext;
import inform.common.Exceptions;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class RequestMonitor {
    public static int TAG_SSRQM_ITEM_NO = 1;
    public static int TAG_SSRQM_ITEM_CONTEXT = 2;
    public static int TAG_SSRQM_ITEM_SQL = 3;
    public static int TAG_SSRQM_ITEM_SQLINFO = 4;
    public static int TAG_SSRQM_ITEM_COMMENTS = 5;
    public static int TAG_SSRQM_ITEM_ERROR = 6;
    public static int TAG_SSRQM_ITEM_EXECUTE_TIME = 7;
    public static int TAG_SSRQM_ITEM_CLOSE_TIME = 8;
    public static int TAG_SSRQM_ITEM_RECORD_COUNT = 9;
    public static int TAG_SSRQM_ITEM_START_TIME = 10;
    public static int TAG_SSRQM_ITEM_FINISHED = 11;
    private static int maxRequestCount = Ini.srqlCount;
    private static final LinkedList<Stat> requests = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stat putRequest(Stat stat) {
        Class<RequestMonitor> clazz = RequestMonitor.class;
        synchronized (RequestMonitor.class) {
            if (maxRequestCount > 0) {
                requests.add(stat);
            }
            while (requests.size() > maxRequestCount) {
                requests.removeFirst();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxRequestCount() {
        Class<RequestMonitor> clazz = RequestMonitor.class;
        synchronized (RequestMonitor.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return maxRequestCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxRequestCount(int count) {
        if (count < 0) {
            count = 0;
        }
        Class<RequestMonitor> clazz = RequestMonitor.class;
        synchronized (RequestMonitor.class) {
            maxRequestCount = count;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stat[] getRequests() {
        Class<RequestMonitor> clazz = RequestMonitor.class;
        synchronized (RequestMonitor.class) {
            Stat[] arr = new Stat[requests.size()];
            // ** MonitorExit[var0] (shouldn't be in output)
            return requests.toArray(arr);
        }
    }

    public static class Stat {
        public final long no = noGenerator.incrementAndGet();
        public final SSContext context;
        public final String sql;
        public Object[] paramValues;
        public SqlDataType[] paramTypes;
        public String sqlInfo;
        public String comments;
        public long startTime;
        public long startTimeNano;
        public volatile long executeDurationNano;
        public volatile long closeTimeNano;
        public volatile long recordCount;
        public volatile boolean finished;
        public volatile Exception exception;
        private static AtomicLong noGenerator = new AtomicLong(0L);

        public Stat(SSContext context, String sql) {
            this.context = context;
            this.sql = sql;
        }

        public void store(TaggedWriter out) throws IOException {
            out.putInt64(TAG_SSRQM_ITEM_NO, this.no);
            if (this.context != null) {
                this.context.storeAs(TAG_SSRQM_ITEM_CONTEXT, out);
            }
            if (this.paramValues != null && this.paramValues.length != 0) {
                StringBuilder sql = new StringBuilder();
                sql.append(this.sql).append("\n{");
                int comma = 32;
                for (int i = 0; i < this.paramValues.length; ++i) {
                    sql.append((char)comma);
                    PreparedStatement.appendLogParameter(sql, this.paramTypes[i], i + 1, this.paramValues[i]);
                    comma = 44;
                }
                sql.append("}\n");
                out.putString(TAG_SSRQM_ITEM_SQL, sql.toString());
            } else {
                out.putString(TAG_SSRQM_ITEM_SQL, this.sql);
            }
            if (!Strings.isVoid(this.sqlInfo)) {
                out.putString(TAG_SSRQM_ITEM_SQLINFO, this.sqlInfo);
            }
            if (!Strings.isVoid(this.comments)) {
                out.putString(TAG_SSRQM_ITEM_COMMENTS, this.comments);
            }
            if (this.exception != null) {
                out.putString(TAG_SSRQM_ITEM_ERROR, Exceptions.toFullString(this.exception));
            }
            out.putDouble(TAG_SSRQM_ITEM_START_TIME, DateTime.fromUnixTime(this.startTime));
            long ct = this.closeTimeNano;
            ct = ct == 0L ? this.executeDurationNano : (ct -= this.startTimeNano);
            out.putInt32(TAG_SSRQM_ITEM_EXECUTE_TIME, (int)(this.executeDurationNano / 1000000L));
            out.putInt32(TAG_SSRQM_ITEM_CLOSE_TIME, (int)(ct /= 1000000L));
            out.putInt64(TAG_SSRQM_ITEM_RECORD_COUNT, this.recordCount);
            out.putBool(TAG_SSRQM_ITEM_FINISHED, this.finished);
        }

        public final void storeAs(int tag, TaggedWriter out) throws IOException {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(data);
            this.store(writer);
            writer.flush();
            if (data.size() == 0) {
                return;
            }
            out.putRaw(tag, data.internalBuffer(), data.size());
        }
    }
}

