/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.h2.schema;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.h2.schema.Column;
import inform.agent.db.connect.h2.schema.Scheme;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;

class Table
extends DbTable {
    Table(String name, Scheme scheme) {
        super(name, scheme);
    }

    @Override
    protected DbColumn newColumn(SSContext ssContext, Statement statement, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, FieldDescriptor fd) throws SQLException {
        Column result = new Column(name, type, brt, nullable, size, this);
        statement.execute(ssContext, String.format("ALTER TABLE %s ADD COLUMN %s %s %s %s", this.fullName(), result.name(), result.getSqlType(), this.scheme.columnDefValue(fd, false), nullable ? "" : " NOT NULL"));
        this.addForeignKey(ssContext, statement, result.name(), fd);
        return result;
    }

    @Override
    protected DbColumn newColumnObject(String name) {
        return new Column(name, DataType.NONE, FieldDescriptor.BlobRawType.BINARY, true, 0, this);
    }

    @Override
    protected DbIndex newIndex(SSContext ssContext, Statement statement, IndexDescriptor id) throws SQLException {
        DbIndex result = new DbIndex(this.scheme.toCaseIfNeed(id.getRawName()), this);
        statement.execute(ssContext, String.format("CREATE %s INDEX %s ON %s ( %s )", id.isUnique() ? "UNIQUE" : "", result.name(), this.fullName(), id.fieldsList()));
        return result;
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, String.format("ALTER TABLE %s RENAME TO %s", this.fullName(), to));
    }
}

