/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mssql.schema;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.mssql.schema.Column;
import inform.agent.db.connect.mssql.schema.Index;
import inform.agent.db.connect.mssql.schema.Scheme;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;

class Table
extends DbTable {
    Table(String name, Scheme scheme) {
        super(name, scheme);
    }

    @Override
    protected DbColumn newColumn(SSContext ssContext, Statement statement, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, FieldDescriptor fd) throws SQLException {
        Column result = new Column(this, name, type, brt, size, nullable);
        statement.execute(ssContext, "ALTER TABLE " + this.fullName() + " ADD " + result.name() + " " + result.getSqlType() + this.scheme.columnDefValue(fd, false) + (nullable ? "" : " NOT NULL"));
        this.addForeignKey(ssContext, statement, result.name(), fd);
        return result;
    }

    @Override
    protected DbColumn newColumnObject(String name) {
        return new Column(this, name, DataType.NONE, FieldDescriptor.BlobRawType.BINARY, 0, true);
    }

    @Override
    protected DbIndex newIndexObject(String name, int type, String condition) {
        return new Index(this, name, false, type == 1);
    }

    @Override
    protected DbIndex newIndex(SSContext ssContext, Statement statement, IndexDescriptor id) throws SQLException {
        Index result = new Index(this, this.scheme.toCaseIfNeed(id.getRawName()), id.isUnique(), id.isBitmap());
        StringBuilder sql = new StringBuilder("CREATE");
        if (id.isUnique()) {
            sql.append(" UNIQUE");
        }
        if (id.isClustered()) {
            sql.append(" CLUSTERED");
        }
        sql.append(" INDEX ").append(result.fullName()).append(" ON ").append(this.fullName()).append(" (");
        int delim = 32;
        for (FieldDescriptor fd : id.getFields()) {
            sql.append((char)delim).append(fd.getRawName()).append(' ').append(id.isDescending() ? "DESC" : "ASC");
            delim = 44;
        }
        sql.append(')');
        statement.execute(ssContext, sql.toString());
        return result;
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, String.format("EXEC sp_rename \"%s\", %s", this.fullName(), to));
    }
}

