/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.mysql.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;

class Column
extends DbColumn {
    public Column(String name, DataType type, FieldDescriptor.BlobRawType brt, boolean nullable, int size, DbTable table) {
        super(name, type, brt, nullable, size, table);
    }

    @Override
    public void internal_setType(SSContext ssContext, Statement statement, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, boolean keyable, FieldDescriptor fd) throws SQLException {
        statement.execute(ssContext, String.format("ALTER TABLE %s MODIFY COLUMN %s %s %s %s", this.table.fullName(), this.name(), this.table.scheme.ct2sql(type, brt, size, keyable), this.scheme().columnDefValue(fd, true), nullable ? "" : "NOT NULL"));
        this.type = type;
        this.blobRawType = brt;
        this.size = size;
        this.nullable = nullable;
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, String.format("ALTER TABLE %s CHANGE COLUMN %s %s %s", this.table.fullName(), this.name(), to, this.getSqlType()));
    }

    @Override
    protected void internal_drop(SSContext ssContext, Statement statement) throws SQLException {
        if (this.isForeignKey() && !Strings.isVoid(this.foreignKeyName)) {
            statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " DROP CONSTRAINT " + this.foreignKeyName);
        }
        statement.execute(ssContext, String.format("ALTER TABLE %s DROP COLUMN %s", this.table.fullName(), this.name()));
    }
}

