/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.oracle.schema.Column;
import inform.agent.db.connect.oracle.schema.Index;
import inform.agent.db.connect.oracle.schema.Scheme;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class Table
extends DbTable {
    Table(String name, Scheme scheme) {
        super(name, scheme);
    }

    @Override
    protected DbColumn newColumn(SSContext ssContext, Statement statement, String name, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, FieldDescriptor fd) throws SQLException {
        Column result = new Column(this, name, type, brt, size, nullable);
        statement.execute(ssContext, "ALTER TABLE " + this.fullName() + " ADD (" + result.name() + " " + result.getSqlType() + this.scheme.columnDefValue(fd, false) + (nullable ? "" : " NOT NULL") + ")");
        this.addForeignKey(ssContext, statement, result.name(), fd);
        return result;
    }

    @Override
    protected DbColumn newColumnObject(String name) {
        return new Column(this, name, DataType.NONE, FieldDescriptor.BlobRawType.BINARY, 0, true);
    }

    @Override
    protected DbIndex newIndexObject(String name, int type, String condition) {
        return new Index(this, name, false, type == 2, 0);
    }

    @Override
    protected DbIndex newIndex(SSContext ssContext, Statement statement, IndexDescriptor id) throws SQLException {
        Index result = new Index(this, this.scheme.toCaseIfNeed(id.getRawName()), id.isUnique(), id.isBitmap(), id.getCompressedFieldsCount());
        StringBuilder sql = new StringBuilder("CREATE");
        if (id.isSDOType()) {
            sql.append(" INDEX ").append(result.fullName()).append(" ON ").append(this.fullName()).append(" ( ");
            Iterator<FieldDescriptor> iterator = id.getFields().iterator();
            if (iterator.hasNext()) {
                FieldDescriptor fd = iterator.next();
                sql.append(fd.getRawName());
            }
            sql.append(" ) INDEXTYPE IS MDSYS.SPATIAL_INDEX");
        } else {
            int cfc;
            if (id.isBitmap()) {
                sql.append(" BITMAP");
            }
            if (id.isUnique()) {
                sql.append(" UNIQUE");
            }
            sql.append(" INDEX ").append(result.fullName()).append(" ON ").append(this.fullName()).append(" (");
            int delim = 32;
            for (FieldDescriptor fd : id.getFields()) {
                sql.append((char)delim).append(fd.getRawName()).append(' ').append(id.isDescending() ? "DESC" : "ASC");
                delim = 44;
            }
            sql.append(')');
            if (!id.isBitmap() && (cfc = Math.min(id.getCompressedFieldsCount(), id.getFields().size())) > 0) {
                sql.append(" COMPRESS ").append(cfc);
            }
            sql.append(" NOLOGGING");
        }
        statement.execute(ssContext, sql.toString());
        return result;
    }

    @Override
    public void internal_rename(SSContext ssContext, Statement statement, String to) throws SQLException {
        statement.execute(ssContext, "ALTER TABLE " + this.fullName() + " RENAME TO " + to);
    }

    @Override
    public Map<String, DbColumn> getColumns(SSContext ssContext) throws SQLException {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = Scheme.getColumns(ssContext, this.scheme, this);
        return this.columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFieldsInfo(SSContext ssContext, Statement statement, TableDescriptor tableDescriptor) throws SQLException {
        boolean hasScheme;
        StringBuilder sql = new StringBuilder();
        DatabaseDescriptor database = this.scheme.getDescriptor();
        DatabaseCaps caps = this.scheme.getDatabaseType().caps();
        if (Strings.isVoid(this.scheme.name())) {
            hasScheme = false;
            sql.append("select COLUMN_NAME, COMMENTS from ");
            database.appendSystemTable("user_col_comments", sql);
            sql.append(" where table_name=?");
        } else {
            hasScheme = true;
            sql.append("select COLUMN_NAME, COMMENTS from ");
            database.appendSystemTable("all_col_comments", sql);
            sql.append(" where table_name=?");
            sql.append(" and owner=?");
        }
        String commentSql = "COMMENT ON COLUMN " + this.fullName() + ".";
        try (PreparedStatement ps = statement.connection().prepareStatement(sql.toString());){
            int idx = 1;
            ps.setString(idx++, Strings.unquote(this.name()));
            if (hasScheme) {
                ps.setString(idx++, Strings.unquote(this.scheme.name()));
            }
            try (ResultSet rs = ps.executeQuery(ssContext);){
                int cName = rs.findColumn("COLUMN_NAME");
                int cComments = rs.findColumn("COMMENTS");
                while (rs.next()) {
                    String fieldName = rs.getString(cName);
                    String fieldComments = rs.getString(cComments);
                    for (FieldDescriptor field : tableDescriptor.getFields()) {
                        if (!field.getRawName().equalsIgnoreCase(fieldName)) continue;
                        String comment = field.getCaption();
                        if (comment == null) {
                            comment = "";
                        }
                        if (comment.equalsIgnoreCase(fieldComments)) continue;
                        statement.execute(ssContext, commentSql + fieldName + " IS " + caps.c_string2sql(comment));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, DbIndex> internalGetIndexes(SSContext ssContext) throws SQLException {
        boolean cName;
        ResultSet rs;
        String sn;
        int idx;
        boolean hasScheme;
        HashMap<String, DbIndex> indexes = new HashMap<String, DbIndex>();
        DatabaseDescriptor database = this.scheme.getDescriptor();
        StringBuilder sql = new StringBuilder();
        if (Strings.isVoid(this.scheme.name())) {
            hasScheme = false;
            sql.append("select INDEX_NAME, INDEX_TYPE, UNIQUENESS, COMPRESSION, PREFIX_LENGTH, STATUS from ");
            database.appendSystemTable("USER_INDEXES", sql);
            sql.append(" where TABLE_NAME=? and TEMPORARY='N' and GENERATED='N'");
        } else {
            hasScheme = true;
            sql.append("select INDEX_NAME, INDEX_TYPE, UNIQUENESS, COMPRESSION, PREFIX_LENGTH, STATUS from ");
            database.appendSystemTable("ALL_INDEXES", sql);
            sql.append(" where TABLE_NAME=? and TEMPORARY='N' and GENERATED='N'");
            sql.append(" and OWNER=? and TABLE_OWNER=?");
        }
        try (PreparedStatement ps = this.scheme.getConnection().prepareStatement(sql.toString());){
            idx = 1;
            ps.setString(idx++, Strings.unquote(this.name()));
            if (hasScheme) {
                sn = Strings.unquote(this.scheme.name());
                ps.setString(idx++, sn);
                ps.setString(idx++, sn);
            }
            rs = ps.executeQuery(ssContext);
            try {
                cName = true;
                int cType = 2;
                int cUniqueness = 3;
                int cCompression = 4;
                int cCompressionCount = 5;
                int cStatus = 6;
                while (rs.next()) {
                    String fieldName = rs.getString(1);
                    String fieldType = rs.getString(2);
                    String fieldUniqueness = rs.getString(3);
                    String fieldCompression = rs.getString(4);
                    int fieldCompressionLength = rs.getAsInteger(5);
                    String fieldStatus = rs.getString(6);
                    String indexName = this.scheme.nameFromDb(fieldName);
                    boolean isUnique = "UNIQUE".equalsIgnoreCase(fieldUniqueness);
                    boolean isBitmap = "BITMAP".equalsIgnoreCase(fieldType);
                    boolean isCompressed = "ENABLED".equalsIgnoreCase(fieldCompression);
                    int compressionLength = 0;
                    if (isCompressed) {
                        compressionLength = fieldCompressionLength;
                    }
                    boolean isValid = "VALID".equalsIgnoreCase(fieldStatus);
                    Index index = new Index(this, indexName, isUnique, isBitmap, compressionLength);
                    index.setValid(isValid);
                    indexes.put(index.name(), index);
                }
            }
            finally {
                rs.close();
            }
        }
        if (indexes.isEmpty()) {
            return indexes;
        }
        sql = new StringBuilder();
        if (!hasScheme) {
            sql.append("select INDEX_NAME, COLUMN_NAME, COLUMN_POSITION from ");
            database.appendSystemTable("USER_IND_COLUMNS", sql);
            sql.append(" where TABLE_NAME=? order by COLUMN_POSITION asc");
        } else {
            sql.append("select INDEX_NAME, COLUMN_NAME, COLUMN_POSITION from ");
            database.appendSystemTable("ALL_IND_COLUMNS", sql);
            sql.append(" where TABLE_NAME=?");
            sql.append(" and INDEX_OWNER=? and TABLE_OWNER=? order by COLUMN_POSITION asc");
        }
        ps = this.scheme.getConnection().prepareStatement(sql.toString());
        try {
            idx = 1;
            ps.setString(idx++, Strings.unquote(this.name()));
            if (hasScheme) {
                sn = Strings.unquote(this.scheme.name());
                ps.setString(idx++, sn);
                ps.setString(idx++, sn);
            }
            rs = ps.executeQuery(ssContext);
            try {
                cName = true;
                int cColumn = 2;
                int cPosition = 3;
                while (rs.next()) {
                    String fieldName = rs.getString(1);
                    String fieldColumn = rs.getString(2);
                    int position = rs.getAsInteger(3) - 1;
                    String indexName = this.scheme.nameFromDb(fieldName);
                    String columnName = this.scheme.nameFromDb(fieldColumn);
                    DbIndex index = indexes.get(indexName);
                    if (index == null) continue;
                    index.getColumns().add(position, this.getColumns(ssContext).get(columnName));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        return indexes;
    }
}

